/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.jnr.aqua.impl;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.violetlib.jnr.aqua.AquaUIPainter;
import org.violetlib.jnr.aqua.TableColumnHeaderConfiguration;
import org.violetlib.jnr.impl.PainterExtension;

public class TableColumnHeaderCellPainterExtension
implements PainterExtension {
    @NotNull
    protected final TableColumnHeaderConfiguration tg;
    @NotNull
    protected Color COLOR = new Color(60, 60, 60, 34);

    public TableColumnHeaderCellPainterExtension(@NotNull TableColumnHeaderConfiguration tableColumnHeaderConfiguration) {
        this.tg = tableColumnHeaderConfiguration;
    }

    @Override
    public void paint(@NotNull Graphics2D graphics2D, float f, float f2) {
        AquaUIPainter.ColumnSortArrowDirection columnSortArrowDirection;
        if (f == 0.0f || f2 == 0.0f) {
            return;
        }
        float f3 = f2 - 16.0f;
        float f4 = Math.min(4.0f, f3 / 2.0f);
        float f5 = 4.0f + f4;
        float f6 = 2.5f;
        float f7 = Math.max(0.0f, f2 - 2.0f * f6);
        if (f7 > 0.0f) {
            float f8 = f - 1.0f;
            float f9 = f6;
            Rectangle2D.Float float_ = new Rectangle2D.Float(f8, f9, 1.0f, f7);
            graphics2D.setColor(this.COLOR);
            graphics2D.fill(float_);
        }
        if ((columnSortArrowDirection = this.tg.getSortArrowDirection()) != AquaUIPainter.ColumnSortArrowDirection.NONE && f >= 12.0f) {
            Image image = null;
            switch (columnSortArrowDirection) {
                case UP: {
                    image = Toolkit.getDefaultToolkit().getImage("NSImage://NSAscendingSortIndicator");
                    break;
                }
                case DOWN: {
                    image = Toolkit.getDefaultToolkit().getImage("NSImage://NSDescendingSortIndicator");
                }
            }
            if (image != null) {
                int n = image.getWidth(null);
                int n2 = image.getHeight(null);
                float f10 = this.tg.isLeftToRight() ? f - 1.0f - f5 - (float)n + 1.0f : f5 + 1.0f;
                float f11 = (f2 - (float)n2) / 2.0f;
                AffineTransform affineTransform = AffineTransform.getTranslateInstance(f10, f11);
                graphics2D.drawImage(image, affineTransform, null);
            }
        }
    }
}

