/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua.fc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.violetlib.aqua.AquaFocusHandler;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.fc.EmptyIcon;
import org.violetlib.aqua.fc.FileInfo;
import org.violetlib.aqua.fc.FileSystemTreeModel;
import org.violetlib.aqua.fc.GenericCellRenderer;
import org.violetlib.aqua.fc.OSXFile;

public class FileRenderer
extends JLabel
implements ListCellRenderer,
GenericCellRenderer {
    private Color labelForeground;
    private Color labelDisabledForeground;
    private Icon selectedExpandingIcon;
    private Icon selectedExpandedIcon;
    private Icon focusedSelectedExpandingIcon;
    private Icon focusedSelectedExpandedIcon;
    private Icon expandingIcon;
    private Icon expandedIcon;
    private Icon emptyIcon;
    private Icon aliasBadgeIcon;
    private JFileChooser fileChooser;
    private int textIconGap;
    private int textArrowIconGap;
    private Icon icon;
    private String text;
    private Icon arrowIcon;
    private Color labelColor;
    private Color labelBrightColor;
    private boolean isSelected;
    private boolean isActive;
    private boolean isGrayed;
    private boolean isAlias;
    private boolean isListView;
    private double labelRadius = 4.8;
    private static final Rectangle zeroRect = new Rectangle(0, 0, 0, 0);
    private static Rectangle iconRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle arrowIconRect = new Rectangle();
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle labelRect = new Rectangle();
    private static Rectangle r = new Rectangle();

    public FileRenderer(JFileChooser jFileChooser) {
        this.fileChooser = jFileChooser;
        this.textIconGap = UIManager.getInt("FileChooser.browserCellTextIconGap");
        this.textArrowIconGap = UIManager.getInt("FileChooser.browserCellTextArrowIconGap");
        this.emptyIcon = new EmptyIcon(12, 12);
        this.aliasBadgeIcon = UIManager.getIcon("FileView.aliasBadgeIcon");
        this.expandedIcon = UIManager.getIcon("Browser.expandedIcon");
        this.selectedExpandedIcon = UIManager.getIcon("Browser.selectedExpandedIcon");
        this.focusedSelectedExpandedIcon = UIManager.getIcon("Browser.focusedSelectedExpandedIcon");
        this.expandingIcon = UIManager.getIcon("Browser.expandingIcon");
        this.selectedExpandingIcon = UIManager.getIcon("Browser.selectedExpandingIcon");
        this.focusedSelectedExpandingIcon = UIManager.getIcon("Browser.focusedSelectedExpandingIcon");
        this.labelForeground = UIManager.getColor("Label.foreground");
        this.labelDisabledForeground = UIManager.getColor("Label.disabledForeground");
        this.setOpaque(true);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    @Override
    public void repaint(Rectangle rectangle) {
    }

    @Override
    protected void firePropertyChange(String string, Object object, Object object2) {
    }

    @Override
    public void firePropertyChange(String string, short s, short s2) {
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
    }

    @Override
    public void firePropertyChange(String string, long l, long l2) {
    }

    @Override
    public void firePropertyChange(String string, float f, float f2) {
    }

    @Override
    public void firePropertyChange(String string, double d, double d2) {
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }

    public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
        return this.getCellRendererComponent(jList, object, bl, bl2, false);
    }

    @Override
    public Component getCellRendererComponent(JComponent jComponent, Object object, boolean bl, boolean bl2) {
        return this.getCellRendererComponent(jComponent, object, bl, bl2, true);
    }

    protected Component getCellRendererComponent(JComponent jComponent, Object object, boolean bl, boolean bl2, boolean bl3) {
        this.isListView = bl3;
        if (!(object instanceof FileInfo)) {
            return this;
        }
        FileInfo fileInfo = (FileInfo)object;
        this.isGrayed = !fileInfo.isAcceptable() && !fileInfo.isTraversable();
        this.labelColor = OSXFile.getLabelColor(fileInfo.getFileLabel(), this.isGrayed ? 2 : 0);
        this.labelBrightColor = OSXFile.getLabelColor(fileInfo.getFileLabel(), this.isGrayed ? 3 : 1);
        this.isSelected = bl;
        boolean bl4 = this.isActive = jComponent.isEnabled() && AquaFocusHandler.hasFocus(jComponent);
        if (this.isSelected) {
            if (this.isActive) {
                this.setBackground(UIManager.getColor("Browser.selectionBackground"));
                this.setForeground(UIManager.getColor("Browser.selectionForeground"));
            } else {
                this.setBackground(UIManager.getColor("Browser.inactiveSelectionBackground"));
                this.setForeground(UIManager.getColor("Browser.inactiveSelectionForeground"));
            }
        } else {
            this.setBackground(jComponent.getBackground());
            this.setForeground(this.isGrayed ? this.labelDisabledForeground : this.labelForeground);
        }
        if (!bl3) {
            if (this.isSelected && this.labelColor == null) {
                this.arrowIcon = bl2 ? (fileInfo.isValidating() ? this.focusedSelectedExpandingIcon : this.focusedSelectedExpandedIcon) : (fileInfo.isValidating() ? this.selectedExpandingIcon : this.selectedExpandedIcon);
            } else {
                Icon icon = this.arrowIcon = fileInfo.isValidating() ? this.expandingIcon : this.expandedIcon;
            }
            if (!fileInfo.isTraversable() || OSXFile.isVirtualFile(fileInfo.lazyGetResolvedFile())) {
                this.arrowIcon = this.labelColor == null ? null : this.emptyIcon;
            }
        } else {
            this.arrowIcon = null;
        }
        this.text = fileInfo.getUserName();
        this.icon = fileInfo.getIcon();
        this.isAlias = false;
        if (fileInfo instanceof FileSystemTreeModel.Node) {
            FileSystemTreeModel.Node node = (FileSystemTreeModel.Node)fileInfo;
            this.isAlias = node.isAlias();
        }
        this.setOpaque(!bl3);
        this.setEnabled(jComponent.isEnabled());
        this.setFont(jComponent.getFont());
        this.setBorder(bl3 ? null : (bl2 ? UIManager.getBorder(this.isGrayed ? "FileChooser.browserCellFocusBorderGrayed" : "FileChooser.browserCellFocusBorder") : UIManager.getBorder("FileChooser.browserCellBorder")));
        return this;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Object object = AquaUtils.beginGraphics((Graphics2D)graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n = this.getWidth();
        int n2 = this.getHeight();
        Insets insets = this.getInsets();
        this.resetRects();
        viewRect.setBounds(0, 0, n, n2);
        FileRenderer.viewRect.x += insets.left;
        FileRenderer.viewRect.y += insets.top;
        FileRenderer.viewRect.width -= insets.left + insets.right;
        FileRenderer.viewRect.height -= insets.top + insets.bottom;
        Font font = this.getFont();
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        if (this.isOpaque()) {
            graphics2D.setColor(this.getBackground());
            graphics2D.fillRect(0, 0, n, n2);
        }
        String string = this.layoutRenderer(fontMetrics, this.text, this.icon, this.arrowIcon, viewRect, iconRect, textRect, arrowIconRect, labelRect, this.text == null ? 0 : this.textIconGap, this.textArrowIconGap);
        if (this.labelColor != null) {
            double d = this.labelRadius;
            Ellipse2D.Double double_ = new Ellipse2D.Double(FileRenderer.labelRect.x, FileRenderer.labelRect.y, d * 2.0, d * 2.0);
            graphics2D.setPaint(this.labelColor);
            graphics2D.fill(double_);
            graphics2D.setPaint(this.isSelected && this.isActive ? Color.WHITE : Color.LIGHT_GRAY);
            graphics2D.draw(double_);
        }
        if (this.icon != null) {
            this.icon.paintIcon(this, graphics2D, FileRenderer.iconRect.x, FileRenderer.iconRect.y);
        }
        if (this.isAlias && this.aliasBadgeIcon != null) {
            this.aliasBadgeIcon.paintIcon(this, graphics2D, FileRenderer.iconRect.x, FileRenderer.iconRect.y);
        }
        if (string != null && !string.equals("")) {
            graphics2D.setColor(this.getForeground());
            graphics2D.drawString(string, FileRenderer.textRect.x, FileRenderer.textRect.y + fontMetrics.getAscent());
        }
        if (this.arrowIcon != null) {
            this.arrowIcon.paintIcon(this, graphics2D, FileRenderer.arrowIconRect.x, FileRenderer.arrowIconRect.y);
        }
        AquaUtils.endGraphics(graphics2D, object);
    }

    private void resetRects() {
        iconRect.setBounds(zeroRect);
        textRect.setBounds(zeroRect);
        arrowIconRect.setBounds(zeroRect);
        labelRect.setBounds(zeroRect);
        viewRect.setBounds(0, 0, Short.MAX_VALUE, Short.MAX_VALUE);
        r.setBounds(zeroRect);
    }

    @Override
    public Dimension getPreferredSize() {
        Insets insets;
        boolean bl;
        Font font = this.getFont();
        FontMetrics fontMetrics = this.getFontMetrics(font);
        this.resetRects();
        this.layoutRenderer(fontMetrics, this.text, this.icon, this.arrowIcon, viewRect, iconRect, textRect, arrowIconRect, labelRect, this.text == null ? 0 : this.textIconGap, this.textArrowIconGap);
        r.setBounds(textRect);
        r = SwingUtilities.computeUnion(FileRenderer.iconRect.x, FileRenderer.iconRect.y, FileRenderer.iconRect.width, FileRenderer.iconRect.height, r);
        boolean bl2 = bl = this.arrowIcon != null;
        if (bl) {
            FileRenderer.r.width += FileRenderer.arrowIconRect.width + this.textArrowIconGap;
        }
        if (this.labelColor != null) {
            FileRenderer.r.width += FileRenderer.labelRect.width + this.textArrowIconGap;
        }
        if ((insets = this.getInsets()) != null) {
            FileRenderer.r.width += insets.left + insets.right;
            FileRenderer.r.height += insets.top + insets.bottom;
        }
        return r.getSize();
    }

    private String layoutRenderer(FontMetrics fontMetrics, String string, Icon icon, Icon icon2, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, Rectangle rectangle4, Rectangle rectangle5, int n, int n2) {
        boolean bl;
        boolean bl2 = bl = icon2 != null;
        if (bl) {
            rectangle4.width = icon2.getIconWidth();
            rectangle4.height = icon2.getIconHeight();
            rectangle4.x = rectangle.x + rectangle.width - rectangle4.width;
            rectangle.width -= rectangle4.width + n2;
        }
        if (this.labelColor != null) {
            int n3;
            rectangle5.width = n3 = (int)Math.ceil(2.0 * this.labelRadius);
            rectangle5.height = n3;
            rectangle5.x = rectangle.x + rectangle.width - rectangle5.width;
            rectangle.width -= rectangle5.width + n2;
        }
        string = AquaUtils.layoutCompoundLabel(this, fontMetrics, string, icon, 0, 2, 0, 4, rectangle, rectangle2, rectangle3, n);
        if (bl) {
            rectangle.width += rectangle4.width + n2;
        }
        if (this.labelColor != null) {
            rectangle.width += rectangle5.width + n2;
        }
        Rectangle rectangle6 = rectangle2.union(rectangle3);
        if (bl) {
            rectangle4.y = rectangle.y + rectangle6.height / 2 - rectangle4.height / 2;
        }
        if (this.labelColor != null) {
            rectangle5.y = rectangle.y + rectangle6.height / 2 - rectangle5.height / 2;
        }
        if (!AquaUtils.isLeftToRight(this)) {
            int n4 = rectangle.width;
            rectangle2.x = n4 - (rectangle2.x + rectangle2.width);
            rectangle3.x = n4 - (rectangle3.x + rectangle3.width);
            rectangle4.x = n4 - (rectangle4.x + rectangle4.width);
            rectangle5.x = n4 - (rectangle5.x + rectangle5.width);
        }
        return string;
    }
}

