/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Component;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;

public class ClientPropertyApplicator<T extends JComponent, N>
implements PropertyChangeListener {
    private final Map<String, Property<N>> properties = new HashMap<String, Property<N>>();

    public ClientPropertyApplicator(Property<N> ... propertyArray) {
        for (Property<N> property : propertyArray) {
            this.properties.put(property.name, property);
        }
    }

    void applyProperty(N n, String string, Object object) {
        Property<N> property = this.properties.get(string);
        if (property != null) {
            property.applyProperty(n, object);
        }
    }

    public void attachAndApplyClientProperties(T t) {
        ((Container)t).addPropertyChangeListener(this);
        N n = this.convertJComponentToTarget(t);
        if (n == null) {
            return;
        }
        Set<String> set = this.properties.keySet();
        for (String string : set) {
            Object object = ((JComponent)t).getClientProperty(string);
            if (object == null) continue;
            this.applyProperty(n, string, object);
        }
    }

    public void removeFrom(T t) {
        ((Component)t).removePropertyChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        N n = this.convertJComponentToTarget((JComponent)propertyChangeEvent.getSource());
        if (n == null) {
            return;
        }
        this.applyProperty(n, propertyChangeEvent.getPropertyName(), propertyChangeEvent.getNewValue());
    }

    public N convertJComponentToTarget(T t) {
        return (N)t;
    }

    public static abstract class Property<X> {
        final String name;

        public Property(String string) {
            this.name = string;
        }

        public abstract void applyProperty(X var1, Object var2);
    }
}

