/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Graphics;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicViewportUI;
import org.violetlib.aqua.AquaUtils;
import org.violetlib.aqua.AquaVibrantSupport;

public class AquaViewportUI
extends BasicViewportUI {
    static AquaUtils.RecyclableSingleton<AquaViewportUI> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<AquaViewportUI>(AquaViewportUI.class);
    public PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            AquaViewportUI.this.propertyChange(propertyChangeEvent);
        }
    };

    public static ComponentUI createUI(JComponent jComponent) {
        return instance.get();
    }

    @Override
    public void installUI(JComponent jComponent) {
        super.installUI(jComponent);
        AquaVibrantSupport.updateVibrantStyle(jComponent);
        jComponent.addPropertyChangeListener(this.propertyChangeListener);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        jComponent.removePropertyChangeListener(this.propertyChangeListener);
        AquaVibrantSupport.uninstallVibrantStyle(jComponent);
        super.uninstallUI(jComponent);
    }

    @Override
    public final void update(Graphics graphics, JComponent jComponent) {
        if (jComponent.isOpaque() || AquaVibrantSupport.isVibrant(jComponent)) {
            AquaUtils.fillRect(graphics, jComponent, 2);
        }
        this.paint(graphics, jComponent);
    }

    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (AquaVibrantSupport.processVibrantStyleChange(propertyChangeEvent)) {
            return;
        }
    }
}

