/*
 * Decompiled with CFR 0.152.
 */
package org.violetlib.aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import org.violetlib.aqua.AquaBorder;

public class AquaFocusHandler
implements FocusListener,
PropertyChangeListener {
    private boolean wasTemporary = false;
    private boolean repaintBorder = false;
    public static final String FRAME_ACTIVE_PROPERTY = "Frame.active";
    public static final String HAS_FOCUS_DELEGATE_KEY = "Component.hasFocusDelegate";
    public static final String QUAQUA_HAS_FOCUS_DELEGATE_KEY = "Quaqua.Component.cellRendererFor";
    static final PropertyChangeListener REPAINT_LISTENER = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            if (object instanceof JComponent) {
                ((JComponent)object).repaint();
            }
        }
    };

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (!this.wasTemporary || this.repaintBorder) {
            AquaBorder.repaintBorder((JComponent)focusEvent.getSource());
            this.repaintBorder = false;
        }
        this.wasTemporary = false;
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.wasTemporary = focusEvent.isTemporary();
        if (!this.wasTemporary) {
            AquaBorder.repaintBorder((JComponent)focusEvent.getSource());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (!FRAME_ACTIVE_PROPERTY.equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (Boolean.TRUE.equals(propertyChangeEvent.getNewValue())) {
            this.repaintBorder = true;
        } else if (this.wasTemporary) {
            AquaBorder.repaintBorder((JComponent)propertyChangeEvent.getSource());
        }
    }

    public static boolean hasFocus(Component component) {
        if (!component.isEnabled()) {
            return false;
        }
        JComponent jComponent = null;
        if (component instanceof JComponent) {
            jComponent = (JComponent)component;
        }
        if (jComponent != null && !AquaFocusHandler.isActive(jComponent)) {
            return false;
        }
        if (component.hasFocus()) {
            return true;
        }
        if (jComponent != null) {
            Object object = jComponent.getClientProperty(HAS_FOCUS_DELEGATE_KEY);
            if (object == null) {
                object = jComponent.getClientProperty(QUAQUA_HAS_FOCUS_DELEGATE_KEY);
            }
            if (object instanceof Component) {
                Component component2 = (Component)object;
                return component2.hasFocus();
            }
        }
        return false;
    }

    public static boolean isActive(JComponent jComponent) {
        if (jComponent == null) {
            return true;
        }
        Object object = jComponent.getClientProperty(FRAME_ACTIVE_PROPERTY);
        return !Boolean.FALSE.equals(object);
    }

    protected static void install(JComponent jComponent) {
        jComponent.addPropertyChangeListener(FRAME_ACTIVE_PROPERTY, REPAINT_LISTENER);
    }

    protected static void uninstall(JComponent jComponent) {
        jComponent.removePropertyChangeListener(FRAME_ACTIVE_PROPERTY, REPAINT_LISTENER);
    }

    static void swapSelectionColors(String string, JTree jTree, Object object) {
    }

    public static void swapSelectionColors(String string, JTable jTable, Object object) {
        Color color = jTable.getSelectionBackground();
        Color color2 = jTable.getSelectionForeground();
        if (!(color instanceof UIResource) || !(color2 instanceof UIResource)) {
            return;
        }
        if (Boolean.FALSE.equals(object)) {
            AquaFocusHandler.setSelectionColors(jTable, "Table.selectionInactiveForeground", "Table.selectionInactiveBackground");
            return;
        }
        if (Boolean.TRUE.equals(object)) {
            AquaFocusHandler.setSelectionColors(jTable, "Table.selectionForeground", "Table.selectionBackground");
            return;
        }
    }

    static void setSelectionColors(JTable jTable, String string, String string2) {
        jTable.setSelectionForeground(UIManager.getColor(string));
        jTable.setSelectionBackground(UIManager.getColor(string2));
    }

    static void swapSelectionColors(String string, JList<?> jList, Object object) {
        Color color = jList.getSelectionBackground();
        Color color2 = jList.getSelectionForeground();
        if (!(color instanceof UIResource) || !(color2 instanceof UIResource)) {
            return;
        }
        if (Boolean.FALSE.equals(object)) {
            AquaFocusHandler.setSelectionColors(jList, "List.selectionInactiveForeground", "List.selectionInactiveBackground");
            return;
        }
        if (Boolean.TRUE.equals(object)) {
            AquaFocusHandler.setSelectionColors(jList, "List.selectionForeground", "List.selectionBackground");
            return;
        }
    }

    static void setSelectionColors(JList<?> jList, String string, String string2) {
        jList.setSelectionForeground(UIManager.getColor(string));
        jList.setSelectionBackground(UIManager.getColor(string2));
    }

    static boolean isComponentValid(JComponent jComponent) {
        if (jComponent == null) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(jComponent);
        return window != null;
    }

    public static Component getFocusableComponent(Component component) {
        if (component instanceof Container) {
            Component component2;
            Object object;
            Object object2;
            Container container = (Container)component;
            if (container.isFocusCycleRoot() && (object2 = ((FocusTraversalPolicy)(object = container.getFocusTraversalPolicy())).getDefaultComponent(container)) != null) {
                return object2;
            }
            object = container.getFocusCycleRootAncestor();
            if (object != null && (component2 = ((FocusTraversalPolicy)(object2 = ((Container)object).getFocusTraversalPolicy())).getComponentAfter((Container)object, container)) != null && SwingUtilities.isDescendingFrom(component2, container)) {
                return component2;
            }
        }
        if (component.isFocusable()) {
            return component;
        }
        return null;
    }
}

