/*
 * Decompiled with CFR 0.152.
 */
package fr.orsay.lri.varna.views;

import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JPanel;

class PrintPanel
extends JPanel
implements Printable {
    PrintPanel() {
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.drawPage(graphics2D);
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        if (n >= 1) {
            return 1;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.draw(new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight()));
        this.drawPage(graphics2D);
        return 0;
    }

    public void drawPage(Graphics2D graphics2D) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        Font font = new Font("Serif", 0, 72);
        GeneralPath generalPath = new GeneralPath();
        TextLayout textLayout = new TextLayout("Hello", font, fontRenderContext);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(0.0, 72.0);
        Shape shape = textLayout.getOutline(affineTransform);
        generalPath.append(shape, false);
        textLayout = new TextLayout("World", font, fontRenderContext);
        affineTransform = AffineTransform.getTranslateInstance(0.0, 144.0);
        shape = textLayout.getOutline(affineTransform);
        generalPath.append(shape, false);
        graphics2D.draw(generalPath);
        graphics2D.clip(generalPath);
        Point2D.Double double_ = new Point2D.Double(0.0, 0.0);
        for (int i = 0; i < 50; ++i) {
            double d = 2 * this.getWidth() * i / 50;
            double d2 = 2 * this.getHeight() * (49 - i) / 50;
            Point2D.Double double_2 = new Point2D.Double(d, d2);
            graphics2D.draw(new Line2D.Double(double_, double_2));
        }
    }
}

