/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.Map;
import java.util.StringTokenizer;
import javajs.api.GenericBinaryDocument;
import javajs.util.LimitedLineReader;
import javajs.util.PT;
import javajs.util.Rdr;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.api.Interface;
import org.jmol.util.Logger;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

public class Resolver {
    private static final String classBase = "org.jmol.adapter.readers.";
    private static final String[] readerSets = new String[]{"aflow.", ";AFLOW;", "cif.", ";Cif;MMCif;MMTF;", "molxyz.", ";Mol3D;Mol;Xyz;", "more.", ";BinaryDcd;Gromacs;Jcampdx;MdCrd;MdTop;Mol2;TlsDataOnly;", "quantum.", ";Adf;Csf;Dgrid;GamessUK;GamessUS;Gaussian;GaussianFchk;GaussianWfn;Jaguar;Molden;MopacGraphf;GenNBO;NWChem;Psi;Qchem;WebMO;MO;", "pdb.", ";Pdb;Pqr;P2n;JmolData;", "pymol.", ";PyMOL;", "simple.", ";Alchemy;Ampac;Cube;FoldingXyz;GhemicalMM;HyperChem;Jme;JSON;Mopac;MopacArchive;Tinker;Input;", "spartan.", ";Spartan;SpartanSmol;Odyssey;", "xtal.", ";Abinit;Aims;Bilbao;Castep;Cgd;Crystal;Dmol;Espresso;Gulp;Jana;Magres;Shelx;Siesta;VaspOutcar;VaspPoscar;Wien2k;Xcrysden;", "xml.", ";XmlArgus;XmlCml;XmlChem3d;XmlMolpro;XmlOdyssey;XmlXsd;XmlVasp;XmlQE;"};
    private static final String CML_NAMESPACE_URI = "http://www.xml-cml.org/schema";
    private static final int LEADER_CHAR_MAX = 64;
    private static final String[] sptRecords = new String[]{"spt", "# Jmol state", "# Jmol script", "JmolManifest"};
    private static final String[] m3dStartRecords = new String[]{"Alchemy", "STRUCTURE  1.00     1"};
    private static final String[] cubeFileStartRecords = new String[]{"Cube", "JVXL", "#JVXL"};
    private static final String[] mol2Records = new String[]{"Mol2", "mol2", "@<TRIPOS>"};
    private static final String[] webmoFileStartRecords = new String[]{"WebMO", "[HEADER]"};
    private static final String[] moldenFileStartRecords = new String[]{"Molden", "[Molden", "MOLDEN", "[MOLDEN"};
    private static final String[] dcdFileStartRecords = new String[]{"BinaryDcd", "T\u0000\u0000\u0000CORD", "\u0000\u0000\u0000TCORD"};
    private static final String[] tlsDataOnlyFileStartRecords = new String[]{"TlsDataOnly", "REFMAC\n\nTL", "REFMAC\r\n\r\n", "REFMAC\r\rTL"};
    private static final String[] inputFileStartRecords = new String[]{"Input", "#ZMATRIX", "%mem=", "AM1", "$rungauss"};
    private static final String[] magresFileStartRecords = new String[]{"Magres", "#$magres", "# magres"};
    private static final String[] pymolStartRecords = new String[]{"PyMOL", "}q"};
    private static final String[] janaStartRecords = new String[]{"Jana", "Version Jana"};
    private static final String[] jsonStartRecords = new String[]{"JSON", "{\"mol\":"};
    private static final String[] jcampdxStartRecords = new String[]{"Jcampdx", "##TITLE"};
    private static final String[] jmoldataStartRecords = new String[]{"JmolData", "REMARK   6 Jmol"};
    private static final String[] pqrStartRecords = new String[]{"Pqr", "REMARK   1 PQR", "REMARK    The B-factors"};
    private static final String[] p2nStartRecords = new String[]{"P2n", "REMARK   1 P2N"};
    private static final String[] xmlStartRecords = new String[]{"Xml", "<?xml"};
    private static final String[][] fileStartsWithRecords = new String[][]{xmlStartRecords, sptRecords, m3dStartRecords, cubeFileStartRecords, mol2Records, webmoFileStartRecords, moldenFileStartRecords, dcdFileStartRecords, tlsDataOnlyFileStartRecords, inputFileStartRecords, magresFileStartRecords, pymolStartRecords, janaStartRecords, jsonStartRecords, jcampdxStartRecords, jmoldataStartRecords, pqrStartRecords, p2nStartRecords};
    private static final String[] mmcifLineStartRecords = new String[]{"MMCif", "_entry.id", "_database_PDB_", "_pdbx_", "_chem_comp.pdbx_type", "_audit_author.name", "_atom_site."};
    private static final String[] cifLineStartRecords = new String[]{"Cif", "data_", "_publ"};
    private static final String[] pdbLineStartRecords = new String[]{"Pdb", "HEADER", "OBSLTE", "TITLE ", "CAVEAT", "COMPND", "SOURCE", "KEYWDS", "EXPDTA", "AUTHOR", "REVDAT", "SPRSDE", "JRNL  ", "REMARK ", "DBREF ", "SEQADV", "SEQRES", "MODRES", "HELIX ", "SHEET ", "TURN  ", "CRYST1", "ORIGX1", "ORIGX2", "ORIGX3", "SCALE1", "SCALE2", "SCALE3", "ATOM  ", "HETATM", "MODEL ", "LINK  ", "USER  MOD "};
    private static final String[] cgdLineStartRecords = new String[]{"Cgd", "EDGE ", "edge "};
    private static final String[] shelxLineStartRecords = new String[]{"Shelx", "TITL ", "ZERR ", "LATT ", "SYMM ", "CELL "};
    private static final String[] ghemicalMMLineStartRecords = new String[]{"GhemicalMM", "!Header mm1gp", "!Header gpr"};
    private static final String[] jaguarLineStartRecords = new String[]{"Jaguar", "  |  Jaguar version"};
    private static final String[] mdlLineStartRecords = new String[]{"Mol", "$MDL "};
    private static final String[] spartanSmolLineStartRecords = new String[]{"SpartanSmol", "INPUT="};
    private static final String[] csfLineStartRecords = new String[]{"Csf", "local_transform"};
    private static final String[] mdTopLineStartRecords = new String[]{"MdTop", "%FLAG TITLE"};
    private static final String[] hyperChemLineStartRecords = new String[]{"HyperChem", "mol 1"};
    private static final String[] vaspOutcarLineStartRecords = new String[]{"VaspOutcar", " vasp.", " INCAR:"};
    private static final String[][] lineStartsWithRecords = new String[][]{mmcifLineStartRecords, cifLineStartRecords, pdbLineStartRecords, cgdLineStartRecords, shelxLineStartRecords, ghemicalMMLineStartRecords, jaguarLineStartRecords, mdlLineStartRecords, spartanSmolLineStartRecords, csfLineStartRecords, mol2Records, mdTopLineStartRecords, hyperChemLineStartRecords, vaspOutcarLineStartRecords};
    private static final String[] bilbaoContainsRecords = new String[]{"Bilbao", ">Bilbao Crystallographic Server<"};
    private static final String[] xmlContainsRecords = new String[]{"Xml", "<?xml", "<atom", "<molecule", "<reaction", "<cml", "<bond", ".dtd\"", "<list>", "<entry", "<identifier", "http://www.xml-cml.org/schema/cml2/core"};
    private static final String[] gaussianContainsRecords = new String[]{"Gaussian", "Entering Gaussian System", "Entering Link 1", "1998 Gaussian, Inc."};
    private static final String[] ampacContainsRecords = new String[]{"Ampac", "AMPAC Version"};
    private static final String[] mopacContainsRecords = new String[]{"Mopac", "MOPAC 93 (c) Fujitsu", "MOPAC FOR LINUX (PUBLIC DOMAIN VERSION)", "MOPAC:  VERSION  6", "MOPAC   7", "MOPAC2", "MOPAC (PUBLIC"};
    private static final String[] qchemContainsRecords = new String[]{"Qchem", "Welcome to Q-Chem", "A Quantum Leap Into The Future Of Chemistry"};
    private static final String[] gamessUKContainsRecords = new String[]{"GamessUK", "GAMESS-UK", "G A M E S S - U K"};
    private static final String[] gamessUSContainsRecords = new String[]{"GamessUS", "GAMESS", "$CONTRL"};
    private static final String[] spartanBinaryContainsRecords = new String[]{"SpartanSmol", "|PropertyArchive", "_spartan", "spardir", "BEGIN Directory Entry Molecule"};
    private static final String[] spartanContainsRecords = new String[]{"Spartan", "Spartan", "converted archive file"};
    private static final String[] adfContainsRecords = new String[]{"Adf", "Amsterdam Density Functional"};
    private static final String[] psiContainsRecords = new String[]{"Psi", "    PSI  3", "PSI3:"};
    private static final String[] nwchemContainsRecords = new String[]{"NWChem", " argument  1 = "};
    private static final String[] uicrcifContainsRecords = new String[]{"Cif", "Crystallographic Information File"};
    private static final String[] dgridContainsRecords = new String[]{"Dgrid", "BASISFILE   created by DGrid"};
    private static final String[] crystalContainsRecords = new String[]{"Crystal", "*                                CRYSTAL", "TORINO", "DOVESI"};
    private static final String[] dmolContainsRecords = new String[]{"Dmol", "DMol^3"};
    private static final String[] gulpContainsRecords = new String[]{"Gulp", "GENERAL UTILITY LATTICE PROGRAM"};
    private static final String[] espressoContainsRecords = new String[]{"Espresso", "Program PWSCF", "Program PHONON"};
    private static final String[] siestaContainsRecords = new String[]{"Siesta", "MD.TypeOfRun", "SolutionMethod", "MeshCutoff", "WELCOME TO SIESTA"};
    private static final String[] xcrysDenContainsRecords = new String[]{"Xcrysden", "PRIMVEC", "CONVVEC", "PRIMCOORD", "ANIMSTEP"};
    private static final String[] mopacArchiveContainsRecords = new String[]{"MopacArchive", "SUMMARY OF PM"};
    private static final String[] abinitContainsRecords = new String[]{"Abinit", "http://www.abinit.org", "Catholique", "Louvain"};
    private static final String[] gaussianFchkContainsRecords = new String[]{"GaussianFchk", "Number of point charges in /Mol/"};
    private static final String[] inputContainsRecords = new String[]{"Input", " ATOMS cartesian", "$molecule", "&zmat", "geometry={", "$DATA", "%coords", "GEOM=PQS", "geometry units angstroms"};
    private static final String[] aflowContainsRecords = new String[]{"AFLOW", "/AFLOWDATA/"};
    private static final String[][] headerContainsRecords = new String[][]{sptRecords, bilbaoContainsRecords, xmlContainsRecords, gaussianContainsRecords, ampacContainsRecords, mopacContainsRecords, qchemContainsRecords, gamessUKContainsRecords, gamessUSContainsRecords, spartanBinaryContainsRecords, spartanContainsRecords, mol2Records, adfContainsRecords, psiContainsRecords, nwchemContainsRecords, uicrcifContainsRecords, dgridContainsRecords, crystalContainsRecords, dmolContainsRecords, gulpContainsRecords, espressoContainsRecords, siestaContainsRecords, xcrysDenContainsRecords, mopacArchiveContainsRecords, abinitContainsRecords, gaussianFchkContainsRecords, inputContainsRecords, aflowContainsRecords};

    public static final String getReaderClassBase(String type) {
        String name = type + "Reader";
        if (type.startsWith("Xml")) {
            return "org.jmol.adapter.readers.xml." + name;
        }
        String key = ";" + type + ";";
        for (int i = 1; i < readerSets.length; i += 2) {
            if (readerSets[i].indexOf(key) < 0) continue;
            return classBase + readerSets[i - 1] + name;
        }
        return "org.jmol.adapter.readers.???." + name;
    }

    static String getFileType(BufferedReader br) {
        try {
            return Resolver.determineAtomSetCollectionReader(br, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    static Object getAtomCollectionReader(String fullName, String type, Object readerOrDocument, Map<String, Object> htParams, int ptFile) throws Exception {
        String readerName;
        fullName = FileManager.fixDOSName(fullName);
        String errMsg = null;
        if (type == null) {
            type = (String)htParams.get("filter");
            int pt = type == null ? -1 : type.toLowerCase().indexOf("filetype");
            String string = type = pt < 0 ? null : type.substring(pt + 8, (type + ";").indexOf(";", pt)).replace('=', ' ').trim();
        }
        if (type != null) {
            readerName = Resolver.getReaderFromType(type);
            if (readerName == null) {
                readerName = Resolver.getReaderFromType("Xml" + type);
            }
            if (readerName == null) {
                errMsg = "unrecognized file format type " + type;
            } else {
                Logger.info("The Resolver assumes " + readerName);
            }
        } else {
            readerName = Resolver.determineAtomSetCollectionReader(readerOrDocument, true);
            if (readerName.charAt(0) == '\n' && (type = (String)htParams.get("defaultType")) != null && (type = Resolver.getReaderFromType(type)) != null) {
                readerName = type;
            }
            if (readerName.charAt(0) == '\n') {
                errMsg = "unrecognized file format for file\n" + fullName + "\n" + Resolver.split(readerName, 50);
            } else if (readerName.equals("spt")) {
                errMsg = "NOTE: file recognized as a script file: " + fullName + "\n";
            } else if (!fullName.equals("ligand")) {
                Logger.info("The Resolver thinks " + readerName);
            }
        }
        if (errMsg != null) {
            SmarterJmolAdapter.close(readerOrDocument);
            return errMsg;
        }
        htParams.put("ptFile", ptFile);
        if (ptFile <= 0) {
            htParams.put("readerName", readerName);
        }
        if (readerName.indexOf("Xml") == 0) {
            readerName = "Xml";
        }
        return Resolver.getReader(readerName, htParams);
    }

    public static Object getReader(String readerName, Map<String, Object> htParams) {
        AtomSetCollectionReader rdr = null;
        String className = null;
        String err = null;
        className = Resolver.getReaderClassBase(readerName);
        rdr = (AtomSetCollectionReader)Interface.getInterface(className, (Viewer)htParams.get("vwr"), "reader");
        if (rdr == null) {
            err = JC.READER_NOT_FOUND + className;
            Logger.error(err);
            return err;
        }
        return rdr;
    }

    private static final String getReaderFromType(String type) {
        type = ";" + type.toLowerCase() + ";";
        if (";zmatrix;cfi;c;vfi;v;mnd;jag;adf;gms;g;gau;mp;nw;orc;pqs;qc;".indexOf(type) >= 0) {
            return "Input";
        }
        int i = readerSets.length;
        while (--i >= 0) {
            String set;
            int pt;
            if ((pt = (set = readerSets[i--]).toLowerCase().indexOf(type)) < 0) continue;
            return set.substring(pt + 1, set.indexOf(";", pt + 2));
        }
        return null;
    }

    private static String split(String a, int n) {
        String s = "";
        int l = a.length();
        int i = 0;
        int j = 0;
        while (i < l) {
            j = Math.min(i + n, l);
            s = s + a.substring(i, j) + "\n";
            i = j;
        }
        return s;
    }

    public static Object DOMResolve(Map<String, Object> htParams) throws Exception {
        String rdrName = Resolver.getXmlType((String)htParams.get("nameSpaceInfo"));
        if (Logger.debugging) {
            Logger.debug("The Resolver thinks " + rdrName);
        }
        htParams.put("readerName", rdrName);
        return Resolver.getReader("XmlReader", htParams);
    }

    private static String determineAtomSetCollectionReader(Object readerOrDocument, boolean returnLines) throws Exception {
        LimitedLineReader llr;
        String leader;
        String readerName;
        if (readerOrDocument instanceof GenericBinaryDocument) {
            GenericBinaryDocument doc = (GenericBinaryDocument)readerOrDocument;
            String readerName2 = Resolver.getBinaryType(doc.getInputStream());
            return readerName2 == null ? "binary file type not recognized" : readerName2;
        }
        if (readerOrDocument instanceof InputStream) {
            readerName = Resolver.getBinaryType((InputStream)readerOrDocument);
            if (readerName != null) {
                return readerName;
            }
            readerOrDocument = Rdr.getBufferedReader(new BufferedInputStream((InputStream)readerOrDocument), null);
        }
        if ((leader = (llr = new LimitedLineReader((BufferedReader)readerOrDocument, 16384)).getHeader(64).trim()).indexOf("PNG") == 1 && leader.indexOf("PNGJ") >= 0) {
            return "pngj";
        }
        if (leader.indexOf("PNG") == 1 || leader.indexOf("JPG") == 1 || leader.indexOf("JFIF") == 6) {
            return "spt";
        }
        if (leader.indexOf("\"num_pairs\"") >= 0) {
            return "dssr";
        }
        readerName = Resolver.checkFileStart(leader);
        if (readerName != null) {
            return readerName.equals("Xml") ? Resolver.getXmlType(llr.getHeader(0)) : readerName;
        }
        String[] lines = new String[16];
        int nLines = 0;
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = llr.readLineWithNewline();
            if (lines[i].length() <= 0) continue;
            ++nLines;
        }
        readerName = Resolver.checkSpecial1(nLines, lines, leader);
        if (readerName != null) {
            return readerName;
        }
        readerName = Resolver.checkLineStarts(lines);
        if (readerName != null) {
            return readerName;
        }
        readerName = Resolver.checkHeaderContains(llr.getHeader(0));
        if (readerName != null) {
            return readerName;
        }
        readerName = Resolver.checkSpecial2(lines);
        if (readerName != null) {
            return readerName;
        }
        return returnLines ? "\n" + lines[0] + "\n" + lines[1] + "\n" + lines[2] + "\n" : null;
    }

    public static String getBinaryType(InputStream inputStream) {
        return Rdr.isPickleS(inputStream) ? "PyMOL" : (Rdr.isMessagePackS(inputStream) ? "MMTF" : null);
    }

    private static String checkFileStart(String leader) {
        for (int i = 0; i < fileStartsWithRecords.length; ++i) {
            String[] recordTags = fileStartsWithRecords[i];
            for (int j = 1; j < recordTags.length; ++j) {
                String recordTag = recordTags[j];
                if (!leader.startsWith(recordTag)) continue;
                return recordTags[0];
            }
        }
        return null;
    }

    private static final String checkSpecial1(int nLines, String[] lines, String leader) {
        if (nLines == 1 && lines[0].length() > 0 && PT.isDigit(lines[0].charAt(0))) {
            return "Jme";
        }
        if (Resolver.checkMopacGraphf(lines)) {
            return "MopacGraphf";
        }
        if (Resolver.checkOdyssey(lines)) {
            return "Odyssey";
        }
        switch (Resolver.checkMol(lines)) {
            case 1: 
            case 3: 
            case 2000: 
            case 3000: {
                return "Mol";
            }
        }
        switch (Resolver.checkXyz(lines)) {
            case 1: {
                return "Xyz";
            }
            case 2: {
                return "Bilbao";
            }
        }
        if (Resolver.checkAlchemy(lines[0])) {
            return "Alchemy";
        }
        if (Resolver.checkFoldingXyz(lines)) {
            return "FoldingXyz";
        }
        if (Resolver.checkCube(lines)) {
            return "Cube";
        }
        if (Resolver.checkWien2k(lines)) {
            return "Wien2k";
        }
        if (Resolver.checkAims(lines)) {
            return "Aims";
        }
        if (Resolver.checkGenNBO(lines, leader)) {
            return "GenNBO";
        }
        return null;
    }

    private static boolean checkAims(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].startsWith("mol 1")) {
                return false;
            }
            String[] tokens = PT.getTokens(lines[i]);
            if (tokens.length == 0 || !(tokens[0].startsWith("atom") && tokens.length > 4 && Float.isNaN(PT.parseFloat(tokens[4])) || tokens[0].startsWith("multipole") && tokens.length >= 6) && (!tokens[0].startsWith("lattice_vector") || tokens.length < 4)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkAlchemy(String line) {
        int pt = line.indexOf("ATOMS");
        if (pt >= 0 && line.indexOf("BONDS") > pt) {
            try {
                int n = Integer.parseInt(line.substring(0, pt).trim());
                return n > 0;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean checkCube(String[] lines) {
        try {
            for (int j = 2; j <= 5; ++j) {
                StringTokenizer tokens2 = new StringTokenizer(lines[j]);
                int n = tokens2.countTokens();
                if (n != 4 && (j != 2 || n != 5)) {
                    return false;
                }
                Integer.parseInt(tokens2.nextToken());
                int i = 3;
                while (--i >= 0) {
                    PT.fVal(tokens2.nextToken());
                }
                if (n != 5) continue;
                Integer.parseInt(tokens2.nextToken());
            }
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private static boolean checkFoldingXyz(String[] lines) {
        StringTokenizer tokens = new StringTokenizer(lines[0].trim(), " \t");
        if (tokens.countTokens() < 2) {
            return false;
        }
        try {
            Integer.parseInt(tokens.nextToken().trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        String secondLine = lines[1].trim();
        if (secondLine.length() == 0) {
            secondLine = lines[2].trim();
        }
        if ((tokens = new StringTokenizer(secondLine, " \t")).countTokens() == 0) {
            return false;
        }
        try {
            Integer.parseInt(tokens.nextToken().trim());
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    private static boolean checkGenNBO(String[] lines, String leader) {
        return leader.indexOf("$GENNBO") >= 0 || lines[1].startsWith(" Basis set information needed for plotting orbitals") || lines[1].indexOf("s in the AO basis:") >= 0 || lines[2].indexOf(" N A T U R A L   A T O M I C   O R B I T A L") >= 0;
    }

    private static int checkMol(String[] lines) {
        String line4trimmed = ("X" + lines[3]).trim().toUpperCase();
        if (line4trimmed.length() < 7 || line4trimmed.indexOf(".") >= 0) {
            return 0;
        }
        if (line4trimmed.endsWith("V2000")) {
            return 2000;
        }
        if (line4trimmed.endsWith("V3000")) {
            return 3000;
        }
        try {
            int n1 = Integer.parseInt(lines[3].substring(0, 3).trim());
            int n2 = Integer.parseInt(lines[3].substring(3, 6).trim());
            return n1 > 0 && n2 >= 0 && lines[0].indexOf("@<TRIPOS>") != 0 && lines[1].indexOf("@<TRIPOS>") != 0 && lines[2].indexOf("@<TRIPOS>") != 0 ? 3 : 0;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static boolean checkMopacGraphf(String[] lines) {
        return lines[0].indexOf("MOPAC-Graphical data") > 2;
    }

    private static boolean checkOdyssey(String[] lines) {
        int i;
        for (i = 0; i < lines.length && (lines[i].startsWith("C ") || lines[i].length() == 0); ++i) {
        }
        if (i >= lines.length || lines[i].charAt(0) != ' ' || (i += 2) + 1 >= lines.length) {
            return false;
        }
        try {
            int spin = Integer.parseInt(lines[i].substring(2).trim());
            int charge = Integer.parseInt(lines[i].substring(0, 2).trim());
            int atom1 = Integer.parseInt(lines[++i].substring(0, 2).trim());
            if (spin < 0 || spin > 5 || atom1 <= 0 || charge > 5) {
                return false;
            }
            float[] atomline = AtomSetCollectionReader.getTokensFloat(lines[i], null, 5);
            return !Float.isNaN(atomline[1]) && !Float.isNaN(atomline[2]) && !Float.isNaN(atomline[3]) && Float.isNaN(atomline[4]);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean checkWien2k(String[] lines) {
        return lines[2].startsWith("MODE OF CALC=") || lines[2].startsWith("             RELA") || lines[2].startsWith("             NREL");
    }

    private static int checkXyz(String[] lines) {
        try {
            Integer.parseInt(lines[0].trim());
            try {
                Integer.parseInt(lines[2].trim());
            }
            catch (NumberFormatException nfe) {
                return 1;
            }
            return 2;
        }
        catch (NumberFormatException nfe) {
            if (lines[0].indexOf("Bilbao Crys") >= 0) {
                return 2;
            }
            return 0;
        }
    }

    private static String checkLineStarts(String[] lines) {
        for (int i = 0; i < lineStartsWithRecords.length; ++i) {
            String[] recordTags = lineStartsWithRecords[i];
            for (int j = 1; j < recordTags.length; ++j) {
                String recordTag = recordTags[j];
                for (int k = 0; k < lines.length; ++k) {
                    if (!lines[k].startsWith(recordTag)) continue;
                    return recordTags[0];
                }
            }
        }
        return null;
    }

    private static String checkHeaderContains(String header) throws Exception {
        for (int i = 0; i < headerContainsRecords.length; ++i) {
            String[] recordTags = headerContainsRecords[i];
            for (int j = 1; j < recordTags.length; ++j) {
                String recordTag = recordTags[j];
                if (header.indexOf(recordTag) < 0) continue;
                String type = recordTags[0];
                if (!type.equals("Xml")) {
                    return type;
                }
                if (header.indexOf("/AFLOWDATA/") >= 0 || header.indexOf("-- Structure PRE --") >= 0) {
                    return "AFLOW";
                }
                return header.indexOf("<!DOCTYPE HTML PUBLIC") < 0 && header.indexOf("XHTML") < 0 && (header.indexOf("xhtml") < 0 || header.indexOf("<cml") >= 0) ? Resolver.getXmlType(header) : null;
            }
        }
        return null;
    }

    private static String getXmlType(String header) throws Exception {
        if (header.indexOf("http://www.molpro.net/") >= 0) {
            return "XmlMolpro";
        }
        if (header.indexOf("odyssey") >= 0) {
            return "XmlOdyssey";
        }
        if (header.indexOf("C3XML") >= 0) {
            return "XmlChem3d";
        }
        if (header.indexOf("arguslab") >= 0) {
            return "XmlArgus";
        }
        if (header.indexOf("jvxl") >= 0 || header.indexOf(CML_NAMESPACE_URI) >= 0 || header.indexOf("cml:") >= 0 || header.indexOf("<cml>") >= 0) {
            return "XmlCml";
        }
        if (header.indexOf("XSD") >= 0) {
            return "XmlXsd";
        }
        if (header.indexOf(">vasp") >= 0) {
            return "XmlVasp";
        }
        if (header.indexOf("<GEOMETRY_INFO>") >= 0) {
            return "XmlQE";
        }
        return "XmlCml(unidentified)";
    }

    private static final String checkSpecial2(String[] lines) {
        if (Resolver.checkGromacs(lines)) {
            return "Gromacs";
        }
        if (Resolver.checkCrystal(lines)) {
            return "Crystal";
        }
        String s = Resolver.checkCastepVasp(lines);
        if (s != null) {
            return s;
        }
        return null;
    }

    private static boolean checkCrystal(String[] lines) {
        String s = lines[1].trim();
        if (s.equals("SLAB") || s.equals("MOLECULE") || s.equals("CRYSTAL") || s.equals("POLYMER") || (s = lines[3]).equals("SLAB") || s.equals("MOLECULE") || s.equals("POLYMER")) {
            return true;
        }
        for (int i = 0; i < lines.length; ++i) {
            if (!lines[i].trim().equals("OPTGEOM") && !lines[i].trim().equals("FREQCALC") && !lines[i].contains("DOVESI") && !lines[i].contains("TORINO") && !lines[i].contains("http://www.crystal.unito.it") && !lines[i].contains("Pcrystal") && !lines[i].contains("MPPcrystal") && !lines[i].contains("crystal executable")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkGromacs(String[] lines) {
        if (PT.parseInt(lines[1]) == Integer.MIN_VALUE) {
            return false;
        }
        int len = -1;
        for (int i = 2; i < 16 && len != 0; ++i) {
            len = lines[i].length();
            if (len == 69 || len == 45 || len == 0) continue;
            return false;
        }
        return true;
    }

    private static String checkCastepVasp(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i].toUpperCase();
            if (line.indexOf("FREQUENCIES IN         CM-1") == 1 || line.contains("CASTEP") || line.startsWith("%BLOCK LATTICE_ABC") || line.startsWith("%BLOCK LATTICE_CART") || line.startsWith("%BLOCK POSITIONS_FRAC") || line.startsWith("%BLOCK POSITIONS_ABS") || line.contains("<-- E")) {
                return "Castep";
            }
            if (i < 6 || i >= 10 || !line.startsWith("DIRECT") && !line.startsWith("CARTESIAN")) continue;
            return "VaspPoscar";
        }
        return null;
    }
}

