/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.sifts;

import MCview.Atom;
import MCview.PDBChain;
import jalview.analysis.AlignSeq;
import jalview.analysis.scoremodels.ScoreMatrix;
import jalview.analysis.scoremodels.ScoreModels;
import jalview.api.DBRefEntryI;
import jalview.api.SiftsClientI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.Mapping;
import jalview.datamodel.SequenceI;
import jalview.io.StructureFile;
import jalview.schemes.ResidueProperties;
import jalview.structure.StructureMapping;
import jalview.util.Comparison;
import jalview.util.DBRefUtils;
import jalview.util.Format;
import jalview.ws.sifts.MappingOutputPojo;
import jalview.ws.sifts.SiftsException;
import jalview.ws.sifts.SiftsSettings;
import jalview.xml.binding.sifts.Entry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class SiftsClient
implements SiftsClientI {
    private static File mockSiftsFile;
    private Entry siftsEntry;
    private StructureFile pdb;
    private String pdbId;
    private String structId;
    private CoordinateSys seqCoordSys = CoordinateSys.UNIPROT;
    private Mapping seqFromPdbMapping;
    private static final int BUFFER_SIZE = 4096;
    public static final int UNASSIGNED = Integer.MIN_VALUE;
    private static final int PDB_RES_POS = 0;
    private static final int PDB_ATOM_POS = 1;
    private static final int PDBE_POS = 2;
    private static final String NOT_OBSERVED = "Not_Observed";
    private static final String SIFTS_FTP_BASE_URL = "http://ftp.ebi.ac.uk/pub/databases/msd/sifts/xml/";
    private static final String NEWLINE;
    private String curSourceDBRef;
    private HashSet<String> curDBRefAccessionIdsString;

    public SiftsClient(StructureFile pdb) throws SiftsException {
        this.pdb = pdb;
        this.pdbId = pdb.getId();
        File siftsFile = SiftsClient.getSiftsFile(this.pdbId);
        this.siftsEntry = this.parseSIFTs(siftsFile);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Entry parseSIFTs(File siftFile) throws SiftsException {
        try (FileInputStream in = new FileInputStream(siftFile);){
            Entry entry;
            try (GZIPInputStream gzis = new GZIPInputStream(in);){
                JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.sifts");
                XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(gzis);
                Unmarshaller um = jc.createUnmarshaller();
                entry = (Entry)um.unmarshal(streamReader);
            }
            return entry;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SiftsException(e.getMessage());
        }
    }

    public static File getSiftsFile(String pdbId) throws SiftsException {
        if (mockSiftsFile != null) {
            return mockSiftsFile;
        }
        String siftsFileName = SiftsSettings.getSiftDownloadDirectory() + pdbId.toLowerCase() + ".xml.gz";
        File siftsFile = new File(siftsFileName);
        if (siftsFile.exists()) {
            System.out.println(">>> SIFTS File already downloaded for " + pdbId);
            if (SiftsClient.isFileOlderThanThreshold(siftsFile, SiftsSettings.getCacheThresholdInDays())) {
                File oldSiftsFile = new File(siftsFileName + "_old");
                siftsFile.renameTo(oldSiftsFile);
                try {
                    siftsFile = SiftsClient.downloadSiftsFile(pdbId.toLowerCase());
                    oldSiftsFile.delete();
                    return siftsFile;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    oldSiftsFile.renameTo(siftsFile);
                    return new File(siftsFileName);
                }
            }
            return siftsFile;
        }
        try {
            siftsFile = SiftsClient.downloadSiftsFile(pdbId.toLowerCase());
        }
        catch (IOException e) {
            throw new SiftsException(e.getMessage());
        }
        return siftsFile;
    }

    public static boolean isFileOlderThanThreshold(File file, int noOfDays) {
        Path filePath = file.toPath();
        int diffInDays = 0;
        try {
            BasicFileAttributes attr = Files.readAttributes(filePath, BasicFileAttributes.class, new LinkOption[0]);
            diffInDays = (int)((new Date().getTime() - attr.lastModifiedTime().toMillis()) / 86400000L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return noOfDays <= diffInDays;
    }

    public static File downloadSiftsFile(String pdbId) throws SiftsException, IOException {
        if (pdbId.contains(".cif")) {
            pdbId = pdbId.replace(".cif", "");
        }
        String siftFile = pdbId + ".xml.gz";
        String siftsFileFTPURL = SIFTS_FTP_BASE_URL + siftFile;
        String downloadedSiftsFile = SiftsSettings.getSiftDownloadDirectory() + siftFile;
        File siftsDownloadDir = new File(SiftsSettings.getSiftDownloadDirectory());
        if (!siftsDownloadDir.exists()) {
            siftsDownloadDir.mkdirs();
        }
        URL url = new URL(siftsFileFTPURL);
        URLConnection conn = url.openConnection();
        InputStream inputStream = conn.getInputStream();
        FileOutputStream outputStream = new FileOutputStream(downloadedSiftsFile);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, bytesRead);
        }
        outputStream.close();
        inputStream.close();
        return new File(downloadedSiftsFile);
    }

    public static boolean deleteSiftsFileByPDBId(String pdbId) {
        File siftsFile = new File(SiftsSettings.getSiftDownloadDirectory() + pdbId.toLowerCase() + ".xml.gz");
        if (siftsFile.exists()) {
            return siftsFile.delete();
        }
        return true;
    }

    public DBRefEntryI getValidSourceDBRef(SequenceI seq) throws SiftsException {
        List<DBRefEntry> dbRefs = seq.getPrimaryDBRefs();
        if (dbRefs == null || dbRefs.size() < 1) {
            throw new SiftsException("Source DBRef could not be determined. DBRefs might not have been retrieved.");
        }
        for (DBRefEntry dbRef : dbRefs) {
            if (dbRef == null || dbRef.getAccessionId() == null || dbRef.getSource() == null) continue;
            String canonicalSource = DBRefUtils.getCanonicalName(dbRef.getSource());
            if (!this.isValidDBRefEntry(dbRef) || !canonicalSource.equalsIgnoreCase("UNIPROT") && !canonicalSource.equalsIgnoreCase("PDB")) continue;
            return dbRef;
        }
        throw new SiftsException("Could not get source DB Ref");
    }

    boolean isValidDBRefEntry(DBRefEntryI entry) {
        return entry != null && entry.getAccessionId() != null && this.isFoundInSiftsEntry(entry.getAccessionId());
    }

    @Override
    public HashSet<String> getAllMappingAccession() {
        HashSet<String> accessions = new HashSet<String>();
        List<Entry.Entity> entities = this.siftsEntry.getEntity();
        for (Entry.Entity entity : entities) {
            List<Entry.Entity.Segment> segments = entity.getSegment();
            for (Entry.Entity.Segment segment : segments) {
                List<Entry.Entity.Segment.ListMapRegion.MapRegion> mapRegions = segment.getListMapRegion().getMapRegion();
                for (Entry.Entity.Segment.ListMapRegion.MapRegion mapRegion : mapRegions) {
                    accessions.add(mapRegion.getDb().getDbAccessionId().toLowerCase());
                }
            }
        }
        return accessions;
    }

    @Override
    public StructureMapping getSiftsStructureMapping(SequenceI seq, String pdbFile, String chain) throws SiftsException {
        SequenceI aseq = seq;
        while (seq.getDatasetSequence() != null) {
            seq = seq.getDatasetSequence();
        }
        this.structId = chain == null ? this.pdbId : this.pdbId + "|" + chain;
        System.out.println("Getting SIFTS mapping for " + this.structId + ": seq " + seq.getName());
        final StringBuilder mappingDetails = new StringBuilder(128);
        PrintStream ps = new PrintStream(System.out){

            @Override
            public void print(String x) {
                mappingDetails.append(x);
            }

            @Override
            public void println() {
                mappingDetails.append(NEWLINE);
            }
        };
        HashMap<Integer, int[]> mapping = this.getGreedyMapping(chain, seq, ps);
        String mappingOutput = mappingDetails.toString();
        StructureMapping siftsMapping = new StructureMapping(aseq, pdbFile, this.pdbId, chain, mapping, mappingOutput, this.seqFromPdbMapping);
        return siftsMapping;
    }

    @Override
    public HashMap<Integer, int[]> getGreedyMapping(String entityId, SequenceI seq, PrintStream os) throws SiftsException {
        ArrayList<Integer> omitNonObserved = new ArrayList<Integer>();
        int nonObservedShiftIndex = 0;
        int pdbeNonObserved = 0;
        Entry.Entity entity = null;
        entity = this.getEntityById(entityId);
        String originalSeq = AlignSeq.extractGaps(Comparison.GapChars, seq.getSequenceAsString());
        HashMap<Integer, int[]> mapping = new HashMap<Integer, int[]>();
        DBRefEntryI sourceDBRef = this.getValidSourceDBRef(seq);
        if (sourceDBRef.getSource().equalsIgnoreCase("PDB")) {
            this.seqCoordSys = CoordinateSys.PDB;
        }
        HashSet<String> dbRefAccessionIdsString = new HashSet<String>();
        for (DBRefEntry dbref : seq.getDBRefs()) {
            dbRefAccessionIdsString.add(dbref.getAccessionId().toLowerCase());
        }
        dbRefAccessionIdsString.add(sourceDBRef.getAccessionId().toLowerCase());
        this.curDBRefAccessionIdsString = dbRefAccessionIdsString;
        this.curSourceDBRef = sourceDBRef.getAccessionId();
        TreeMap<Integer, String> resNumMap = new TreeMap<Integer, String>();
        List<Entry.Entity.Segment> segments = entity.getSegment();
        SegmentHelperPojo shp = new SegmentHelperPojo(seq, mapping, resNumMap, omitNonObserved, nonObservedShiftIndex, pdbeNonObserved);
        this.processSegments(segments, shp);
        try {
            this.populateAtomPositions(entityId, mapping);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.seqCoordSys == CoordinateSys.UNIPROT) {
            this.padWithGaps(resNumMap, omitNonObserved);
        }
        int seqStart = Integer.MIN_VALUE;
        int seqEnd = Integer.MIN_VALUE;
        int pdbStart = Integer.MIN_VALUE;
        int pdbEnd = Integer.MIN_VALUE;
        if (mapping.isEmpty()) {
            throw new SiftsException("SIFTS mapping failed");
        }
        Object[] keys = mapping.keySet().toArray(new Integer[0]);
        Arrays.sort(keys);
        seqStart = (Integer)keys[0];
        seqEnd = (Integer)keys[keys.length - 1];
        ArrayList<int[]> from = new ArrayList<int[]>();
        ArrayList<int[]> to = new ArrayList<int[]>();
        int[] _cfrom = null;
        int[] _cto = null;
        String matchedSeq = originalSeq;
        if (seqStart != Integer.MIN_VALUE) {
            Object[] objectArray = keys;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                int seqps = (Integer)objectArray[i];
                int pdbpos = mapping.get(seqps)[2];
                if (pdbpos == Integer.MIN_VALUE) continue;
                if (_cfrom == null || seqps != _cfrom[1] + 1) {
                    _cfrom = new int[]{seqps, seqps};
                    from.add(_cfrom);
                    _cto = null;
                } else {
                    _cfrom[1] = seqps;
                }
                if (_cto == null || pdbpos != 1 + _cto[1]) {
                    _cto = new int[]{pdbpos, pdbpos};
                    to.add(_cto);
                    continue;
                }
                _cto[1] = pdbpos;
            }
            _cfrom = new int[from.size() * 2];
            _cto = new int[to.size() * 2];
            int p = 0;
            for (int[] range : from) {
                _cfrom[p++] = range[0];
                _cfrom[p++] = range[1];
            }
            p = 0;
            for (int[] range : to) {
                _cto[p++] = range[0];
                _cto[p++] = range[1];
            }
            this.seqFromPdbMapping = new Mapping(null, _cto, _cfrom, 1, 1);
            pdbStart = mapping.get(seqStart)[0];
            pdbEnd = mapping.get(seqEnd)[0];
            int orignalSeqStart = seq.getStart();
            if (orignalSeqStart >= 1) {
                int subSeqStart = seqStart >= orignalSeqStart ? seqStart - orignalSeqStart : 0;
                int subSeqEnd = seqEnd - (orignalSeqStart - 1);
                subSeqEnd = originalSeq.length() < subSeqEnd ? originalSeq.length() : subSeqEnd;
                matchedSeq = originalSeq.substring(subSeqStart, subSeqEnd);
            } else {
                matchedSeq = originalSeq.substring(1, originalSeq.length());
            }
        }
        StringBuilder targetStrucSeqs = new StringBuilder();
        for (String res : resNumMap.values()) {
            targetStrucSeqs.append(res);
        }
        if (os != null) {
            MappingOutputPojo mop = new MappingOutputPojo();
            mop.setSeqStart(seqStart);
            mop.setSeqEnd(seqEnd);
            mop.setSeqName(seq.getName());
            mop.setSeqResidue(matchedSeq);
            mop.setStrStart(pdbStart);
            mop.setStrEnd(pdbEnd);
            mop.setStrName(this.structId);
            mop.setStrResidue(targetStrucSeqs.toString());
            mop.setType("pep");
            os.print(this.getMappingOutput(mop).toString());
            os.println();
        }
        return mapping;
    }

    void processSegments(List<Entry.Entity.Segment> segments, SegmentHelperPojo shp) {
        SequenceI seq = shp.getSeq();
        HashMap<Integer, int[]> mapping = shp.getMapping();
        TreeMap<Integer, String> resNumMap = shp.getResNumMap();
        List<Integer> omitNonObserved = shp.getOmitNonObserved();
        int nonObservedShiftIndex = shp.getNonObservedShiftIndex();
        int pdbeNonObservedCount = shp.getPdbeNonObserved();
        int firstPDBResNum = Integer.MIN_VALUE;
        for (Entry.Entity.Segment segment : segments) {
            List<Entry.Entity.Segment.ListResidue.Residue> residues = segment.getListResidue().getResidue();
            for (Entry.Entity.Segment.ListResidue.Residue residue : residues) {
                int resNum;
                boolean isObserved = this.isResidueObserved(residue);
                int pdbeIndex = SiftsClient.getLeadingIntegerValue(residue.getDbResNum(), Integer.MIN_VALUE);
                int currSeqIndex = Integer.MIN_VALUE;
                List<Entry.Entity.Segment.ListResidue.Residue.CrossRefDb> cRefDbs = residue.getCrossRefDb();
                Entry.Entity.Segment.ListResidue.Residue.CrossRefDb pdbRefDb = null;
                for (Entry.Entity.Segment.ListResidue.Residue.CrossRefDb cRefDb : cRefDbs) {
                    if (cRefDb.getDbSource().equalsIgnoreCase("PDB")) {
                        pdbRefDb = cRefDb;
                        if (firstPDBResNum == Integer.MIN_VALUE) {
                            firstPDBResNum = SiftsClient.getLeadingIntegerValue(cRefDb.getDbResNum(), Integer.MIN_VALUE);
                        } else if (isObserved) {
                            ++firstPDBResNum;
                        }
                    }
                    if (!cRefDb.getDbCoordSys().equalsIgnoreCase(this.seqCoordSys.getName()) || !this.isAccessionMatched(cRefDb.getDbAccessionId())) continue;
                    currSeqIndex = SiftsClient.getLeadingIntegerValue(cRefDb.getDbResNum(), Integer.MIN_VALUE);
                    if (pdbRefDb == null) continue;
                    break;
                }
                if (!isObserved) {
                    ++pdbeNonObservedCount;
                }
                if (this.seqCoordSys == CoordinateSys.PDB) {
                    currSeqIndex = seq.getStart() - 1 + pdbeIndex;
                }
                if (!isObserved && this.seqCoordSys != CoordinateSys.UNIPROT) {
                    omitNonObserved.add(currSeqIndex);
                    ++nonObservedShiftIndex;
                }
                if (currSeqIndex == Integer.MIN_VALUE) continue;
                int n = resNum = pdbRefDb == null ? SiftsClient.getLeadingIntegerValue(residue.getDbResNum(), Integer.MIN_VALUE) : SiftsClient.getLeadingIntegerValue(pdbRefDb.getDbResNum(), Integer.MIN_VALUE);
                if (!isObserved) continue;
                char resCharCode = ResidueProperties.getSingleCharacterCode(ResidueProperties.getCanonicalAminoAcid(residue.getDbResName()));
                resNumMap.put(currSeqIndex, String.valueOf(resCharCode));
                int[] mappingcols = new int[]{resNum, Integer.MIN_VALUE, isObserved ? firstPDBResNum : Integer.MIN_VALUE};
                mapping.put(currSeqIndex - nonObservedShiftIndex, mappingcols);
            }
        }
    }

    static int getLeadingIntegerValue(String input, int failValue) {
        if (input == null) {
            return failValue;
        }
        String[] parts = input.split("(?=\\D)(?<=\\d)");
        if (parts != null && parts.length > 0 && parts[0].matches("[0-9]+")) {
            return Integer.valueOf(parts[0]);
        }
        return failValue;
    }

    void populateAtomPositions(String chainId, Map<Integer, int[]> mapping) throws IllegalArgumentException, SiftsException {
        try {
            PDBChain chain = this.pdb.findChain(chainId);
            if (chain == null || mapping == null) {
                throw new IllegalArgumentException("Chain id or mapping must not be null.");
            }
            for (int[] map : mapping.values()) {
                if (map[0] == Integer.MIN_VALUE) continue;
                map[1] = this.getAtomIndex(map[0], chain.atoms);
            }
        }
        catch (NullPointerException e) {
            throw new SiftsException(e.getMessage());
        }
        catch (Exception e) {
            throw new SiftsException(e.getMessage());
        }
    }

    int getAtomIndex(int residueIndex, Collection<Atom> atoms) {
        if (atoms == null) {
            throw new IllegalArgumentException("atoms collection must not be null!");
        }
        for (Atom atom : atoms) {
            if (atom.resNumber != residueIndex) continue;
            return atom.atomIndex;
        }
        return Integer.MIN_VALUE;
    }

    private boolean isResidueObserved(Entry.Entity.Segment.ListResidue.Residue residue) {
        Set<String> annotations = this.getResidueAnnotaitons(residue, ResidueDetailType.ANNOTATION);
        if (annotations == null || annotations.isEmpty()) {
            return true;
        }
        for (String annotation : annotations) {
            if (!annotation.equalsIgnoreCase(NOT_OBSERVED)) continue;
            return false;
        }
        return true;
    }

    private Set<String> getResidueAnnotaitons(Entry.Entity.Segment.ListResidue.Residue residue, ResidueDetailType type) {
        HashSet<String> foundAnnotations = new HashSet<String>();
        List<Entry.Entity.Segment.ListResidue.Residue.ResidueDetail> resDetails = residue.getResidueDetail();
        for (Entry.Entity.Segment.ListResidue.Residue.ResidueDetail resDetail : resDetails) {
            if (!resDetail.getProperty().equalsIgnoreCase(type.getCode())) continue;
            foundAnnotations.add(resDetail.getContent());
        }
        return foundAnnotations;
    }

    @Override
    public boolean isAccessionMatched(String accession) {
        boolean isStrictMatch = true;
        return isStrictMatch ? this.curSourceDBRef.equalsIgnoreCase(accession) : this.curDBRefAccessionIdsString.contains(accession.toLowerCase());
    }

    private boolean isFoundInSiftsEntry(String accessionId) {
        HashSet<String> siftsDBRefs = this.getAllMappingAccession();
        return accessionId != null && siftsDBRefs.contains(accessionId.toLowerCase());
    }

    void padWithGaps(Map<Integer, String> resNumMap, List<Integer> omitNonObserved) {
        if (resNumMap == null || resNumMap.isEmpty()) {
            return;
        }
        Integer[] keys = resNumMap.keySet().toArray(new Integer[0]);
        int firstIndex = keys[0];
        int lastIndex = keys[keys.length - 1];
        for (int x = firstIndex; x <= lastIndex; ++x) {
            if (resNumMap.containsKey(x) || omitNonObserved.contains(x)) continue;
            resNumMap.put(x, "-");
        }
    }

    @Override
    public Entry.Entity getEntityById(String id) throws SiftsException {
        Entry.Entity entity = this.getEntityByMostOptimalMatchedId(id);
        if (entity != null) {
            return entity;
        }
        throw new SiftsException("Entity " + id + " not found");
    }

    public Entry.Entity getEntityByMostOptimalMatchedId(String chainId) {
        List<Entry.Entity> entities = this.siftsEntry.getEntity();
        SiftsEntitySortPojo[] sPojo = new SiftsEntitySortPojo[entities.size()];
        int count = 0;
        for (Entry.Entity entity : entities) {
            sPojo[count] = new SiftsEntitySortPojo();
            sPojo[count].entityId = entity.getEntityId();
            List<Entry.Entity.Segment> segments = entity.getSegment();
            for (Entry.Entity.Segment segment : segments) {
                List<Entry.Entity.Segment.ListResidue.Residue> residues = segment.getListResidue().getResidue();
                for (Entry.Entity.Segment.ListResidue.Residue residue : residues) {
                    List<Entry.Entity.Segment.ListResidue.Residue.CrossRefDb> cRefDbs = residue.getCrossRefDb();
                    for (Entry.Entity.Segment.ListResidue.Residue.CrossRefDb cRefDb : cRefDbs) {
                        if (!cRefDb.getDbSource().equalsIgnoreCase("PDB")) continue;
                        ++sPojo[count].resCount;
                        if (!cRefDb.getDbChainId().equalsIgnoreCase(chainId)) continue;
                        ++sPojo[count].chainIdFreq;
                    }
                }
            }
            sPojo[count].pid = 100 * sPojo[count].chainIdFreq / sPojo[count].resCount;
            ++count;
        }
        Arrays.sort(sPojo, Collections.reverseOrder());
        if (sPojo[0].entityId != null) {
            if (sPojo[0].pid < 1) {
                return null;
            }
            for (Entry.Entity entity : entities) {
                if (!entity.getEntityId().equalsIgnoreCase(sPojo[0].entityId)) continue;
                return entity;
            }
        }
        return null;
    }

    @Override
    public StringBuilder getMappingOutput(MappingOutputPojo mp) throws SiftsException {
        String seqRes = mp.getSeqResidue();
        String seqName = mp.getSeqName();
        int sStart = mp.getSeqStart();
        int sEnd = mp.getSeqEnd();
        String strRes = mp.getStrResidue();
        String strName = mp.getStrName();
        int pdbStart = mp.getStrStart();
        int pdbEnd = mp.getStrEnd();
        String type = mp.getType();
        int maxid = seqName.length() >= strName.length() ? seqName.length() : strName.length();
        int len = 72 - maxid - 1;
        int nochunks = seqRes.length() / len + (seqRes.length() % len > 0 ? 1 : 0);
        StringBuilder output = new StringBuilder(512);
        output.append(NEWLINE);
        output.append("Sequence \u27f7 Structure mapping details").append(NEWLINE);
        output.append("Method: SIFTS");
        output.append(NEWLINE).append(NEWLINE);
        output.append(new Format("%" + maxid + "s").form(seqName));
        output.append(" :  ");
        output.append(String.valueOf(sStart));
        output.append(" - ");
        output.append(String.valueOf(sEnd));
        output.append(" Maps to ");
        output.append(NEWLINE);
        output.append(new Format("%" + maxid + "s").form(this.structId));
        output.append(" :  ");
        output.append(String.valueOf(pdbStart));
        output.append(" - ");
        output.append(String.valueOf(pdbEnd));
        output.append(NEWLINE).append(NEWLINE);
        ScoreMatrix pam250 = ScoreModels.getInstance().getPam250();
        int matchedSeqCount = 0;
        for (int j = 0; j < nochunks; ++j) {
            int i;
            output.append(new Format("%" + maxid + "s").form(seqName)).append(" ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= seqRes.length()) continue;
                output.append(seqRes.charAt(i + j * len));
            }
            output.append(NEWLINE);
            output.append(new Format("%" + maxid + "s").form(" ")).append(" ");
            for (i = 0; i < len; ++i) {
                try {
                    char c2;
                    if (i + j * len >= seqRes.length()) continue;
                    char c1 = seqRes.charAt(i + j * len);
                    boolean sameChar = Comparison.isSameResidue(c1, c2 = strRes.charAt(i + j * len), false);
                    if (sameChar && !Comparison.isGap(c1)) {
                        ++matchedSeqCount;
                        output.append("|");
                        continue;
                    }
                    if (type.equals("pep")) {
                        if (pam250.getPairwiseScore(c1, c2) > 0.0f) {
                            output.append(".");
                            continue;
                        }
                        output.append(" ");
                        continue;
                    }
                    output.append(" ");
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    // empty catch block
                }
            }
            output = output.append(NEWLINE);
            output = output.append(new Format("%" + maxid + "s").form(strName)).append(" ");
            for (i = 0; i < len; ++i) {
                if (i + j * len >= strRes.length()) continue;
                output.append(strRes.charAt(i + j * len));
            }
            output.append(NEWLINE).append(NEWLINE);
        }
        float pid = (float)matchedSeqCount / (float)seqRes.length() * 100.0f;
        if (pid < (float)SiftsSettings.getFailSafePIDThreshold()) {
            throw new SiftsException(">>> Low PID detected for SIFTs mapping...");
        }
        output.append("Length of alignment = " + seqRes.length()).append(NEWLINE);
        output.append(new Format("Percentage ID = %2.2f").form(pid));
        return output;
    }

    @Override
    public int getEntityCount() {
        return this.siftsEntry.getEntity().size();
    }

    @Override
    public String getDbAccessionId() {
        return this.siftsEntry.getDbAccessionId();
    }

    @Override
    public String getDbCoordSys() {
        return this.siftsEntry.getDbCoordSys();
    }

    @Override
    public String getDbSource() {
        return this.siftsEntry.getDbSource();
    }

    @Override
    public String getDbVersion() {
        return this.siftsEntry.getDbVersion();
    }

    public static void setMockSiftsFile(File file) {
        mockSiftsFile = file;
    }

    static {
        NEWLINE = System.lineSeparator();
    }

    private class SegmentHelperPojo {
        private SequenceI seq;
        private HashMap<Integer, int[]> mapping;
        private TreeMap<Integer, String> resNumMap;
        private List<Integer> omitNonObserved;
        private int nonObservedShiftIndex;
        private int pdbeNonObserved;

        public SegmentHelperPojo(SequenceI seq, HashMap<Integer, int[]> mapping, TreeMap<Integer, String> resNumMap, List<Integer> omitNonObserved, int nonObservedShiftIndex, int pdbeNonObserved) {
            this.setSeq(seq);
            this.setMapping(mapping);
            this.setResNumMap(resNumMap);
            this.setOmitNonObserved(omitNonObserved);
            this.setNonObservedShiftIndex(nonObservedShiftIndex);
            this.setPdbeNonObserved(pdbeNonObserved);
        }

        public void setPdbeNonObserved(int pdbeNonObserved2) {
            this.pdbeNonObserved = pdbeNonObserved2;
        }

        public int getPdbeNonObserved() {
            return this.pdbeNonObserved;
        }

        public SequenceI getSeq() {
            return this.seq;
        }

        public void setSeq(SequenceI seq) {
            this.seq = seq;
        }

        public HashMap<Integer, int[]> getMapping() {
            return this.mapping;
        }

        public void setMapping(HashMap<Integer, int[]> mapping) {
            this.mapping = mapping;
        }

        public TreeMap<Integer, String> getResNumMap() {
            return this.resNumMap;
        }

        public void setResNumMap(TreeMap<Integer, String> resNumMap) {
            this.resNumMap = resNumMap;
        }

        public List<Integer> getOmitNonObserved() {
            return this.omitNonObserved;
        }

        public void setOmitNonObserved(List<Integer> omitNonObserved) {
            this.omitNonObserved = omitNonObserved;
        }

        public int getNonObservedShiftIndex() {
            return this.nonObservedShiftIndex;
        }

        public void setNonObservedShiftIndex(int nonObservedShiftIndex) {
            this.nonObservedShiftIndex = nonObservedShiftIndex;
        }
    }

    private class SiftsEntitySortPojo
    implements Comparable<SiftsEntitySortPojo> {
        public String entityId;
        public int chainIdFreq;
        public int pid;
        public int resCount;

        private SiftsEntitySortPojo() {
        }

        @Override
        public int compareTo(SiftsEntitySortPojo o) {
            return this.pid - o.pid;
        }
    }

    private static enum ResidueDetailType {
        NAME_SEC_STRUCTURE("nameSecondaryStructure"),
        CODE_SEC_STRUCTURE("codeSecondaryStructure"),
        ANNOTATION("Annotation");

        private String code;

        private ResidueDetailType(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    private static enum CoordinateSys {
        UNIPROT("UniProt"),
        PDB("PDBresnum"),
        PDBe("PDBe");

        private String name;

        private CoordinateSys(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

