/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.rest.clientdefs;

import jalview.io.packed.DataProvider;
import jalview.util.MessageManager;
import jalview.ws.rest.InputType;
import jalview.ws.rest.RestClient;
import jalview.ws.rest.RestServiceDescription;
import jalview.ws.rest.params.Alignment;
import jalview.ws.rest.params.SeqGroupIndexVector;
import java.util.Hashtable;

public class ShmrRestClient {
    public static RestClient makeShmmrRestClient() {
        String action = "Analysis";
        String description = "Sequence Harmony and Multi-Relief (Brandt et al. 2010)";
        String name = MessageManager.getString("label.multiharmony");
        Hashtable<String, InputType> iparams = new Hashtable<String, InputType>();
        Alignment aliinput = new Alignment();
        aliinput.token = "ali_file";
        aliinput.writeAsFile = true;
        iparams.put(aliinput.token, aliinput);
        SeqGroupIndexVector sgroups = new SeqGroupIndexVector();
        sgroups.setMinsize(2);
        sgroups.min = 2;
        iparams.put("groups", sgroups);
        sgroups.token = "groups";
        sgroups.sep = " ";
        RestServiceDescription shmrService = new RestServiceDescription(action, description, name, "http://zeus.few.vu.nl/programs/shmrwww/index.php?tool=jalview", "?tool=jalview", iparams, true, false, '-');
        shmrService.addResultDatatype(DataProvider.JvDataType.ANNOTATION);
        return new RestClient(shmrService);
    }
}

