/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.JABAService;
import compbio.data.msa.MsaWS;
import compbio.data.msa.SequenceAnnotation;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.util.MessageManager;
import jalview.ws.api.JalviewServiceEndpointProviderI;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.MsaWSClient;
import jalview.ws.jws2.SequenceAnnotationWSClient;
import jalview.ws.jws2.jabaws2.JabawsMsaInstance;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.io.Closeable;
import java.net.URL;
import javax.swing.JMenu;

public class Jws2Instance
extends ServiceWithParameters
implements JalviewServiceEndpointProviderI,
AutoCloseable {
    public JABAService service;
    PresetManager presets = null;
    public JabaParamStore paramStore = null;
    private boolean hasParams = false;
    private boolean lookedForParams = false;
    AlignAnalysisUIText aaui;

    public Jws2Instance(String hosturl, String serviceType, String action, String description, JABAService service) {
        super(action, action, serviceType, description, hosturl);
        this.service = service;
        int p = description.indexOf("MORE INFORMATION:");
        if (p > -1) {
            String docUrl = description.substring(description.indexOf("http", p)).trim();
            if (docUrl.indexOf(10) > -1) {
                docUrl = docUrl.substring(0, docUrl.indexOf("\n")).trim();
            }
            if (docUrl.length() > 0) {
                try {
                    URL url = new URL(docUrl);
                    if (url != null) {
                        this.setDocumentationUrl(docUrl);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public PresetManager getPresets() {
        if (this.presets == null) {
            try {
                if (this.service instanceof MsaWS) {
                    this.presets = ((MsaWS)this.service).getPresets();
                }
                if (this.service instanceof SequenceAnnotation) {
                    this.presets = ((SequenceAnnotation)this.service).getPresets();
                }
            }
            catch (Exception ex) {
                System.err.println("Exception when retrieving presets for service " + this.getServiceType() + " at " + this.getHostURL());
            }
        }
        return this.presets;
    }

    public RunnerConfig getRunnerConfig() {
        if (this.service instanceof MsaWS) {
            return ((MsaWS)this.service).getRunnerOptions();
        }
        if (this.service instanceof SequenceAnnotation) {
            return ((SequenceAnnotation)this.service).getRunnerOptions();
        }
        throw new Error(MessageManager.formatMessage("error.implementation_error_runner_config_not_available", new String[]{this.getServiceType(), this.service.getClass().toString()}));
    }

    @Override
    public void close() {
        if (this.service != null) {
            try {
                ((Closeable)this.service).close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Override
    public ParamDatastoreI getParamStore() {
        if (this.paramStore == null) {
            try {
                this.paramStore = new JabaParamStore(this, Desktop.instance != null ? Desktop.getUserParameterStore() : null);
            }
            catch (Exception ex) {
                System.err.println("Unexpected exception creating JabaParamStore.");
                ex.printStackTrace();
            }
        }
        return this.paramStore;
    }

    public String getUri() {
        return this.getHostURL() + (this.getHostURL().lastIndexOf("/") == this.getHostURL().length() - 1 ? "" : "/") + this.getName();
    }

    @Override
    public boolean hasParameters() {
        if (!this.lookedForParams) {
            this.lookedForParams = true;
            try {
                this.hasParams = this.getRunnerConfig().getArguments().size() > 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.hasParams;
    }

    public void attachWSMenuEntry(JMenu atpoint, AlignFrame alignFrame) {
        if (this.service instanceof MsaWS) {
            new MsaWSClient().attachWSMenuEntry(atpoint, this, alignFrame);
        } else if (this.service instanceof SequenceAnnotation) {
            new SequenceAnnotationWSClient().attachWSMenuEntry(atpoint, this, alignFrame);
        }
    }

    public String getNameURI() {
        return "java:" + this.getName();
    }

    public AlignAnalysisUIText getAlignAnalysisUI() {
        return this.aaui;
    }

    @Override
    public void initParamStore(ParamManager userParameterStore) {
        if (this.paramStore == null) {
            this.paramStore = new JabaParamStore(this, userParameterStore);
        }
    }

    @Override
    public Object getEndpoint() {
        if (this.aaui != null) {
            return null;
        }
        if (this.service instanceof MsaWS) {
            return new JabawsMsaInstance(this);
        }
        return null;
    }
}

