/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2.jabaws2;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.FastaSequence;
import compbio.metadata.Argument;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.LimitExceededException;
import compbio.metadata.Preset;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.UnsupportedRuntimeException;
import compbio.metadata.WrongParameterException;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;
import jalview.gui.WebserviceInfo;
import jalview.util.MessageManager;
import jalview.ws.api.CancellableI;
import jalview.ws.api.JobId;
import jalview.ws.api.MultipleSequenceAlignmentI;
import jalview.ws.gui.WsJob;
import jalview.ws.jws2.JabaParamStore;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.InvalidArgumentException;
import jalview.ws.params.WsParamSetI;
import java.io.IOError;
import java.rmi.ServerError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JabawsMsaInstance
implements MultipleSequenceAlignmentI,
CancellableI {
    Jws2Instance our;
    MsaWS<?> service;
    Map<JobStatus, WsJob.JobState> jwsState = new HashMap<JobStatus, WsJob.JobState>();

    @Override
    public JobId align(List<SequenceI> toalign, WsParamSetI parameters, List<ArgumentI> arguments) throws Throwable {
        ArrayList<FastaSequence> seqs = new ArrayList<FastaSequence>();
        for (SequenceI seq : toalign) {
            seqs.add(new FastaSequence(seq.getName(), seq.getSequenceAsString()));
        }
        String jobid = null;
        jobid = parameters != null ? (parameters instanceof JabaPreset ? this.service.presetAlign(seqs, ((JabaPreset)parameters).getJabaPreset()) : this.service.customAlign(seqs, JabaParamStore.getJabafromJwsArgs(parameters.getArguments()))) : (arguments != null && arguments.size() > 0 ? this.service.customAlign(seqs, JabaParamStore.getJabafromJwsArgs(arguments)) : this.service.align(seqs));
        if (jobid == null) {
            return null;
        }
        return new JobId(this.our.getServiceType(), this.our.getName(), jobid);
    }

    @Override
    public AlignmentI getAlignmentFor(JobId jobId) throws InvalidArgumentException, ServerError, IOError {
        compbio.data.sequence.Alignment alignment = null;
        try {
            alignment = this.service.getResult(jobId.getJobId());
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            // empty catch block
        }
        int alseq_l = 0;
        if (alignment.getSequences().size() == 0) {
            return null;
        }
        SequenceI[] alseqs = new SequenceI[alignment.getSequences().size()];
        for (FastaSequence seq : alignment.getSequences()) {
            alseqs[alseq_l++] = new Sequence(seq.getId(), seq.getSequence());
        }
        Alignment jv_al = new Alignment(alseqs);
        jv_al.setGapCharacter(alignment.getMetadata().getGapchar());
        return jv_al;
    }

    public JabawsMsaInstance(Jws2Instance handle) {
        this.jwsState.put(JobStatus.CANCELLED, WsJob.JobState.CANCELLED);
        this.jwsState.put(JobStatus.COLLECTED, WsJob.JobState.FINISHED);
        this.jwsState.put(JobStatus.FAILED, WsJob.JobState.FAILED);
        this.jwsState.put(JobStatus.FINISHED, WsJob.JobState.FINISHED);
        this.jwsState.put(JobStatus.PENDING, WsJob.JobState.QUEUED);
        this.jwsState.put(JobStatus.RUNNING, WsJob.JobState.RUNNING);
        this.jwsState.put(JobStatus.STARTED, WsJob.JobState.RUNNING);
        this.jwsState.put(JobStatus.SUBMITTED, WsJob.JobState.SUBMITTED);
        this.jwsState.put(JobStatus.UNDEFINED, WsJob.JobState.UNKNOWN);
        this.our = handle;
        this.service = (MsaWS)this.our.service;
    }

    @Override
    public boolean cancel(WsJob job) {
        this.service.cancelJob(job.getJobId());
        return true;
    }

    @Override
    public void updateStatus(WsJob job) {
        JobStatus jwsstatus = this.service.getJobStatus(job.getJobId());
        job.setState(this.jwsState.get(jwsstatus));
    }

    @Override
    public boolean updateJobProgress(WsJob job) throws Exception {
        StringBuilder response = new StringBuilder(job.getStatus());
        long lastchunk = job.getNextChunk();
        boolean changed = false;
        do {
            ChunkHolder chunk;
            if ((chunk = this.service.pullExecStatistics(job.getJobId(), lastchunk)) != null) {
                changed |= chunk.getChunk().length() > 0;
                response.append(chunk.getChunk());
                lastchunk = chunk.getNextPosition();
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            job.setnextChunk(lastchunk);
        } while (lastchunk >= 0L && job.getNextChunk() != lastchunk);
        if (job instanceof WsJob) {
            job.setStatus(response.toString());
        }
        return changed;
    }

    public boolean isPresetJob(WsJob job) {
        return job.getPreset() != null && job.getPreset() instanceof JabaPreset;
    }

    public Preset getServerPreset(WsJob job) {
        return this.isPresetJob(job) ? ((JabaPreset)job.getPreset()).getJabaPreset() : null;
    }

    public List<Argument> getJabaArguments(WsParamSetI preset) {
        ArrayList<Argument> newargs = new ArrayList<Argument>();
        if (preset != null) {
            if (preset instanceof JabaWsParamSet) {
                newargs.addAll(((JabaWsParamSet)preset).getjabaArguments());
            } else {
                newargs.addAll(JabaParamStore.getJabafromJwsArgs(preset.getArguments()));
            }
        }
        return newargs;
    }

    @Override
    public boolean handleSubmitError(Throwable _lex, WsJob j, WebserviceInfo wsInfo) throws Exception, Error {
        if (_lex instanceof UnsupportedRuntimeException) {
            wsInfo.appendProgressText(MessageManager.formatMessage("info.job_couldnt_be_run_server_doesnt_support_program", new String[]{_lex.getMessage()}));
            wsInfo.warnUser(_lex.getMessage(), MessageManager.getString("warn.service_not_supported"));
            wsInfo.setStatus(5);
            wsInfo.setStatus(j.getJobnum(), 5);
            return true;
        }
        if (_lex instanceof LimitExceededException) {
            wsInfo.appendProgressText(MessageManager.formatMessage("info.job_couldnt_be_run_exceeded_hard_limit", new String[]{_lex.getMessage()}));
            wsInfo.warnUser(_lex.getMessage(), MessageManager.getString("warn.input_is_too_big"));
            wsInfo.setStatus(4);
            wsInfo.setStatus(j.getJobnum(), 4);
            return true;
        }
        if (_lex instanceof WrongParameterException) {
            wsInfo.warnUser(_lex.getMessage(), MessageManager.getString("warn.invalid_job_param_set"));
            wsInfo.appendProgressText(MessageManager.formatMessage("info.job_couldnt_be_run_incorrect_param_setting", new String[]{_lex.getMessage()}));
            wsInfo.setStatus(4);
            wsInfo.setStatus(j.getJobnum(), 4);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleCollectionException(Exception ex, WsJob msjob, WebserviceInfo wsInfo) {
        if (ex instanceof ResultNotAvailableException) {
            Cache.log.debug((Object)"Results not available for finished job - marking as broken job.", (Throwable)ex);
            String status = msjob.getStatus();
            msjob.setStatus(status + "\nResult not available. Probably due to invalid input or parameter settings. Server error message below:\n\n" + ex.getLocalizedMessage());
            msjob.setState(WsJob.JobState.BROKEN);
            return true;
        }
        return false;
    }
}

