/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.RunnerConfig;
import compbio.metadata.ValueConstrain;
import compbio.metadata.WrongParameterException;
import jalview.util.MessageManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class ParameterUtils {
    public static List<String> writeParameterSet(List<Option> optSet, String pseparator) {
        ArrayList<String> pset = new ArrayList<String>();
        for (Option o : optSet) {
            pset.add(o.toCommand(pseparator));
        }
        return pset;
    }

    public static List<Option> processParameters(List<String> params, RunnerConfig options, String pseparator) {
        ArrayList<Option> chosenOptions = new ArrayList<Option>();
        for (String param : params) {
            String oname = null;
            oname = ParameterUtils.isParameter(param, pseparator) ? ParameterUtils.getParamName(param, pseparator) : param;
            Object o = options.getArgumentByOptionName(oname);
            if (o == null) {
                System.out.println("WARN ignoring unsuppoted parameter: " + oname);
                continue;
            }
            o = o instanceof Parameter ? ParameterUtils.copyParameter((Parameter)o) : ParameterUtils.copyOption(o);
            try {
                o.setDefaultValue(ParameterUtils.isParameter(param, pseparator) ? ParameterUtils.getParamValue(param, pseparator) : param);
            }
            catch (WrongParameterException e) {
                System.out.println("Problem setting value for the parameter: " + param);
                e.printStackTrace();
            }
            chosenOptions.add((Option)o);
        }
        return chosenOptions;
    }

    static String getParamName(String fullName, String pseparator) {
        assert (ParameterUtils.isParameter(fullName, pseparator));
        return fullName.substring(0, fullName.indexOf(pseparator));
    }

    static String getParamValue(String fullName, String pseparator) {
        assert (ParameterUtils.isParameter(fullName, pseparator));
        return fullName.substring(fullName.indexOf(pseparator) + 1);
    }

    static boolean isParameter(String param, String pseparator) {
        return param.contains(pseparator);
    }

    public static Option copyOption(Option option) {
        Option copy = new Option(option.getName(), option.getDescription());
        ParameterUtils.setOptionFrom(copy, option);
        return copy;
    }

    public static void setOptionFrom(Option copy, Option option) {
        copy.setName(option.getName());
        copy.setDescription(option.getDescription());
        copy.setBasicURL(option.getBasicURL());
        copy.setFurtherDetails(option.getFurtherDetails());
        copy.setRequired(option.isRequired());
        List names = option.getOptionNames();
        if (names != null) {
            if (names.size() == 1) {
                HashSet<String> st = new HashSet<String>();
                st.add((String)names.get(0));
                copy.setOptionNames(st);
            } else {
                copy.addOptionNames(names.toArray(new String[0]));
            }
        }
        try {
            if (option.getDefaultValue() != null) {
                copy.setDefaultValue(option.getDefaultValue());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static ValueConstrain copyValueConstrain(ValueConstrain vc) {
        try {
            ValueConstrain copy = new ValueConstrain();
            if (vc.getMax() != null) {
                copy.setMax(vc.getMax().toString());
            }
            if (vc.getMin() != null) {
                copy.setMin(vc.getMin().toString());
            }
            if (vc.getType() != null) {
                copy.setType(vc.getType());
            }
            return copy;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Error(MessageManager.getString("error.implementation_error_couldnt_copy_value_constraint"));
        }
    }

    public static Parameter copyParameter(Parameter parameter) {
        List pv;
        Parameter copy = new Parameter(parameter.getName(), parameter.getDescription());
        if (parameter.getValidValue() != null) {
            copy.setValidValue(ParameterUtils.copyValueConstrain(parameter.getValidValue()));
        }
        if ((pv = parameter.getPossibleValues()) != null) {
            copy.addPossibleValues(pv.toArray(new String[0]));
        }
        ParameterUtils.setOptionFrom((Option)copy, (Option)parameter);
        return copy;
    }
}

