/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.ws.client.Services;
import jalview.api.AlignCalcWorkerI;
import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.JvSwingUtils;
import jalview.util.MessageManager;
import jalview.ws.WSClient;
import jalview.ws.api.ServiceWithParameters;
import jalview.ws.jws2.AbstractJabaCalcWorker;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.Jws2Discoverer;
import jalview.ws.jws2.SequenceAnnotationWSClient;
import jalview.ws.jws2.dm.AAConSettings;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.WsParamSetI;
import jalview.ws.uimodel.AlignAnalysisUIText;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class Jws2Client
extends WSClient {
    public Jws2Client(AlignFrame _alignFrame, WsParamSetI preset, List<ArgumentI> arguments) {
        super(_alignFrame, preset, arguments);
        if (preset != null && !(preset instanceof JabaPreset) && !(preset instanceof JabaWsParamSet)) {
            throw new Error(MessageManager.getString("error.implementation_error_can_only_instantiate_jaba_param_sets"));
        }
    }

    public Jws2Client() {
    }

    abstract void attachWSMenuEntry(JMenu var1, ServiceWithParameters var2, AlignFrame var3);

    static boolean registerAAConWSInstance(JMenu wsmenu, ServiceWithParameters service, final AlignFrame alignFrame) {
        Jws2Instance jaba_service = (Jws2Instance)service;
        final AlignAnalysisUIText aaui = jaba_service.getAlignAnalysisUI();
        if (aaui == null) {
            return false;
        }
        JCheckBoxMenuItem _aaConEnabled = null;
        for (int i = 0; i < wsmenu.getItemCount(); ++i) {
            JMenuItem item = wsmenu.getItem(i);
            if (!(item instanceof JCheckBoxMenuItem) || !item.getText().equals(aaui.getAAconToggle())) continue;
            _aaConEnabled = (JCheckBoxMenuItem)item;
        }
        List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(aaui.getClient());
        if (aaconClient != null && aaconClient.size() > 0) {
            AbstractJabaCalcWorker worker = (AbstractJabaCalcWorker)aaconClient.get(0);
            if (!worker.service.getHostURL().equals(service.getHostURL())) {
                Jws2Client.removeCurrentAAConWorkerFor(aaui, alignFrame);
                Jws2Client.buildCurrentAAConWorkerFor(aaui, alignFrame, jaba_service);
            }
        }
        if (_aaConEnabled == null) {
            final JCheckBoxMenuItem aaConEnabled = new JCheckBoxMenuItem(aaui.getAAconToggle());
            aaConEnabled.setToolTipText(JvSwingUtils.wrapTooltip(true, aaui.getAAconToggleTooltip()));
            aaConEnabled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(aaui.getClient());
                    if (aaconClient != null && aaconClient.size() > 0) {
                        Jws2Client.removeCurrentAAConWorkerFor(aaui, alignFrame);
                    } else {
                        Jws2Client.buildCurrentAAConWorkerFor(aaui, alignFrame);
                    }
                }
            });
            wsmenu.add(aaConEnabled);
            final JMenuItem modifyParams = new JMenuItem(aaui.getAAeditSettings());
            modifyParams.setToolTipText(JvSwingUtils.wrapTooltip(true, aaui.getAAeditSettingsTooltip()));
            modifyParams.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Jws2Client.showAAConAnnotationSettingsFor(aaui, alignFrame);
                }
            });
            wsmenu.add(modifyParams);
            wsmenu.addMenuListener(new MenuListener(){

                @Override
                public void menuSelected(MenuEvent arg0) {
                    if (alignFrame.getViewport().getAlignment().isNucleotide() ? aaui.isNa() : aaui.isPr()) {
                        aaConEnabled.setEnabled(true);
                        modifyParams.setEnabled(true);
                    } else {
                        aaConEnabled.setEnabled(false);
                        modifyParams.setEnabled(false);
                    }
                    List<AlignCalcWorkerI> aaconClient = alignFrame.getViewport().getCalcManager().getRegisteredWorkersOfClass(aaui.getClient());
                    if (aaconClient != null && aaconClient.size() > 0) {
                        aaConEnabled.setSelected(true);
                    } else {
                        aaConEnabled.setSelected(false);
                    }
                }

                @Override
                public void menuDeselected(MenuEvent arg0) {
                }

                @Override
                public void menuCanceled(MenuEvent arg0) {
                }
            });
        }
        return true;
    }

    private static void showAAConAnnotationSettingsFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        AAConSettings fave = (AAConSettings)alignFrame.getViewport().getCalcIdSettingsFor(aaui.getCalcId());
        if (fave == null) {
            fave = Jws2Client.createDefaultAAConSettings(aaui);
        }
        new SequenceAnnotationWSClient(fave, alignFrame, true);
    }

    private static void buildCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        Jws2Client.buildCurrentAAConWorkerFor(aaui, alignFrame, null);
    }

    private static void buildCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame, Jws2Instance service) {
        AAConSettings fave = (AAConSettings)alignFrame.getViewport().getCalcIdSettingsFor(aaui.getCalcId());
        if (fave == null) {
            fave = Jws2Client.createDefaultAAConSettings(aaui, service);
        } else if (service != null && !fave.getService().getHostURL().equals(service.getHostURL())) {
            Cache.log.debug((Object)("Changing AACon service to " + service.getHostURL() + " from " + fave.getService().getHostURL()));
            fave.setService(service);
        }
        new SequenceAnnotationWSClient(fave, alignFrame, false);
    }

    private static AAConSettings createDefaultAAConSettings(AlignAnalysisUIText aaui) {
        return Jws2Client.createDefaultAAConSettings(aaui, null);
    }

    private static AAConSettings createDefaultAAConSettings(AlignAnalysisUIText aaui, Jws2Instance service) {
        if (service != null) {
            if (!service.getServiceType().equals(Services.AAConWS.toString())) {
                Cache.log.warn((Object)("Ignoring invalid preferred service for AACon calculations (service type was " + service.getServiceType() + ")"));
                service = null;
            } else if (!Jws2Discoverer.getDiscoverer().getServices().contains(service)) {
                service = null;
            }
        }
        if (service == null) {
            service = Jws2Discoverer.getDiscoverer().getPreferredServiceFor(null, aaui.getServiceType());
        }
        if (service == null) {
            throw new Error(MessageManager.getString("error.no_aacon_service_found"));
        }
        return new AAConSettings(true, service, null, null);
    }

    private static void removeCurrentAAConWorkerFor(AlignAnalysisUIText aaui, AlignFrame alignFrame) {
        alignFrame.getViewport().getCalcManager().removeRegisteredWorkersOfClass(aaui.getClient());
    }
}

