/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.jws2;

import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.RunnerConfig;
import jalview.util.MessageManager;
import jalview.util.QuickSort;
import jalview.ws.jws2.JabaPreset;
import jalview.ws.jws2.ParameterUtils;
import jalview.ws.jws2.dm.JabaOption;
import jalview.ws.jws2.dm.JabaParameter;
import jalview.ws.jws2.dm.JabaWsParamSet;
import jalview.ws.jws2.jabaws2.Jws2Instance;
import jalview.ws.params.ArgumentI;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.params.WsParamSetI;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class JabaParamStore
implements ParamDatastoreI {
    Hashtable<String, JabaWsParamSet> editedParams = new Hashtable();
    private Jws2Instance service;
    private RunnerConfig serviceOptions;
    private Hashtable<String, JabaPreset> servicePresets;
    ParamManager manager;

    public JabaParamStore(Jws2Instance service) {
        this(service, null);
    }

    public JabaParamStore(Jws2Instance service, ParamManager manager) {
        this.service = service;
        this.serviceOptions = service.getRunnerConfig();
        this.manager = manager;
        if (manager != null) {
            manager.registerParser(service.getUri(), this);
            WsParamSetI[] prams = manager.getParameterSet(null, service.getUri(), true, false);
            if (prams != null) {
                for (WsParamSetI paramset : prams) {
                    if (paramset instanceof JabaWsParamSet) {
                        this.editedParams.put(paramset.getName(), (JabaWsParamSet)paramset);
                        continue;
                    }
                    System.err.println("Warning: Ignoring parameter set instance of type " + paramset.getClass() + " : Bound but not applicable for service at " + service.getUri());
                }
            }
        }
    }

    @Override
    public List<WsParamSetI> getPresets() {
        ArrayList<WsParamSetI> prefs = new ArrayList<WsParamSetI>();
        if (this.servicePresets == null) {
            List list;
            this.servicePresets = new Hashtable();
            PresetManager prman = this.service.getPresets();
            if (prman != null && (list = prman.getPresets()) != null) {
                for (Object pr : list) {
                    JabaPreset prset = new JabaPreset(this.service, (Preset)pr);
                    this.servicePresets.put(prset.getName(), prset);
                }
            }
        }
        for (JabaPreset jabaPreset : this.servicePresets.values()) {
            prefs.add(jabaPreset);
        }
        for (WsParamSetI wsParamSetI : this.editedParams.values()) {
            prefs.add(wsParamSetI);
        }
        return prefs;
    }

    @Override
    public WsParamSetI getPreset(String name) {
        for (WsParamSetI pr : this.getPresets()) {
            if (!pr.getName().equals(name)) continue;
            return pr;
        }
        return null;
    }

    public static List<ArgumentI> getJwsArgsfromJaba(List jabargs) {
        return JabaParamStore.getJwsArgsfromJaba(jabargs, true);
    }

    public static List<ArgumentI> getJwsArgsfromJaba(List jabargs, boolean sortByOpt) {
        ArrayList<ArgumentI> rgs = new ArrayList<ArgumentI>();
        ArrayList<String> rgnames = new ArrayList<String>();
        for (Object rg : jabargs) {
            JabaOption narg = null;
            String nargstring = null;
            if (rg instanceof Parameter) {
                narg = new JabaParameter((Parameter)rg);
                nargstring = narg.getName();
            } else if (rg instanceof Option) {
                narg = new JabaOption((Option)rg);
                nargstring = (String)((Option)rg).getOptionNames().get(0);
            }
            if (narg == null) {
                throw new Error(MessageManager.formatMessage("error.implementation_error_cannot_handle_jaba_param", new String[]{rg.getClass().toString()}));
            }
            rgs.add(narg);
            rgnames.add(nargstring);
        }
        if (!sortByOpt) {
            return rgs;
        }
        Object[] rgssort = rgs.toArray(new ArgumentI[rgs.size()]);
        String[] rgssorton = rgnames.toArray(new String[rgs.size()]);
        QuickSort.sort(rgssorton, rgssort);
        int i = 0;
        while (rgssort.length - i > i) {
            Object tmp1 = rgssort[rgssort.length - i - 1];
            rgssort[rgssort.length - i - 1] = rgssort[i];
            rgssort[i++] = tmp1;
        }
        return Arrays.asList(rgssort);
    }

    public static List getJabafromJwsArgs(List<ArgumentI> jwsargs) {
        ArrayList<Option> rgs = new ArrayList<Option>();
        for (ArgumentI rg : jwsargs) {
            Option narg;
            Option option = narg = rg instanceof JabaOption ? ((JabaOption)rg).getOption() : null;
            if (narg == null) {
                throw new Error(MessageManager.formatMessage("error.implementation_error_cannot_handle_jaba_param", new String[]{rg.getClass().toString()}));
            }
            rgs.add(narg);
        }
        return rgs;
    }

    @Override
    public List<ArgumentI> getServiceParameters() {
        return JabaParamStore.getJwsArgsfromJaba(this.serviceOptions.getArguments());
    }

    @Override
    public boolean presetExists(String name) {
        return this.editedParams.containsKey(name) || this.servicePresets.containsKey(name);
    }

    @Override
    public void deletePreset(String name) {
        if (this.editedParams.containsKey(name)) {
            WsParamSetI parameterSet = this.editedParams.get(name);
            this.editedParams.remove(name);
            if (this.manager != null) {
                this.manager.deleteParameterSet(parameterSet);
            }
            return;
        }
        if (this.servicePresets.containsKey(name)) {
            throw new Error(MessageManager.getString("error.implementation_error_attempt_to_delete_service_preset"));
        }
    }

    @Override
    public void storePreset(String presetName, String text, List<ArgumentI> jobParams) {
        JabaWsParamSet jps = new JabaWsParamSet(presetName, text, jobParams);
        jps.setApplicableUrls(new String[]{this.service.getUri()});
        this.editedParams.put(jps.getName(), jps);
        if (this.manager != null) {
            this.manager.storeParameterSet(jps);
        }
    }

    @Override
    public void updatePreset(String oldName, String presetName, String text, List<ArgumentI> jobParams) {
        JabaWsParamSet jps = (JabaWsParamSet)(oldName != null ? this.getPreset(oldName) : this.getPreset(presetName));
        if (jps == null) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_cannot_locate_oldname_presetname", new String[]{oldName, presetName}));
        }
        jps.setName(presetName);
        jps.setDescription(text);
        jps.setArguments(jobParams);
        jps.setApplicableUrls(new String[]{this.service.getUri()});
        if (oldName != null && !oldName.equals(jps.getName())) {
            this.editedParams.remove(oldName);
        }
        this.editedParams.put(jps.getName(), jps);
        if (this.manager != null) {
            this.manager.storeParameterSet(jps);
        }
    }

    WsParamSetI newWsParamSet() {
        return new JabaWsParamSet();
    }

    private boolean involves(String[] urls) {
        boolean found = false;
        for (String url : urls) {
            if (!this.service.getNameURI().equals(url) && !this.service.getUri().equalsIgnoreCase(url)) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public WsParamSetI parseServiceParameterFile(String name, String descr, String[] urls, String parameterfile) throws IOException {
        if (!this.involves(urls)) {
            throw new IOException(MessageManager.getString("error.implementation_error_cannot_find_service_url_in_given_set"));
        }
        JabaWsParamSet wsp = new JabaWsParamSet();
        wsp.setName(name);
        wsp.setDescription(descr);
        wsp.setApplicableUrls((String[])urls.clone());
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(parameterfile, "\n");
        while (st.hasMoreTokens()) {
            lines.add(st.nextToken());
        }
        wsp.setjabaArguments(ParameterUtils.processParameters(lines, this.serviceOptions, " "));
        return wsp;
    }

    @Override
    public String generateServiceParameterFile(WsParamSetI pset) throws IOException {
        if (!this.involves(pset.getApplicableUrls())) {
            throw new IOException(MessageManager.formatMessage("error.implementation_error_cannot_find_service_url_in_given_set_param_store", new String[]{this.service.getUri()}));
        }
        if (!(pset instanceof JabaWsParamSet)) {
            throw new Error(MessageManager.getString("error.implementation_error_jabaws_param_set_only_handled_by"));
        }
        StringBuffer rslt = new StringBuffer();
        for (String ln : ParameterUtils.writeParameterSet(((JabaWsParamSet)pset).getjabaArguments(), " ")) {
            rslt.append(ln);
            rslt.append("\n");
        }
        return rslt.toString();
    }
}

