/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws.dbsources;

import jalview.analysis.SequenceIdMatcher;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.FeatureProperties;
import jalview.datamodel.Mapping;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.DBRefUtils;
import jalview.util.DnaUtils;
import jalview.util.MapList;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.ws.dbsources.EbiFileRetrievedProxy;
import jalview.ws.ebi.EBIFetchClient;
import jalview.xml.binding.embl.EntryType;
import jalview.xml.binding.embl.ROOT;
import jalview.xml.binding.embl.XrefType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class EmblXmlSource
extends EbiFileRetrievedProxy {
    private static final String EMBL_NOT_FOUND_REPLY = "ERROR 12 No entries found.";
    private static final Pattern SPACE_PATTERN = Pattern.compile(" ");

    protected AlignmentI getEmblSequenceRecords(String emprefx, String query) throws Exception {
        File reply;
        this.startQuery();
        EBIFetchClient dbFetch = new EBIFetchClient();
        try {
            reply = dbFetch.fetchDataAsFile(emprefx.toLowerCase() + ":" + query.trim(), "display=xml", "xml");
        }
        catch (Exception e) {
            this.stopQuery();
            throw new Exception(MessageManager.formatMessage("exception.ebiembl_retrieval_failed_on", new String[]{emprefx.toLowerCase(), query.trim()}), e);
        }
        return this.getEmblSequenceRecords(emprefx, query, reply);
    }

    protected AlignmentI getEmblSequenceRecords(String emprefx, String query, File reply) throws Exception {
        List<EntryType> entries = null;
        if (reply != null && reply.exists()) {
            this.file = reply.getAbsolutePath();
            if (reply.length() > (long)EMBL_NOT_FOUND_REPLY.length()) {
                FileInputStream is = new FileInputStream(reply);
                entries = this.getEmblEntries(is);
            }
        }
        Alignment al = null;
        ArrayList<SequenceI> seqs = new ArrayList<SequenceI>();
        ArrayList<SequenceI> peptides = new ArrayList<SequenceI>();
        if (entries != null) {
            for (EntryType entry : entries) {
                SequenceI seq = this.getSequence(emprefx, entry, peptides);
                if (seq == null) continue;
                seqs.add(seq.deriveSequence());
            }
            if (!seqs.isEmpty()) {
                al = new Alignment(seqs.toArray(new SequenceI[seqs.size()]));
            } else {
                System.out.println("No record found for '" + emprefx + ":" + query + "'");
            }
        }
        this.stopQuery();
        return al;
    }

    List<EntryType> getEmblEntries(InputStream is) {
        List<EntryType> entries = new ArrayList<EntryType>();
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.embl");
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            Unmarshaller um = jc.createUnmarshaller();
            ROOT root = (ROOT)um.unmarshal(streamReader);
            if (root == null) {
                return entries;
            }
            if (root.getEntrySet() != null) {
                entries = root.getEntrySet().getEntry();
            } else if (root.getEntry() != null) {
                entries.add(root.getEntry());
            }
        }
        catch (JAXBException | FactoryConfigurationError | XMLStreamException e) {
            e.printStackTrace();
        }
        return entries;
    }

    SequenceI getSequence(String sourceDb, EntryType entry, List<SequenceI> peptides) {
        String seqString = entry.getSequence();
        if (seqString == null) {
            return null;
        }
        seqString = seqString.replace(" ", "").replace("\n", "").replace("\t", "");
        String accession = entry.getAccession();
        Sequence dna = new Sequence(sourceDb + "|" + accession, seqString);
        dna.setDescription(entry.getDescription());
        String sequenceVersion = String.valueOf(entry.getVersion().intValue());
        DBRefEntry selfRref = new DBRefEntry(sourceDb, sequenceVersion, accession);
        dna.addDBRef(selfRref);
        selfRref.setMap(new Mapping(null, new int[]{1, dna.getLength()}, new int[]{1, dna.getLength()}, 1, 1));
        List<XrefType> xrefs = entry.getXref();
        if (xrefs != null) {
            for (XrefType xref : xrefs) {
                String acc = xref.getId();
                String source = DBRefUtils.getCanonicalName(xref.getDb());
                String version = xref.getSecondaryId();
                if (version == null || "".equals(version)) {
                    version = "0";
                }
                dna.addDBRef(new DBRefEntry(source, version, acc));
            }
        }
        SequenceIdMatcher matcher = new SequenceIdMatcher(peptides);
        try {
            List<EntryType.Feature> features = entry.getFeature();
            if (features != null) {
                for (EntryType.Feature feature : features) {
                    if (!FeatureProperties.isCodingFeature(sourceDb, feature.getName())) continue;
                    this.parseCodingFeature(entry, feature, sourceDb, dna, peptides, matcher);
                }
            }
        }
        catch (Exception e) {
            System.err.println("EMBL Record Features parsing error!");
            System.err.println("Please report the following to help@jalview.org :");
            System.err.println("EMBL Record " + accession);
            System.err.println("Resulted in exception: " + e.getMessage());
            e.printStackTrace(System.err);
        }
        return dna;
    }

    void parseCodingFeature(EntryType entry, EntryType.Feature feature, String sourceDb, SequenceI dna, List<SequenceI> peptides, SequenceIdMatcher matcher) {
        boolean isEmblCdna = sourceDb.equals("EMBLCDS");
        String accession = entry.getAccession();
        String sequenceVersion = entry.getVersion().toString();
        int[] exons = this.getCdsRanges(entry.getAccession(), feature);
        String translation = null;
        String proteinName = "";
        String proteinId = null;
        Hashtable<String, String> vals = new Hashtable<String, String>();
        int codonStart = 1;
        if (feature.getQualifier() != null) {
            for (EntryType.Feature.Qualifier q : feature.getQualifier()) {
                String qname = q.getName();
                String value = q.getValue();
                String string = value = value == null ? "" : value.trim().replace(" ", "").replace("\n", "").replace("\t", "");
                if (qname.equals("translation")) {
                    translation = value;
                    continue;
                }
                if (qname.equals("protein_id")) {
                    proteinId = value;
                    continue;
                }
                if (qname.equals("codon_start")) {
                    try {
                        codonStart = Integer.parseInt(value.trim());
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Invalid codon_start in XML for " + entry.getAccession() + ": " + e.getMessage());
                    }
                    continue;
                }
                if (qname.equals("product")) {
                    proteinName = value;
                    continue;
                }
                if ("".equals(value)) continue;
                vals.put(qname, value);
            }
        }
        DBRefEntry proteinToEmblProteinRef = null;
        exons = MappingUtils.removeStartPositions(codonStart - 1, exons);
        SequenceI product = null;
        Mapping dnaToProteinMapping = null;
        if (translation != null && proteinName != null && proteinId != null) {
            int translationLength = translation.length();
            product = matcher.findIdMatch(proteinId);
            if (product == null) {
                product = new Sequence(proteinId, translation, 1, translationLength);
                product.setDescription(proteinName.length() == 0 ? "Protein Product from " + sourceDb : proteinName);
                peptides.add(product);
                matcher.add(product);
            }
            if (exons == null || exons.length == 0) {
                System.err.println("Implementation Notice: EMBLCDS records not properly supported yet - Making up the CDNA region of this sequence... may be incorrect (" + sourceDb + ":" + entry.getAccession() + ")");
                int dnaLength = dna.getLength();
                if (translationLength * 3 == 1 - codonStart + dnaLength) {
                    System.err.println("Not allowing for additional stop codon at end of cDNA fragment... !");
                    exons = new int[]{dna.getStart() + (codonStart - 1), dna.getEnd()};
                    dnaToProteinMapping = new Mapping(product, exons, new int[]{1, translationLength}, 3, 1);
                }
                if ((translationLength + 1) * 3 == 1 - codonStart + dnaLength) {
                    System.err.println("Allowing for additional stop codon at end of cDNA fragment... will probably cause an error in VAMSAs!");
                    exons = new int[]{dna.getStart() + (codonStart - 1), dna.getEnd() - 3};
                    dnaToProteinMapping = new Mapping(product, exons, new int[]{1, translationLength}, 3, 1);
                }
            } else if (!isEmblCdna) {
                int[] cdsRanges = EmblXmlSource.adjustForProteinLength(translationLength, exons);
                dnaToProteinMapping = new Mapping(product, cdsRanges, new int[]{1, translationLength}, 3, 1);
                if (product != null) {
                    DBRefEntry proteinToEmblRef = new DBRefEntry("EMBL", sequenceVersion, proteinId, new Mapping(dnaToProteinMapping.getMap().getInverse()));
                    product.addDBRef(proteinToEmblRef);
                    MapList proteinToCdsMapList = new MapList(new int[]{1, translationLength}, new int[]{1 + (codonStart - 1), codonStart - 1 + 3 * translationLength}, 1, 3);
                    DBRefEntry proteinToEmblCdsRef = new DBRefEntry("EMBLCDS", sequenceVersion, proteinId, new Mapping(proteinToCdsMapList));
                    product.addDBRef(proteinToEmblCdsRef);
                    proteinToEmblProteinRef = new DBRefEntry(proteinToEmblCdsRef);
                    proteinToEmblProteinRef.setSource(DBRefSource.EMBLCDSProduct);
                    proteinToEmblProteinRef.setMap(null);
                    product.addDBRef(proteinToEmblProteinRef);
                }
            }
            String cds = feature.getName();
            for (int xint = 0; exons != null && xint < exons.length - 1; xint += 2) {
                int exonStart = exons[xint];
                int exonEnd = exons[xint + 1];
                int begin = Math.min(exonStart, exonEnd);
                int end = Math.max(exonStart, exonEnd);
                int exonNumber = xint / 2 + 1;
                String desc = String.format("Exon %d for protein '%s' EMBLCDS:%s", exonNumber, proteinName, proteinId);
                SequenceFeature sf = this.makeCdsFeature(cds, desc, begin, end, sourceDb, vals);
                sf.setEnaLocation(feature.getLocation());
                boolean forwardStrand = exonStart <= exonEnd;
                sf.setStrand(forwardStrand ? "+" : "-");
                sf.setPhase(String.valueOf(codonStart - 1));
                sf.setValue("exon number", exonNumber);
                sf.setValue("product", proteinName);
                dna.addSequenceFeature(sf);
            }
        }
        boolean hasUniprotDbref = false;
        List<XrefType> xrefs = feature.getXref();
        if (xrefs != null) {
            boolean mappingUsed = false;
            for (XrefType xref : xrefs) {
                String source = DBRefUtils.getCanonicalName(xref.getDb());
                String version = xref.getSecondaryId();
                if (version == null || "".equals(version)) {
                    version = "0";
                }
                DBRefEntry dbref = new DBRefEntry(source, version, xref.getId());
                DBRefEntry proteinDbRef = new DBRefEntry(source, version, dbref.getAccessionId());
                if (source.equals("UNIPROT")) {
                    String proteinSeqName = "UNIPROT|" + dbref.getAccessionId();
                    if (dnaToProteinMapping != null && dnaToProteinMapping.getTo() != null) {
                        if (mappingUsed) {
                            dnaToProteinMapping = new Mapping(dnaToProteinMapping);
                        }
                        mappingUsed = true;
                        SequenceI proteinSeq = matcher.findIdMatch(proteinSeqName);
                        if (proteinSeq == null) {
                            proteinSeq = new Sequence(proteinSeqName, product.getSequenceAsString());
                            matcher.add(proteinSeq);
                            peptides.add(proteinSeq);
                        }
                        dnaToProteinMapping.setTo(proteinSeq);
                        dnaToProteinMapping.setMappedFromId(proteinId);
                        proteinSeq.addDBRef(proteinDbRef);
                        dbref.setMap(dnaToProteinMapping);
                    }
                    hasUniprotDbref = true;
                }
                if (product != null) {
                    DBRefEntry pref = proteinDbRef;
                    pref.setMap(null);
                    product.addDBRef(pref);
                    if (dnaToProteinMapping != null) {
                        Mapping pmap = new Mapping(dna, dnaToProteinMapping.getMap().getInverse());
                        pref = new DBRefEntry(sourceDb, sequenceVersion, accession);
                        pref.setMap(pmap);
                        if (dnaToProteinMapping.getTo() != null) {
                            dnaToProteinMapping.getTo().addDBRef(pref);
                        }
                    }
                }
                dna.addDBRef(dbref);
            }
        }
        if (!hasUniprotDbref && product != null) {
            if (proteinToEmblProteinRef == null) {
                proteinToEmblProteinRef = new DBRefEntry(DBRefSource.EMBLCDSProduct, sequenceVersion, proteinId);
            }
            product.addDBRef(proteinToEmblProteinRef);
            if (dnaToProteinMapping != null && dnaToProteinMapping.getTo() != null) {
                DBRefEntry dnaToEmblProteinRef = new DBRefEntry(DBRefSource.EMBLCDSProduct, sequenceVersion, proteinId);
                dnaToEmblProteinRef.setMap(dnaToProteinMapping);
                dnaToProteinMapping.setMappedFromId(proteinId);
                dna.addDBRef(dnaToEmblProteinRef);
            }
        }
    }

    @Override
    public boolean isDnaCoding() {
        return true;
    }

    protected int[] getCdsRanges(String accession, EntryType.Feature feature) {
        String location = feature.getLocation();
        if (location == null) {
            return new int[0];
        }
        try {
            List<int[]> ranges = DnaUtils.parseLocation(location);
            return this.listToArray(ranges);
        }
        catch (ParseException e) {
            Cache.log.warn((Object)String.format("Not parsing inexact CDS location %s in ENA %s", location, accession));
            return new int[0];
        }
    }

    int[] listToArray(List<int[]> ranges) {
        int[] result = new int[ranges.size() * 2];
        int i = 0;
        for (int[] range : ranges) {
            result[i++] = range[0];
            result[i++] = range[1];
        }
        return result;
    }

    protected SequenceFeature makeCdsFeature(String type, String desc, int begin, int end, String group, Map<String, String> vals) {
        SequenceFeature sf = new SequenceFeature(type, desc, begin, end, group);
        if (!vals.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Map.Entry<String, String> val : vals.entrySet()) {
                if (!first) {
                    sb.append(";");
                }
                sb.append(val.getKey()).append("=").append(val.getValue());
                first = false;
                sf.setValue(val.getKey(), val.getValue());
            }
            sf.setAttributes(sb.toString());
        }
        return sf;
    }

    static int[] adjustForProteinLength(int proteinLength, int[] exon) {
        if (proteinLength <= 0 || exon == null) {
            return exon;
        }
        int expectedCdsLength = proteinLength * 3;
        int exonLength = MappingUtils.getLength(Arrays.asList(new int[][]{exon}));
        if (expectedCdsLength >= exonLength || expectedCdsLength == exonLength - 3) {
            return exon;
        }
        int sxpos = -1;
        int endxon = 0;
        int[] origxon = new int[exon.length];
        System.arraycopy(exon, 0, origxon, 0, exon.length);
        int cdspos = 0;
        for (int x = 0; x < exon.length; x += 2) {
            if (expectedCdsLength > (cdspos += Math.abs(exon[x + 1] - exon[x]) + 1)) continue;
            sxpos = x;
            if (expectedCdsLength != cdspos) {
                // empty if block
            }
            if (exon[x + 1] >= exon[x]) {
                endxon = exon[x + 1] - cdspos + expectedCdsLength;
                break;
            }
            endxon = exon[x + 1] + cdspos - expectedCdsLength;
            break;
        }
        if (sxpos != -1) {
            int[] nxon = new int[sxpos + 2];
            System.arraycopy(exon, 0, nxon, 0, sxpos + 2);
            nxon[sxpos + 1] = endxon;
            exon = nxon;
        }
        return exon;
    }
}

