/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import jalview.ext.ensembl.EnsemblGene;
import jalview.util.QuickSort;
import jalview.ws.dbsources.EmblCdsSource;
import jalview.ws.dbsources.EmblSource;
import jalview.ws.dbsources.Pdb;
import jalview.ws.dbsources.PfamFull;
import jalview.ws.dbsources.PfamSeed;
import jalview.ws.dbsources.RfamSeed;
import jalview.ws.dbsources.Uniprot;
import jalview.ws.seqfetcher.ASequenceFetcher;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.util.ArrayList;

public class SequenceFetcher
extends ASequenceFetcher {
    public SequenceFetcher() {
        this.addDBRefSourceImpl(EnsemblGene.class);
        this.addDBRefSourceImpl(EmblSource.class);
        this.addDBRefSourceImpl(EmblCdsSource.class);
        this.addDBRefSourceImpl(Uniprot.class);
        this.addDBRefSourceImpl(Pdb.class);
        this.addDBRefSourceImpl(PfamFull.class);
        this.addDBRefSourceImpl(PfamSeed.class);
        this.addDBRefSourceImpl(RfamSeed.class);
    }

    public String[] getOrderedSupportedSources() {
        String[] srcs = this.getSupportedDb();
        ArrayList<String> src = new ArrayList<String>();
        for (int i = 0; i < srcs.length; ++i) {
            boolean skip = false;
            for (DbSourceProxy dbs : this.getSourceProxy(srcs[i])) {
                if (!dbs.isAlignmentSource()) continue;
                skip = true;
            }
            if (skip) continue;
            src.add(srcs[i]);
        }
        String[] tosort = src.toArray(new String[0]);
        Object[] sorted = src.toArray(new String[0]);
        int jSize = sorted.length;
        for (int j = 0; j < jSize; ++j) {
            tosort[j] = tosort[j].toLowerCase();
        }
        QuickSort.sort(tosort, sorted);
        int i = 0;
        int j = sorted.length - 1;
        while (j >= 0) {
            tosort[i] = sorted[j];
            --j;
            ++i;
        }
        return tosort;
    }
}

