/*
 * Decompiled with CFR 0.152.
 */
package jalview.ws;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.NameValuePair;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

public class HttpClientUtils {
    public static BufferedReader doHttpUrlPost(String postUrl, List<NameValuePair> vals, int connectionTimeoutMs, int readTimeoutMs) throws ClientProtocolException, IOException {
        BasicHttpParams params = new BasicHttpParams();
        params.setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        if (connectionTimeoutMs > 0) {
            HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)connectionTimeoutMs);
        }
        if (readTimeoutMs > 0) {
            HttpConnectionParams.setSoTimeout((HttpParams)params, (int)readTimeoutMs);
        }
        DefaultHttpClient httpclient = new DefaultHttpClient((HttpParams)params);
        HttpPost httppost = new HttpPost(postUrl);
        UrlEncodedFormEntity ue = new UrlEncodedFormEntity(vals, "UTF-8");
        httppost.setEntity((HttpEntity)ue);
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity resEntity = response.getEntity();
        if (resEntity != null) {
            BufferedReader r = new BufferedReader(new InputStreamReader(resEntity.getContent()));
            return r;
        }
        return null;
    }

    public static BufferedReader doHttpMpartFilePost(String postUrl, List<NameValuePair> vals, String fparm, File file, String mtype) throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(postUrl);
        MultipartEntity mpe = new MultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE);
        for (NameValuePair nvp : vals) {
            mpe.addPart(nvp.getName(), (ContentBody)new StringBody(nvp.getValue()));
        }
        FileBody fb = new FileBody(file, mtype != null ? mtype : "application/octet-stream");
        mpe.addPart(fparm, (ContentBody)fb);
        UrlEncodedFormEntity ue = new UrlEncodedFormEntity(vals, "UTF-8");
        httppost.setEntity((HttpEntity)ue);
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity resEntity = response.getEntity();
        if (resEntity != null) {
            BufferedReader r = new BufferedReader(new InputStreamReader(resEntity.getContent()));
            return r;
        }
        return null;
    }

    public static BufferedReader doHttpMpartInputstreamPost(String postUrl, List<NameValuePair> vals, String fparm, String fname, InputStream is, String mtype) throws ClientProtocolException, IOException {
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httppost = new HttpPost(postUrl);
        MultipartEntity mpe = new MultipartEntity(HttpMultipartMode.STRICT);
        for (NameValuePair nvp : vals) {
            mpe.addPart(nvp.getName(), (ContentBody)new StringBody(nvp.getValue()));
        }
        InputStreamBody fb = mtype != null ? new InputStreamBody(is, fname, mtype) : new InputStreamBody(is, fname);
        mpe.addPart(fparm, (ContentBody)fb);
        UrlEncodedFormEntity ue = new UrlEncodedFormEntity(vals, "UTF-8");
        httppost.setEntity((HttpEntity)ue);
        HttpResponse response = httpclient.execute((HttpUriRequest)httppost);
        HttpEntity resEntity = response.getEntity();
        if (resEntity != null) {
            BufferedReader r = new BufferedReader(new InputStreamReader(resEntity.getContent()));
            return r;
        }
        return null;
    }
}

