/*
 * Decompiled with CFR 0.152.
 */
package jalview.viewmodel;

import jalview.analysis.AnnotationSorter;
import jalview.analysis.Conservation;
import jalview.analysis.TreeModel;
import jalview.api.AlignCalcManagerI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.FeaturesDisplayedI;
import jalview.api.ViewStyleI;
import jalview.commands.CommandI;
import jalview.datamodel.AlignedCodonFrame;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.Annotation;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.ProfilesI;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.renderer.ResidueShader;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.ColourSchemeI;
import jalview.structure.CommandListener;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasSource;
import jalview.util.Comparison;
import jalview.util.MapList;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.ViewportRanges;
import jalview.viewmodel.styles.ViewStyle;
import jalview.workers.AlignCalcManager;
import jalview.workers.ComplementConsensusThread;
import jalview.workers.ConsensusThread;
import jalview.workers.ConservationThread;
import jalview.workers.InformationThread;
import jalview.workers.StrucConsensusThread;
import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Deque;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public abstract class AlignmentViewport
implements AlignViewportI,
CommandListener,
VamsasSource {
    protected ViewportRanges ranges;
    protected ViewStyleI viewStyle = new ViewStyle();
    AlignViewportI codingComplement = null;
    FeaturesDisplayedI featuresDisplayed = null;
    protected Deque<CommandI> historyList = new ArrayDeque<CommandI>();
    protected Deque<CommandI> redoList = new ArrayDeque<CommandI>();
    protected AlignmentI alignment;
    protected boolean ignoreBelowBackGroundFrequencyCalculation = false;
    protected boolean infoLetterHeight = false;
    protected AlignmentAnnotation occupancy;
    protected ProfilesI consensusProfiles;
    protected ProfilesI hmmProfiles;
    protected String sequenceSetID;
    protected boolean isDataset = false;
    private Map<SequenceI, SequenceCollectionI> hiddenRepSequences;
    protected ColumnSelection colSel = new ColumnSelection();
    public boolean autoCalculateConsensus = true;
    protected boolean autoCalculateStrucConsensus = true;
    protected boolean ignoreGapsInConsensusCalculation = false;
    protected ResidueShaderI residueShading = new ResidueShader();
    protected AlignmentAnnotation consensus;
    protected AlignmentAnnotation complementConsensus;
    protected AlignmentAnnotation gapcounts;
    protected AlignmentAnnotation strucConsensus;
    protected AlignmentAnnotation conservation;
    protected AlignmentAnnotation quality;
    protected AlignmentAnnotation[] groupConsensus;
    protected AlignmentAnnotation[] groupConservation;
    protected ProfilesI hconsensus = null;
    protected Hashtable[] hcomplementConsensus = null;
    protected Hashtable[] hStrucConsensus = null;
    protected Conservation hconservation = null;
    int ConsPercGaps = 25;
    protected AlignCalcManagerI calculator = new AlignCalcManager();
    protected boolean showGroupConservation = false;
    protected boolean showGroupConsensus = false;
    protected boolean showSequenceLogo = false;
    protected boolean normaliseSequenceLogo = false;
    protected boolean showConsensusHistogram = true;
    protected boolean hmmShowSequenceLogo = false;
    protected boolean hmmNormaliseSequenceLogo = false;
    protected boolean hmmShowHistogram = true;
    private boolean padGaps = false;
    public boolean sortByTree = false;
    protected SequenceGroup selectionGroup;
    protected String viewId = null;
    private long sgrouphash = -1L;
    private long colselhash = -1L;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    protected boolean showConservation = true;
    protected boolean showQuality = true;
    protected boolean showConsensus = true;
    protected boolean showOccupancy = true;
    private Map<SequenceI, Color> sequenceColours = new HashMap<SequenceI, Color>();
    protected AnnotationSorter.SequenceAnnotationOrder sortAnnotationsBy = null;
    protected boolean showAutocalculatedAbove;
    private boolean followHighlight = true;
    private boolean selectionIsDefinedGroup = false;
    private SearchResultsI searchResults = null;
    protected TreeModel currentTree = null;
    private boolean needToUpdateStructureViews = false;

    public AlignmentViewport(AlignmentI al) {
        this.setAlignment(al);
        this.ranges = new ViewportRanges(al);
    }

    @Override
    public void setFontName(String name) {
        this.viewStyle.setFontName(name);
    }

    @Override
    public void setFontStyle(int style) {
        this.viewStyle.setFontStyle(style);
    }

    @Override
    public void setFontSize(int size) {
        this.viewStyle.setFontSize(size);
    }

    @Override
    public int getFontStyle() {
        return this.viewStyle.getFontStyle();
    }

    @Override
    public String getFontName() {
        return this.viewStyle.getFontName();
    }

    @Override
    public int getFontSize() {
        return this.viewStyle.getFontSize();
    }

    @Override
    public void setUpperCasebold(boolean upperCasebold) {
        this.viewStyle.setUpperCasebold(upperCasebold);
    }

    @Override
    public boolean isUpperCasebold() {
        return this.viewStyle.isUpperCasebold();
    }

    @Override
    public boolean isSeqNameItalics() {
        return this.viewStyle.isSeqNameItalics();
    }

    @Override
    public void setColourByReferenceSeq(boolean colourByReferenceSeq) {
        this.viewStyle.setColourByReferenceSeq(colourByReferenceSeq);
    }

    @Override
    public void setColourAppliesToAllGroups(boolean b) {
        this.viewStyle.setColourAppliesToAllGroups(b);
    }

    @Override
    public boolean getColourAppliesToAllGroups() {
        return this.viewStyle.getColourAppliesToAllGroups();
    }

    @Override
    public boolean getAbovePIDThreshold() {
        return this.viewStyle.getAbovePIDThreshold();
    }

    @Override
    public void setIncrement(int inc) {
        this.viewStyle.setIncrement(inc);
    }

    @Override
    public int getIncrement() {
        return this.viewStyle.getIncrement();
    }

    @Override
    public void setConservationSelected(boolean b) {
        this.viewStyle.setConservationSelected(b);
    }

    @Override
    public void setShowHiddenMarkers(boolean show) {
        this.viewStyle.setShowHiddenMarkers(show);
    }

    @Override
    public boolean getShowHiddenMarkers() {
        return this.viewStyle.getShowHiddenMarkers();
    }

    @Override
    public void setScaleRightWrapped(boolean b) {
        this.viewStyle.setScaleRightWrapped(b);
    }

    @Override
    public void setScaleLeftWrapped(boolean b) {
        this.viewStyle.setScaleLeftWrapped(b);
    }

    @Override
    public void setScaleAboveWrapped(boolean b) {
        this.viewStyle.setScaleAboveWrapped(b);
    }

    @Override
    public boolean getScaleLeftWrapped() {
        return this.viewStyle.getScaleLeftWrapped();
    }

    @Override
    public boolean getScaleAboveWrapped() {
        return this.viewStyle.getScaleAboveWrapped();
    }

    @Override
    public boolean getScaleRightWrapped() {
        return this.viewStyle.getScaleRightWrapped();
    }

    @Override
    public void setAbovePIDThreshold(boolean b) {
        this.viewStyle.setAbovePIDThreshold(b);
    }

    @Override
    public void setThreshold(int thresh) {
        this.viewStyle.setThreshold(thresh);
    }

    @Override
    public int getThreshold() {
        return this.viewStyle.getThreshold();
    }

    @Override
    public boolean getShowJVSuffix() {
        return this.viewStyle.getShowJVSuffix();
    }

    @Override
    public void setShowJVSuffix(boolean b) {
        this.viewStyle.setShowJVSuffix(b);
    }

    @Override
    public void setWrapAlignment(boolean state) {
        this.viewStyle.setWrapAlignment(state);
        this.ranges.setWrappedMode(state);
    }

    @Override
    public void setShowText(boolean state) {
        this.viewStyle.setShowText(state);
    }

    @Override
    public void setRenderGaps(boolean state) {
        this.viewStyle.setRenderGaps(state);
    }

    @Override
    public boolean getColourText() {
        return this.viewStyle.getColourText();
    }

    @Override
    public void setColourText(boolean state) {
        this.viewStyle.setColourText(state);
    }

    @Override
    public boolean getWrapAlignment() {
        return this.viewStyle.getWrapAlignment();
    }

    @Override
    public boolean getShowText() {
        return this.viewStyle.getShowText();
    }

    @Override
    public int getWrappedWidth() {
        return this.viewStyle.getWrappedWidth();
    }

    @Override
    public void setWrappedWidth(int w) {
        this.viewStyle.setWrappedWidth(w);
    }

    @Override
    public int getCharHeight() {
        return this.viewStyle.getCharHeight();
    }

    @Override
    public void setCharHeight(int h) {
        this.viewStyle.setCharHeight(h);
    }

    @Override
    public int getCharWidth() {
        return this.viewStyle.getCharWidth();
    }

    @Override
    public void setCharWidth(int w) {
        this.viewStyle.setCharWidth(w);
    }

    @Override
    public boolean getShowBoxes() {
        return this.viewStyle.getShowBoxes();
    }

    @Override
    public boolean getShowUnconserved() {
        return this.viewStyle.getShowUnconserved();
    }

    @Override
    public void setShowUnconserved(boolean showunconserved) {
        this.viewStyle.setShowUnconserved(showunconserved);
    }

    @Override
    public void setSeqNameItalics(boolean default1) {
        this.viewStyle.setSeqNameItalics(default1);
    }

    @Override
    public AlignmentI getAlignment() {
        return this.alignment;
    }

    @Override
    public char getGapCharacter() {
        return this.alignment.getGapCharacter();
    }

    public void setDataset(boolean b) {
        this.isDataset = b;
    }

    public boolean isDataset() {
        return this.isDataset;
    }

    @Override
    public void setGlobalColourScheme(ColourSchemeI cs) {
        if (this.residueShading == null) {
            this.residueShading = new ResidueShader(this.viewStyle);
        }
        this.residueShading.setColourScheme(cs);
        if (cs != null) {
            if (this.getConservationSelected()) {
                this.residueShading.setConservation(this.hconservation);
            }
            this.residueShading.setConservationApplied(this.getConservationSelected());
            this.residueShading.alignmentChanged(this.alignment, this.hiddenRepSequences);
        }
        if (this.getColourAppliesToAllGroups()) {
            for (SequenceGroup sg : this.getAlignment().getGroups()) {
                sg.setColourScheme(cs == null ? null : cs.getInstance(this, sg));
                if (cs == null) continue;
                sg.getGroupColourScheme().alignmentChanged(sg, this.hiddenRepSequences);
            }
        }
    }

    @Override
    public ColourSchemeI getGlobalColourScheme() {
        return this.residueShading == null ? null : this.residueShading.getColourScheme();
    }

    @Override
    public ResidueShaderI getResidueShading() {
        return this.residueShading;
    }

    @Override
    public void setConservation(Conservation cons) {
        this.hconservation = cons;
    }

    @Override
    public int getConsPercGaps() {
        return this.ConsPercGaps;
    }

    @Override
    public void setSequenceConsensusHash(ProfilesI hconsensus) {
        this.hconsensus = hconsensus;
    }

    @Override
    public void setComplementConsensusHash(Hashtable[] hconsensus) {
        this.hcomplementConsensus = hconsensus;
    }

    @Override
    public ProfilesI getSequenceConsensusHash() {
        return this.hconsensus;
    }

    @Override
    public void setHmmProfiles(ProfilesI info) {
        this.hmmProfiles = info;
    }

    @Override
    public ProfilesI getHmmProfiles() {
        return this.hmmProfiles;
    }

    @Override
    public Hashtable[] getComplementConsensusHash() {
        return this.hcomplementConsensus;
    }

    @Override
    public Hashtable[] getRnaStructureConsensusHash() {
        return this.hStrucConsensus;
    }

    @Override
    public void setRnaStructureConsensusHash(Hashtable[] hStrucConsensus) {
        this.hStrucConsensus = hStrucConsensus;
    }

    @Override
    public AlignmentAnnotation getAlignmentQualityAnnot() {
        return this.quality;
    }

    @Override
    public AlignmentAnnotation getAlignmentConservationAnnotation() {
        return this.conservation;
    }

    @Override
    public AlignmentAnnotation getAlignmentConsensusAnnotation() {
        return this.consensus;
    }

    @Override
    public AlignmentAnnotation getAlignmentGapAnnotation() {
        return this.gapcounts;
    }

    @Override
    public AlignmentAnnotation getComplementConsensusAnnotation() {
        return this.complementConsensus;
    }

    @Override
    public AlignmentAnnotation getAlignmentStrucConsensusAnnotation() {
        return this.strucConsensus;
    }

    public void updateConservation(AlignmentViewPanel ap) {
        if (this.alignment.isNucleotide() || this.conservation == null && this.quality == null || !this.autoCalculateConsensus) {
            return;
        }
        if (this.calculator.getRegisteredWorkersOfClass(ConservationThread.class) == null) {
            this.calculator.registerWorker(new ConservationThread(this, ap));
        }
    }

    public void updateConsensus(AlignmentViewPanel ap) {
        AlignmentI al;
        if (this.consensus == null || !this.autoCalculateConsensus) {
            return;
        }
        if (this.calculator.getRegisteredWorkersOfClass(ConsensusThread.class) == null) {
            this.calculator.registerWorker(new ConsensusThread(this, ap));
        }
        if (!(al = this.getAlignment()).isNucleotide() && al.getCodonFrames() != null && !al.getCodonFrames().isEmpty()) {
            boolean doConsensus = false;
            for (AlignedCodonFrame mapping : al.getCodonFrames()) {
                MapList[] mapLists = mapping.getdnaToProt();
                if (mapLists.length <= 0 || mapLists[0].getFromRatio() != 3) continue;
                doConsensus = true;
                break;
            }
            if (doConsensus && this.calculator.getRegisteredWorkersOfClass(ComplementConsensusThread.class) == null) {
                this.calculator.registerWorker(new ComplementConsensusThread(this, ap));
            }
        }
    }

    @Override
    public void initInformationWorker(AlignmentViewPanel ap) {
        if (this.calculator.getRegisteredWorkersOfClass(InformationThread.class) == null) {
            this.calculator.registerWorker(new InformationThread(this, ap));
        }
    }

    public void updateStrucConsensus(AlignmentViewPanel ap) {
        if (this.autoCalculateStrucConsensus && this.strucConsensus == null && this.alignment.isNucleotide() && this.alignment.hasRNAStructure()) {
            this.initRNAStructure();
        }
        if (this.strucConsensus == null || !this.autoCalculateStrucConsensus) {
            return;
        }
        if (this.calculator.getRegisteredWorkersOfClass(StrucConsensusThread.class) == null) {
            this.calculator.registerWorker(new StrucConsensusThread(this, ap));
        }
    }

    public boolean isCalcInProgress() {
        return this.calculator.isWorking();
    }

    @Override
    public boolean isCalculationInProgress(AlignmentAnnotation alignmentAnnotation) {
        if (!alignmentAnnotation.autoCalculated) {
            return false;
        }
        return this.calculator.workingInvolvedWith(alignmentAnnotation);
    }

    public void setAlignment(AlignmentI align) {
        this.alignment = align;
    }

    @Override
    public void dispose() {
        this.consensus = null;
        this.complementConsensus = null;
        this.strucConsensus = null;
        this.conservation = null;
        this.quality = null;
        this.consensusProfiles = null;
        this.groupConsensus = null;
        this.groupConservation = null;
        this.hconsensus = null;
        this.hconservation = null;
        this.hcomplementConsensus = null;
        this.gapcounts = null;
        this.calculator = null;
        this.residueShading = null;
        this.changeSupport = null;
        this.ranges = null;
        this.currentTree = null;
        this.selectionGroup = null;
        this.setAlignment(null);
    }

    @Override
    public boolean isClosed() {
        return this.alignment == null;
    }

    @Override
    public AlignCalcManagerI getCalcManager() {
        return this.calculator;
    }

    @Override
    public boolean isShowSequenceLogo() {
        return this.showSequenceLogo;
    }

    @Override
    public boolean isShowHMMSequenceLogo() {
        return this.hmmShowSequenceLogo;
    }

    public void setShowSequenceLogo(boolean showSequenceLogo) {
        if (showSequenceLogo != this.showSequenceLogo) {
            this.showSequenceLogo = showSequenceLogo;
            this.calculator.updateAnnotationFor(ConsensusThread.class);
            this.calculator.updateAnnotationFor(ComplementConsensusThread.class);
            this.calculator.updateAnnotationFor(StrucConsensusThread.class);
        }
        this.showSequenceLogo = showSequenceLogo;
    }

    public void setShowHMMSequenceLogo(boolean showHMMSequenceLogo) {
        if (showHMMSequenceLogo != this.hmmShowSequenceLogo) {
            this.hmmShowSequenceLogo = showHMMSequenceLogo;
        }
        this.hmmShowSequenceLogo = showHMMSequenceLogo;
    }

    public void setShowConsensusHistogram(boolean showConsensusHistogram) {
        this.showConsensusHistogram = showConsensusHistogram;
    }

    public void setShowInformationHistogram(boolean showInformationHistogram) {
        this.hmmShowHistogram = showInformationHistogram;
    }

    public boolean isShowGroupConservation() {
        return this.showGroupConservation;
    }

    public void setShowGroupConservation(boolean showGroupConservation) {
        this.showGroupConservation = showGroupConservation;
    }

    public boolean isShowGroupConsensus() {
        return this.showGroupConsensus;
    }

    public void setShowGroupConsensus(boolean showGroupConsensus) {
        this.showGroupConsensus = showGroupConsensus;
    }

    @Override
    public boolean isShowConsensusHistogram() {
        return this.showConsensusHistogram;
    }

    @Override
    public boolean isShowInformationHistogram() {
        return this.hmmShowHistogram;
    }

    @Override
    public SequenceGroup getSelectionGroup() {
        return this.selectionGroup;
    }

    @Override
    public void setSelectionGroup(SequenceGroup sg) {
        this.selectionGroup = sg;
        if (sg != null && sg.getContext() == null) {
            sg.setContext(this.alignment);
        }
    }

    public void setHiddenColumns(HiddenColumns hidden) {
        this.alignment.setHiddenColumns(hidden);
    }

    @Override
    public ColumnSelection getColumnSelection() {
        return this.colSel;
    }

    @Override
    public void setColumnSelection(ColumnSelection colSel) {
        this.colSel = colSel;
        if (colSel != null) {
            this.updateHiddenColumns();
        }
        this.isColSelChanged(true);
    }

    @Override
    public Map<SequenceI, SequenceCollectionI> getHiddenRepSequences() {
        return this.hiddenRepSequences;
    }

    @Override
    public void setHiddenRepSequences(Map<SequenceI, SequenceCollectionI> hiddenRepSequences) {
        this.hiddenRepSequences = hiddenRepSequences;
    }

    @Override
    public boolean hasSelectedColumns() {
        ColumnSelection columnSelection = this.getColumnSelection();
        return columnSelection != null && columnSelection.hasSelectedColumns();
    }

    @Override
    public boolean hasHiddenColumns() {
        return this.alignment.getHiddenColumns() != null && this.alignment.getHiddenColumns().hasHiddenColumns();
    }

    public void updateHiddenColumns() {
    }

    @Override
    public boolean hasHiddenRows() {
        return this.alignment.getHiddenSequences().getSize() > 0;
    }

    public void setSequenceSetId(String newid) {
        if (this.sequenceSetID != null) {
            System.err.println("Warning - overwriting a sequenceSetId for a viewport!");
        }
        this.sequenceSetID = new String(newid);
    }

    @Override
    public String getSequenceSetId() {
        if (this.sequenceSetID == null) {
            this.sequenceSetID = this.alignment.hashCode() + "";
        }
        return this.sequenceSetID;
    }

    @Override
    public String getViewId() {
        if (this.viewId == null) {
            this.viewId = this.getSequenceSetId() + "." + this.hashCode() + "";
        }
        return this.viewId;
    }

    public void setIgnoreGapsConsensus(boolean b, AlignmentViewPanel ap) {
        this.ignoreGapsInConsensusCalculation = b;
        if (ap != null) {
            this.updateConsensus(ap);
            if (this.residueShading != null) {
                this.residueShading.setThreshold(this.residueShading.getThreshold(), this.ignoreGapsInConsensusCalculation);
            }
        }
    }

    public void setIgnoreBelowBackground(boolean b, AlignmentViewPanel ap) {
        this.ignoreBelowBackGroundFrequencyCalculation = b;
    }

    public void setInfoLetterHeight(boolean b, AlignmentViewPanel ap) {
        this.infoLetterHeight = b;
    }

    public boolean isSelectionGroupChanged(boolean b) {
        int hc;
        int n = hc = this.selectionGroup == null || this.selectionGroup.getSize() == 0 ? -1 : this.selectionGroup.hashCode();
        if (hc != -1 && (long)hc != this.sgrouphash) {
            if (b) {
                this.sgrouphash = hc;
            }
            return true;
        }
        return false;
    }

    public boolean isColSelChanged(boolean b) {
        int hc;
        int n = hc = this.colSel == null || this.colSel.isEmpty() ? -1 : this.colSel.hashCode();
        if (hc != -1 && (long)hc != this.colselhash) {
            if (b) {
                this.colselhash = hc;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean isIgnoreGapsConsensus() {
        return this.ignoreGapsInConsensusCalculation;
    }

    @Override
    public boolean isIgnoreBelowBackground() {
        return this.ignoreBelowBackGroundFrequencyCalculation;
    }

    @Override
    public boolean isInfoLetterHeight() {
        return this.infoLetterHeight;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void firePropertyChange(String prop, Object oldvalue, Object newvalue) {
        this.changeSupport.firePropertyChange(prop, oldvalue, newvalue);
    }

    public void hideSelectedColumns() {
        if (this.colSel.isEmpty()) {
            return;
        }
        this.colSel.hideSelectedColumns(this.alignment);
        this.setSelectionGroup(null);
        this.isColSelChanged(true);
    }

    public void hideColumns(int start, int end) {
        if (start == end) {
            this.colSel.hideSelectedColumns(start, this.alignment.getHiddenColumns());
        } else {
            this.alignment.getHiddenColumns().hideColumns(start, end);
        }
        this.isColSelChanged(true);
    }

    public void showColumn(int col) {
        this.alignment.getHiddenColumns().revealHiddenColumns(col, this.colSel);
        this.isColSelChanged(true);
    }

    public void showAllHiddenColumns() {
        this.alignment.getHiddenColumns().revealAllHiddenColumns(this.colSel);
        this.isColSelChanged(true);
    }

    public void showAllHiddenSeqs() {
        int startSeq = this.ranges.getStartSeq();
        int endSeq = this.ranges.getEndSeq();
        if (this.alignment.getHiddenSequences().getSize() > 0) {
            if (this.selectionGroup == null) {
                this.selectionGroup = new SequenceGroup();
                this.selectionGroup.setEndRes(this.alignment.getWidth() - 1);
            }
            List<SequenceI> tmp = this.alignment.getHiddenSequences().showAll(this.hiddenRepSequences);
            for (SequenceI seq : tmp) {
                this.selectionGroup.addSequence(seq, false);
                this.setSequenceAnnotationsVisible(seq, true);
            }
            this.hiddenRepSequences = null;
            this.ranges.setStartEndSeq(startSeq, endSeq + tmp.size());
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
            this.sendSelection();
        }
    }

    public void showSequence(int index) {
        int startSeq = this.ranges.getStartSeq();
        int endSeq = this.ranges.getEndSeq();
        List<SequenceI> tmp = this.alignment.getHiddenSequences().showSequence(index, this.hiddenRepSequences);
        if (tmp.size() > 0) {
            if (this.selectionGroup == null) {
                this.selectionGroup = new SequenceGroup();
                this.selectionGroup.setEndRes(this.alignment.getWidth() - 1);
            }
            for (SequenceI seq : tmp) {
                this.selectionGroup.addSequence(seq, false);
                this.setSequenceAnnotationsVisible(seq, true);
            }
            this.ranges.setStartEndSeq(startSeq, endSeq + tmp.size());
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
            this.sendSelection();
        }
    }

    public void hideAllSelectedSeqs() {
        if (this.selectionGroup == null || this.selectionGroup.getSize() < 1) {
            return;
        }
        SequenceI[] seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
        this.hideSequence(seqs);
        this.setSelectionGroup(null);
    }

    public void hideSequence(SequenceI[] seq) {
        int startSeq = this.ranges.getStartSeq();
        if (seq != null) {
            for (int i = 0; i < seq.length; ++i) {
                this.alignment.getHiddenSequences().hideSequence(seq[i]);
                this.setSequenceAnnotationsVisible(seq[i], false);
            }
            this.ranges.setStartSeq(startSeq);
            this.firePropertyChange("alignment", null, this.alignment.getSequences());
        }
    }

    public void hideSequences(SequenceI sequence, boolean representGroup) {
        if (this.selectionGroup == null || this.selectionGroup.getSize() < 1) {
            this.hideSequence(new SequenceI[]{sequence});
            return;
        }
        if (representGroup) {
            this.hideRepSequences(sequence, this.selectionGroup);
            this.setSelectionGroup(null);
            return;
        }
        int gsize = this.selectionGroup.getSize();
        SequenceI[] hseqs = this.selectionGroup.getSequences().toArray(new SequenceI[gsize]);
        this.hideSequence(hseqs);
        this.setSelectionGroup(null);
        this.sendSelection();
    }

    protected void setSequenceAnnotationsVisible(SequenceI sequenceI, boolean visible) {
        AlignmentAnnotation[] anns = this.alignment.getAlignmentAnnotation();
        if (anns != null) {
            for (AlignmentAnnotation ann : anns) {
                if (ann.sequenceRef != sequenceI) continue;
                ann.visible = visible;
            }
        }
    }

    public void hideRepSequences(SequenceI repSequence, SequenceGroup sg) {
        int sSize = sg.getSize();
        if (sSize < 2) {
            return;
        }
        if (this.hiddenRepSequences == null) {
            this.hiddenRepSequences = new Hashtable<SequenceI, SequenceCollectionI>();
        }
        this.hiddenRepSequences.put(repSequence, sg);
        SequenceI[] seqs = new SequenceI[sSize - 1];
        int index = 0;
        for (int i = 0; i < sSize; ++i) {
            if (sg.getSequenceAt(i) == repSequence) continue;
            if (index == sSize - 1) {
                return;
            }
            seqs[index++] = sg.getSequenceAt(i);
        }
        sg.setSeqrep(repSequence);
        sg.setHidereps(true);
        this.hideSequence(seqs);
    }

    public SequenceI getReferenceSeq() {
        return this.alignment.getSeqrep();
    }

    public boolean isReferenceSeq(SequenceI seq) {
        return this.alignment.getSeqrep() == seq;
    }

    public boolean isHiddenRepSequence(SequenceI seq) {
        return this.hiddenRepSequences != null && this.hiddenRepSequences.containsKey(seq);
    }

    public SequenceGroup getRepresentedSequences(SequenceI seq) {
        return (SequenceGroup)(this.hiddenRepSequences == null ? null : this.hiddenRepSequences.get(seq));
    }

    @Override
    public int adjustForHiddenSeqs(int alignmentIndex) {
        return this.alignment.getHiddenSequences().adjustForHiddenSeqs(alignmentIndex);
    }

    @Override
    public void invertColumnSelection() {
        this.colSel.invertColumnSelection(0, this.alignment.getWidth(), this.alignment);
        this.isColSelChanged(true);
    }

    @Override
    public SequenceI[] getSelectionAsNewSequence() {
        SequenceI[] sequences;
        if (this.selectionGroup == null || this.selectionGroup.getSize() == 0) {
            sequences = this.alignment.getSequencesArray();
            AlignmentAnnotation[] annots = this.alignment.getAlignmentAnnotation();
            for (int i = 0; i < sequences.length; ++i) {
                sequences[i] = new Sequence(sequences[i], annots);
            }
        } else {
            sequences = this.selectionGroup.getSelectionAsNewSequences(this.alignment);
        }
        return sequences;
    }

    @Override
    public SequenceI[] getSequenceSelection() {
        SequenceI[] sequences = null;
        if (this.selectionGroup != null) {
            sequences = this.selectionGroup.getSequencesInOrder(this.alignment);
        }
        if (sequences == null) {
            sequences = this.alignment.getSequencesArray();
        }
        return sequences;
    }

    @Override
    public AlignmentView getAlignmentView(boolean selectedOnly) {
        return this.getAlignmentView(selectedOnly, false);
    }

    @Override
    public AlignmentView getAlignmentView(boolean selectedOnly, boolean markGroups) {
        return new AlignmentView(this.alignment, this.alignment.getHiddenColumns(), this.selectionGroup, this.alignment.getHiddenColumns() != null && this.alignment.getHiddenColumns().hasHiddenColumns(), selectedOnly, markGroups);
    }

    @Override
    public String[] getViewAsString(boolean selectedRegionOnly) {
        return this.getViewAsString(selectedRegionOnly, true);
    }

    @Override
    public String[] getViewAsString(boolean selectedRegionOnly, boolean exportHiddenSeqs) {
        int iSize;
        String[] selection = null;
        SequenceI[] seqs = null;
        int start = 0;
        int end = 0;
        if (selectedRegionOnly && this.selectionGroup != null) {
            iSize = this.selectionGroup.getSize();
            seqs = this.selectionGroup.getSequencesInOrder(this.alignment);
            start = this.selectionGroup.getStartRes();
            end = this.selectionGroup.getEndRes() + 1;
        } else if (this.hasHiddenRows() && exportHiddenSeqs) {
            AlignmentI fullAlignment = this.alignment.getHiddenSequences().getFullAlignment();
            iSize = fullAlignment.getHeight();
            seqs = fullAlignment.getSequencesArray();
            end = fullAlignment.getWidth();
        } else {
            iSize = this.alignment.getHeight();
            seqs = this.alignment.getSequencesArray();
            end = this.alignment.getWidth();
        }
        selection = new String[iSize];
        if (this.alignment.getHiddenColumns() != null && this.alignment.getHiddenColumns().hasHiddenColumns()) {
            for (int i = 0; i < iSize; ++i) {
                VisibleContigsIterator blocks = this.alignment.getHiddenColumns().getVisContigsIterator(start, end + 1, false);
                selection[i] = seqs[i].getSequenceStringFromIterator(blocks);
            }
        } else {
            for (int i = 0; i < iSize; ++i) {
                selection[i] = seqs[i].getSequenceAsString(start, end);
            }
        }
        return selection;
    }

    @Override
    public List<int[]> getVisibleRegionBoundaries(int min, int max) {
        ArrayList<int[]> regions = new ArrayList<int[]>();
        int start = min;
        int end = max;
        do {
            HiddenColumns hidden;
            if ((hidden = this.alignment.getHiddenColumns()) != null && hidden.hasHiddenColumns()) {
                if (start == 0) {
                    start = hidden.visibleToAbsoluteColumn(start);
                }
                if (start == (end = hidden.getNextHiddenBoundary(false, start))) {
                    end = max;
                }
                if (end > max) {
                    end = max;
                }
            }
            regions.add(new int[]{start, end});
            if (hidden == null || !hidden.hasHiddenColumns()) continue;
            start = hidden.visibleToAbsoluteColumn(end);
            start = hidden.getNextHiddenBoundary(true, start) + 1;
        } while (end < max);
        int[][] startEnd = new int[regions.size()][2];
        return regions;
    }

    @Override
    public List<AlignmentAnnotation> getVisibleAlignmentAnnotation(boolean selectedOnly) {
        ArrayList<AlignmentAnnotation> ala = new ArrayList<AlignmentAnnotation>();
        AlignmentAnnotation[] aa = this.alignment.getAlignmentAnnotation();
        if (aa != null) {
            for (AlignmentAnnotation annot : aa) {
                AlignmentAnnotation clone = new AlignmentAnnotation(annot);
                if (selectedOnly && this.selectionGroup != null) {
                    clone.makeVisibleAnnotation(this.selectionGroup.getStartRes(), this.selectionGroup.getEndRes(), this.alignment.getHiddenColumns());
                } else {
                    clone.makeVisibleAnnotation(this.alignment.getHiddenColumns());
                }
                ala.add(clone);
            }
        }
        return ala;
    }

    @Override
    public boolean isPadGaps() {
        return this.padGaps;
    }

    @Override
    public void setPadGaps(boolean padGaps) {
        this.padGaps = padGaps;
    }

    @Override
    public void alignmentChanged(AlignmentViewPanel ap) {
        if (this.isPadGaps()) {
            this.alignment.padGaps();
        }
        if (this.autoCalculateConsensus) {
            this.updateConsensus(ap);
        }
        if (this.hconsensus != null && this.autoCalculateConsensus) {
            this.updateConservation(ap);
        }
        if (this.autoCalculateStrucConsensus) {
            this.updateStrucConsensus(ap);
        }
        int alWidth = this.alignment.getWidth();
        List<SequenceGroup> groups = this.alignment.getGroups();
        if (groups != null) {
            for (SequenceGroup sg : groups) {
                if (sg.getEndRes() <= alWidth) continue;
                sg.setEndRes(alWidth - 1);
            }
        }
        if (this.selectionGroup != null && this.selectionGroup.getEndRes() > alWidth) {
            this.selectionGroup.setEndRes(alWidth - 1);
        }
        this.updateAllColourSchemes();
        this.calculator.restartWorkers();
    }

    void updateAllColourSchemes() {
        ResidueShaderI rs = this.residueShading;
        if (rs != null) {
            rs.alignmentChanged(this.alignment, this.hiddenRepSequences);
            rs.setConsensus(this.hconsensus);
            if (rs.conservationApplied()) {
                rs.setConservation(Conservation.calculateConservation("All", this.alignment.getSequences(), 0, this.alignment.getWidth(), false, this.getConsPercGaps(), false));
            }
        }
        for (SequenceGroup sg : this.alignment.getGroups()) {
            if (sg.cs != null) {
                sg.cs.alignmentChanged(sg, this.hiddenRepSequences);
            }
            sg.recalcConservation();
        }
    }

    protected void initAutoAnnotation() {
        if (this.hconsensus == null && !this.isDataset) {
            if (!this.alignment.isNucleotide()) {
                this.initConservation();
                this.initQuality();
            } else {
                this.initRNAStructure();
            }
            this.consensus = new AlignmentAnnotation("Consensus", MessageManager.getString("label.consensus_descr"), new Annotation[1], 0.0f, 100.0f, 1);
            this.initConsensus(this.consensus);
            this.initGapCounts();
            this.initComplementConsensus();
        }
    }

    public boolean initComplementConsensus() {
        List<AlignedCodonFrame> codonMappings;
        if (!this.alignment.isNucleotide() && (codonMappings = this.alignment.getCodonFrames()) != null && !codonMappings.isEmpty()) {
            boolean doConsensus = false;
            for (AlignedCodonFrame mapping : codonMappings) {
                MapList[] mapLists = mapping.getdnaToProt();
                if (mapLists.length <= 0 || mapLists[0].getFromRatio() != 3) continue;
                doConsensus = true;
                break;
            }
            if (doConsensus) {
                this.complementConsensus = new AlignmentAnnotation("cDNA Consensus", MessageManager.getString("label.complement_consensus_descr"), new Annotation[1], 0.0f, 100.0f, 1);
                this.initConsensus(this.complementConsensus);
                return true;
            }
        }
        return false;
    }

    private void initConsensus(AlignmentAnnotation aa) {
        aa.hasText = true;
        aa.autoCalculated = true;
        if (this.showConsensus) {
            this.alignment.addAnnotation(aa);
        }
    }

    private void initGapCounts() {
        if (this.showOccupancy) {
            this.gapcounts = new AlignmentAnnotation("Occupancy", MessageManager.getString("label.occupancy_descr"), new Annotation[1], 0.0f, this.alignment.getHeight(), 1);
            this.gapcounts.hasText = true;
            this.gapcounts.autoCalculated = true;
            this.gapcounts.scaleColLabel = true;
            this.gapcounts.graph = 1;
            this.alignment.addAnnotation(this.gapcounts);
        }
    }

    private void initConservation() {
        if (this.showConservation && this.conservation == null) {
            this.conservation = new AlignmentAnnotation("Conservation", MessageManager.formatMessage("label.conservation_descr", this.getConsPercGaps()), new Annotation[1], 0.0f, 11.0f, 1);
            this.conservation.hasText = true;
            this.conservation.autoCalculated = true;
            this.alignment.addAnnotation(this.conservation);
        }
    }

    private void initQuality() {
        if (this.showQuality && this.quality == null) {
            this.quality = new AlignmentAnnotation("Quality", MessageManager.getString("label.quality_descr"), new Annotation[1], 0.0f, 11.0f, 1);
            this.quality.hasText = true;
            this.quality.autoCalculated = true;
            this.alignment.addAnnotation(this.quality);
        }
    }

    private void initRNAStructure() {
        if (this.alignment.hasRNAStructure() && this.strucConsensus == null) {
            this.strucConsensus = new AlignmentAnnotation("StrucConsensus", MessageManager.getString("label.strucconsensus_descr"), new Annotation[1], 0.0f, 100.0f, 1);
            this.strucConsensus.hasText = true;
            this.strucConsensus.autoCalculated = true;
            if (this.showConsensus) {
                this.alignment.addAnnotation(this.strucConsensus);
            }
        }
    }

    @Override
    public int calcPanelHeight() {
        AlignmentAnnotation[] anns = this.getAlignment().getAlignmentAnnotation();
        int height = 0;
        int charHeight = this.getCharHeight();
        if (anns != null) {
            BitSet graphgrp = new BitSet();
            for (AlignmentAnnotation aa : anns) {
                if (aa == null) {
                    System.err.println("Null annotation row: ignoring.");
                    continue;
                }
                if (!aa.visible) continue;
                if (aa.graphGroup > -1) {
                    if (graphgrp.get(aa.graphGroup)) continue;
                    graphgrp.set(aa.graphGroup);
                }
                aa.height = 0;
                if (aa.hasText) {
                    aa.height += charHeight;
                }
                if (aa.hasIcons) {
                    aa.height += 16;
                }
                if (aa.graph > 0) {
                    aa.height += aa.graphHeight;
                }
                if (aa.height == 0) {
                    aa.height = 20;
                }
                height += aa.height;
            }
        }
        if (height == 0) {
            height = 20;
        }
        return height;
    }

    @Override
    public void updateGroupAnnotationSettings(boolean applyGlobalSettings, boolean preserveNewGroupSettings) {
        boolean updateCalcs = false;
        boolean conv = this.isShowGroupConservation();
        boolean cons = this.isShowGroupConsensus();
        boolean showprf = this.isShowSequenceLogo();
        boolean showConsHist = this.isShowConsensusHistogram();
        boolean normLogo = this.isNormaliseSequenceLogo();
        boolean showHMMPrf = this.isShowHMMSequenceLogo();
        boolean showInfoHist = this.isShowInformationHistogram();
        boolean normHMMLogo = this.isNormaliseHMMSequenceLogo();
        boolean sortg = true;
        AlignmentAnnotation[] aan = this.alignment.getAlignmentAnnotation();
        ArrayList<SequenceGroup> oldrfs = new ArrayList<SequenceGroup>();
        if (aan != null) {
            for (int an = 0; an < aan.length; ++an) {
                if (!aan[an].autoCalculated || aan[an].groupRef == null) continue;
                oldrfs.add(aan[an].groupRef);
                this.alignment.deleteAnnotation(aan[an], false);
            }
        }
        if (this.alignment.getGroups() != null) {
            for (SequenceGroup sg : this.alignment.getGroups()) {
                updateCalcs = false;
                if (applyGlobalSettings || !preserveNewGroupSettings && !oldrfs.contains(sg)) {
                    sg.setshowSequenceLogo(showprf);
                    sg.setShowConsensusHistogram(showConsHist);
                    sg.setNormaliseSequenceLogo(normLogo);
                    sg.setShowHMMSequenceLogo(showHMMPrf);
                    sg.setShowInformationHistogram(showInfoHist);
                    sg.setNormaliseHMMSequenceLogo(normHMMLogo);
                }
                if (conv) {
                    updateCalcs = true;
                    this.alignment.addAnnotation(sg.getConservationRow(), 0);
                }
                if (cons) {
                    updateCalcs = true;
                    this.alignment.addAnnotation(sg.getConsensus(), 0);
                }
                if (!updateCalcs) continue;
                sg.recalcConservation();
            }
        }
        oldrfs.clear();
    }

    @Override
    public boolean isDisplayReferenceSeq() {
        return this.alignment.hasSeqrep() && this.viewStyle.isDisplayReferenceSeq();
    }

    @Override
    public void setDisplayReferenceSeq(boolean displayReferenceSeq) {
        this.viewStyle.setDisplayReferenceSeq(displayReferenceSeq);
    }

    @Override
    public boolean isColourByReferenceSeq() {
        return this.alignment.hasSeqrep() && this.viewStyle.isColourByReferenceSeq();
    }

    @Override
    public Color getSequenceColour(SequenceI seq) {
        Color sqc = this.sequenceColours.get(seq);
        return sqc == null ? Color.white : sqc;
    }

    @Override
    public void setSequenceColour(SequenceI seq, Color col) {
        if (col == null) {
            this.sequenceColours.remove(seq);
        } else {
            this.sequenceColours.put(seq, col);
        }
    }

    @Override
    public void updateSequenceIdColours() {
        for (SequenceGroup sg : this.alignment.getGroups()) {
            if (sg.idColour == null) continue;
            for (SequenceI s : sg.getSequences(this.getHiddenRepSequences())) {
                this.sequenceColours.put(s, sg.idColour);
            }
        }
    }

    @Override
    public void clearSequenceColours() {
        this.sequenceColours.clear();
    }

    @Override
    public AlignViewportI getCodingComplement() {
        return this.codingComplement;
    }

    @Override
    public void setCodingComplement(AlignViewportI av) {
        if (this == av) {
            System.err.println("Ignoring recursive setCodingComplement request");
        } else {
            this.codingComplement = av;
            if (av.getCodingComplement() != this) {
                av.setCodingComplement(this);
            }
        }
    }

    @Override
    public boolean isNucleotide() {
        return this.getAlignment() == null ? false : this.getAlignment().isNucleotide();
    }

    @Override
    public FeaturesDisplayedI getFeaturesDisplayed() {
        return this.featuresDisplayed;
    }

    @Override
    public void setFeaturesDisplayed(FeaturesDisplayedI featuresDisplayedI) {
        this.featuresDisplayed = featuresDisplayedI;
    }

    @Override
    public boolean areFeaturesDisplayed() {
        return this.featuresDisplayed != null && this.featuresDisplayed.getRegisteredFeaturesCount() > 0;
    }

    @Override
    public void setShowSequenceFeatures(boolean b) {
        this.viewStyle.setShowSequenceFeatures(b);
    }

    @Override
    public boolean isShowSequenceFeatures() {
        return this.viewStyle.isShowSequenceFeatures();
    }

    @Override
    public void setShowSequenceFeaturesHeight(boolean selected) {
        this.viewStyle.setShowSequenceFeaturesHeight(selected);
    }

    @Override
    public boolean isShowSequenceFeaturesHeight() {
        return this.viewStyle.isShowSequenceFeaturesHeight();
    }

    @Override
    public void setShowAnnotation(boolean b) {
        this.viewStyle.setShowAnnotation(b);
    }

    @Override
    public boolean isShowAnnotation() {
        return this.viewStyle.isShowAnnotation();
    }

    @Override
    public boolean isRightAlignIds() {
        return this.viewStyle.isRightAlignIds();
    }

    @Override
    public void setRightAlignIds(boolean rightAlignIds) {
        this.viewStyle.setRightAlignIds(rightAlignIds);
    }

    @Override
    public boolean getConservationSelected() {
        return this.viewStyle.getConservationSelected();
    }

    @Override
    public void setShowBoxes(boolean state) {
        this.viewStyle.setShowBoxes(state);
    }

    @Override
    public Color getTextColour() {
        return this.viewStyle.getTextColour();
    }

    @Override
    public Color getTextColour2() {
        return this.viewStyle.getTextColour2();
    }

    @Override
    public int getThresholdTextColour() {
        return this.viewStyle.getThresholdTextColour();
    }

    @Override
    public boolean isConservationColourSelected() {
        return this.viewStyle.isConservationColourSelected();
    }

    @Override
    public boolean isRenderGaps() {
        return this.viewStyle.isRenderGaps();
    }

    @Override
    public boolean isShowColourText() {
        return this.viewStyle.isShowColourText();
    }

    @Override
    public void setConservationColourSelected(boolean conservationColourSelected) {
        this.viewStyle.setConservationColourSelected(conservationColourSelected);
    }

    @Override
    public void setShowColourText(boolean showColourText) {
        this.viewStyle.setShowColourText(showColourText);
    }

    @Override
    public void setTextColour(Color textColour) {
        this.viewStyle.setTextColour(textColour);
    }

    @Override
    public void setThresholdTextColour(int thresholdTextColour) {
        this.viewStyle.setThresholdTextColour(thresholdTextColour);
    }

    @Override
    public void setTextColour2(Color textColour2) {
        this.viewStyle.setTextColour2(textColour2);
    }

    @Override
    public ViewStyleI getViewStyle() {
        return new ViewStyle(this.viewStyle);
    }

    @Override
    public void setViewStyle(ViewStyleI settingsForView) {
        this.viewStyle = new ViewStyle(settingsForView);
        if (this.residueShading != null) {
            this.residueShading.setConservationApplied(settingsForView.isConservationColourSelected());
        }
    }

    @Override
    public boolean sameStyle(ViewStyleI them) {
        return this.viewStyle.sameStyle(them);
    }

    @Override
    public int getIdWidth() {
        return this.viewStyle.getIdWidth();
    }

    @Override
    public void setIdWidth(int i) {
        this.viewStyle.setIdWidth(i);
    }

    @Override
    public boolean isCentreColumnLabels() {
        return this.viewStyle.isCentreColumnLabels();
    }

    @Override
    public void setCentreColumnLabels(boolean centreColumnLabels) {
        this.viewStyle.setCentreColumnLabels(centreColumnLabels);
    }

    @Override
    public void setShowDBRefs(boolean showdbrefs) {
        this.viewStyle.setShowDBRefs(showdbrefs);
    }

    @Override
    public boolean isShowDBRefs() {
        return this.viewStyle.isShowDBRefs();
    }

    @Override
    public boolean isShowNPFeats() {
        return this.viewStyle.isShowNPFeats();
    }

    @Override
    public void setShowNPFeats(boolean shownpfeats) {
        this.viewStyle.setShowNPFeats(shownpfeats);
    }

    public abstract StructureSelectionManager getStructureSelectionManager();

    public void addToHistoryList(CommandI command) {
        if (this.historyList != null) {
            this.historyList.push(command);
            this.broadcastCommand(command, false);
        }
    }

    protected void broadcastCommand(CommandI command, boolean undo) {
        this.getStructureSelectionManager().commandPerformed(command, undo, this.getVamsasSource());
    }

    public void addToRedoList(CommandI command) {
        if (this.redoList != null) {
            this.redoList.push(command);
        }
        this.broadcastCommand(command, true);
    }

    public void clearRedoList() {
        if (this.redoList != null) {
            this.redoList.clear();
        }
    }

    public void setHistoryList(Deque<CommandI> list) {
        this.historyList = list;
    }

    public Deque<CommandI> getHistoryList() {
        return this.historyList;
    }

    public void setRedoList(Deque<CommandI> list) {
        this.redoList = list;
    }

    public Deque<CommandI> getRedoList() {
        return this.redoList;
    }

    @Override
    public VamsasSource getVamsasSource() {
        return this;
    }

    public AnnotationSorter.SequenceAnnotationOrder getSortAnnotationsBy() {
        return this.sortAnnotationsBy;
    }

    public void setSortAnnotationsBy(AnnotationSorter.SequenceAnnotationOrder sortAnnotationsBy) {
        this.sortAnnotationsBy = sortAnnotationsBy;
    }

    public boolean isShowAutocalculatedAbove() {
        return this.showAutocalculatedAbove;
    }

    public void setShowAutocalculatedAbove(boolean showAutocalculatedAbove) {
        this.showAutocalculatedAbove = showAutocalculatedAbove;
    }

    @Override
    public boolean isScaleProteinAsCdna() {
        return this.viewStyle.isScaleProteinAsCdna();
    }

    @Override
    public void setScaleProteinAsCdna(boolean b) {
        this.viewStyle.setScaleProteinAsCdna(b);
    }

    @Override
    public boolean isProteinFontAsCdna() {
        return this.viewStyle.isProteinFontAsCdna();
    }

    @Override
    public void setProteinFontAsCdna(boolean b) {
        this.viewStyle.setProteinFontAsCdna(b);
    }

    @Override
    public void setShowComplementFeatures(boolean b) {
        this.viewStyle.setShowComplementFeatures(b);
    }

    @Override
    public boolean isShowComplementFeatures() {
        return this.viewStyle.isShowComplementFeatures();
    }

    @Override
    public void setShowComplementFeaturesOnTop(boolean b) {
        this.viewStyle.setShowComplementFeaturesOnTop(b);
    }

    @Override
    public boolean isShowComplementFeaturesOnTop() {
        return this.viewStyle.isShowComplementFeaturesOnTop();
    }

    @Override
    public final boolean isFollowHighlight() {
        return this.followHighlight;
    }

    @Override
    public final void setFollowHighlight(boolean b) {
        this.followHighlight = b;
    }

    @Override
    public ViewportRanges getRanges() {
        return this.ranges;
    }

    protected int findComplementScrollTarget(SearchResultsI sr) {
        AlignmentI proteinAlignment;
        AlignViewportI complement = this.getCodingComplement();
        if (complement == null || !complement.isFollowHighlight()) {
            return 0;
        }
        boolean iAmProtein = !this.getAlignment().isNucleotide();
        AlignmentI alignmentI = proteinAlignment = iAmProtein ? this.getAlignment() : complement.getAlignment();
        if (proteinAlignment == null) {
            return 0;
        }
        List<AlignedCodonFrame> mappings = proteinAlignment.getCodonFrames();
        int seqOffset = 0;
        SequenceI sequence = null;
        int middleColumn = this.ranges.getStartRes() + (this.ranges.getEndRes() - this.ranges.getStartRes()) / 2;
        HiddenSequences hiddenSequences = this.getAlignment().getHiddenSequences();
        int lastSeq = this.alignment.getHeight() - 1;
        List<AlignedCodonFrame> seqMappings = null;
        int seqNo = this.ranges.getStartSeq();
        while (seqNo <= lastSeq) {
            sequence = this.getAlignment().getSequenceAt(seqNo);
            if ((hiddenSequences == null || !hiddenSequences.isHidden(sequence)) && !Comparison.isGap(sequence.getCharAt(middleColumn)) && !(seqMappings = MappingUtils.findMappingsForSequenceAndOthers(sequence, mappings, this.getCodingComplement().getAlignment().getSequences())).isEmpty()) break;
            ++seqNo;
            ++seqOffset;
        }
        if (sequence == null || seqMappings == null || seqMappings.isEmpty()) {
            return 0;
        }
        MappingUtils.addSearchResults(sr, sequence, sequence.findPosition(middleColumn), seqMappings);
        return seqOffset;
    }

    public void expandColSelection(SequenceGroup sg, boolean wholewidth) {
        int sgs;
        if (sg != null && (sgs = sg.getStartRes()) >= 0) {
            int sge = sg.getEndRes();
            if (sg.getStartRes() <= sge && !this.hasSelectedColumns()) {
                if (!wholewidth && this.alignment.getWidth() == 1 + sge - sgs) {
                    return;
                }
                if (this.colSel == null) {
                    this.colSel = new ColumnSelection();
                }
                for (int cspos = sg.getStartRes(); cspos <= sg.getEndRes(); ++cspos) {
                    this.colSel.addElement(cspos);
                }
            }
        }
    }

    @Override
    public boolean isSelectionDefinedGroup() {
        if (this.selectionGroup == null) {
            return false;
        }
        if (this.isSelectionGroupChanged(true)) {
            this.selectionIsDefinedGroup = false;
            List<SequenceGroup> gps = this.alignment.getGroups();
            this.selectionIsDefinedGroup = gps == null || gps.size() == 0 ? false : gps.contains(this.selectionGroup);
        }
        return this.selectionGroup.isDefined() || this.selectionIsDefinedGroup;
    }

    @Override
    public boolean hasSearchResults() {
        return this.searchResults != null;
    }

    @Override
    public void setSearchResults(SearchResultsI results) {
        this.searchResults = results;
    }

    @Override
    public SearchResultsI getSearchResults() {
        return this.searchResults;
    }

    public SequenceI getConsensusSeq() {
        if (this.consensus == null) {
            this.updateConsensus(null);
        }
        if (this.consensus == null) {
            return null;
        }
        StringBuffer seqs = new StringBuffer();
        for (int i = 0; i < this.consensus.annotations.length; ++i) {
            Annotation annotation = this.consensus.annotations[i];
            if (annotation == null) continue;
            String description = annotation.description;
            if (description != null && description.startsWith("[")) {
                seqs.append(description.charAt(1));
                continue;
            }
            seqs.append(annotation.displayCharacter);
        }
        Sequence sq = new Sequence("Consensus", seqs.toString());
        sq.setDescription("Percentage Identity Consensus " + (this.ignoreGapsInConsensusCalculation ? " without gaps" : ""));
        return sq;
    }

    public boolean hasReferenceAnnotation() {
        AlignmentAnnotation[] annots;
        for (AlignmentAnnotation annot : annots = this.alignment.getAlignmentAnnotation()) {
            if (!"RF".equals(annot.label) && !annot.label.contains("Reference")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setCurrentTree(TreeModel tree) {
        this.currentTree = tree;
    }

    @Override
    public TreeModel getCurrentTree() {
        return this.currentTree;
    }

    @Override
    public boolean isNormaliseSequenceLogo() {
        return this.normaliseSequenceLogo;
    }

    public void setNormaliseSequenceLogo(boolean state) {
        this.normaliseSequenceLogo = state;
    }

    @Override
    public boolean isNormaliseHMMSequenceLogo() {
        return this.hmmNormaliseSequenceLogo;
    }

    public void setNormaliseHMMSequenceLogo(boolean state) {
        this.hmmNormaliseSequenceLogo = state;
    }

    @Override
    public boolean isUpdateStructures() {
        return this.needToUpdateStructureViews;
    }

    @Override
    public void setUpdateStructures(boolean update) {
        this.needToUpdateStructureViews = update;
    }

    @Override
    public boolean needToUpdateStructureViews() {
        boolean update = this.needToUpdateStructureViews;
        this.needToUpdateStructureViews = false;
        return update;
    }

    @Override
    public void addSequenceGroup(SequenceGroup sequenceGroup) {
        this.alignment.addGroup(sequenceGroup);
        Color col = sequenceGroup.idColour;
        if (col != null) {
            col = col.brighter();
            for (SequenceI sq : sequenceGroup.getSequences()) {
                this.setSequenceColour(sq, col);
            }
        }
        if (this.codingComplement != null) {
            SequenceGroup mappedGroup = MappingUtils.mapSequenceGroup(sequenceGroup, this, this.codingComplement);
            if (mappedGroup.getSequences().size() > 0) {
                this.codingComplement.getAlignment().addGroup(mappedGroup);
                if (col != null) {
                    for (SequenceI seq : mappedGroup.getSequences()) {
                        this.codingComplement.setSequenceColour(seq, col);
                    }
                }
            }
            this.codingComplement.setUpdateStructures(this.needToUpdateStructureViews);
        }
    }

    public void filterByEvalue(double eValue) {
        for (SequenceI seq : this.alignment.getSequencesArray()) {
            if (seq.getAnnotation("Search Scores") != null && !(seq.getAnnotation("Search Scores")[0].getEValue() > eValue) || seq.getHMM() != null) continue;
            this.hideSequence(new SequenceI[]{seq});
        }
    }

    public void filterByScore(double score) {
        for (SequenceI seq : this.alignment.getSequencesArray()) {
            if (seq.getAnnotation("Search Scores") != null && !(seq.getAnnotation("Search Scores")[0].getBitScore() < score) || seq.getHMM() != null) continue;
            this.hideSequence(new SequenceI[]{seq});
        }
    }
}

