/*
 * Decompiled with CFR 0.152.
 */
package jalview.util.matcher;

import jalview.util.matcher.Condition;
import jalview.util.matcher.MatcherI;
import java.util.Objects;
import java.util.regex.Pattern;

public class Matcher
implements MatcherI {
    Condition condition;
    String pattern;
    String uppercasePattern;
    Pattern regexPattern;
    float value;

    public Matcher(Condition cond, String compareTo) {
        Objects.requireNonNull(cond);
        this.condition = cond;
        if (cond.isNumeric()) {
            this.value = Float.valueOf(compareTo).floatValue();
            this.uppercasePattern = this.pattern = String.valueOf(this.value);
        } else {
            this.pattern = compareTo;
            if (this.pattern != null) {
                this.uppercasePattern = this.pattern.toUpperCase();
            }
        }
    }

    public Matcher(Condition cond, float compareTo) {
        this(cond, String.valueOf(compareTo));
    }

    @Override
    public boolean matches(String val) {
        if (this.condition.isNumeric()) {
            try {
                return val == null ? false : this.matches(Float.valueOf(val).floatValue());
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (val == null) {
            return this.condition == Condition.NotContains || this.condition == Condition.NotMatches || this.condition == Condition.NotPresent;
        }
        String upper = val.toUpperCase().trim();
        boolean matched = false;
        switch (this.condition) {
            case Matches: {
                matched = upper.equals(this.uppercasePattern);
                break;
            }
            case NotMatches: {
                matched = !upper.equals(this.uppercasePattern);
                break;
            }
            case Contains: {
                matched = upper.indexOf(this.uppercasePattern) > -1;
                break;
            }
            case NotContains: {
                matched = upper.indexOf(this.uppercasePattern) == -1;
                break;
            }
            case Present: {
                matched = true;
                break;
            }
        }
        return matched;
    }

    boolean matches(float f) {
        if (!this.condition.isNumeric()) {
            return this.matches(String.valueOf(f));
        }
        boolean matched = false;
        switch (this.condition) {
            case LT: {
                matched = f < this.value;
                break;
            }
            case LE: {
                matched = f <= this.value;
                break;
            }
            case EQ: {
                matched = f == this.value;
                break;
            }
            case NE: {
                matched = f != this.value;
                break;
            }
            case GT: {
                matched = f > this.value;
                break;
            }
            case GE: {
                matched = f >= this.value;
                break;
            }
        }
        return matched;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.condition.hashCode() + (int)this.value;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Matcher)) {
            return false;
        }
        Matcher m = (Matcher)obj;
        if (this.condition != m.condition || this.value != m.value) {
            return false;
        }
        if (this.pattern == null) {
            return m.pattern == null;
        }
        return this.uppercasePattern.equals(m.uppercasePattern);
    }

    @Override
    public Condition getCondition() {
        return this.condition;
    }

    @Override
    public String getPattern() {
        return this.pattern;
    }

    @Override
    public float getFloatValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.condition.toString()).append(" ");
        if (this.condition.isNumeric()) {
            sb.append(this.pattern);
        } else {
            sb.append("'").append(this.pattern).append("'");
        }
        return sb.toString();
    }
}

