/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StringUtils {
    private static final Pattern DELIMITERS_PATTERN = Pattern.compile(".*='[^']*(?!')");
    private static final boolean DEBUG = false;

    public static final char[] insertCharAt(char[] in, int position, int count, char ch) {
        char[] tmp = new char[in.length + count];
        if (position >= in.length) {
            System.arraycopy(in, 0, tmp, 0, in.length);
            position = in.length;
        } else {
            System.arraycopy(in, 0, tmp, 0, position);
        }
        int index = position;
        while (count > 0) {
            tmp[index++] = ch;
            --count;
        }
        if (position < in.length) {
            System.arraycopy(in, position, tmp, index, in.length - position);
        }
        return tmp;
    }

    public static final char[] deleteChars(char[] in, int from, int to) {
        char[] tmp;
        if (from >= in.length || from < 0) {
            return in;
        }
        if (to >= in.length) {
            tmp = new char[from];
            System.arraycopy(in, 0, tmp, 0, from);
            to = in.length;
        } else {
            tmp = new char[in.length - to + from];
            System.arraycopy(in, 0, tmp, 0, from);
            System.arraycopy(in, to, tmp, from, in.length - to);
        }
        return tmp;
    }

    public static String[] separatorListToArray(String input, String delimiter) {
        int pos;
        int seplen = delimiter.length();
        if (input == null || input.equals("") || input.equals(delimiter)) {
            return null;
        }
        ArrayList<String> jv = new ArrayList<String>();
        int cp = 0;
        boolean wasescaped = false;
        boolean wasquoted = false;
        String lstitem = null;
        while ((pos = input.indexOf(delimiter, cp)) >= cp) {
            int escape;
            int n = escape = pos > 0 && input.charAt(pos - 1) == '\\' ? -1 : 0;
            if (wasescaped || wasquoted) {
                lstitem = lstitem + delimiter + input.substring(cp, pos + escape);
                jv.set(jv.size() - 1, lstitem);
            } else {
                lstitem = input.substring(cp, pos + escape);
                jv.add(lstitem);
            }
            cp = pos + seplen;
            wasescaped = escape == -1;
            wasquoted = DELIMITERS_PATTERN.matcher(lstitem).matches();
        }
        if (cp < input.length()) {
            String c = input.substring(cp);
            if (wasescaped || wasquoted) {
                jv.set(jv.size() - 1, lstitem + delimiter + c);
            } else if (!c.equals(delimiter)) {
                jv.add(c);
            }
        }
        if (jv.size() > 0) {
            String[] v = jv.toArray(new String[jv.size()]);
            jv.clear();
            return v;
        }
        return null;
    }

    public static String arrayToSeparatorList(String[] list, String separator) {
        StringBuffer v = new StringBuffer();
        if (list != null && list.length > 0) {
            int iSize = list.length;
            for (int i = 0; i < iSize; ++i) {
                if (list[i] == null) continue;
                if (v.length() > 0) {
                    v.append(separator);
                }
                v.append(list[i]);
            }
            return v.toString();
        }
        return "" + separator;
    }

    public static String listToDelimitedString(List<String> terms, String delim) {
        StringBuilder sb = new StringBuilder(32);
        if (terms != null && !terms.isEmpty()) {
            boolean appended = false;
            for (String term : terms) {
                if (appended) {
                    sb.append(delim);
                }
                appended = true;
                sb.append(term);
            }
        }
        return sb.toString();
    }

    public static int parseInt(String s) {
        int result = 0;
        if (s != null && s.length() > 0) {
            try {
                result = Integer.parseInt(s);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    public static int compareVersions(String v1, String v2) {
        return StringUtils.compareVersions(v1, v2, null);
    }

    public static int compareVersions(String v1, String v2, String pointSeparator) {
        int i;
        if (v1 == null || v2 == null) {
            return 0;
        }
        String[] toks1 = v1.split("\\.");
        String[] toks2 = v2.split("\\.");
        for (i = 0; i < toks1.length; ++i) {
            if (i >= toks2.length) {
                return 1;
            }
            String tok1 = toks1[i];
            String tok2 = toks2[i];
            if (pointSeparator != null) {
                tok1 = tok1.replace(pointSeparator, ".");
                tok2 = tok2.replace(pointSeparator, ".");
            }
            try {
                float f1 = Float.valueOf(tok1).floatValue();
                float f2 = Float.valueOf(tok2).floatValue();
                int comp = Float.compare(f1, f2);
                if (comp == 0) continue;
                return comp;
            }
            catch (NumberFormatException e) {
                System.err.println("Invalid version format found: " + e.getMessage());
                return 0;
            }
        }
        if (i < toks2.length) {
            return -1;
        }
        return 0;
    }

    public static String toSentenceCase(String s) {
        if (s == null) {
            return s;
        }
        if (s.length() <= 1) {
            return s.toUpperCase();
        }
        return s.substring(0, 1).toUpperCase() + s.substring(1).toLowerCase();
    }

    public static String stripHtmlTags(String text) {
        int endTag;
        if (text == null) {
            return null;
        }
        String tmp2up = text.toUpperCase();
        int startTag = tmp2up.indexOf("<HTML>");
        if (startTag > -1) {
            text = text.substring(startTag + 6);
            tmp2up = tmp2up.substring(startTag + 6);
        }
        if ((endTag = tmp2up.indexOf("</BODY>")) > -1) {
            text = text.substring(0, endTag);
            tmp2up = tmp2up.substring(0, endTag);
        }
        if ((endTag = tmp2up.indexOf("</HTML>")) > -1) {
            text = text.substring(0, endTag);
        }
        if (startTag == -1 && (text.contains("<") || text.contains(">"))) {
            text = text.replaceAll("<", "&lt;");
            text = text.replaceAll(">", "&gt;");
        }
        return text;
    }
}

