/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.util.ShortcutKeyMaskExWrapper;
import java.awt.event.MouseEvent;

public class Platform {
    private static Boolean isAMac = null;
    private static Boolean isWindows = null;
    private static Boolean isHeadless = null;

    public static boolean isAMac() {
        if (isAMac == null) {
            isAMac = System.getProperty("os.name").indexOf("Mac") > -1;
        }
        return isAMac;
    }

    public static boolean isWindows() {
        if (isWindows == null) {
            isWindows = System.getProperty("os.name").indexOf("Win") > -1;
        }
        return isWindows;
    }

    public static boolean isHeadless() {
        if (isHeadless == null) {
            isHeadless = "true".equals(System.getProperty("java.awt.headless"));
        }
        return isHeadless;
    }

    public static int getMaxCommandLineLength() {
        return 2046;
    }

    public static String escapeBackslashes(String s) {
        return s == null ? null : s.replace("\\", "\\\\");
    }

    public static boolean isControlDown(MouseEvent e) {
        boolean aMac = Platform.isAMac();
        return Platform.isControlDown(e, aMac);
    }

    protected static boolean isControlDown(MouseEvent e, boolean aMac) {
        if (aMac) {
            if (e.isPopupTrigger()) {
                return false;
            }
            return (ShortcutKeyMaskExWrapper.getMenuShortcutKeyMaskEx() & ShortcutKeyMaskExWrapper.getModifiersEx(e)) != 0;
        }
        return e.isControlDown();
    }

    public static boolean pathEquals(String path1, String path2) {
        if (path1 == null) {
            return path2 == null;
        }
        if (path2 == null) {
            return false;
        }
        String p1 = path1.replace('\\', '/');
        String p2 = path2.replace('\\', '/');
        return p1.equals(p2);
    }
}

