/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MessageManager {
    private static ResourceBundle rb;
    private static Logger log;
    private static Locale loc;

    public static String getString(String key) {
        String value = "[missing key] " + key;
        try {
            value = rb.getString(key);
        }
        catch (Exception e) {
            log.warning("I18N missing: " + loc + "\t" + key);
        }
        return value;
    }

    public static Locale getLocale() {
        return loc;
    }

    public static String formatMessage(String key, Object ... params) {
        return MessageFormat.format(rb.getString(key), params);
    }

    public static String formatMessage(String key, String[] params) {
        return MessageFormat.format(rb.getString(key), params);
    }

    public static String getStringOrReturn(String keyroot, String name) {
        String smkey = keyroot + name.toLowerCase().replaceAll(" ", "");
        try {
            name = rb.getString(smkey);
        }
        catch (Exception x) {
            log.finest("I18N missing key with root " + keyroot + ": " + loc + "\t" + smkey);
        }
        return name;
    }

    static {
        log = Logger.getLogger(MessageManager.class.getCanonicalName());
        try {
            loc = Locale.getDefault();
            log.info("Getting messages for lang: " + loc);
            rb = ResourceBundle.getBundle("lang.Messages", loc);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Language keys: " + rb.keySet());
            }
        }
        catch (Exception q) {
            log.warning("Exception when initting Locale for i18n messages\n" + q.getMessage());
            q.printStackTrace();
        }
        catch (Error v) {
            log.warning("Error when initting Locale for i18n messages\n" + v.getMessage());
            v.printStackTrace();
        }
    }
}

