/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceI;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.HMMFile;
import jalview.io.StockholmFile;
import jalview.schemes.ResidueProperties;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.Vector;

public class HMMProbabilityDistributionAnalyser {
    AlignmentAnnotation reference = null;
    Vector<SequenceI> sequences;
    HiddenMarkovModel hmm;
    List<ArrayList<Double>> raw = new ArrayList<ArrayList<Double>>();
    Map<String, Double> binned = new HashMap<String, Double>();
    String families = "/media/sf_Shared_Folder/PFAM/Family/SeedFamilies.seed";
    static final String FAMILIESTOCLAN = "/media/sf_Shared_Folder/PFAM/Family/Clanlinks.dat";
    String hmms = "/media/sf_Shared_Folder/PFAM/HMMs/Pfam-A.hmm";
    static final String RAW = "/Raw.csv";
    static final String BINNED = "/Binned.csv";
    static final double SCALE = 1.0;
    int currentFilePosition = 0;
    static final String NL = "\n";
    Random generator = new Random();
    String currentFolder;
    boolean keepRaw = false;

    public void setFolder(String path) {
        this.currentFolder = path;
    }

    public void moveLocationBy(int index, BufferedReader br) throws IOException {
        for (int i = 0; i < index; ++i) {
            String line = br.readLine();
            while (!"//".equals(line)) {
                line = br.readLine();
            }
        }
    }

    public void run(int increments, boolean keepRawData) throws IOException {
        this.keepRaw = keepRawData;
        try {
            this.readPreviousData(this.currentFolder);
            BufferedReader posReader = new BufferedReader(new FileReader(this.currentFolder + "/CurrentPosition.txt"));
            String line = posReader.readLine();
            posReader.close();
            this.currentFilePosition = Integer.parseInt(line);
        }
        catch (Exception e) {
            System.out.println("No previous data found");
        }
        BufferedReader inputSTO = new BufferedReader(new FileReader(this.families));
        BufferedReader inputHMM = new BufferedReader(new FileReader(this.hmms));
        this.moveLocationBy(this.currentFilePosition, inputHMM);
        this.moveLocationBy(this.currentFilePosition, inputSTO);
        int filesRead = 0;
        int i = 0;
        while (filesRead < increments) {
            this.readStockholm(inputSTO);
            this.readHMM(inputHMM);
            int count = this.countValidResidues();
            this.processData(count);
            ++filesRead;
            ++this.currentFilePosition;
            System.out.println(i);
            ++i;
        }
        PrintWriter p = new PrintWriter(new File(this.currentFolder + "/CurrentPosition.txt"));
        p.print(this.currentFilePosition);
        p.close();
        this.exportData(this.currentFolder);
        this.raw.clear();
        this.binned.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runToEnd(int minCount, int maxCount, boolean keepRawData, boolean forClans) throws IOException {
        this.keepRaw = keepRawData;
        BufferedReader inputSTO = null;
        BufferedReader inputHMM = null;
        boolean size = false;
        int files = 1;
        try {
            if (forClans) {
                files = 603;
            }
            int filesRead = 0;
            for (int clan = 0; clan < files; ++clan) {
                System.out.println(clan);
                String clanPath = "";
                int numberOfFamilies = 0;
                if (forClans) {
                    clanPath = this.currentFolder + "/Clan" + clan;
                    if (!new File(clanPath).exists()) continue;
                    BufferedReader famCountReader = new BufferedReader(new FileReader(clanPath + "/NumberOfFamilies.txt"));
                    numberOfFamilies = Integer.parseInt(famCountReader.readLine());
                } else {
                    numberOfFamilies = 1;
                }
                for (int fam = 0; fam < numberOfFamilies; ++fam) {
                    if (forClans) {
                        this.families = clanPath + "/Families/Fam" + fam + ".sto";
                        this.hmms = clanPath + "/HMMs/HMM" + fam + ".hmm";
                    }
                    inputSTO = new BufferedReader(new FileReader(this.families));
                    inputHMM = new BufferedReader(new FileReader(this.hmms));
                    boolean i = false;
                    boolean endReached = this.atEnd(inputSTO);
                    while (!endReached) {
                        this.readStockholm(inputSTO);
                        this.readHMM(inputHMM);
                        int count = this.countValidResidues();
                        if (count >= minCount && count < maxCount) {
                            this.processData(count);
                        }
                        System.out.println(++filesRead);
                        endReached = this.atEnd(inputSTO);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.exportData(this.currentFolder);
            this.raw.clear();
            this.binned.clear();
        }
    }

    public void readPreviousData(String source) throws IOException {
        this.readBinned(source);
        if (this.keepRaw) {
            this.readRaw(source);
        }
    }

    public void readBinned(String source) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(source + BINNED));
        String line = input.readLine();
        this.binned = new HashMap<String, Double>();
        while (!"".equals(line) && line != null) {
            Scanner scanner = new Scanner(line);
            scanner.useDelimiter(",");
            String key = scanner.next();
            String value = scanner.next();
            this.binned.put(key, Double.valueOf(value));
            scanner.close();
            line = input.readLine();
        }
        input.close();
    }

    public void readRaw(String source) throws IOException {
        BufferedReader input = new BufferedReader(new FileReader(source + RAW));
        String line = input.readLine();
        if (line == null) {
            input.close();
            return;
        }
        Scanner numberScanner = new Scanner(line);
        numberScanner.useDelimiter(",");
        this.raw = new ArrayList<ArrayList<Double>>();
        while (numberScanner.hasNext()) {
            numberScanner.next();
            this.raw.add(new ArrayList());
        }
        numberScanner.close();
        line = input.readLine();
        while (!"".equals(line) && line != null) {
            Scanner scanner = new Scanner(line);
            scanner.useDelimiter(",");
            int i = 0;
            while (scanner.hasNext()) {
                String value = scanner.next();
                if (!value.equals("EMPTY")) {
                    this.raw.get(i).add(Double.parseDouble(value));
                } else {
                    this.raw.get(i).add(null);
                }
                ++i;
            }
            scanner.close();
            line = input.readLine();
        }
        input.close();
    }

    public int countValidResidues() {
        int count = 0;
        for (int width = 0; width < this.sequences.size(); ++width) {
            for (int length = 1; length < this.hmm.getLength() + 1; ++length) {
                int alignPos = this.hmm.getNodeMapPosition(length);
                char symbol = this.sequences.get(width).getCharAt(alignPos);
                if (!ResidueProperties.backgroundFrequencies.get("amino").containsKey(Character.valueOf(symbol))) continue;
                ++count;
            }
        }
        return count;
    }

    public void processData(int count) {
        int rawPos = 0;
        if (this.keepRaw) {
            this.raw.add(new ArrayList());
            rawPos = this.raw.size() - 1;
        }
        Double total = 0.0;
        for (int width = 0; width < this.sequences.size(); ++width) {
            for (int length = 1; length < this.hmm.getLength() + 1; ++length) {
                int alignPos = this.hmm.getNodeMapPosition(length);
                char symbol = this.sequences.get(width).getCharAt(alignPos);
                if (!ResidueProperties.backgroundFrequencies.get("amino").containsKey(Character.valueOf(symbol))) continue;
                Double prob = this.hmm.getMatchEmissionProbability(alignPos, symbol);
                Float bfreq = ResidueProperties.backgroundFrequencies.get("amino").get(Character.valueOf(symbol));
                if (prob == 0.0 || bfreq.floatValue() == 0.0f) {
                    System.out.println("error");
                }
                Double llr = Math.log(prob / (double)bfreq.floatValue());
                if (this.keepRaw) {
                    this.raw.get(rawPos).add(llr);
                }
                String output = String.format("%.1f", llr);
                total = total + Double.parseDouble(output);
                if ("-0.0".equals(output)) {
                    output = "0.0";
                }
                if (this.binned.containsKey(output)) {
                    double prev = this.binned.get(output);
                    this.binned.put(output, prev += 1.0 / (double)count);
                    continue;
                }
                this.binned.put(output, 1.0 / (double)count);
            }
        }
        System.out.println(total / (double)count);
    }

    public void readStockholm(BufferedReader inputSTO) throws IOException {
        FileParse parserSTO = new FileParse(inputSTO, "", DataSourceType.FILE);
        StockholmFile file = new StockholmFile(parserSTO);
        Vector<AlignmentAnnotation> annots = file.getAnnotations();
        for (AlignmentAnnotation annot : annots) {
            if (!annot.label.contains("Reference")) continue;
            this.reference = annot;
        }
        this.sequences = file.getSeqs();
    }

    public void readHMM(BufferedReader inputHMM) throws IOException {
        FileParse parserHMM = new FileParse(inputHMM, "", DataSourceType.FILE);
        HMMFile file = new HMMFile(parserHMM);
        this.hmm = file.getHMM();
    }

    public void exportData(String location) throws FileNotFoundException {
        PrintWriter writerBin = new PrintWriter(new File(location + BINNED));
        for (Map.Entry<String, Double> entry : this.binned.entrySet()) {
            writerBin.println(entry.getKey() + "," + entry.getValue());
        }
        writerBin.close();
        if (this.keepRaw) {
            PrintWriter writerRaw = new PrintWriter(new File(location + RAW));
            StringBuilder identifier = new StringBuilder();
            for (int i = 1; i < this.raw.size() + 1; ++i) {
                identifier.append("Fam " + i + ",");
            }
            writerRaw.println(identifier);
            boolean rowIsEmpty = false;
            int row = 0;
            while (!rowIsEmpty) {
                rowIsEmpty = true;
                StringBuilder string = new StringBuilder();
                for (int column = 0; column < this.raw.size(); ++column) {
                    if (this.raw.get(column).size() <= row) {
                        string.append("EMPTY,");
                        continue;
                    }
                    string.append(this.raw.get(column).get(row) + ",");
                    rowIsEmpty = false;
                }
                ++row;
                writerRaw.println(string);
            }
            writerRaw.close();
        }
    }

    public void printFam(int index) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.families));
        this.moveLocationBy(index, br);
        String line = br.readLine();
        while (!"//".equals(line)) {
            System.out.println(line);
            line = br.readLine();
        }
        System.out.println(line);
        br.close();
    }

    public void printHMM(int index) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.hmms));
        this.moveLocationBy(index, br);
        String line = br.readLine();
        while (!"//".equals(line)) {
            System.out.println(line);
            line = br.readLine();
        }
        System.out.println(line);
        br.close();
    }

    public void exportFam(int index, String location) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.families));
        this.moveLocationBy(index, br);
        String line = br.readLine();
        PrintWriter writer = new PrintWriter(new FileOutputStream(new File(location), true));
        while (!"//".equals(line)) {
            writer.println(line);
            line = br.readLine();
        }
        writer.println(line);
        writer.close();
        br.close();
    }

    public void exportFile(BufferedReader br, String location, boolean append) throws IOException {
        String line = br.readLine();
        PrintWriter writer = new PrintWriter(new FileOutputStream(location, append));
        while (!"//".equals(line)) {
            writer.println(line);
            line = br.readLine();
        }
        writer.println(line);
        writer.close();
    }

    public String getHMMName(int index) throws IOException {
        BufferedReader nameFinder = new BufferedReader(new FileReader(this.hmms));
        this.moveLocationBy(index, nameFinder);
        nameFinder.readLine();
        Scanner scanner = new Scanner(nameFinder.readLine());
        String name = scanner.next();
        name = scanner.next();
        scanner.close();
        return name;
    }

    public String getFamilyName(int index) throws IOException {
        BufferedReader nameFinder = new BufferedReader(new FileReader(this.families));
        this.moveLocationBy(index, nameFinder);
        nameFinder.readLine();
        Scanner scanner = new Scanner(nameFinder.readLine());
        String name = scanner.next();
        name = scanner.next();
        name = scanner.next();
        scanner.close();
        return name;
    }

    public void exportHMM(int index, String location) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(this.hmms));
        this.moveLocationBy(index, br);
        String line = br.readLine();
        PrintWriter writer = new PrintWriter(new FileOutputStream(new File(location), true));
        while (!"//".equals(line)) {
            writer.println(line);
            line = br.readLine();
        }
        writer.println(line);
        writer.close();
        br.close();
    }

    public void clear() throws FileNotFoundException {
        PrintWriter pos = new PrintWriter(this.currentFolder + "/CurrentPosition.txt");
        pos.println("0");
        PrintWriter raw = new PrintWriter(this.currentFolder + RAW);
        PrintWriter bin = new PrintWriter(this.currentFolder + BINNED);
        pos.close();
        bin.close();
        raw.close();
    }

    public void sortIntoClans(String directory) throws IOException {
        BufferedReader clanFinder = new BufferedReader(new FileReader(FAMILIESTOCLAN));
        BufferedReader familyReader = new BufferedReader(new FileReader(this.families));
        BufferedReader hmmReader = new BufferedReader(new FileReader(this.hmms));
        int families = 0;
        HashMap<String, Integer> clanIndexes = new HashMap<String, Integer>();
        ArrayList<Integer> familyCounts = new ArrayList<Integer>();
        int filePos = 0;
        int clanCount = 0;
        String line = clanFinder.readLine();
        while (!"".equals(line) && !" ".equals(line) && line != null) {
            boolean inClan = false;
            while (line.indexOf("//") <= -1) {
                if (line.indexOf("#=GF CL") > -1) {
                    System.out.println(++families);
                    inClan = true;
                    Scanner scanner = new Scanner(line);
                    scanner.next();
                    scanner.next();
                    String clanName = scanner.next();
                    scanner.close();
                    if (!clanIndexes.containsKey(clanName)) {
                        clanIndexes.put(clanName, clanCount);
                        ++clanCount;
                        familyCounts.add(0);
                    }
                    Integer clanI = (Integer)clanIndexes.get(clanName);
                    String clanPath = directory + "/Clan" + clanI.toString();
                    this.createFolders(clanPath);
                    int index = (Integer)clanIndexes.get(clanName);
                    this.exportFile(familyReader, clanPath + "/Families/Fam" + familyCounts.get(index) + ".sto", false);
                    this.exportFile(hmmReader, clanPath + "/HMMs/HMM" + familyCounts.get(index) + ".hmm", false);
                    int count = (Integer)familyCounts.get(index);
                    familyCounts.set(index, ++count);
                }
                line = clanFinder.readLine();
            }
            if (!inClan) {
                this.moveLocationBy(1, familyReader);
                this.moveLocationBy(1, hmmReader);
            }
            ++filePos;
            line = clanFinder.readLine();
        }
        clanFinder.close();
        for (int clan = 0; clan < clanCount; ++clan) {
            PrintWriter writer = new PrintWriter(directory + "/Clan" + clan + "/NumberOfFamilies.txt");
            int count = (Integer)familyCounts.get(clan);
            writer.print(count);
            writer.close();
        }
    }

    public String getFamilies() {
        return this.families;
    }

    public void setFamilies(String families) {
        this.families = this.currentFolder + families;
    }

    public String getHmms() {
        return this.hmms;
    }

    public void setHmms(String hmms) {
        this.hmms = this.currentFolder + hmms;
    }

    public void alignWithinClan(String exportLocation, String clansLocation) throws IOException, InterruptedException {
        int alignmentsExported = 0;
        for (int clan = 0; clan < 604; ++clan) {
            System.out.println(clan);
            int famCount = 0;
            String clanPath = clansLocation + "/Clan" + clan;
            BufferedReader br = new BufferedReader(new FileReader(clanPath + "/NumberOfFamilies.txt"));
            String line = br.readLine();
            int numberOfFamilies = Integer.parseInt(line);
            br.close();
            if (numberOfFamilies == 1) continue;
            final String commandExportLocation = exportLocation + "/Clan" + clan;
            this.createFolders(commandExportLocation);
            for (int family = 0; family < numberOfFamilies; ++family) {
                ++famCount;
                ArrayList<Integer> indexes = new ArrayList<Integer>();
                for (int i = 0; i < numberOfFamilies; ++i) {
                    if (i == family) continue;
                    indexes.add(i);
                }
                int hmmIndex = this.getRandom(indexes);
                String famPath = clanPath + "/Families/Fam" + family + ".sto";
                String hmmPath = clanPath + "/HMMs/HMM" + hmmIndex + ".hmm";
                String command = "/media/sf_Shared_Folder/hmmer/binaries/hmmalign --mapali " + clanPath + "/Families/Fam" + hmmIndex + ".sto --trim ";
                command = command + hmmPath + " ";
                command = command + famPath;
                final int familyIndex = family;
                final Process p = Runtime.getRuntime().exec(command);
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                        String line = null;
                        try {
                            PrintWriter writer = new PrintWriter(commandExportLocation + "/Families/Fam" + familyIndex + ".sto");
                            String lastLine = "";
                            boolean dataFound = false;
                            while ((line = input.readLine()) != null) {
                                if (line.contains("#=GR") && !dataFound) {
                                    writer.println(lastLine);
                                    dataFound = true;
                                }
                                if (line.contains("#") || dataFound || " ".equals(line) || "".equals(line) || "//".equals(line)) {
                                    writer.println(line);
                                }
                                lastLine = line;
                            }
                            writer.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }).start();
                p.waitFor();
                BufferedReader hmmExporter = new BufferedReader(new FileReader(hmmPath));
                this.exportFile(hmmExporter, commandExportLocation + "/HMMs/HMM" + family + ".hmm", false);
                ++alignmentsExported;
            }
            PrintWriter writer = new PrintWriter(commandExportLocation + "/NumberOfFamilies.txt");
            writer.print(famCount);
            writer.close();
        }
    }

    public boolean atEnd(BufferedReader br) throws IOException {
        boolean end = false;
        br.mark(80);
        String line = br.readLine();
        if ("".equals(line) || line == null) {
            end = true;
        }
        br.reset();
        return end;
    }

    public int getRandom(ArrayList<Integer> list) {
        if (list.size() <= 0) {
            System.out.println("Error - size = " + list.size());
        }
        int index = this.generator.nextInt(list.size());
        int value = list.get(index);
        list.remove(index);
        return value;
    }

    public void createFolders(String clanPath) {
        File clanFolder = new File(clanPath);
        if (!clanFolder.exists()) {
            clanFolder.mkdir();
        }
        File famFolder = new File(clanPath + "/Families");
        File hmmFolder = new File(clanPath + "/HMMs");
        if (!famFolder.exists()) {
            famFolder.mkdir();
            hmmFolder.mkdir();
        }
    }
}

