/*
 * Decompiled with CFR 0.152.
 */
package jalview.util;

import jalview.datamodel.SequenceI;
import java.util.ArrayList;

public class Comparison {
    private static final int EIGHTY_FIVE = 85;
    private static final int TO_UPPER_CASE = 32;
    public static final char GAP_SPACE = ' ';
    public static final char GAP_DOT = '.';
    public static final char GAP_DASH = '-';
    public static final String GapChars = new String(new char[]{' ', '.', '-'});
    static final int caseShift = 32;

    public static final float compare(SequenceI ii, SequenceI jj) {
        return Comparison.compare(ii, jj, 0, ii.getLength() - 1);
    }

    public static float compare(SequenceI ii, SequenceI jj, int start, int end) {
        String si = ii.getSequenceAsString();
        String sj = jj.getSequenceAsString();
        int ilen = si.length() - 1;
        int jlen = sj.length() - 1;
        while (Comparison.isGap(si.charAt(start + ilen))) {
            --ilen;
        }
        while (Comparison.isGap(sj.charAt(start + jlen))) {
            --jlen;
        }
        int count = 0;
        int match = 0;
        float pid = -1.0f;
        if (ilen > jlen) {
            for (int j = 0; j < jlen; ++j) {
                if (si.substring(start + j, start + j + 1).equals(sj.substring(start + j, start + j + 1))) {
                    ++match;
                }
                ++count;
            }
            pid = (float)match / (float)ilen * 100.0f;
        } else {
            for (int j = 0; j < jlen; ++j) {
                if (si.substring(start + j, start + j + 1).equals(sj.substring(start + j, start + j + 1))) {
                    ++match;
                }
                ++count;
            }
            pid = (float)match / (float)jlen * 100.0f;
        }
        return pid;
    }

    @Deprecated
    public static final float PID(String seq1, String seq2) {
        return Comparison.PID(seq1, seq2, 0, seq1.length());
    }

    @Deprecated
    public static final float PID(String seq1, String seq2, int start, int end) {
        return Comparison.PID(seq1, seq2, start, end, true, false);
    }

    @Deprecated
    public static final float PID(String seq1, String seq2, int start, int end, boolean wcGaps, boolean ungappedOnly) {
        int s2len;
        int s1len = seq1.length();
        int len = Math.min(s1len, s2len = seq2.length());
        if (end < len) {
            len = end;
        }
        if (len < start) {
            start = len - 1;
        }
        int elen = len - start;
        int bad = 0;
        for (int i = start; i < len; ++i) {
            boolean agap;
            char chr1 = seq1.charAt(i);
            char chr2 = seq2.charAt(i);
            boolean bl = agap = Comparison.isGap(chr1) || Comparison.isGap(chr2);
            if ('a' <= chr1 && chr1 <= 'z') {
                chr1 = (char)(chr1 - 32);
            }
            if ('a' <= chr2 && chr2 <= 'z') {
                chr2 = (char)(chr2 - 32);
            }
            if (chr1 == chr2) continue;
            if (agap) {
                if (ungappedOnly) {
                    --elen;
                    continue;
                }
                if (wcGaps) continue;
                ++bad;
                continue;
            }
            ++bad;
        }
        if (elen < 1) {
            return 0.0f;
        }
        return 100.0f * (float)(elen - bad) / (float)elen;
    }

    public static final boolean isGap(char c) {
        return c == '-' || c == '.' || c == ' ';
    }

    public static final boolean isNucleotide(SequenceI seq) {
        return Comparison.isNucleotide(new SequenceI[]{seq});
    }

    public static final boolean isNucleotide(SequenceI[] seqs) {
        if (seqs == null) {
            return false;
        }
        int ntCount = 0;
        int aaCount = 0;
        for (SequenceI seq : seqs) {
            if (seq == null) continue;
            int len = seq.getLength();
            for (int i = 0; i < len; ++i) {
                char c = seq.getCharAt(i);
                if (Comparison.isNucleotide(c)) {
                    ++ntCount;
                    continue;
                }
                if (Comparison.isGap(c)) continue;
                ++aaCount;
            }
        }
        return ntCount * 100 > 85 * (ntCount + aaCount);
    }

    public static boolean isNucleotide(char c) {
        if ('a' <= c && c <= 'z') {
            c = (char)(c - 32);
        }
        switch (c) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'U': {
                return true;
            }
        }
        return false;
    }

    public static boolean isNucleotideSequence(String s, boolean allowGaps) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Comparison.isNucleotide(c) || allowGaps && Comparison.isGap(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isNucleotide(SequenceI[][] seqs) {
        if (seqs == null) {
            return false;
        }
        ArrayList<SequenceI> flattened = new ArrayList<SequenceI>();
        SequenceI[][] sequenceIArray = seqs;
        int n = sequenceIArray.length;
        for (int i = 0; i < n; ++i) {
            SequenceI[] ss;
            for (SequenceI s : ss = sequenceIArray[i]) {
                flattened.add(s);
            }
        }
        SequenceI[] oneDArray = flattened.toArray(new SequenceI[flattened.size()]);
        return Comparison.isNucleotide(oneDArray);
    }

    public static boolean isSameResidue(char c1, char c2, boolean caseSensitive) {
        if (caseSensitive) {
            return c1 == c2;
        }
        return Character.toUpperCase(c1) == Character.toUpperCase(c2);
    }
}

