/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

import jalview.datamodel.PDBEntry;

public class StructureImportSettings {
    private static boolean visibleChainAnnotation = false;
    private static boolean processSecStr = false;
    private static boolean externalSecondaryStructure = false;
    private static boolean showSeqFeatures = true;
    private static PDBEntry.Type defaultStructureFileFormat = PDBEntry.Type.PDB;
    private static StructureParser defaultPDBFileParser = StructureParser.JMOL_PARSER;

    public static void addSettings(boolean addAlignmentAnnotations, boolean processSecStr, boolean externalSecStr) {
        visibleChainAnnotation = addAlignmentAnnotations;
        StructureImportSettings.processSecStr = processSecStr;
        externalSecondaryStructure = externalSecStr;
        showSeqFeatures = true;
    }

    public static boolean isVisibleChainAnnotation() {
        return visibleChainAnnotation;
    }

    public static void setVisibleChainAnnotation(boolean visibleChainAnnotation) {
        StructureImportSettings.visibleChainAnnotation = visibleChainAnnotation;
    }

    public static boolean isProcessSecondaryStructure() {
        return processSecStr;
    }

    public static void setProcessSecondaryStructure(boolean processSecondaryStructure) {
        processSecStr = processSecondaryStructure;
    }

    public static boolean isExternalSecondaryStructure() {
        return externalSecondaryStructure;
    }

    public static void setExternalSecondaryStructure(boolean externalSecondaryStructure) {
        StructureImportSettings.externalSecondaryStructure = externalSecondaryStructure;
    }

    public static boolean isShowSeqFeatures() {
        return showSeqFeatures;
    }

    public static void setShowSeqFeatures(boolean showSeqFeatures) {
        StructureImportSettings.showSeqFeatures = showSeqFeatures;
    }

    public static PDBEntry.Type getDefaultStructureFileFormat() {
        return defaultStructureFileFormat;
    }

    public static void setDefaultStructureFileFormat(String defaultStructureFileFormat) {
        StructureImportSettings.defaultStructureFileFormat = PDBEntry.Type.valueOf(defaultStructureFileFormat.toUpperCase());
    }

    public static String getDefaultPDBFileParser() {
        return defaultPDBFileParser.toString();
    }

    public static void setDefaultPDBFileParser(StructureParser defaultPDBFileParser) {
        StructureImportSettings.defaultPDBFileParser = defaultPDBFileParser;
    }

    public static void setDefaultPDBFileParser(String defaultPDBFileParser) {
        StructureImportSettings.defaultPDBFileParser = StructureParser.valueOf(defaultPDBFileParser.toUpperCase());
    }

    public static enum StructureParser {
        JMOL_PARSER,
        JALVIEW_PARSER;

    }
}

