/*
 * Decompiled with CFR 0.152.
 */
package jalview.structure;

public class AtomSpec {
    int modelNo;
    private String pdbFile;
    private String chain;
    private int pdbResNum;
    private int atomIndex;

    public static AtomSpec fromChimeraAtomspec(String spec) {
        int colonPos = spec.indexOf(":");
        if (colonPos == -1) {
            throw new IllegalArgumentException(spec);
        }
        int hashPos = spec.indexOf("#");
        if (hashPos == -1 && colonPos != 0) {
            throw new IllegalArgumentException(spec);
        }
        String modelSubmodel = spec.substring(hashPos + 1, colonPos);
        int dotPos = modelSubmodel.indexOf(".");
        int modelId = 0;
        try {
            modelId = Integer.valueOf(dotPos == -1 ? modelSubmodel : modelSubmodel.substring(0, dotPos));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String residueChain = spec.substring(colonPos + 1);
        dotPos = residueChain.indexOf(".");
        int resNum = 0;
        try {
            resNum = Integer.parseInt(dotPos == -1 ? residueChain : residueChain.substring(0, dotPos));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(spec);
        }
        String chainId = dotPos == -1 ? "" : residueChain.substring(dotPos + 1);
        return new AtomSpec(modelId, chainId, resNum, 0);
    }

    public AtomSpec(String pdbFile, String chain, int resNo, int atomNo) {
        this.pdbFile = pdbFile;
        this.chain = chain;
        this.pdbResNum = resNo;
        this.atomIndex = atomNo;
    }

    public AtomSpec(int modelId, String chainId, int resNo, int atomNo) {
        this.modelNo = modelId;
        this.chain = chainId;
        this.pdbResNum = resNo;
        this.atomIndex = atomNo;
    }

    public String getPdbFile() {
        return this.pdbFile;
    }

    public String getChain() {
        return this.chain;
    }

    public int getPdbResNum() {
        return this.pdbResNum;
    }

    public int getAtomIndex() {
        return this.atomIndex;
    }

    public int getModelNumber() {
        return this.modelNo;
    }

    public void setPdbFile(String file) {
        this.pdbFile = file;
    }

    public String toString() {
        return "pdbFile: " + this.pdbFile + ", chain: " + this.chain + ", res: " + this.pdbResNum + ", atom: " + this.atomIndex;
    }
}

