/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.api.AlignViewportI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.SequenceCollectionI;
import jalview.datamodel.SequenceI;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.JalviewColourScheme;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Map;

public class RNAHelicesColour
extends ResidueColourScheme {
    public Hashtable<Integer, String> positionsToHelix = new Hashtable();
    int numHelix = 0;
    public AlignmentAnnotation annotation;
    private long lastrefresh = -1L;

    public RNAHelicesColour() {
    }

    public RNAHelicesColour(AlignmentAnnotation annotation) {
        super(ResidueProperties.nucleotideIndex);
        this.annotation = annotation;
        ColourSchemeProperty.resetRnaHelicesShading();
        this.refresh();
    }

    public RNAHelicesColour(AnnotatedCollectionI alignment) {
        super(ResidueProperties.nucleotideIndex);
        ColourSchemeProperty.resetRnaHelicesShading();
        this.alignmentChanged(alignment, null);
    }

    public RNAHelicesColour(RNAHelicesColour rnaHelicesColour) {
        super(ResidueProperties.nucleotideIndex);
        this.annotation = rnaHelicesColour.annotation;
        this.refresh();
    }

    @Override
    public void alignmentChanged(AnnotatedCollectionI alignment, Map<SequenceI, SequenceCollectionI> hiddenReps) {
        AlignmentAnnotation[] annotations = alignment.getAlignmentAnnotation();
        if (annotations == null) {
            return;
        }
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotations[i].visible || !annotations[i].isRNA() || !annotations[i].isValidStruc()) continue;
            this.annotation = annotations[i];
            break;
        }
        this.refresh();
    }

    public void refresh() {
        if (this.annotation != null && (this.annotation._rnasecstr == null || this.lastrefresh != (long)this.annotation._rnasecstr.hashCode()) && this.annotation.isValidStruc()) {
            this.annotation.getRNAStruc();
            this.lastrefresh = this.annotation._rnasecstr.hashCode();
            this.numHelix = 0;
            this.positionsToHelix = new Hashtable();
            for (int x = 0; x < this.annotation._rnasecstr.length; ++x) {
                this.positionsToHelix.put(this.annotation._rnasecstr[x].getBegin(), this.annotation._rnasecstr[x].getFeatureGroup());
                this.positionsToHelix.put(this.annotation._rnasecstr[x].getEnd(), this.annotation._rnasecstr[x].getFeatureGroup());
                if (Integer.parseInt(this.annotation._rnasecstr[x].getFeatureGroup()) <= this.numHelix) continue;
                this.numHelix = Integer.parseInt(this.annotation._rnasecstr[x].getFeatureGroup());
            }
            ColourSchemeProperty.initRnaHelicesShading(this.numHelix);
        }
    }

    @Override
    public Color findColour(char c) {
        return ResidueProperties.purinepyrimidine[ResidueProperties.purinepyrimidineIndex[c]];
    }

    @Override
    public Color findColour(char c, int j, SequenceI seq) {
        this.refresh();
        Color currentColour = Color.white;
        String currentHelix = null;
        currentHelix = this.positionsToHelix.get(j);
        if (currentHelix != null) {
            currentColour = ColourSchemeProperty.rnaHelices[Integer.parseInt(currentHelix)];
        }
        return currentColour;
    }

    @Override
    public ColourSchemeI getInstance(AlignViewportI view, AnnotatedCollectionI sg) {
        return new RNAHelicesColour(sg);
    }

    @Override
    public boolean isNucleotideSpecific() {
        return true;
    }

    @Override
    public boolean isApplicableTo(AnnotatedCollectionI ac) {
        return ac instanceof AlignmentI && ((AlignmentI)ac).hasRNAStructure();
    }

    @Override
    public String getSchemeName() {
        return JalviewColourScheme.RNAHelices.toString();
    }

    @Override
    public boolean isSimple() {
        return false;
    }
}

