/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer.seqfeatures;

import jalview.api.AlignViewportI;
import jalview.api.FeatureColourI;
import jalview.datamodel.ContiguousI;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.util.Comparison;
import jalview.util.ReverseListIterator;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.List;

public class FeatureRenderer
extends FeatureRendererModel {
    private static final AlphaComposite NO_TRANSPARENCY = AlphaComposite.getInstance(3, 1.0f);

    public FeatureRenderer(AlignViewportI viewport) {
        this.av = viewport;
    }

    boolean renderFeature(Graphics g, SequenceI seq, int featureStart, int featureEnd, Color featureColour, int start, int end, int y1, boolean colourOnly) {
        int charHeight = this.av.getCharHeight();
        int charWidth = this.av.getCharWidth();
        boolean validCharWidth = this.av.isValidCharWidth();
        if (featureStart > end || featureEnd < start) {
            return false;
        }
        if (featureStart < start) {
            featureStart = start;
        }
        if (featureEnd >= end) {
            featureEnd = end;
        }
        int pady = y1 + charHeight - charHeight / 5;
        FontMetrics fm = g.getFontMetrics();
        for (int i = featureStart; i <= featureEnd; ++i) {
            char s = seq.getCharAt(i);
            if (Comparison.isGap(s)) continue;
            g.setColor(featureColour);
            g.fillRect((i - start) * charWidth, y1, charWidth, charHeight);
            if (colourOnly || !validCharWidth) continue;
            g.setColor(Color.white);
            int charOffset = (charWidth - fm.charWidth(s)) / 2;
            g.drawString(String.valueOf(s), charOffset + charWidth * (i - start), pady);
        }
        return true;
    }

    boolean renderScoreFeature(Graphics g, SequenceI seq, int fstart, int fend, Color featureColour, int start, int end, int y1, byte[] bs, boolean colourOnly) {
        if (fstart > end || fend < start) {
            return false;
        }
        if (fstart < start) {
            fstart = start;
        }
        if (fend >= end) {
            fend = end;
        }
        int charHeight = this.av.getCharHeight();
        int pady = y1 + charHeight - charHeight / 5;
        int ystrt = 0;
        int yend = charHeight;
        if (bs[0] != 0) {
            if (bs[1] < 128) {
                yend = charHeight * (128 - bs[1]) / 512;
                ystrt = charHeight - yend / 2;
            } else {
                ystrt = charHeight / 2;
                yend = charHeight * (bs[1] - 128) / 512;
            }
        } else {
            yend = charHeight * bs[1] / 255;
            ystrt = charHeight - yend;
        }
        FontMetrics fm = g.getFontMetrics();
        int charWidth = this.av.getCharWidth();
        for (int i = fstart; i <= fend; ++i) {
            char s = seq.getCharAt(i);
            if (Comparison.isGap(s)) continue;
            g.setColor(featureColour);
            int x = (i - start) * charWidth;
            g.drawRect(x, y1, charWidth, charHeight);
            g.fillRect(x, y1 + ystrt, charWidth, yend);
            if (colourOnly || !this.av.isValidCharWidth()) continue;
            g.setColor(Color.black);
            int charOffset = (charWidth - fm.charWidth(s)) / 2;
            g.drawString(String.valueOf(s), charOffset + charWidth * (i - start), pady);
        }
        return true;
    }

    @Override
    public Color findFeatureColour(SequenceI seq, int column, Graphics g) {
        if (!this.av.isShowSequenceFeatures()) {
            return null;
        }
        if (Comparison.isGap(seq.getCharAt(column - 1))) {
            return null;
        }
        Color renderedColour = null;
        renderedColour = this.transparency == 1.0f ? this.findFeatureColour(seq, column) : this.drawSequence(g, seq, column, column, 0, true);
        return renderedColour;
    }

    public synchronized Color drawSequence(Graphics g, SequenceI seq, int start, int end, int y1, boolean colourOnly) {
        ContiguousI visiblePositions = seq.findPositions(start + 1, end + 1);
        if (visiblePositions == null || !seq.getFeatures().hasFeatures() && !this.av.isShowComplementFeatures()) {
            return null;
        }
        this.updateFeatures();
        if (this.transparency != 1.0f && g != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(AlphaComposite.getInstance(3, this.transparency));
        }
        Color drawnColour = null;
        if (this.av.isShowComplementFeatures() && !this.av.isShowComplementFeaturesOnTop()) {
            drawnColour = this.drawComplementFeatures(g, seq, start, end, y1, colourOnly, visiblePositions, drawnColour);
        }
        for (int renderIndex = 0; renderIndex < this.renderOrder.length; ++renderIndex) {
            String type = this.renderOrder[renderIndex];
            if (!this.showFeatureOfType(type)) continue;
            FeatureColourI fc = this.getFeatureStyle(type);
            List<SequenceFeature> overlaps = seq.getFeatures().findFeatures(visiblePositions.getBegin(), visiblePositions.getEnd(), type);
            if (fc.isSimpleColour()) {
                this.filterFeaturesForDisplay(overlaps);
            }
            for (SequenceFeature sf : overlaps) {
                boolean drawn;
                int visibleEnd;
                Color featureColour = this.getColor(sf, fc);
                if (featureColour == null) continue;
                int visibleStart = sf.getBegin();
                if (visibleStart < visiblePositions.getBegin()) {
                    int n = visibleStart = sf.isContactFeature() ? sf.getEnd() : visiblePositions.getBegin();
                }
                if ((visibleEnd = sf.getEnd()) > visiblePositions.getEnd()) {
                    visibleEnd = sf.isContactFeature() ? sf.getBegin() : visiblePositions.getEnd();
                }
                int featureStartCol = seq.findIndex(visibleStart);
                int featureEndCol = sf.begin == sf.end ? featureStartCol : seq.findIndex(visibleEnd);
                boolean isContactFeature = sf.isContactFeature();
                if (isContactFeature) {
                    drawn = this.renderFeature(g, seq, featureStartCol - 1, featureStartCol - 1, featureColour, start, end, y1, colourOnly);
                    if (!(drawn |= this.renderFeature(g, seq, featureEndCol - 1, featureEndCol - 1, featureColour, start, end, y1, colourOnly))) continue;
                    drawnColour = featureColour;
                    continue;
                }
                drawn = this.renderFeature(g, seq, featureStartCol - 1, featureEndCol - 1, featureColour, start, end, y1, colourOnly);
                if (!drawn) continue;
                drawnColour = featureColour;
            }
        }
        if (this.av.isShowComplementFeatures() && this.av.isShowComplementFeaturesOnTop()) {
            drawnColour = this.drawComplementFeatures(g, seq, start, end, y1, colourOnly, visiblePositions, drawnColour);
        }
        if (this.transparency != 1.0f && g != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setComposite(NO_TRANSPARENCY);
        }
        return drawnColour;
    }

    Color drawComplementFeatures(Graphics g, SequenceI seq, int start, int end, int y1, boolean colourOnly, ContiguousI visiblePositions, Color drawnColour) {
        AlignViewportI comp = this.av.getCodingComplement();
        jalview.gui.FeatureRenderer fr2 = Desktop.getAlignFrameFor(comp).getFeatureRenderer();
        int visibleStart = visiblePositions.getBegin();
        int visibleEnd = visiblePositions.getEnd();
        for (int pos = visibleStart; pos <= visibleEnd; ++pos) {
            int column = seq.findIndex(pos);
            MappedFeatures mf = fr2.findComplementFeaturesAtResidue(seq, pos);
            if (mf == null) continue;
            for (SequenceFeature sf : mf.features) {
                FeatureColourI fc = fr2.getFeatureStyle(sf.getType());
                Color featureColour = fr2.getColor(sf, fc);
                this.renderFeature(g, seq, column - 1, column - 1, featureColour, start, end, y1, colourOnly);
                drawnColour = featureColour;
            }
        }
        return drawnColour;
    }

    @Override
    public void featuresAdded() {
        this.findAllFeatures();
    }

    Color findFeatureColour(SequenceI seq, int column) {
        Color col;
        this.updateFeatures();
        if (this.av.isShowComplementFeatures() && this.av.isShowComplementFeaturesOnTop() && (col = this.findComplementFeatureColour(seq, column)) != null) {
            return col;
        }
        for (int renderIndex = this.renderOrder.length - 1; renderIndex >= 0; --renderIndex) {
            String type = this.renderOrder[renderIndex];
            if (!this.showFeatureOfType(type)) continue;
            List<SequenceFeature> overlaps = seq.findFeatures(column, column, type);
            for (SequenceFeature sequenceFeature : overlaps) {
                Color col2;
                if (this.featureGroupNotShown(sequenceFeature) || (col2 = this.getColour(sequenceFeature)) == null) continue;
                return col2;
            }
        }
        col = null;
        if (this.av.isShowComplementFeatures() && !this.av.isShowComplementFeaturesOnTop()) {
            col = this.findComplementFeatureColour(seq, column);
        }
        return col;
    }

    Color findComplementFeatureColour(SequenceI seq, int column) {
        AlignViewportI complement = this.av.getCodingComplement();
        AlignFrame af = Desktop.getAlignFrameFor(complement);
        jalview.gui.FeatureRenderer fr2 = af.getFeatureRenderer();
        MappedFeatures mf = fr2.findComplementFeaturesAtResidue(seq, seq.findPosition(column - 1));
        if (mf == null) {
            return null;
        }
        ReverseListIterator<SequenceFeature> it = new ReverseListIterator<SequenceFeature>(mf.features);
        while (it.hasNext()) {
            Color col;
            SequenceFeature sf = it.next();
            if (fr2.featureGroupNotShown(sf) || (col = fr2.getColour(sf)) == null) continue;
            return col;
        }
        return null;
    }
}

