/*
 * Decompiled with CFR 0.152.
 */
package jalview.renderer;

import jalview.api.AlignViewportI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.SequenceI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ScaleRenderer {
    public List<ScaleMark> calculateMarks(AlignViewportI av, int startx, int endx) {
        int scalestartx = startx / 10 * 10;
        SequenceI refSeq = av.getAlignment().getSeqrep();
        int refSp = 0;
        int refStartI = 0;
        int refEndI = -1;
        HiddenColumns hc = av.getAlignment().getHiddenColumns();
        if (refSeq != null) {
            Iterator<int[]> it = hc.iterator();
            int index = refSeq.firstResidueOutsideIterator(it);
            refSp = hc.absoluteToVisibleColumn(index);
            refStartI = refSeq.findIndex(refSeq.getStart()) - 1;
            int seqlength = refSeq.getLength();
            int pastEndPos = refSeq.findPosition(seqlength + 1);
            refEndI = refSeq.findIndex(pastEndPos - 1) - 1;
            scalestartx = refSp + (scalestartx - refSp) / 10 * 10;
        }
        if (refSeq == null && scalestartx % 10 == 0) {
            scalestartx += 5;
        }
        ArrayList<ScaleMark> marks = new ArrayList<ScaleMark>();
        for (int i = scalestartx; i <= endx; i += 5) {
            if ((i - refSp) % 10 == 0) {
                String string;
                int iadj;
                if (refSeq == null) {
                    iadj = hc.visibleToAbsoluteColumn(i - 1) + 1;
                    string = String.valueOf(iadj);
                } else {
                    iadj = hc.visibleToAbsoluteColumn(i - 1);
                    int refN = refSeq.findPosition(iadj);
                    string = iadj < refStartI ? String.valueOf(iadj - refStartI) : (iadj > refEndI ? "+" + String.valueOf(iadj - refEndI) : String.valueOf(refN) + refSeq.getCharAt(iadj));
                }
                marks.add(new ScaleMark(true, i - startx - 1, string));
                continue;
            }
            marks.add(new ScaleMark(false, i - startx - 1, null));
        }
        return marks;
    }

    public final class ScaleMark {
        public final boolean major;
        public final int column;
        public final String text;

        ScaleMark(boolean isMajor, int col, String txt) {
            this.major = isMajor;
            this.column = col;
            this.text = txt;
        }
    }
}

