/*
 * Decompiled with CFR 0.152.
 */
package jalview.json.binding.biojs;

import jalview.json.binding.biojs.BioJSReleasePojo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class BioJSRepositoryPojo {
    private String description;
    private String latestReleaseVersion;
    private Collection<BioJSReleasePojo> releases = new ArrayList<BioJSReleasePojo>();

    public BioJSRepositoryPojo() {
    }

    public BioJSRepositoryPojo(String jsonString) {
        try {
            this.parse(jsonString);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void parse(String jsonString) throws ParseException {
        Objects.requireNonNull(jsonString, "Supplied jsonString must not be null");
        JSONParser jsonParser = new JSONParser();
        JSONObject JsonObj = (JSONObject)jsonParser.parse(jsonString);
        this.description = (String)JsonObj.get((Object)"description");
        this.latestReleaseVersion = (String)JsonObj.get((Object)"latestReleaseVersion");
        JSONArray repositoriesJsonArray = (JSONArray)JsonObj.get((Object)"releases");
        for (JSONObject repoObj : repositoriesJsonArray) {
            BioJSReleasePojo repo = new BioJSReleasePojo();
            repo.setType((String)repoObj.get((Object)"type"));
            repo.setUrl((String)repoObj.get((Object)"url"));
            repo.setVersion((String)repoObj.get((Object)"version"));
            this.getReleases().add(repo);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLatestReleaseVersion() {
        return this.latestReleaseVersion;
    }

    public void setLatestReleaseVersion(String latestReleaseVersion) {
        this.latestReleaseVersion = latestReleaseVersion;
    }

    public Collection<BioJSReleasePojo> getReleases() {
        return this.releases;
    }

    public void setReleases(Collection<BioJSReleasePojo> releases) {
        this.releases = releases;
    }
}

