/*
 * Decompiled with CFR 0.152.
 */
package jalview.jbgui;

import jalview.io.FileFormatI;
import jalview.util.MessageManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public abstract class GAlignExportSettings
extends JPanel {
    protected JPanel hiddenRegionConfPanel = new JPanel();
    protected JPanel complexExportPanel = new JPanel();
    protected JPanel optionsPanel = new JPanel();
    protected JPanel actionPanel = new JPanel();
    protected BorderLayout hiddenRegionLayout = new BorderLayout();
    protected BorderLayout complexExportLayout = new BorderLayout();
    protected BorderLayout mainLayout = new BorderLayout();
    protected JCheckBox chkAll = new JCheckBox();
    protected JCheckBox chkHiddenSeqs = new JCheckBox();
    protected JCheckBox chkHiddenCols = new JCheckBox();
    protected JCheckBox chkExportAnnots = new JCheckBox();
    protected JCheckBox chkExportFeats = new JCheckBox();
    protected JCheckBox chkExportGrps = new JCheckBox();
    JButton btnOk = new JButton();
    JButton btnCancel = new JButton();
    private boolean hasHiddenSeq;
    private boolean hasHiddenCols;
    private boolean isComplexAlignFile;
    private boolean showDialog;

    public GAlignExportSettings(boolean hasHiddenSeq, boolean hasHiddenCols, FileFormatI format) {
        this.hasHiddenSeq = hasHiddenSeq;
        this.hasHiddenCols = hasHiddenCols;
        this.isComplexAlignFile = format.isComplexAlignFile();
        if (this.hasHiddenCols || this.hasHiddenSeq || this.isComplexAlignFile) {
            this.showDialog = true;
        }
        this.init();
    }

    public void init() {
        this.chkHiddenSeqs.setText(MessageManager.getString("action.export_hidden_sequences"));
        this.chkHiddenCols.setText(MessageManager.getString("action.export_hidden_columns"));
        this.chkExportAnnots.setText(MessageManager.getString("action.export_annotations"));
        this.chkExportFeats.setText(MessageManager.getString("action.export_features"));
        this.chkExportGrps.setText(MessageManager.getString("action.export_groups"));
        this.btnOk.setText(MessageManager.getString("action.ok"));
        this.btnCancel.setText(MessageManager.getString("action.cancel"));
        this.chkAll.setText(MessageManager.getString("action.select_all"));
        this.hiddenRegionConfPanel.setLayout(this.hiddenRegionLayout);
        this.complexExportPanel.setLayout(this.complexExportLayout);
        this.setLayout(this.mainLayout);
        this.chkAll.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GAlignExportSettings.this.checkAllAction();
            }
        });
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignExportSettings.this.ok_actionPerformed(e);
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GAlignExportSettings.this.cancel_actionPerformed(e);
            }
        });
        this.hiddenRegionConfPanel.add((Component)this.chkHiddenSeqs, "Center");
        this.hiddenRegionConfPanel.add((Component)this.chkHiddenCols, "South");
        this.chkHiddenSeqs.setEnabled(this.hasHiddenSeq);
        this.chkHiddenCols.setEnabled(this.hasHiddenCols);
        this.complexExportPanel.add((Component)this.chkExportAnnots, "North");
        this.complexExportPanel.add((Component)this.chkExportFeats, "Center");
        this.complexExportPanel.add((Component)this.chkExportGrps, "South");
        this.actionPanel.add(this.chkAll);
        if (this.isComplexAlignFile) {
            this.optionsPanel.add(this.complexExportPanel);
        }
        if (this.hasHiddenSeq || this.hasHiddenCols) {
            this.optionsPanel.add(this.hiddenRegionConfPanel);
        }
        this.actionPanel.add(this.btnCancel);
        this.actionPanel.add(this.btnOk);
        this.add((Component)this.optionsPanel, "North");
        this.add((Component)this.actionPanel, "South");
    }

    private void checkAllAction() {
        boolean isSelected = this.chkAll.isSelected();
        this.chkHiddenSeqs.setSelected(this.chkHiddenSeqs.isEnabled() && isSelected);
        this.chkHiddenCols.setSelected(this.chkHiddenCols.isEnabled() && isSelected);
        this.chkExportAnnots.setSelected(this.isComplexAlignFile && this.chkExportAnnots.isEnabled() && isSelected);
        this.chkExportFeats.setSelected(this.isComplexAlignFile && this.chkExportFeats.isEnabled() && isSelected);
        this.chkExportGrps.setSelected(this.isComplexAlignFile && this.chkExportGrps.isEnabled() && isSelected);
    }

    public boolean isShowDialog() {
        return this.showDialog;
    }

    public void setShowDialog(boolean showDialog) {
        this.showDialog = showDialog;
    }

    public abstract void ok_actionPerformed(ActionEvent var1);

    public abstract void cancel_actionPerformed(ActionEvent var1);
}

