/*
 * Decompiled with CFR 0.152.
 */
package jalview.javascript;

import jalview.api.AlignmentViewPanel;
import jalview.appletgui.AlignFrame;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.FeatureRenderer;
import jalview.appletgui.SequenceRenderer;
import jalview.bin.JalviewLite;
import jalview.datamodel.SequenceI;
import jalview.ext.jmol.JmolCommands;
import jalview.javascript.JSFunctionExec;
import jalview.javascript.JsCallBack;
import jalview.structure.AtomSpec;
import jalview.structure.StructureListener;
import jalview.structure.StructureMapping;
import jalview.structure.StructureMappingcommandSet;
import jalview.structure.StructureSelectionManager;
import jalview.util.HttpUtils;
import java.util.ArrayList;
import java.util.List;

public class MouseOverStructureListener
extends JSFunctionExec
implements JsCallBack,
StructureListener {
    String _listenerfn;
    String[] modelSet;

    public MouseOverStructureListener(JalviewLite jalviewLite, String listener, String[] modelList) {
        super(jalviewLite);
        this._listenerfn = listener;
        this.modelSet = modelList;
        if (this.modelSet != null) {
            for (int i = 0; i < this.modelSet.length; ++i) {
                this.modelSet[i] = this.resolveModelFile(this.modelSet[i]);
            }
        }
    }

    public String resolveModelFile(String file) {
        if (HttpUtils.isValidUrl(file)) {
            return file;
        }
        String db = this.jvlite.getDocumentBase().toString();
        String docBaseFile = (db = db.substring(0, db.lastIndexOf("/"))) + "/" + file;
        if (HttpUtils.isValidUrl(docBaseFile)) {
            return docBaseFile;
        }
        String cb = this.jvlite.getCodeBase() + file;
        if (HttpUtils.isValidUrl(cb)) {
            return cb;
        }
        return file;
    }

    @Override
    public String[] getStructureFiles() {
        return this.modelSet;
    }

    public void mouseOverStructure(int atomIndex, String strInfo) {
    }

    @Override
    public void highlightAtoms(List<AtomSpec> atoms) {
        for (AtomSpec atom : atoms) {
            try {
                this.executeJavascriptFunction(this._listenerfn, new String[]{"mouseover", "" + atom.getPdbFile(), "" + atom.getChain(), "" + atom.getPdbResNum(), "" + atom.getAtomIndex()});
            }
            catch (Exception ex) {
                System.err.println("Couldn't execute callback with " + this._listenerfn + " for atomSpec: " + atom);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void updateColours(Object srce) {
        Object source = srce;
        StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(this.jvlite);
        if (JalviewLite.debug) {
            System.err.println(this.getClass().getName() + " modelSet[0]: " + this.modelSet[0]);
            ssm.reportMapping();
        }
        if (source instanceof AlignmentViewPanel) {
            FeatureRenderer fr;
            SequenceI[][] sequence = new SequenceI[this.modelSet.length][];
            for (int m = 0; m < this.modelSet.length; ++m) {
                StructureMapping[] sm = ssm.getMapping(this.modelSet[m]);
                if (sm != null && sm.length > 0) {
                    sequence[m] = new SequenceI[sm.length];
                    for (int i = 0; i < sm.length; ++i) {
                        sequence[m][i] = sm[i].getSequence();
                    }
                    continue;
                }
                sequence[m] = new SequenceI[0];
            }
            SequenceRenderer sr = ((AlignmentPanel)source).getSequenceRenderer();
            FeatureRenderer featureRenderer = fr = ((AlignmentPanel)source).av.isShowSequenceFeatures() ? new FeatureRenderer(((AlignmentPanel)source).av) : null;
            if (fr != null) {
                fr.transferSettings(((AlignmentPanel)source).getFeatureRenderer());
            }
            ArrayList<String[]> ccomands = new ArrayList<String[]>();
            ArrayList<String> pdbfn = new ArrayList<String>();
            StructureMappingcommandSet[] colcommands = JmolCommands.getColourBySequenceCommand(ssm, this.modelSet, sequence, sr, (AlignmentViewPanel)source);
            if (colcommands == null) {
                return;
            }
            int sz = 0;
            for (StructureMappingcommandSet ccset : colcommands) {
                sz += ccset.commands.length;
                ccomands.add(ccset.commands);
                pdbfn.add(ccset.mapping);
            }
            String[] ccomandset = new String[sz];
            sz = 0;
            for (String[] ccset : ccomands) {
                System.arraycopy(ccset, 0, ccomandset, sz, ccset.length);
                sz += ccset.length;
            }
            String mclass = "colourstruct";
            String mhandle = ((AlignmentPanel)source).av.getViewId();
            if (this.jvlite.isJsMessageSetChanged("colourstruct", mhandle, ccomandset)) {
                this.jvlite.setJsMessageSet(mclass, mhandle, ccomandset);
                Object[] st = new String[]{"colourstruct", "" + ((AlignmentPanel)source).av.getViewId(), "" + ccomandset.length, this.jvlite.arrayToSeparatorList(pdbfn.toArray(new String[pdbfn.size()]))};
                try {
                    this.executeJavascriptFunction(true, this._listenerfn, st);
                }
                catch (Exception ex) {
                    System.err.println("Couldn't execute callback with " + this._listenerfn + " using args { " + (String)st[0] + ", " + (String)st[1] + ", " + (String)st[2] + "," + (String)st[3] + "}");
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public AlignFrame getAlignFrame() {
        return null;
    }

    @Override
    public String getListenerFunction() {
        return this._listenerfn;
    }

    @Override
    public void releaseReferences(Object svl) {
    }

    @Override
    public boolean isListeningFor(SequenceI seq) {
        return true;
    }
}

