/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.bin.Cache;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.DatastoreRegistry;
import jalview.util.MessageManager;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Vector;
import org.apache.log4j.Logger;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Provenance;
import uk.ac.vamsas.objects.core.Seg;

public abstract class DatastoreItem {
    Entry provEntry = null;
    IClientDocument cdoc;
    Hashtable vobj2jv;
    IdentityHashMap jv2vobj;
    boolean tojalview = false;
    protected static Logger log = Logger.getLogger(DatastoreItem.class);
    boolean addtodoc = false;
    boolean conflicted = false;
    boolean updated = false;
    boolean addfromdoc = false;
    boolean success = false;
    private boolean updatedtodoc;
    private boolean updatedfromdoc;
    VamsasAppDatastore datastore = null;
    protected Vobject vobj = null;
    protected Object jvobj = null;
    protected DatastoreRegistry dsReg;

    protected Vobject getjv2vObj(Object jvobj) {
        if (this.jv2vobj.containsKey(jvobj)) {
            return this.cdoc.getObject((VorbaId)this.jv2vobj.get(jvobj));
        }
        if (Cache.log.isDebugEnabled()) {
            Cache.log.debug((Object)("Returning null VorbaID binding for jalview object " + jvobj));
        }
        return null;
    }

    protected Object getvObj2jv(Vobject vobj) {
        if (this.vobj2jv == null) {
            return null;
        }
        VorbaId id = vobj.getVorbaId();
        if (id == null) {
            id = this.cdoc.registerObject(vobj);
            Cache.log.debug((Object)"Registering new object and returning null for getvObj2jv");
            return null;
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId())) {
            return this.vobj2jv.get(vobj.getVorbaId());
        }
        return null;
    }

    protected void bindjvvobj(Object jvobj, Vobject vobj) {
        VorbaId id = vobj.getVorbaId();
        if (id == null && ((id = this.cdoc.registerObject(vobj)) == null || vobj.getVorbaId() == null || this.cdoc.getObject(id) != vobj)) {
            Cache.log.error((Object)("Failed to get id for " + (vobj.isRegisterable() ? "registerable" : "unregisterable") + " object " + vobj));
        }
        if (this.vobj2jv.containsKey(vobj.getVorbaId()) && !this.vobj2jv.get(vobj.getVorbaId()).equals(jvobj)) {
            Cache.log.debug((Object)("Warning? Overwriting existing vamsas id binding for " + vobj.getVorbaId()), (Throwable)new Exception(MessageManager.getString("exception.overwriting_vamsas_id_binding")));
        } else if (this.jv2vobj.containsKey(jvobj) && !((VorbaId)this.jv2vobj.get(jvobj)).equals((Object)vobj.getVorbaId())) {
            Cache.log.debug((Object)("Warning? Overwriting existing jalview object binding for " + jvobj), (Throwable)new Exception(MessageManager.getString("exception.overwriting_jalview_id_binding")));
        }
        Cache.log.debug((Object)("Binding " + vobj.getVorbaId() + " to " + jvobj));
        this.vobj2jv.put(vobj.getVorbaId(), jvobj);
        this.jv2vobj.put(jvobj, vobj.getVorbaId());
        if (jvobj == this.jvobj || vobj == this.vobj) {
            this.updateRegistryEntry(jvobj, vobj);
        }
    }

    private void updateRegistryEntry(Object jvobj, Vobject vobj) {
        if (this.jvobj != null && this.vobj != null) {
            Cache.log.debug((Object)("updating dsobj registry. (" + this.getClass().getName() + ")"));
        }
        this.jvobj = jvobj;
        this.vobj = vobj;
        this.dsReg.registerDsObj(this);
    }

    protected void replaceJvObjMapping(Object oldjvobject, Object newjvobject) {
        Object vobject = this.jv2vobj.remove(oldjvobject);
        if (vobject == null) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_old_jalview_object_not_bound", new String[]{oldjvobject.toString()}));
        }
        if (newjvobject != null) {
            this.jv2vobj.put(newjvobject, vobject);
            this.vobj2jv.put(vobject, newjvobject);
            this.updateRegistryEntry(newjvobject, this.vobj);
        }
    }

    public DatastoreItem() {
    }

    public DatastoreItem(VamsasAppDatastore datastore) {
        this();
        this.initDatastoreItem(datastore);
    }

    public DatastoreItem(VamsasAppDatastore datastore2, Vobject vobj2, Class boundType) {
        this(datastore2);
        this.vobj = vobj2;
        this.jvobj = this.getvObj2jv(vobj2);
        this.tojalview = true;
        if (this.jvobj != null && !boundType.isAssignableFrom(this.jvobj.getClass())) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_vamsas_doc_class_should_bind_to_type", new String[]{this.vobj.getClass().toString(), boundType.toString(), this.jvobj.getClass().toString()}));
        }
        this.dsReg.registerDsObj(this);
    }

    public DatastoreItem(VamsasAppDatastore datastore2, Object jvobj2, Class boundToType) {
        this(datastore2);
        this.jvobj = jvobj2;
        this.tojalview = false;
        this.vobj = this.getjv2vObj(this.jvobj);
        if (this.vobj != null && !boundToType.isAssignableFrom(this.vobj.getClass())) {
            throw new Error(MessageManager.formatMessage("error.implementation_error_vamsas_doc_class_should_bind_to_type", new String[]{jvobj2.getClass().toString(), boundToType.toString(), this.vobj.getClass().toString()}));
        }
        this.dsReg.registerDsObj(this);
    }

    public abstract void addToDocument();

    public abstract void conflict();

    public abstract void updateToDoc();

    public abstract void updateFromDoc();

    public abstract void addFromDocument();

    protected void doSync() {
        this.dsReg.registerDsObj(this);
        if (this.vobj == null) {
            log.debug((Object)"adding new vobject to document.");
            this.addtodoc = true;
            this.addToDocument();
        } else if (this.vobj.isUpdated()) {
            log.debug((Object)"Handling update conflict for existing bound vobject.");
            this.conflicted = true;
            this.conflict();
        } else {
            log.debug((Object)"updating existing vobject in document.");
            this.updatedtodoc = true;
            this.updateToDoc();
        }
        this.success = true;
    }

    protected void doJvUpdate() {
        this.dsReg.registerDsObj(this);
        if (this.jvobj == null) {
            log.debug((Object)"adding new vobject to Jalview from Document");
            this.addfromdoc = true;
            this.addFromDocument();
        } else if (this.vobj.isUpdated()) {
            log.debug((Object)"updating Jalview from existing bound vObject");
            this.updatedfromdoc = true;
            this.updateFromDoc();
        }
    }

    public void initDatastoreItem(VamsasAppDatastore ds) {
        this.datastore = ds;
        this.dsReg = ds.getDatastoreRegisty();
        this.initDatastoreItem(ds.getProvEntry(), ds.getClientDocument(), ds.getVamsasObjectBinding(), ds.getJvObjectBinding());
    }

    private void initDatastoreItem(Entry provEntry, IClientDocument cdoc, Hashtable vobj2jv, IdentityHashMap jv2vobj) {
        this.provEntry = provEntry;
        this.cdoc = cdoc;
        this.vobj2jv = vobj2jv;
        this.jv2vobj = jv2vobj;
    }

    protected boolean isModifiable(String modifiable) {
        return modifiable == null;
    }

    protected Vector getjv2vObjs(Vector alsq) {
        Vector<Vobject> vObjs = new Vector<Vobject>();
        Enumeration elm = alsq.elements();
        while (elm.hasMoreElements()) {
            vObjs.addElement(this.getjv2vObj(elm.nextElement()));
        }
        return vObjs;
    }

    public int[] getSegRange(Seg visSeg, boolean ensureDirection) {
        boolean incl = visSeg.getInclusive();
        int pol = visSeg.getStart() <= visSeg.getEnd() ? 1 : -1;
        int start = visSeg.getStart() + (incl ? 0 : pol);
        int end = visSeg.getEnd() + (incl ? 0 : -pol);
        if (ensureDirection && pol == -1) {
            int t = end;
            end = start;
            start = t;
        }
        return new int[]{start, end, pol < 0 ? 1 : 0};
    }

    protected jalview.datamodel.Provenance getJalviewProvenance(Provenance prov) {
        jalview.datamodel.Provenance jprov = new jalview.datamodel.Provenance();
        for (int i = 0; i < prov.getEntryCount(); ++i) {
            jprov.addEntry(prov.getEntry(i).getUser(), prov.getEntry(i).getAction(), prov.getEntry(i).getDate(), prov.getEntry(i).getId());
        }
        return jprov;
    }

    Provenance dummyProvenance() {
        return this.dummyProvenance(null);
    }

    protected Entry dummyPEntry(String action) {
        Entry entry = new Entry();
        entry.setApp(this.provEntry.getApp());
        if (action != null) {
            entry.setAction(action);
        } else {
            entry.setAction("created.");
        }
        entry.setDate(new Date());
        entry.setUser(this.provEntry.getUser());
        return entry;
    }

    protected Provenance dummyProvenance(String action) {
        Provenance prov = new Provenance();
        prov.addEntry(this.dummyPEntry(action));
        return prov;
    }

    protected void addProvenance(Provenance p, String action) {
        p.addEntry(this.dummyPEntry(action));
    }

    public boolean isTojalview() {
        return this.tojalview;
    }

    public boolean isAddtodoc() {
        return this.addtodoc;
    }

    public boolean isConflicted() {
        return this.conflicted;
    }

    public boolean isUpdatedFromDoc() {
        return this.updatedfromdoc;
    }

    public boolean isUpdatedToDoc() {
        return this.updatedtodoc;
    }

    public boolean isAddfromdoc() {
        return this.addfromdoc;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Vobject getVobj() {
        return this.vobj;
    }

    public Object getJvobj() {
        return this.jvobj;
    }

    public boolean docWasUpdated() {
        return (this.addtodoc || this.updated) && this.success;
    }

    public boolean jvWasUpdated() {
        return this.success;
    }
}

