/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.vamsas;

import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.io.VamsasAppDatastore;
import jalview.io.vamsas.DatastoreItem;
import jalview.io.vamsas.Dbref;
import jalview.io.vamsas.Sequencefeature;
import java.util.List;
import uk.ac.vamsas.client.Vobject;
import uk.ac.vamsas.objects.core.DataSet;
import uk.ac.vamsas.objects.core.DbRef;
import uk.ac.vamsas.objects.core.Sequence;

public class Datasetsequence
extends DatastoreItem {
    String dict;
    private DataSet dataset;
    boolean modified = false;

    public Datasetsequence(VamsasAppDatastore vamsasAppDatastore, SequenceI sq, String theDict, DataSet theDataset) {
        super(vamsasAppDatastore, sq, Sequence.class);
        this.dataset = theDataset;
        this.dict = theDict;
        this.doSync();
    }

    public Datasetsequence(VamsasAppDatastore vamsasAppDatastore, Sequence vdseq) {
        super(vamsasAppDatastore, (Vobject)vdseq, SequenceI.class);
        this.doJvUpdate();
    }

    @Override
    public void addFromDocument() {
        Sequence vseq = (Sequence)this.vobj;
        jalview.datamodel.Sequence dsseq = new jalview.datamodel.Sequence(vseq.getName(), vseq.getSequence(), (int)vseq.getStart(), (int)vseq.getEnd());
        dsseq.setDescription(vseq.getDescription());
        this.bindjvvobj(dsseq, (Vobject)vseq);
        dsseq.setVamsasId(vseq.getVorbaId().getId());
        this.jvobj = dsseq;
        this.modified = true;
    }

    @Override
    public void updateFromDoc() {
        Sequence sq = (Sequence)this.vobj;
        SequenceI sequence = (SequenceI)this.jvobj;
        if (!sequence.getSequenceAsString().equals(sq.getSequence())) {
            log.warn((Object)"Potential Client Error ! - mismatch of dataset sequence: and jalview internal dataset sequence.");
        } else {
            if (!(sequence.getDescription() == null || sequence.getDescription() != null && sequence.getDescription().equals(sq.getDescription()))) {
                sequence.setDescription(sq.getDescription());
                this.modified = true;
            }
            if (!(sequence.getSequence() != null && sequence.getSequenceAsString().equals(sq.getSequence()) || (long)sequence.getStart() == sq.getStart() && (long)sequence.getEnd() == sq.getEnd())) {
                sequence.setSequence(sq.getSequence());
                sequence.setStart((int)sq.getStart());
                sequence.setEnd((int)sq.getEnd());
                this.modified = true;
            }
            if (!sequence.getName().equals(sq.getName())) {
                sequence.setName(sq.getName());
                this.modified = true;
            }
            this.modified |= this.updateJvDbRefs();
        }
    }

    private boolean updateSqFeatures() {
        boolean changed = false;
        SequenceI sq = (SequenceI)this.jvobj;
        List<SequenceFeature> sfs = sq.getSequenceFeatures();
        for (SequenceFeature sf : sfs) {
            changed |= new Sequencefeature(this.datastore, sf, this.dataset, (Sequence)this.vobj).docWasUpdated();
        }
        return changed;
    }

    @Override
    public void addToDocument() {
        SequenceI sq = (SequenceI)this.jvobj;
        Sequence sequence = new Sequence();
        this.bindjvvobj(sq, (Vobject)sequence);
        sq.setVamsasId(sequence.getVorbaId().getId());
        sequence.setSequence(sq.getSequenceAsString());
        sequence.setDictionary(this.dict);
        sequence.setName(sq.getName());
        sequence.setStart((long)sq.getStart());
        sequence.setEnd((long)sq.getEnd());
        sequence.setDescription(sq.getDescription());
        this.dataset.addSequence(sequence);
        this.vobj = sequence;
        this.updateSqFeatures();
        this.updateDbRefs();
    }

    private boolean updateDbRefs() {
        boolean modifiedthedoc = false;
        SequenceI sq = (SequenceI)this.jvobj;
        if (sq.getDatasetSequence() == null && sq.getDBRefs() != null) {
            DBRefEntry[] entries = sq.getDBRefs();
            for (int db = 0; db < entries.length; ++db) {
                modifiedthedoc |= new Dbref(this.datastore, entries[db], sq, (Sequence)this.vobj, this.dataset).docWasUpdated();
            }
        }
        return modifiedthedoc;
    }

    private boolean updateJvDbRefs() {
        boolean modifiedtheseq = false;
        SequenceI sq = (SequenceI)this.jvobj;
        Sequence vsq = (Sequence)this.vobj;
        if (vsq.getDbRefCount() > 0) {
            DbRef[] entries = vsq.getDbRef();
            for (int db = 0; db < entries.length; ++db) {
                modifiedtheseq |= new Dbref(this.datastore, entries[db], vsq, sq).jvWasUpdated();
            }
        }
        return modifiedtheseq;
    }

    @Override
    public void conflict() {
        log.warn((Object)"Conflict in dataset sequence update to document. Overwriting document");
        this.updateToDoc();
    }

    @Override
    public void updateToDoc() {
        SequenceI sq = (SequenceI)this.jvobj;
        Sequence sequence = (Sequence)this.vobj;
        if (!(sequence.getDescription() == null || sequence.getDescription() != null && sequence.getDescription().equals(sq.getDescription()))) {
            sequence.setDescription(sq.getDescription());
            this.modified = true;
        }
        if (!(sequence.getSequence() != null && sequence.getSequence().equals(sq.getSequenceAsString()) || sequence.getStart() == (long)sq.getStart() && sequence.getEnd() == (long)sq.getEnd())) {
            sequence.setSequence(sq.getSequenceAsString());
            sequence.setStart((long)sq.getStart());
            sequence.setEnd((long)sq.getEnd());
            this.modified = true;
        }
        if (!this.dict.equals(sequence.getDictionary())) {
            sequence.setDictionary(this.dict);
            this.modified = true;
        }
        if (!sequence.getName().equals(sq.getName())) {
            sequence.setName(sq.getName());
            this.modified = true;
        }
        this.modified |= this.updateDbRefs();
        this.modified |= this.updateSqFeatures();
    }

    public boolean getModified() {
        return this.modified;
    }
}

