/*
 * Decompiled with CFR 0.152.
 */
package jalview.io.cache;

import jalview.bin.Cache;
import jalview.io.cache.AppCache;
import jalview.util.MessageManager;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class JvCacheableInputBox<E>
extends JComboBox<String> {
    private static final long serialVersionUID = 5774610435079326695L;
    private static final int LEFT_BOARDER_WIDTH = 16;
    private String cacheKey;
    private AppCache appCache;
    private JPopupMenu popup = new JPopupMenu();
    private JMenuItem menuItemClearCache = new JMenuItem();
    volatile boolean enterWasPressed = false;

    public boolean wasEnterPressed() {
        return this.enterWasPressed;
    }

    public JvCacheableInputBox(String newCacheKey) {
        this.cacheKey = newCacheKey;
        this.setEditable(true);
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                JvCacheableInputBox.this.enterWasPressed = false;
                if (e.getKeyCode() == 10) {
                    JvCacheableInputBox.this.enterWasPressed = true;
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        this.appCache = AppCache.getInstance();
        this.initCachePopupMenu();
        this.initCache(newCacheKey);
        this.updateCache();
    }

    private void initCache(String cacheKey) {
        String delimitedCacheStr = Cache.getProperty(cacheKey);
        if (delimitedCacheStr == null || delimitedCacheStr.isEmpty()) {
            return;
        }
        List<String> persistedCacheItems = Arrays.asList(delimitedCacheStr.split(";"));
        LinkedHashSet<String> foundCacheItems = this.appCache.getAllCachedItemsFor(cacheKey);
        if (foundCacheItems == null) {
            foundCacheItems = new LinkedHashSet();
        }
        for (String cacheItem : persistedCacheItems) {
            foundCacheItems.add(cacheItem);
        }
        this.appCache.putCache(cacheKey, foundCacheItems);
    }

    private void initCachePopupMenu() {
        this.menuItemClearCache.setFont(new Font("Verdana", 0, 12));
        this.menuItemClearCache.setText(MessageManager.getString("action.clear_cached_items"));
        this.menuItemClearCache.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JvCacheableInputBox.this.setSelectedItem("");
                JvCacheableInputBox.this.appCache.deleteCacheItems(JvCacheableInputBox.this.cacheKey);
                JvCacheableInputBox.this.updateCache();
            }
        });
        this.popup.add(this.menuItemClearCache);
        this.setComponentPopupMenu(this.popup);
        this.add(this.popup);
    }

    static boolean isInteger(String text) {
        try {
            Integer.parseInt(text);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void updateCache() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int cacheLimit = Integer.parseInt(JvCacheableInputBox.this.appCache.getCacheLimit(JvCacheableInputBox.this.cacheKey));
                String userInput = JvCacheableInputBox.this.getUserInput();
                if (userInput != null && !userInput.isEmpty()) {
                    LinkedHashSet<String> foundCache = JvCacheableInputBox.this.appCache.getAllCachedItemsFor(JvCacheableInputBox.this.cacheKey);
                    foundCache.remove(userInput);
                    foundCache.add(userInput);
                    JvCacheableInputBox.this.appCache.putCache(JvCacheableInputBox.this.cacheKey, foundCache);
                }
                String lastSearch = userInput;
                if (JvCacheableInputBox.this.getItemCount() > 0) {
                    JvCacheableInputBox.this.removeAllItems();
                }
                LinkedHashSet<String> cacheItems = JvCacheableInputBox.this.appCache.getAllCachedItemsFor(JvCacheableInputBox.this.cacheKey);
                ArrayList<String> reversedCacheItems = new ArrayList<String>();
                reversedCacheItems.addAll(cacheItems);
                cacheItems = null;
                Collections.reverse(reversedCacheItems);
                if (lastSearch.isEmpty()) {
                    JvCacheableInputBox.this.addItem("");
                }
                if (reversedCacheItems != null && !reversedCacheItems.isEmpty()) {
                    LinkedHashSet<String> foundCache = JvCacheableInputBox.this.appCache.getAllCachedItemsFor(JvCacheableInputBox.this.cacheKey);
                    boolean prune = reversedCacheItems.size() > cacheLimit;
                    int count = 1;
                    boolean limitExceeded = false;
                    for (String cacheItem : reversedCacheItems) {
                        boolean bl = limitExceeded = count++ > cacheLimit;
                        if (prune) {
                            if (limitExceeded) {
                                foundCache.remove(cacheItem);
                                continue;
                            }
                            JvCacheableInputBox.this.addItem(cacheItem);
                            continue;
                        }
                        JvCacheableInputBox.this.addItem(cacheItem);
                    }
                    JvCacheableInputBox.this.appCache.putCache(JvCacheableInputBox.this.cacheKey, foundCache);
                }
                JvCacheableInputBox.this.setSelectedItem(lastSearch.isEmpty() ? "" : lastSearch);
            }
        });
    }

    public void persistCache() {
        this.appCache.persistCache(this.cacheKey);
    }

    public String getUserInput() {
        return this.getEditor().getItem() == null ? "" : this.getEditor().getItem().toString().trim();
    }
}

