/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import MCview.PDBChain;
import jalview.analysis.AlignSeq;
import jalview.api.FeatureSettingsModelI;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.PDBFeatureSettings;
import jalview.schemes.ColourSchemeI;
import jalview.structure.StructureImportSettings;
import java.awt.Color;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Vector;

public abstract class StructureFile
extends AlignFile {
    private String id;
    private PDBEntry.Type dbRefType;
    protected boolean visibleChainAnnotation = false;
    protected boolean predictSecondaryStructure = false;
    protected boolean externalSecondaryStructure = false;
    private Vector<PDBChain> chains;
    private boolean pdbIdAvailable;
    String structureFileType = PDBEntry.Type.PDB.toString();

    public StructureFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    public StructureFile(FileParse fp) throws IOException {
        super(fp);
    }

    public void addSettings(boolean addAlignmentAnnotations, boolean predictSecondaryStructure, boolean externalSecStr) {
        this.visibleChainAnnotation = addAlignmentAnnotations;
        this.predictSecondaryStructure = predictSecondaryStructure;
        this.externalSecondaryStructure = externalSecStr;
    }

    public void xferSettings() {
        this.visibleChainAnnotation = StructureImportSettings.isVisibleChainAnnotation();
        this.predictSecondaryStructure = StructureImportSettings.isProcessSecondaryStructure();
        this.externalSecondaryStructure = StructureImportSettings.isExternalSecondaryStructure();
    }

    public StructureFile(boolean parseImmediately, String dataObject, DataSourceType sourceType) throws IOException {
        super(parseImmediately, dataObject, sourceType);
    }

    public StructureFile(boolean a, FileParse fp) throws IOException {
        super(a, fp);
    }

    public StructureFile() {
    }

    protected SequenceI postProcessChain(PDBChain chain) {
        SequenceI pdbSequence = chain.sequence;
        pdbSequence.setName(this.getId() + "|" + pdbSequence.getName());
        PDBEntry entry = new PDBEntry();
        entry.setId(this.getId());
        entry.setType(this.getStructureFileType());
        if (chain.id != null) {
            entry.setChainCode(chain.id);
        }
        if (this.inFile != null) {
            entry.setFile(this.inFile.getAbsolutePath());
        } else {
            entry.setFile(this.getDataName());
        }
        DBRefEntry sourceDBRef = new DBRefEntry();
        sourceDBRef.setAccessionId(this.getId());
        sourceDBRef.setSource("PDB");
        sourceDBRef.setVersion("");
        pdbSequence.addPDBId(entry);
        pdbSequence.addDBRef(sourceDBRef);
        SequenceI chainseq = pdbSequence;
        this.seqs.addElement(chainseq);
        AlignmentAnnotation[] chainannot = chainseq.getAnnotation();
        if (chainannot != null && this.visibleChainAnnotation) {
            for (int ai = 0; ai < chainannot.length; ++ai) {
                chainannot[ai].visible = this.visibleChainAnnotation;
                this.annotations.addElement(chainannot[ai]);
            }
        }
        return chainseq;
    }

    protected void setStructureFileType(String structureFileType) {
        this.structureFileType = structureFileType;
    }

    public String getStructureFileType() {
        return this.structureFileType;
    }

    protected void processPdbFileWithAnnotate3d(List<SequenceI> rna) throws Exception {
        try {
            Class<?> cl = Class.forName("jalview.ws.jws1.Annotate3D");
            if (cl != null) {
                Object annotate3d = cl.getConstructor(new Class[0]).newInstance(new Object[0]);
                AlignmentI al = (AlignmentI)cl.getMethod("getRNAMLFor", FileParse.class).invoke(annotate3d, new FileParse(this.getDataName(), this.dataSourceType));
                for (SequenceI sq : al.getSequences()) {
                    if (sq.getDatasetSequence() != null) {
                        if (sq.getDatasetSequence().getAllPDBEntries() == null) continue;
                        sq.getDatasetSequence().getAllPDBEntries().clear();
                        continue;
                    }
                    if (sq.getAllPDBEntries() == null) continue;
                    sq.getAllPDBEntries().clear();
                }
                this.replaceAndUpdateChains(rna, al, "dna", false);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void replaceAndUpdateChains(List<SequenceI> prot, AlignmentI al, String pep, boolean b) {
        List<List<? extends Object>> replaced = AlignSeq.replaceMatchingSeqsWith(this.seqs, this.annotations, prot, al, pep, false);
        for (PDBChain ch : this.getChains()) {
            int p = 0;
            for (SequenceI sequenceI : replaced.get(0)) {
                ++p;
                if (sequenceI != ch.sequence && sequenceI.getDatasetSequence() != ch.sequence) continue;
                p = -p;
                break;
            }
            if (p >= 0) continue;
            p = -p - 1;
            ch.shadow = (SequenceI)replaced.get(1).get(p);
            ch.shadowMap = ((AlignSeq)replaced.get(2).get(p)).getMappingFromS1(false);
        }
    }

    protected void addSecondaryStructure(List<SequenceI> rnaSequences, List<SequenceI> proteinSequences) {
        if (this.externalSecondaryStructure && rnaSequences.size() > 0) {
            try {
                this.processPdbFileWithAnnotate3d(rnaSequences);
            }
            catch (Exception x) {
                System.err.println("Exceptions when dealing with RNA in pdb file");
                x.printStackTrace();
            }
        }
        if (proteinSequences.size() > 0) {
            try {
                this.processWithJmolParser(proteinSequences);
            }
            catch (Exception x) {
                System.err.println("Exceptions from Jmol when processing data in pdb file");
                x.printStackTrace();
            }
        }
    }

    private void processWithJmolParser(List<SequenceI> prot) throws Exception {
        try {
            Class<?> cl = Class.forName("jalview.ext.jmol.JmolParser");
            if (cl != null) {
                Constructor<?> constructor = cl.getConstructor(FileParse.class);
                Object[] args = new Object[]{new FileParse(this.getDataName(), this.dataSourceType)};
                StructureImportSettings.setShowSeqFeatures(false);
                StructureImportSettings.setVisibleChainAnnotation(false);
                StructureImportSettings.setProcessSecondaryStructure(this.predictSecondaryStructure);
                StructureImportSettings.setExternalSecondaryStructure(this.externalSecondaryStructure);
                Object jmf = constructor.newInstance(args);
                Alignment al = new Alignment((SequenceI[])cl.getMethod("getSeqsAsArray", new Class[0]).invoke(jmf, new Object[0]));
                cl.getMethod("addAnnotations", AlignmentI.class).invoke(jmf, al);
                for (SequenceI sq : al.getSequences()) {
                    if (sq.getDatasetSequence() != null) {
                        sq.getDatasetSequence().getAllPDBEntries().clear();
                        continue;
                    }
                    sq.getAllPDBEntries().clear();
                }
                this.replaceAndUpdateChains(prot, al, "pep", false);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        StructureImportSettings.setShowSeqFeatures(true);
    }

    public PDBChain findChain(String id) throws Exception {
        for (PDBChain chain : this.getChains()) {
            if (!chain.id.equals(id)) continue;
            return chain;
        }
        throw new Exception("PDB chain not Found!");
    }

    public void makeResidueList() {
        for (PDBChain chain : this.getChains()) {
            chain.makeResidueList(this.visibleChainAnnotation);
        }
    }

    public void makeCaBondList() {
        for (PDBChain chain : this.getChains()) {
            chain.makeCaBondList();
        }
    }

    public void setChargeColours() {
        for (PDBChain chain : this.getChains()) {
            chain.setChargeColours();
        }
    }

    public void setColours(ColourSchemeI cs) {
        for (PDBChain chain : this.getChains()) {
            chain.setChainColours(cs);
        }
    }

    public void setChainColours() {
        int i = 0;
        for (PDBChain chain : this.getChains()) {
            chain.setChainColours(Color.getHSBColor(1.0f / (float)i++, 0.4f, 1.0f));
        }
    }

    public static boolean isRNA(SequenceI seq) {
        int length = seq.getLength();
        for (int i = 0; i < length; ++i) {
            char c = seq.getCharAt(i);
            if (c == 'A' || c == 'C' || c == 'G' || c == 'U') continue;
            return false;
        }
        return true;
    }

    protected String safeName(String dataName) {
        int p = 0;
        while ((p = dataName.indexOf("/")) > -1 && p < dataName.length()) {
            dataName = dataName.substring(p + 1);
        }
        if (dataName.indexOf(".") > -1) {
            dataName = dataName.substring(0, dataName.lastIndexOf("."));
        }
        return dataName;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Vector<PDBChain> getChains() {
        return this.chains;
    }

    public void setChains(Vector<PDBChain> chains) {
        this.chains = chains;
    }

    public PDBEntry.Type getDbRefType() {
        return this.dbRefType;
    }

    public void setDbRefType(String dbRefType) {
        this.dbRefType = PDBEntry.Type.getType(dbRefType);
    }

    public void setDbRefType(PDBEntry.Type dbRefType) {
        this.dbRefType = dbRefType;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new PDBFeatureSettings();
    }

    public boolean isPPDBIdAvailable() {
        return this.pdbIdAvailable;
    }

    public void setPDBIdAvailable(boolean pdbIdAvailable) {
        this.pdbIdAvailable = pdbIdAvailable;
    }
}

