/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.FeatureColourI;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.DBRefSource;
import jalview.datamodel.GeneLociI;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceI;
import jalview.util.MessageManager;
import jalview.util.StringUtils;
import jalview.util.UrlLink;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;

public class SequenceAnnotationReport {
    private static final String COMMA = ",";
    private static final String ELLIPSIS = "...";
    private static final int MAX_REFS_PER_SOURCE = 4;
    private static final int MAX_SOURCES = 40;
    private static final String[][] PRIMARY_SOURCES = new String[][]{DBRefSource.CODINGDBS, DBRefSource.DNACODINGDBS, DBRefSource.PROTEINDBS};
    final String linkImageURL;
    private static Comparator<DBRefEntry> comparator = new Comparator<DBRefEntry>(){

        @Override
        public int compare(DBRefEntry ref1, DBRefEntry ref2) {
            int comp;
            if (ref1 instanceof GeneLociI) {
                return -1;
            }
            if (ref2 instanceof GeneLociI) {
                return 1;
            }
            String s1 = ref1.getSource();
            String s2 = ref2.getSource();
            boolean s1Primary = this.isPrimarySource(s1);
            boolean s2Primary = this.isPrimarySource(s2);
            if (s1Primary && !s2Primary) {
                return -1;
            }
            if (!s1Primary && s2Primary) {
                return 1;
            }
            int n = s1 == null ? -1 : (comp = s2 == null ? 1 : s1.compareToIgnoreCase(s2));
            if (comp == 0) {
                String a1 = ref1.getAccessionId();
                String a2 = ref2.getAccessionId();
                comp = a1 == null ? -1 : (a2 == null ? 1 : a1.compareToIgnoreCase(a2));
            }
            return comp;
        }

        private boolean isPrimarySource(String source) {
            String[][] stringArray = PRIMARY_SOURCES;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String[] primary;
                for (String s : primary = stringArray[i]) {
                    if (!source.equals(s)) continue;
                    return true;
                }
            }
            return false;
        }
    };

    public SequenceAnnotationReport(String linkURL) {
        this.linkImageURL = linkURL;
    }

    public void appendFeatures(StringBuilder sb, int residuePos, List<SequenceFeature> features, FeatureRendererModel fr) {
        for (SequenceFeature feature : features) {
            this.appendFeature(sb, residuePos, fr, feature, null);
        }
    }

    public void appendFeatures(StringBuilder sb, int residuePos, MappedFeatures mf, FeatureRendererModel fr) {
        for (SequenceFeature feature : mf.features) {
            this.appendFeature(sb, residuePos, fr, feature, mf);
        }
    }

    void appendFeature(StringBuilder sb, int rpos, FeatureRendererModel fr, SequenceFeature feature, MappedFeatures mf) {
        boolean linkOnly;
        if (feature.isContactFeature()) {
            if (feature.getBegin() == rpos || feature.getEnd() == rpos) {
                if (sb.length() > 6) {
                    sb.append("<br>");
                }
                sb.append(feature.getType()).append(" ").append(feature.getBegin()).append(":").append(feature.getEnd());
            }
            return;
        }
        if (sb.length() > 6) {
            sb.append("<br>");
        }
        boolean bl = linkOnly = feature.getValue("linkonly") != null;
        if (!linkOnly) {
            String variants;
            CharSequence[] attName;
            String attVal;
            FeatureColourI fc;
            String status;
            String description;
            sb.append(feature.getType()).append(" ");
            if (rpos != 0) {
                sb.append(feature.begin);
            }
            if (feature.begin != feature.end) {
                sb.append(" ").append(feature.end);
            }
            if ((description = feature.getDescription()) != null && !description.equals(feature.getType())) {
                description = StringUtils.stripHtmlTags(description);
                sb.append("; ").append(description);
            }
            if (this.showScore(feature, fr)) {
                sb.append(" Score=").append(String.valueOf(feature.getScore()));
            }
            if ((status = (String)feature.getValue("status")) != null && status.length() > 0) {
                sb.append("; (").append(status).append(")");
            }
            if (fr != null && (fc = fr.getFeatureColours().get(feature.getType())) != null && fc.isColourByAttribute() && (attVal = feature.getValueAsString((String[])(attName = fc.getAttributeName()))) != null) {
                sb.append("; ").append(String.join((CharSequence)":", attName)).append("=").append(attVal);
            }
            if (mf != null && !(variants = mf.findProteinVariants(feature)).isEmpty()) {
                sb.append(" ").append(variants);
            }
        }
    }

    boolean showScore(SequenceFeature feature, FeatureRendererModel fr) {
        if (Float.isNaN(feature.getScore())) {
            return false;
        }
        if (fr == null) {
            return true;
        }
        float[][] minMax = fr.getMinMax().get(feature.getType());
        return minMax != null && minMax[0] != null && minMax[0][0] != minMax[0][1];
    }

    void appendLinks(StringBuffer sb, SequenceFeature feature) {
        if (feature.links != null) {
            if (this.linkImageURL != null) {
                sb.append(" <img src=\"" + this.linkImageURL + "\">");
            } else {
                for (String urlstring : feature.links) {
                    try {
                        for (List<String> urllink : this.createLinksFrom(null, urlstring)) {
                            sb.append("<br/> <a href=\"" + urllink.get(3) + "\" target=\"" + urllink.get(0) + "\">" + (urllink.get(0).toLowerCase().equals(urllink.get(1).toLowerCase()) ? urllink.get(0) : urllink.get(0) + ":" + urllink.get(1)) + "</a></br>");
                        }
                    }
                    catch (Exception x) {
                        System.err.println("problem when creating links from " + urlstring);
                        x.printStackTrace();
                    }
                }
            }
        }
    }

    Collection<List<String>> createLinksFrom(SequenceI seq, String link) {
        LinkedHashMap<String, List<String>> urlSets = new LinkedHashMap<String, List<String>>();
        UrlLink urlLink = new UrlLink(link);
        if (!urlLink.isValid()) {
            System.err.println(urlLink.getInvalidMessage());
            return null;
        }
        urlLink.createLinksFromSeq(seq, urlSets);
        return urlSets.values();
    }

    public void createSequenceAnnotationReport(StringBuilder tip, SequenceI sequence, boolean showDbRefs, boolean showNpFeats, FeatureRendererModel fr) {
        this.createSequenceAnnotationReport(tip, sequence, showDbRefs, showNpFeats, fr, false);
    }

    int createSequenceAnnotationReport(StringBuilder sb, SequenceI sequence, boolean showDbRefs, boolean showNpFeats, FeatureRendererModel fr, boolean summary) {
        sb.append("<i>");
        int maxWidth = 0;
        if (sequence.getDescription() != null) {
            String tmp = sequence.getDescription();
            sb.append("<br>").append(tmp);
            maxWidth = Math.max(maxWidth, tmp.length());
        }
        SequenceI ds = sequence;
        while (ds.getDatasetSequence() != null) {
            ds = ds.getDatasetSequence();
        }
        AlignmentAnnotation[] anns = ds.getAnnotation();
        for (int i = 0; anns != null && i < anns.length; ++i) {
            AlignmentAnnotation aa = anns[i];
            if (aa == null || !aa.hasScore() || aa.sequenceRef == null) continue;
            sb.append("<br>").append(aa.label).append(": ").append(aa.getScore());
        }
        if (showDbRefs) {
            maxWidth = Math.max(maxWidth, this.appendDbRefs(sb, ds, summary));
        }
        if (showNpFeats) {
            for (SequenceFeature sf : sequence.getFeatures().getNonPositionalFeatures(new String[0])) {
                int sz = -sb.length();
                this.appendFeature(sb, 0, fr, sf, null);
                maxWidth = Math.max(maxWidth, sz += sb.length());
            }
        }
        if (sequence.getAnnotation("Search Scores") != null) {
            sb.append("<br>");
            String eValue = " E-Value: " + sequence.getAnnotation("Search Scores")[0].getEValue();
            String bitScore = " Bit Score: " + sequence.getAnnotation("Search Scores")[0].getBitScore();
            sb.append(eValue);
            sb.append("<br>");
            sb.append(bitScore);
            maxWidth = Math.max(maxWidth, eValue.length());
            maxWidth = Math.max(maxWidth, bitScore.length());
        }
        sb.append("<br>");
        sb.append("</i>");
        return maxWidth;
    }

    protected int appendDbRefs(StringBuilder sb, SequenceI ds, boolean summary) {
        DBRefEntry[] dbrefs = ds.getDBRefs();
        if (dbrefs == null) {
            return 0;
        }
        Arrays.sort(dbrefs, comparator);
        boolean ellipsis = false;
        String source = null;
        String lastSource = null;
        int countForSource = 0;
        int sourceCount = 0;
        boolean moreSources = false;
        int maxLineLength = 0;
        int lineLength = 0;
        for (DBRefEntry ref : dbrefs) {
            boolean sourceChanged;
            source = ref.getSource();
            if (source == null) continue;
            boolean bl = sourceChanged = !source.equals(lastSource);
            if (sourceChanged) {
                lineLength = 0;
                countForSource = 0;
                ++sourceCount;
            }
            if (sourceCount > 40 && summary) {
                ellipsis = true;
                moreSources = true;
                break;
            }
            lastSource = source;
            if (++countForSource == 1 || !summary) {
                sb.append("<br>");
            }
            if (countForSource <= 4 || !summary) {
                String accessionId = ref.getAccessionId();
                lineLength += accessionId.length() + 1;
                if (countForSource > 1 && summary) {
                    sb.append(", ").append(accessionId);
                    ++lineLength;
                } else {
                    sb.append(source).append(" ").append(accessionId);
                    lineLength += source.length();
                }
                maxLineLength = Math.max(maxLineLength, lineLength);
            }
            if (countForSource != 4 || !summary) continue;
            sb.append(COMMA).append(ELLIPSIS);
            ellipsis = true;
        }
        if (moreSources) {
            sb.append("<br>").append(source).append(COMMA).append(ELLIPSIS);
        }
        if (ellipsis) {
            sb.append("<br>(");
            sb.append(MessageManager.getString("label.output_seq_details"));
            sb.append(")");
        }
        return maxLineLength;
    }

    public void createTooltipAnnotationReport(StringBuilder tip, SequenceI sequence, boolean showDbRefs, boolean showNpFeats, FeatureRendererModel fr) {
        int maxWidth = this.createSequenceAnnotationReport(tip, sequence, showDbRefs, showNpFeats, fr, true);
        if (maxWidth > 60) {
            // empty if block
        }
    }
}

