/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.bin.Cache;
import jalview.gui.JvOptionPane;
import jalview.io.FileFormatI;
import jalview.io.FileFormats;
import jalview.io.JalviewFileFilter;
import jalview.util.MessageManager;
import jalview.util.Platform;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.basic.BasicFileChooserUI;

public class JalviewFileChooser
extends JFileChooser {
    private JCheckBox backupfilesCheckBox = null;
    protected boolean includeBackupFiles = false;
    File ourselectedFile = null;

    public static JalviewFileChooser forRead(String directory, String selected) {
        return JalviewFileChooser.forRead(directory, selected, false);
    }

    public static JalviewFileChooser forRead(String directory, String selected, boolean allowBackupFiles) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> descs = new ArrayList<String>();
        for (FileFormatI format : FileFormats.getInstance().getFormats()) {
            if (!format.isReadable()) continue;
            extensions.add(format.getExtensions());
            descs.add(format.getName());
        }
        return new JalviewFileChooser(directory, extensions.toArray(new String[extensions.size()]), descs.toArray(new String[descs.size()]), selected, true, allowBackupFiles);
    }

    public static JalviewFileChooser forWrite(String directory, String selected) {
        ArrayList<String> extensions = new ArrayList<String>();
        ArrayList<String> descs = new ArrayList<String>();
        for (FileFormatI format : FileFormats.getInstance().getFormats()) {
            if (!format.isWritable()) continue;
            extensions.add(format.getExtensions());
            descs.add(format.getName());
        }
        return new JalviewFileChooser(directory, extensions.toArray(new String[extensions.size()]), descs.toArray(new String[descs.size()]), selected, false);
    }

    public JalviewFileChooser(String dir) {
        super(JalviewFileChooser.safePath(dir));
        this.setAccessory(new RecentlyOpened());
    }

    public JalviewFileChooser(String dir, String[] suffix, String[] desc, String selected) {
        this(dir, suffix, desc, selected, true);
    }

    public JalviewFileChooser(String extension, String desc) {
        this(Cache.getProperty("LAST_DIRECTORY"), new String[]{extension}, new String[]{desc}, desc, true);
    }

    JalviewFileChooser(String dir, String[] extensions, String[] descs, String selected, boolean allFiles) {
        this(dir, extensions, descs, selected, allFiles, false);
    }

    public JalviewFileChooser(String dir, String[] extensions, String[] descs, String selected, boolean allFiles, boolean allowBackupFiles) {
        super(JalviewFileChooser.safePath(dir));
        if (extensions.length == descs.length) {
            ArrayList<String[]> formats = new ArrayList<String[]>();
            for (int i = 0; i < extensions.length; ++i) {
                formats.add(new String[]{extensions[i], descs[i]});
            }
            this.init(formats, selected, allFiles, allowBackupFiles);
        } else {
            System.err.println("JalviewFileChooser arguments mismatch: " + extensions + ", " + descs);
        }
    }

    private static File safePath(String dir) {
        if (dir == null) {
            return null;
        }
        File f = new File(dir);
        if (f.getName().indexOf(58) > -1) {
            return null;
        }
        return f;
    }

    void init(List<String[]> formats, String selected, boolean allFiles) {
        this.init(formats, selected, allFiles, false);
    }

    void init(List<String[]> formats, String selected, boolean allFiles, boolean allowBackupFiles) {
        JalviewFileFilter chosen = null;
        this.setAcceptAllFileFilterUsed(allFiles);
        for (String[] format : formats) {
            JalviewFileFilter jvf = new JalviewFileFilter(format[0], format[1]);
            if (allowBackupFiles) {
                jvf.setParentJFC(this);
            }
            this.addChoosableFileFilter(jvf);
            if (selected == null || !selected.equalsIgnoreCase(format[1])) continue;
            chosen = jvf;
        }
        if (chosen != null) {
            this.setFileFilter(chosen);
        }
        if (allowBackupFiles) {
            JPanel multi = new JPanel();
            multi.setLayout(new BoxLayout(multi, 3));
            if (this.backupfilesCheckBox == null) {
                try {
                    this.includeBackupFiles = Boolean.parseBoolean(Cache.getProperty("BACKUPFILES_FC_INCLUDE"));
                }
                catch (Exception e) {
                    this.includeBackupFiles = false;
                }
                this.backupfilesCheckBox = new JCheckBox(MessageManager.getString("label.include_backup_files"), this.includeBackupFiles);
                this.backupfilesCheckBox.setAlignmentX(0.5f);
                final JalviewFileChooser jfc = this;
                this.backupfilesCheckBox.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        JalviewFileChooser.this.includeBackupFiles = JalviewFileChooser.this.backupfilesCheckBox.isSelected();
                        Cache.setProperty("BACKUPFILES_FC_INCLUDE", String.valueOf(JalviewFileChooser.this.includeBackupFiles));
                        FileFilter f = jfc.getFileFilter();
                        File selectedFile = jfc.getSelectedFile();
                        if (selectedFile != null && !f.accept(selectedFile)) {
                            jfc.setSelectedFile(null);
                        }
                        String s = jfc.getApproveButtonText();
                        jfc.firePropertyChange("ApproveButtonTextChangedProperty", null, s);
                        jfc.firePropertyChange("fileFilterChanged", null, f);
                        jfc.rescanCurrentDirectory();
                        jfc.revalidate();
                        jfc.repaint();
                    }
                });
            }
            multi.add(new RecentlyOpened());
            multi.add(this.backupfilesCheckBox);
            this.setAccessory(multi);
        } else {
            this.includeBackupFiles = false;
            this.setAccessory(new RecentlyOpened());
        }
    }

    @Override
    public void setFileFilter(FileFilter filter) {
        super.setFileFilter(filter);
        try {
            if (this.getUI() instanceof BasicFileChooserUI) {
                final BasicFileChooserUI fcui = (BasicFileChooserUI)this.getUI();
                final String name = fcui.getFileName().trim();
                if (name == null || name.length() == 0) {
                    return;
                }
                EventQueue.invokeLater(new Thread(){

                    @Override
                    public void run() {
                        String currentName = fcui.getFileName();
                        if (currentName == null || currentName.length() == 0) {
                            fcui.setFileName(name);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public FileFormatI getSelectedFormat() {
        if (this.getFileFilter() == null) {
            return null;
        }
        String format = this.getFileFilter().getDescription();
        int parenPos = format.indexOf("(");
        if (parenPos > 0) {
            format = format.substring(0, parenPos).trim();
            try {
                return FileFormats.getInstance().forName(format);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Unexpected format: " + format);
            }
        }
        return null;
    }

    @Override
    public File getSelectedFile() {
        File selfile = super.getSelectedFile();
        if (selfile == null && this.ourselectedFile != null) {
            return this.ourselectedFile;
        }
        return selfile;
    }

    @Override
    public int showSaveDialog(Component parent) throws HeadlessException {
        this.setAccessory(null);
        this.setSelectedFile(null);
        return super.showSaveDialog(parent);
    }

    @Override
    public void approveSelection() {
        int confirm;
        JalviewFileFilter jvf;
        if (this.getDialogType() != 1) {
            super.approveSelection();
            return;
        }
        this.ourselectedFile = this.getSelectedFile();
        if (this.ourselectedFile == null) {
            try {
                String filename = ((BasicFileChooserUI)this.getUI()).getFileName();
                if (filename != null && filename.length() > 0) {
                    this.ourselectedFile = new File(this.getCurrentDirectory(), filename);
                }
            }
            catch (Throwable x) {
                System.err.println("Unexpected exception when trying to get filename.");
                x.printStackTrace();
            }
        }
        if (this.ourselectedFile == null) {
            return;
        }
        if (this.getFileFilter() instanceof JalviewFileFilter && !(jvf = (JalviewFileFilter)this.getFileFilter()).accept(this.ourselectedFile)) {
            String withExtension = this.getSelectedFile().getName() + "." + jvf.getAcceptableExtension();
            this.ourselectedFile = new File(this.getCurrentDirectory(), withExtension);
            this.setSelectedFile(this.ourselectedFile);
        }
        if (this.ourselectedFile.exists() && (confirm = JvOptionPane.showConfirmDialog(this, MessageManager.getString("label.overwrite_existing_file"), MessageManager.getString("label.file_already_exists"), 0)) != 0) {
            return;
        }
        super.approveSelection();
    }

    void recentListSelectionChanged(Object selection) {
        this.setSelectedFile(null);
        if (selection != null) {
            JalviewFileFilter jvf;
            File file = new File((String)selection);
            if (this.getFileFilter() instanceof JalviewFileFilter && !(jvf = (JalviewFileFilter)this.getFileFilter()).accept(file)) {
                this.setFileFilter(this.getChoosableFileFilters()[0]);
            }
            this.setSelectedFile(file);
        }
    }

    class RecentlyOpened
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JList<String> list;

        RecentlyOpened() {
            String historyItems = Cache.getProperty("RECENT_FILE");
            Vector<String> recent = new Vector<String>();
            if (historyItems != null) {
                StringTokenizer st = new StringTokenizer(historyItems, "\t");
                while (st.hasMoreTokens()) {
                    recent.addElement(st.nextToken());
                }
            }
            this.list = new JList(recent);
            DefaultListCellRenderer dlcr = new DefaultListCellRenderer();
            dlcr.setHorizontalAlignment(4);
            this.list.setCellRenderer(dlcr);
            this.list.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    JalviewFileChooser.this.recentListSelectionChanged(RecentlyOpened.this.list.getSelectedValue());
                }
            });
            this.setBorder(new TitledBorder(MessageManager.getString("label.recently_opened")));
            final JScrollPane scroller = new JScrollPane(this.list);
            SpringLayout layout = new SpringLayout();
            layout.putConstraint("West", (Component)scroller, 5, "West", (Component)this);
            layout.putConstraint("North", (Component)scroller, 5, "North", (Component)this);
            if (Platform.isAMac()) {
                scroller.setPreferredSize(new Dimension(500, 100));
            } else {
                scroller.setPreferredSize(new Dimension(130, 200));
            }
            this.add(scroller);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    scroller.getHorizontalScrollBar().setValue(scroller.getHorizontalScrollBar().getMaximum());
                }
            });
        }
    }
}

