/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.api.AlignExportSettingI;
import jalview.api.AlignViewportI;
import jalview.api.AlignmentViewPanel;
import jalview.api.ComplexAlignFile;
import jalview.api.FeatureRenderer;
import jalview.api.FeatureSettingsModelI;
import jalview.api.FeaturesDisplayedI;
import jalview.bin.BuildDetails;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenSequences;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.io.AlignFile;
import jalview.io.DataSourceType;
import jalview.io.FileParse;
import jalview.io.PDBFeatureSettings;
import jalview.json.binding.biojson.v1.AlignmentAnnotationPojo;
import jalview.json.binding.biojson.v1.AlignmentPojo;
import jalview.json.binding.biojson.v1.AnnotationDisplaySettingPojo;
import jalview.json.binding.biojson.v1.AnnotationPojo;
import jalview.json.binding.biojson.v1.ColourSchemeMapper;
import jalview.json.binding.biojson.v1.SequenceFeaturesPojo;
import jalview.json.binding.biojson.v1.SequenceGrpPojo;
import jalview.json.binding.biojson.v1.SequencePojo;
import jalview.renderer.seqfeatures.FeatureColourFinder;
import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.JalviewColourScheme;
import jalview.util.ColorUtils;
import jalview.util.Format;
import jalview.viewmodel.seqfeatures.FeaturesDisplayed;
import java.awt.Color;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class JSONFile
extends AlignFile
implements ComplexAlignFile {
    private static String version = new BuildDetails().getVersion();
    private String webstartUrl = "http://www.jalview.org/services/launchApp";
    private String application = "Jalview";
    private String globalColourScheme;
    private boolean showSeqFeatures;
    private Hashtable<String, Sequence> seqMap;
    private FeaturesDisplayedI displayedFeatures;
    private FeatureRenderer fr;
    private HiddenColumns hiddenColumns;
    private List<String> hiddenSeqRefs;
    private ArrayList<SequenceI> hiddenSequences;
    private static final String TCOFFEE_SCORE = "TCoffeeScore";

    public JSONFile() {
    }

    public JSONFile(FileParse source) throws IOException {
        super(source);
    }

    public JSONFile(String inFile, DataSourceType sourceType) throws IOException {
        super(inFile, sourceType);
    }

    @Override
    public void parse() throws IOException {
        this.parse(this.getReader());
    }

    @Override
    public String print(SequenceI[] sqs, boolean jvsuffix) {
        String jsonOutput = null;
        try {
            AlignmentPojo jsonAlignmentPojo = new AlignmentPojo();
            AlignExportSettingI exportSettings = this.getExportSettings();
            if (exportSettings == null) {
                exportSettings = new AlignExportSettingI(){

                    @Override
                    public boolean isExportHiddenSequences() {
                        return true;
                    }

                    @Override
                    public boolean isExportHiddenColumns() {
                        return true;
                    }

                    @Override
                    public boolean isExportGroups() {
                        return true;
                    }

                    @Override
                    public boolean isExportFeatures() {
                        return true;
                    }

                    @Override
                    public boolean isExportAnnotations() {
                        return true;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                };
            }
            int count = 0;
            for (SequenceI seq : sqs) {
                StringBuilder name = new StringBuilder();
                name.append(seq.getName()).append("/").append(seq.getStart()).append("-").append(seq.getEnd());
                SequencePojo jsonSeqPojo = new SequencePojo();
                jsonSeqPojo.setId(String.valueOf(seq.hashCode()));
                jsonSeqPojo.setOrder(++count);
                jsonSeqPojo.setEnd(seq.getEnd());
                jsonSeqPojo.setStart(seq.getStart());
                jsonSeqPojo.setName(name.toString());
                jsonSeqPojo.setSeq(seq.getSequenceAsString());
                jsonAlignmentPojo.getSeqs().add(jsonSeqPojo);
            }
            jsonAlignmentPojo.setGlobalColorScheme(this.globalColourScheme);
            jsonAlignmentPojo.getAppSettings().put("application", this.application);
            jsonAlignmentPojo.getAppSettings().put("version", version);
            jsonAlignmentPojo.getAppSettings().put("webStartUrl", this.webstartUrl);
            jsonAlignmentPojo.getAppSettings().put("showSeqFeatures", String.valueOf(this.showSeqFeatures));
            String[] hiddenSections = this.getHiddenSections();
            if (hiddenSections != null) {
                if (hiddenSections[0] != null && exportSettings.isExportHiddenColumns()) {
                    jsonAlignmentPojo.getAppSettings().put("hiddenCols", String.valueOf(hiddenSections[0]));
                }
                if (hiddenSections[1] != null && exportSettings.isExportHiddenSequences()) {
                    jsonAlignmentPojo.getAppSettings().put("hiddenSeqs", String.valueOf(hiddenSections[1]));
                }
            }
            if (exportSettings.isExportAnnotations()) {
                jsonAlignmentPojo.setAlignAnnotation(JSONFile.annotationToJsonPojo(this.annotations));
            } else if (this.globalColourScheme.equalsIgnoreCase(JalviewColourScheme.RNAHelices.toString()) || this.globalColourScheme.equalsIgnoreCase(JalviewColourScheme.TCoffee.toString())) {
                jsonAlignmentPojo.setGlobalColorScheme("None");
            }
            if (exportSettings.isExportFeatures()) {
                jsonAlignmentPojo.setSeqFeatures(this.sequenceFeatureToJsonPojo(sqs));
            }
            if (exportSettings.isExportGroups() && this.seqGroups != null && this.seqGroups.size() > 0) {
                for (SequenceGroup seqGrp : this.seqGroups) {
                    SequenceGrpPojo seqGrpPojo = new SequenceGrpPojo();
                    seqGrpPojo.setGroupName(seqGrp.getName());
                    seqGrpPojo.setColourScheme(ColourSchemeProperty.getColourName(seqGrp.getColourScheme()));
                    seqGrpPojo.setColourText(seqGrp.getColourText());
                    seqGrpPojo.setDescription(seqGrp.getDescription());
                    seqGrpPojo.setDisplayBoxes(seqGrp.getDisplayBoxes());
                    seqGrpPojo.setDisplayText(seqGrp.getDisplayText());
                    seqGrpPojo.setEndRes(seqGrp.getEndRes());
                    seqGrpPojo.setStartRes(seqGrp.getStartRes());
                    seqGrpPojo.setShowNonconserved(seqGrp.getShowNonconserved());
                    for (SequenceI seq : seqGrp.getSequences()) {
                        seqGrpPojo.getSequenceRefs().add(String.valueOf(seq.hashCode()));
                    }
                    jsonAlignmentPojo.getSeqGroups().add(seqGrpPojo);
                }
            }
            org.json.JSONObject generatedJSon = new org.json.JSONObject((Object)jsonAlignmentPojo);
            jsonOutput = generatedJSon.toString();
            return jsonOutput.replaceAll("xstart", "xStart").replaceAll("xend", "xEnd");
        }
        catch (Exception e) {
            e.printStackTrace();
            return jsonOutput;
        }
    }

    public String[] getHiddenSections() {
        HiddenSequences hiddenSeqsObj;
        String[] hiddenSections = new String[2];
        if (this.getViewport() == null) {
            return null;
        }
        if (this.getViewport().hasHiddenColumns()) {
            hiddenSections[0] = this.getViewport().getAlignment().getHiddenColumns().regionsToString(";", "-");
        }
        if ((hiddenSeqsObj = this.getViewport().getAlignment().getHiddenSequences()) == null || hiddenSeqsObj.hiddenSequences == null) {
            return hiddenSections;
        }
        SequenceI[] hiddenSeqs = hiddenSeqsObj.hiddenSequences;
        StringBuilder hiddenSeqsBuilder = new StringBuilder();
        for (SequenceI hiddenSeq : hiddenSeqs) {
            if (hiddenSeq == null) continue;
            hiddenSeqsBuilder.append(";").append(hiddenSeq.hashCode());
        }
        if (hiddenSeqsBuilder.length() > 0) {
            hiddenSeqsBuilder.deleteCharAt(0);
        }
        hiddenSections[1] = hiddenSeqsBuilder.toString();
        return hiddenSections;
    }

    protected List<SequenceFeaturesPojo> sequenceFeatureToJsonPojo(SequenceI[] sqs) {
        this.displayedFeatures = this.fr == null ? null : this.fr.getFeaturesDisplayed();
        ArrayList<SequenceFeaturesPojo> sequenceFeaturesPojo = new ArrayList<SequenceFeaturesPojo>();
        if (sqs == null) {
            return sequenceFeaturesPojo;
        }
        FeatureColourFinder finder = new FeatureColourFinder(this.fr);
        String[] visibleFeatureTypes = this.displayedFeatures == null ? null : this.displayedFeatures.getVisibleFeatures().toArray(new String[this.displayedFeatures.getVisibleFeatureCount()]);
        for (SequenceI seq : sqs) {
            List<SequenceFeature> seqFeatures = seq.getFeatures().getAllFeatures(visibleFeatureTypes);
            for (SequenceFeature sf : seqFeatures) {
                SequenceFeaturesPojo jsonFeature = new SequenceFeaturesPojo(String.valueOf(seq.hashCode()));
                String featureColour = this.fr == null ? null : Format.getHexString(finder.findFeatureColour(Color.white, seq, seq.findIndex(sf.getBegin())));
                int xStart = sf.getBegin() == 0 ? 0 : seq.findIndex(sf.getBegin()) - 1;
                int xEnd = sf.getEnd() == 0 ? 0 : seq.findIndex(sf.getEnd());
                jsonFeature.setXstart(xStart);
                jsonFeature.setXend(xEnd);
                jsonFeature.setType(sf.getType());
                jsonFeature.setDescription(sf.getDescription());
                jsonFeature.setLinks(sf.links);
                jsonFeature.setOtherDetails(sf.otherDetails);
                jsonFeature.setScore(Float.valueOf(sf.getScore()));
                jsonFeature.setFillColor(featureColour);
                jsonFeature.setFeatureGroup(sf.getFeatureGroup());
                sequenceFeaturesPojo.add(jsonFeature);
            }
        }
        return sequenceFeaturesPojo;
    }

    public static List<AlignmentAnnotationPojo> annotationToJsonPojo(Vector<AlignmentAnnotation> annotations) {
        ArrayList<AlignmentAnnotationPojo> jsonAnnotations = new ArrayList<AlignmentAnnotationPojo>();
        if (annotations == null) {
            return jsonAnnotations;
        }
        for (AlignmentAnnotation annot : annotations) {
            AlignmentAnnotationPojo alignAnnotPojo = new AlignmentAnnotationPojo();
            alignAnnotPojo.setDescription(annot.description);
            alignAnnotPojo.setLabel(annot.label);
            if (!Double.isNaN(annot.score)) {
                alignAnnotPojo.setScore(annot.score);
            }
            alignAnnotPojo.setCalcId(annot.getCalcId());
            alignAnnotPojo.setGraphType(annot.graph);
            AnnotationDisplaySettingPojo annotSetting = new AnnotationDisplaySettingPojo();
            annotSetting.setBelowAlignment(annot.belowAlignment);
            annotSetting.setCentreColLabels(annot.centreColLabels);
            annotSetting.setScaleColLabel(annot.scaleColLabel);
            annotSetting.setShowAllColLabels(annot.showAllColLabels);
            annotSetting.setVisible(annot.visible);
            annotSetting.setHasIcon(annot.hasIcons);
            alignAnnotPojo.setAnnotationSettings(annotSetting);
            SequenceI refSeq = annot.sequenceRef;
            if (refSeq != null) {
                alignAnnotPojo.setSequenceRef(String.valueOf(refSeq.hashCode()));
            }
            for (Annotation annotation : annot.annotations) {
                AnnotationPojo annotationPojo = new AnnotationPojo();
                if (annotation != null) {
                    annotationPojo.setDescription(annotation.description);
                    annotationPojo.setValue(annotation.value);
                    annotationPojo.setSecondaryStructure(annotation.secondaryStructure);
                    String displayChar = annotation.displayCharacter == null ? null : annotation.displayCharacter;
                    annotationPojo.setDisplayCharacter(displayChar);
                    if (annotation.colour != null) {
                        annotationPojo.setColour(Format.getHexString(annotation.colour));
                    }
                    alignAnnotPojo.getAnnotations().add(annotationPojo);
                    continue;
                }
                if (annot.getCalcId() != null && annot.getCalcId().equalsIgnoreCase(TCOFFEE_SCORE)) continue;
                alignAnnotPojo.getAnnotations().add(annotationPojo);
            }
            jsonAnnotations.add(alignAnnotPojo);
        }
        return jsonAnnotations;
    }

    public JSONFile parse(Reader jsonAlignmentString) {
        try {
            JSONParser jsonParser = new JSONParser();
            JSONObject alignmentJsonObj = (JSONObject)jsonParser.parse(jsonAlignmentString);
            JSONArray seqJsonArray = (JSONArray)alignmentJsonObj.get((Object)"seqs");
            JSONArray alAnnotJsonArray = (JSONArray)alignmentJsonObj.get((Object)"alignAnnotation");
            JSONArray jsonSeqArray = (JSONArray)alignmentJsonObj.get((Object)"seqFeatures");
            JSONArray seqGrpJsonArray = (JSONArray)alignmentJsonObj.get((Object)"seqGroups");
            JSONObject jvSettingsJsonObj = (JSONObject)alignmentJsonObj.get((Object)"appSettings");
            if (jvSettingsJsonObj != null) {
                this.globalColourScheme = (String)jvSettingsJsonObj.get((Object)"globalColorScheme");
                Boolean showFeatures = Boolean.valueOf(jvSettingsJsonObj.get((Object)"showSeqFeatures").toString());
                this.setShowSeqFeatures(showFeatures);
                this.parseHiddenSeqRefsAsList(jvSettingsJsonObj);
                this.parseHiddenCols(jvSettingsJsonObj);
            }
            this.hiddenSequences = new ArrayList();
            this.seqMap = new Hashtable();
            for (JSONObject sequence : seqJsonArray) {
                String sequcenceString = sequence.get((Object)"seq").toString();
                String sequenceName = sequence.get((Object)"name").toString();
                String seqUniqueId = sequence.get((Object)"id").toString();
                int start = Integer.valueOf(sequence.get((Object)"start").toString());
                int end = Integer.valueOf(sequence.get((Object)"end").toString());
                Sequence seq = new Sequence(sequenceName, sequcenceString, start, end);
                if (this.hiddenSeqRefs != null && this.hiddenSeqRefs.contains(seqUniqueId)) {
                    this.hiddenSequences.add(seq);
                }
                this.seqs.add(seq);
                this.seqMap.put(seqUniqueId, seq);
            }
            this.parseFeatures(jsonSeqArray);
            for (JSONObject seqGrpObj : seqGrpJsonArray) {
                String grpName = seqGrpObj.get((Object)"groupName").toString();
                String colourScheme = seqGrpObj.get((Object)"colourScheme").toString();
                String description = seqGrpObj.get((Object)"description") == null ? null : seqGrpObj.get((Object)"description").toString();
                boolean displayBoxes = Boolean.valueOf(seqGrpObj.get((Object)"displayBoxes").toString());
                boolean displayText = Boolean.valueOf(seqGrpObj.get((Object)"displayText").toString());
                boolean colourText = Boolean.valueOf(seqGrpObj.get((Object)"colourText").toString());
                boolean showNonconserved = Boolean.valueOf(seqGrpObj.get((Object)"showNonconserved").toString());
                int startRes = Integer.valueOf(seqGrpObj.get((Object)"startRes").toString());
                int endRes = Integer.valueOf(seqGrpObj.get((Object)"endRes").toString());
                JSONArray sequenceRefs = (JSONArray)seqGrpObj.get((Object)"sequenceRefs");
                ArrayList<SequenceI> grpSeqs = new ArrayList<SequenceI>();
                if (sequenceRefs.size() > 0) {
                    for (String seqHash : sequenceRefs) {
                        Sequence sequence = this.seqMap.get(seqHash);
                        if (sequence == null) continue;
                        grpSeqs.add(sequence);
                    }
                }
                SequenceGroup seqGrp = new SequenceGroup(grpSeqs, grpName, null, displayBoxes, displayText, colourText, startRes, endRes);
                seqGrp.setColourScheme(ColourSchemeMapper.getJalviewColourScheme(colourScheme, seqGrp));
                seqGrp.setShowNonconserved(showNonconserved);
                seqGrp.setDescription(description);
                this.seqGroups.add(seqGrp);
            }
            for (JSONObject alAnnot : alAnnotJsonArray) {
                Sequence sequence;
                JSONArray annotJsonArray = (JSONArray)alAnnot.get((Object)"annotations");
                Annotation[] annotations = new Annotation[annotJsonArray.size()];
                int count = 0;
                for (JSONObject annot : annotJsonArray) {
                    if (annot == null) {
                        annotations[count] = null;
                    } else {
                        float val = (annot.get((Object)"value") == null ? null : Float.valueOf(annot.get((Object)"value").toString())).floatValue();
                        String desc = annot.get((Object)"description") == null ? null : annot.get((Object)"description").toString();
                        char ss = annot.get((Object)"secondaryStructure") == null || annot.get((Object)"secondaryStructure").toString().equalsIgnoreCase("u0000") ? (char)' ' : (char)annot.get((Object)"secondaryStructure").toString().charAt(0);
                        String displayChar = annot.get((Object)"displayCharacter") == null ? "" : annot.get((Object)"displayCharacter").toString();
                        annotations[count] = new Annotation(displayChar, desc, ss, val);
                        if (annot.get((Object)"colour") != null) {
                            Color color;
                            annotations[count].colour = color = ColorUtils.parseColourString(annot.get((Object)"colour").toString());
                        }
                    }
                    ++count;
                }
                AlignmentAnnotation alignAnnot = new AlignmentAnnotation(alAnnot.get((Object)"label").toString(), alAnnot.get((Object)"description").toString(), annotations);
                alignAnnot.graph = alAnnot.get((Object)"graphType") == null ? 0 : Integer.valueOf(alAnnot.get((Object)"graphType").toString());
                JSONObject diplaySettings = (JSONObject)alAnnot.get((Object)"annotationSettings");
                if (diplaySettings != null) {
                    alignAnnot.scaleColLabel = diplaySettings.get((Object)"scaleColLabel") == null ? false : Boolean.valueOf(diplaySettings.get((Object)"scaleColLabel").toString());
                    alignAnnot.showAllColLabels = diplaySettings.get((Object)"showAllColLabels") == null ? true : Boolean.valueOf(diplaySettings.get((Object)"showAllColLabels").toString());
                    alignAnnot.centreColLabels = diplaySettings.get((Object)"centreColLabels") == null ? true : Boolean.valueOf(diplaySettings.get((Object)"centreColLabels").toString());
                    alignAnnot.belowAlignment = diplaySettings.get((Object)"belowAlignment") == null ? false : Boolean.valueOf(diplaySettings.get((Object)"belowAlignment").toString());
                    alignAnnot.visible = diplaySettings.get((Object)"visible") == null ? true : Boolean.valueOf(diplaySettings.get((Object)"visible").toString());
                    boolean bl = alignAnnot.hasIcons = diplaySettings.get((Object)"hasIcon") == null ? true : Boolean.valueOf(diplaySettings.get((Object)"hasIcon").toString());
                }
                if (alAnnot.get((Object)"score") != null) {
                    alignAnnot.score = Double.valueOf(alAnnot.get((Object)"score").toString());
                }
                String calcId = alAnnot.get((Object)"calcId") == null ? "" : alAnnot.get((Object)"calcId").toString();
                alignAnnot.setCalcId(calcId);
                String seqHash = alAnnot.get((Object)"sequenceRef") != null ? alAnnot.get((Object)"sequenceRef").toString() : null;
                Sequence sequence2 = sequence = seqHash != null ? this.seqMap.get(seqHash) : null;
                if (sequence != null) {
                    alignAnnot.sequenceRef = sequence;
                    sequence.addAlignmentAnnotation(alignAnnot);
                    if (alignAnnot.label.equalsIgnoreCase("T-COFFEE")) {
                        alignAnnot.createSequenceMapping(sequence, sequence.getStart(), false);
                        sequence.addAlignmentAnnotation(alignAnnot);
                        alignAnnot.adjustForAlignment();
                    }
                }
                alignAnnot.validateRangeAndDisplay();
                this.annotations.add(alignAnnot);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    public void parseHiddenSeqRefsAsList(JSONObject jvSettingsJson) {
        this.hiddenSeqRefs = new ArrayList<String>();
        String hiddenSeqs = (String)jvSettingsJson.get((Object)"hiddenSeqs");
        if (hiddenSeqs != null && !hiddenSeqs.isEmpty()) {
            String[] seqRefs;
            for (String seqRef : seqRefs = hiddenSeqs.split(";")) {
                this.hiddenSeqRefs.add(seqRef);
            }
        }
    }

    public void parseHiddenCols(JSONObject jvSettingsJson) {
        String hiddenCols = (String)jvSettingsJson.get((Object)"hiddenCols");
        if (hiddenCols != null && !hiddenCols.isEmpty()) {
            String[] rangeStrings;
            this.hiddenColumns = new HiddenColumns();
            for (String rangeString : rangeStrings = hiddenCols.split(";")) {
                String[] range = rangeString.split("-");
                this.hiddenColumns.hideColumns(Integer.valueOf(range[0]), Integer.valueOf(range[1]));
            }
        }
    }

    private void parseFeatures(JSONArray jsonSeqFeatures) {
        if (jsonSeqFeatures != null) {
            this.displayedFeatures = new FeaturesDisplayed();
            for (JSONObject jsonFeature : jsonSeqFeatures) {
                Long begin = (Long)jsonFeature.get((Object)"xStart");
                Long end = (Long)jsonFeature.get((Object)"xEnd");
                String type = (String)jsonFeature.get((Object)"type");
                String featureGrp = (String)jsonFeature.get((Object)"featureGroup");
                String description = (String)jsonFeature.get((Object)"description");
                String seqRef = (String)jsonFeature.get((Object)"sequenceRef");
                Float score = Float.valueOf(jsonFeature.get((Object)"score").toString());
                Sequence seq = this.seqMap.get(seqRef);
                int featureBegin = begin.intValue() == 0 ? 0 : seq.findPosition(begin.intValue());
                int featureEnd = end.intValue() == 0 ? 0 : seq.findPosition(end.intValue()) - 1;
                SequenceFeature sequenceFeature = new SequenceFeature(type, description, featureBegin, featureEnd, score.floatValue(), featureGrp);
                JSONArray linksJsonArray = (JSONArray)jsonFeature.get((Object)"links");
                if (linksJsonArray != null && linksJsonArray.size() > 0) {
                    for (String link : linksJsonArray) {
                        sequenceFeature.addLink(link);
                    }
                }
                seq.addSequenceFeature(sequenceFeature);
                this.displayedFeatures.setVisible(type);
            }
        }
    }

    @Override
    public String getGlobalColourScheme() {
        return this.globalColourScheme;
    }

    public void setGlobalColorScheme(String globalColourScheme) {
        this.globalColourScheme = globalColourScheme;
    }

    @Override
    public FeaturesDisplayedI getDisplayedFeatures() {
        return this.displayedFeatures;
    }

    public void setDisplayedFeatures(FeaturesDisplayedI displayedFeatures) {
        this.displayedFeatures = displayedFeatures;
    }

    @Override
    public void configureForView(AlignmentViewPanel avpanel) {
        if (avpanel == null) {
            return;
        }
        super.configureForView(avpanel);
        AlignViewportI viewport = avpanel.getAlignViewport();
        AlignmentI alignment = viewport.getAlignment();
        AlignmentAnnotation[] annots = alignment.getAlignmentAnnotation();
        this.seqGroups = alignment.getGroups();
        this.fr = avpanel.cloneFeatureRenderer();
        if (annots != null) {
            for (AlignmentAnnotation annot : annots) {
                if (annot == null || annot.autoCalculated) continue;
                this.annotations.add(annot);
            }
        }
        this.globalColourScheme = ColourSchemeProperty.getColourName(viewport.getGlobalColourScheme());
        this.setDisplayedFeatures(viewport.getFeaturesDisplayed());
        this.showSeqFeatures = viewport.isShowSequenceFeatures();
    }

    @Override
    public boolean isShowSeqFeatures() {
        return this.showSeqFeatures;
    }

    public void setShowSeqFeatures(boolean showSeqFeatures) {
        this.showSeqFeatures = showSeqFeatures;
    }

    @Override
    public Vector<AlignmentAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public HiddenColumns getHiddenColumns() {
        return this.hiddenColumns;
    }

    public void setHiddenColumns(HiddenColumns hidden) {
        this.hiddenColumns = hidden;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SequenceI[] getHiddenSequences() {
        if (this.hiddenSequences == null || this.hiddenSequences.isEmpty()) {
            return new SequenceI[0];
        }
        ArrayList<SequenceI> arrayList = this.hiddenSequences;
        synchronized (arrayList) {
            return this.hiddenSequences.toArray(new SequenceI[this.hiddenSequences.size()]);
        }
    }

    public void setHiddenSequences(ArrayList<SequenceI> hiddenSequences) {
        this.hiddenSequences = hiddenSequences;
    }

    @Override
    public FeatureSettingsModelI getFeatureColourScheme() {
        return new PDBFeatureSettings();
    }

    public class JSONExportSettings {
        private boolean exportSequence;
        private boolean exportSequenceFeatures;
        private boolean exportAnnotations;
        private boolean exportGroups;
        private boolean exportJalviewSettings;

        public boolean isExportSequence() {
            return this.exportSequence;
        }

        public void setExportSequence(boolean exportSequence) {
            this.exportSequence = exportSequence;
        }

        public boolean isExportSequenceFeatures() {
            return this.exportSequenceFeatures;
        }

        public void setExportSequenceFeatures(boolean exportSequenceFeatures) {
            this.exportSequenceFeatures = exportSequenceFeatures;
        }

        public boolean isExportAnnotations() {
            return this.exportAnnotations;
        }

        public void setExportAnnotations(boolean exportAnnotations) {
            this.exportAnnotations = exportAnnotations;
        }

        public boolean isExportGroups() {
            return this.exportGroups;
        }

        public void setExportGroups(boolean exportGroups) {
            this.exportGroups = exportGroups;
        }

        public boolean isExportJalviewSettings() {
            return this.exportJalviewSettings;
        }

        public void setExportJalviewSettings(boolean exportJalviewSettings) {
            this.exportJalviewSettings = exportJalviewSettings;
        }
    }
}

