/*
 * Decompiled with CFR 0.152.
 */
package jalview.io;

import jalview.io.BackupFilesPresetEntry;
import java.io.File;

public class BackupFilenameParts {
    private String base;
    private String templateStart;
    private int num;
    private int digits;
    private String templateEnd;
    private boolean isBackupFile = false;

    private BackupFilenameParts() {
    }

    public BackupFilenameParts(File file, String base, String template, int digits) {
        this(file.getName(), base, template, digits);
    }

    public BackupFilenameParts(String filename, String base, String template, int suggesteddigits) {
        this(filename, base, template, suggesteddigits, false);
    }

    public BackupFilenameParts(String filename, String base, String template, int suggesteddigits, boolean extensionMatch) {
        String numString;
        int numcharstart = template.indexOf("%n");
        int digits = 0;
        String templateStart = template;
        String templateEnd = "";
        if (numcharstart > -1) {
            templateStart = template.substring(0, numcharstart);
            templateEnd = template.substring(numcharstart + "%n".length());
            digits = suggesteddigits;
        }
        String savedFilename = "";
        if (extensionMatch) {
            int extensioncharstart = filename.lastIndexOf('.' + base + templateStart);
            if (extensioncharstart == -1) {
                return;
            }
            savedFilename = filename.substring(0, extensioncharstart + 1);
            filename = filename.substring(extensioncharstart + 1);
        }
        int minlength = base.length() + template.length() - "%n".length() + digits;
        if (!filename.startsWith(base + templateStart) || !filename.endsWith(templateEnd) || filename.length() < minlength) {
            return;
        }
        int startLength = base.length() + templateStart.length();
        int endLength = templateEnd.length();
        String string = numString = numcharstart > -1 ? filename.substring(startLength, filename.length() - endLength) : "";
        if (filename.length() >= startLength + digits + endLength && filename.startsWith(base + templateStart) && filename.endsWith(templateEnd) && (numString.matches("[0-9]{" + digits + "}") || numString.matches("[1-9][0-9]{" + digits + ",}"))) {
            this.base = extensionMatch ? savedFilename + base : base;
            this.templateStart = templateStart;
            this.num = numString.length() > 0 ? Integer.parseInt(numString) : 0;
            this.digits = digits;
            this.templateEnd = templateEnd;
            this.isBackupFile = true;
        }
    }

    public static BackupFilenameParts currentBackupFilenameParts(String filename, String base, boolean extensionMatch) {
        int digits;
        BackupFilenameParts bfp = new BackupFilenameParts();
        BackupFilesPresetEntry bfpe = BackupFilesPresetEntry.getSavedBackupEntry();
        String template = bfpe.suffix;
        if (template == null) {
            return bfp;
        }
        try {
            digits = bfpe.digits;
        }
        catch (Exception e) {
            return bfp;
        }
        return new BackupFilenameParts(filename, base, template, digits, extensionMatch);
    }

    public boolean isBackupFile() {
        return this.isBackupFile;
    }

    public int indexNum() {
        return this.num;
    }

    public static String getBackupFilename(int index, String base, String template, int digits) {
        String numString = String.format("%0" + digits + "d", index);
        String backupSuffix = template.replaceFirst("%n", numString);
        String backupfilename = base + backupSuffix;
        return backupfilename;
    }
}

