/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.analysis.SeqsetUtils;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AnnotatedCollectionI;
import jalview.datamodel.Annotation;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.JvOptionPane;
import jalview.io.FastaFile;
import jalview.io.HMMFile;
import jalview.io.StockholmFile;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.params.ArgumentI;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public abstract class HmmerCommand
implements Runnable {
    public static final String HMMBUILD = "hmmbuild";
    protected final AlignFrame af;
    protected final AlignmentI alignment;
    protected final List<ArgumentI> params;
    static final String DATABASE_KEY = "label.database";
    static final String THIS_ALIGNMENT_KEY = "label.this_alignment";
    static final String USE_ACCESSIONS_KEY = "label.use_accessions";
    static final String AUTO_ALIGN_SEQS_KEY = "label.auto_align_seqs";
    static final String NUMBER_OF_RESULTS_KEY = "label.number_of_results";
    static final String NUMBER_OF_ITERATIONS = "label.number_of_iterations";
    static final String TRIM_TERMINI_KEY = "label.trim_termini";
    static final String RETURN_N_NEW_SEQ = "label.check_for_new_sequences";
    static final String REPORTING_CUTOFF_KEY = "label.reporting_cutoff";
    static final String CUTOFF_NONE = "label.default";
    static final String CUTOFF_SCORE = "label.score";
    static final String CUTOFF_EVALUE = "label.evalue";
    static final String REPORTING_SEQ_EVALUE_KEY = "label.reporting_seq_evalue";
    static final String REPORTING_DOM_EVALUE_KEY = "label.reporting_dom_evalue";
    static final String REPORTING_SEQ_SCORE_KEY = "label.reporting_seq_score";
    static final String REPORTING_DOM_SCORE_KEY = "label.reporting_dom_score";
    static final String INCLUSION_SEQ_EVALUE_KEY = "label.inclusion_seq_evalue";
    static final String INCLUSION_DOM_EVALUE_KEY = "label.inclusion_dom_evalue";
    static final String INCLUSION_SEQ_SCORE_KEY = "label.inclusion_seq_score";
    static final String INCLUSION_DOM_SCORE_KEY = "label.inclusion_dom_score";
    static final String ARG_TRIM = "--trim";
    static final String INCLUSION_THRESHOLD_KEY = "label.inclusion_threshold";

    public HmmerCommand(AlignFrame alignFrame, List<ArgumentI> args) {
        this.af = alignFrame;
        this.alignment = this.af.getViewport().getAlignment();
        this.params = args;
    }

    public static boolean isHmmerAvailable() {
        File exec = FileUtils.getExecutable(HMMBUILD, Cache.getProperty("HMMER_PATH"));
        return exec != null;
    }

    protected Hashtable stashSequences(SequenceI[] seqs) {
        return SeqsetUtils.uniquify(seqs, true);
    }

    protected void recoverSequences(Hashtable hashtable, SequenceI[] seqs) {
        SeqsetUtils.deuniquify(hashtable, seqs);
    }

    public boolean runCommand(List<String> commands) throws IOException {
        List<String> args = Platform.isWindows() ? this.wrapWithCygwin(commands) : commands;
        try {
            ProcessBuilder pb = new ProcessBuilder(args);
            pb.redirectErrorStream(true);
            if (Platform.isWindows()) {
                String path = pb.environment().get("Path");
                path = Cache.getProperty("CYGWIN_PATH") + ";" + path;
                pb.environment().put("Path", path);
            }
            final Process p = pb.start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
                    try {
                        String line = input.readLine();
                        while (line != null) {
                            System.out.println(line);
                            line = input.readLine();
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue != 0) {
                Cache.log.error((Object)("Command failed, return code = " + exitValue));
                Cache.log.error((Object)("Command/args were: " + args.toString()));
            }
            return exitValue == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected List<String> wrapWithCygwin(List<String> commands) {
        File bash = FileUtils.getExecutable("bash", Cache.getProperty("CYGWIN_PATH"));
        if (bash == null) {
            Cache.log.error((Object)"Cygwin shell not found");
            return commands;
        }
        ArrayList<String> wrapped = new ArrayList<String>();
        wrapped.add(bash.getAbsolutePath());
        wrapped.add("-c");
        StringBuilder sb = new StringBuilder();
        for (String cmd : commands) {
            sb.append(" ").append(cmd);
        }
        wrapped.add(sb.toString());
        return wrapped;
    }

    public void exportStockholm(SequenceI[] seqs, File toFile, AnnotatedCollectionI annotated) throws IOException {
        Object[] annots;
        if (seqs == null) {
            return;
        }
        Alignment newAl = new Alignment(seqs);
        if (!newAl.isAligned()) {
            newAl.padGaps();
        }
        if (toFile != null && annotated != null && (annots = annotated.getAlignmentAnnotation()) != null) {
            Object[] objectArray = annots;
            int n = objectArray.length;
            for (int i = 0; i < n; ++i) {
                AlignmentAnnotation newRF;
                Object annot = objectArray[i];
                if (!((AlignmentAnnotation)annot).label.contains("Reference") && !"RF".equals(((AlignmentAnnotation)annot).label)) continue;
                if (((AlignmentAnnotation)annot).annotations.length > newAl.getWidth()) {
                    Annotation[] rfAnnots = new Annotation[newAl.getWidth()];
                    System.arraycopy(((AlignmentAnnotation)annot).annotations, 0, rfAnnots, 0, rfAnnots.length);
                    newRF = new AlignmentAnnotation("RF", "Reference Positions", rfAnnots);
                } else {
                    newRF = new AlignmentAnnotation((AlignmentAnnotation)annot);
                }
                newAl.addAnnotation(newRF);
            }
        }
        for (SequenceI seq : newAl.getSequencesArray()) {
            if (seq.getAnnotation() == null) continue;
            for (AlignmentAnnotation ann : seq.getAnnotation()) {
                seq.removeAlignmentAnnotation(ann);
            }
        }
        StockholmFile file = new StockholmFile(newAl);
        String output = file.print(seqs, false);
        PrintWriter writer = new PrintWriter(toFile);
        writer.println(output);
        writer.close();
    }

    protected String getCommandPath(String cmd) throws IOException {
        String binariesFolder = Cache.getProperty("HMMER_PATH");
        File file = FileUtils.getExecutable(cmd, binariesFolder = Paths.get(binariesFolder, new String[0]).toRealPath(new LinkOption[0]).toString());
        if (file == null && this.af != null) {
            JvOptionPane.showInternalMessageDialog(this.af, MessageManager.formatMessage("label.executable_not_found", cmd));
        }
        return file == null ? null : this.getFilePath(file, true);
    }

    public void exportHmm(HiddenMarkovModel hmm, File hmmFile) throws IOException {
        if (hmm != null) {
            HMMFile file = new HMMFile(hmm);
            PrintWriter writer = new PrintWriter(hmmFile);
            writer.print(file.print());
            writer.close();
        }
    }

    public void exportSequence(SequenceI seq, File seqFile) throws IOException {
        if (seq != null) {
            FastaFile file = new FastaFile();
            PrintWriter writer = new PrintWriter(seqFile);
            writer.print(file.print(new SequenceI[]{seq}, false));
            writer.close();
        }
    }

    protected HiddenMarkovModel getHmmProfile() {
        String alignToParamName = MessageManager.getString("label.use_hmm");
        for (ArgumentI arg : this.params) {
            String seqName;
            SequenceI hmmSeq;
            String name = arg.getName();
            if (!name.equals(alignToParamName) || !(hmmSeq = this.alignment.findName(seqName = arg.getValue())).hasHMMProfile()) continue;
            return hmmSeq.getHMM();
        }
        return null;
    }

    protected SequenceI getSequence() {
        String alignToParamName = MessageManager.getString("label.use_sequence");
        for (ArgumentI arg : this.params) {
            String name = arg.getName();
            if (!name.equals(alignToParamName)) continue;
            String seqName = arg.getValue();
            SequenceI seq = this.alignment.findName(seqName);
            return seq;
        }
        return null;
    }

    protected String getFilePath(File resultFile, boolean isInCygwin) {
        int colon;
        String path = resultFile.getAbsolutePath();
        if (Platform.isWindows() && isInCygwin && (colon = (path = path.replaceAll("\\" + File.separator, "/")).indexOf(58)) > 0) {
            String drive = path.substring(0, colon);
            path = path.replaceAll(drive + ":", "/cygdrive/" + drive);
        }
        return path;
    }

    void deleteHmmSequences(AnnotatedCollectionI ac) {
        List<SequenceI> hmmSeqs = ac.getHmmSequences();
        for (SequenceI hmmSeq : hmmSeqs) {
            if (ac instanceof SequenceGroup) {
                ((SequenceGroup)ac).deleteSequence(hmmSeq, false);
                AnnotatedCollectionI context = ac.getContext();
                if (context == null || !(context instanceof AlignmentI)) continue;
                ((AlignmentI)context).deleteSequence(hmmSeq);
                continue;
            }
            ((AlignmentI)ac).deleteSequence(hmmSeq);
        }
    }

    void renameDuplicates(AlignmentI al) {
        int j;
        int i;
        SequenceI[] seqs = al.getSequencesArray();
        ArrayList<Boolean> wasRenamed = new ArrayList<Boolean>();
        for (SequenceI seq : seqs) {
            wasRenamed.add(false);
        }
        for (i = 0; i < seqs.length; ++i) {
            for (j = 0; j < seqs.length; ++j) {
                if (!seqs[i].getName().equals(seqs[j].getName()) || i == j || ((Boolean)wasRenamed.get(j)).booleanValue()) continue;
                wasRenamed.set(i, true);
                String range = "/" + seqs[j].getStart() + "-" + seqs[j].getEnd();
                seqs[j].setName(seqs[j].getName() + range + range);
            }
            if (!((Boolean)wasRenamed.get(i)).booleanValue()) continue;
            String range = "/" + seqs[i].getStart() + "-" + seqs[i].getEnd();
            seqs[i].setName(seqs[i].getName() + range + range);
        }
        for (i = 0; i < seqs.length; ++i) {
            for (j = 0; j < seqs.length; ++j) {
                if (!seqs[i].getName().equals(seqs[j].getName()) || i == j) continue;
                al.deleteSequence(j);
            }
        }
    }
}

