/*
 * Decompiled with CFR 0.152.
 */
package jalview.hmmer;

import jalview.analysis.AlignmentSorter;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.AlignmentOrder;
import jalview.datamodel.AlignmentView;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.HiddenMarkovModel;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.gui.SplitFrame;
import jalview.hmmer.HmmerCommand;
import jalview.io.DataSourceType;
import jalview.io.StockholmFile;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.viewmodel.seqfeatures.FeatureRendererSettings;
import jalview.ws.params.ArgumentI;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class HMMAlign
extends HmmerCommand {
    static final String HMMALIGN = "hmmalign";
    private final AlignmentI dataset;

    public HMMAlign(AlignFrame af, List<ArgumentI> args) {
        super(af, args);
        this.dataset = this.alignment.getDataset() != null ? this.alignment.getDataset() : null;
    }

    @Override
    public void run() {
        HiddenMarkovModel hmm = this.getHmmProfile();
        long msgId = System.currentTimeMillis();
        this.af.setProgressBar(MessageManager.getString("status.running_hmmalign"), msgId);
        this.alignment.padGaps();
        AlignmentView msa = this.af.gatherSequencesForAlignment();
        SequenceI[][] subAlignments = msa.getVisibleContigs(this.alignment.getGapCharacter());
        ArrayList<AlignmentOrder> allOrders = new ArrayList<AlignmentOrder>();
        SequenceI[][] allResults = new SequenceI[subAlignments.length][];
        int job = 0;
        for (SequenceI[] seqs : subAlignments) {
            Hashtable sequencesHash = this.stashSequences(seqs);
            try {
                File modelFile = FileUtils.createTempFile("hmm", ".hmm");
                File alignmentFile = FileUtils.createTempFile("output", ".sto");
                File resultFile = FileUtils.createTempFile("input", ".sto");
                this.exportStockholm(seqs, alignmentFile.getAbsoluteFile(), null);
                this.exportHmm(hmm, modelFile.getAbsoluteFile());
                boolean ran = this.runCommand(modelFile, alignmentFile, resultFile);
                if (!ran) {
                    JvOptionPane.showInternalMessageDialog(this.af, MessageManager.formatMessage("warn.command_failed", HMMALIGN));
                    return;
                }
                SequenceI[] result = this.importData(resultFile, allOrders);
                this.recoverSequences(sequencesHash, result);
                allResults[job] = result;
                modelFile.delete();
                alignmentFile.delete();
                resultFile.delete();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++job;
        }
        String title = "hmmalign to " + hmm.getConsensusSequence().getName();
        this.displayResults(allResults, allOrders, msa, title);
        this.af.setProgressBar("", msgId);
    }

    private boolean runCommand(File modelFile, File alignmentFile, File resultFile) throws IOException {
        String command = this.getCommandPath(HMMALIGN);
        if (command == null) {
            return false;
        }
        ArrayList<String> args = new ArrayList<String>();
        args.add(command);
        if (this.params != null) {
            for (ArgumentI arg : this.params) {
                String name = arg.getName();
                if (!MessageManager.getString("label.trim_termini").equals(name)) continue;
                args.add("--trim");
            }
        }
        args.add("-o");
        args.add(this.getFilePath(resultFile, true));
        args.add(this.getFilePath(modelFile, true));
        args.add(this.getFilePath(alignmentFile, true));
        return this.runCommand(args);
    }

    private SequenceI[] importData(File resultFile, List<AlignmentOrder> allOrders) throws IOException {
        StockholmFile file = new StockholmFile(this.getFilePath(resultFile, false), DataSourceType.FILE);
        SequenceI[] result = file.getSeqsAsArray();
        AlignmentOrder msaorder = new AlignmentOrder(result);
        AlignmentSorter.recoverOrder(result);
        allOrders.add(msaorder);
        return result;
    }

    private void displayResults(SequenceI[][] allResults, List<AlignmentOrder> allOrders, AlignmentView msa, String title) {
        AlignmentOrder[] arrOrders = allOrders.toArray(new AlignmentOrder[allOrders.size()]);
        Object[] newview = msa.getUpdatedView(allResults, arrOrders, this.alignment.getGapCharacter());
        SequenceI[] seqs = (SequenceI[])newview[0];
        HiddenColumns hidden = (HiddenColumns)newview[1];
        Alignment al = new Alignment(seqs);
        al.setProperty("Alignment Program", HMMALIGN);
        if (this.dataset != null) {
            al.setDataset(this.dataset);
        }
        this.displayInNewFrame(al, allOrders, hidden, title);
    }

    private void displayInNewFrame(AlignmentI al, List<AlignmentOrder> alorders, HiddenColumns hidden, String title) {
        AlignFrame alignFrame = new AlignFrame(al, hidden, 700, 500);
        alignFrame.setTitle(title);
        FeatureRendererSettings featureSettings = this.af.getFeatureRenderer().getSettings();
        alignFrame.getFeatureRenderer().transferSettings(featureSettings);
        this.addSortByMenuItems(alignFrame, alorders);
        AlignFrame requestedBy = this.af;
        if (requestedBy != null && requestedBy.getSplitViewContainer() != null && requestedBy.getSplitViewContainer().getComplement(requestedBy) != null) {
            AlignmentI complement = requestedBy.getSplitViewContainer().getComplement(requestedBy);
            String complementTitle = requestedBy.getSplitViewContainer().getComplementTitle(requestedBy);
            Alignment copyComplement = new Alignment(complement);
            copyComplement.setGapCharacter(complement.getGapCharacter());
            copyComplement.setDataset(complement.getDataset());
            copyComplement.alignAs(al);
            if (copyComplement.getHeight() > 0) {
                alignFrame.setTitle(this.af.getTitle());
                AlignFrame af2 = new AlignFrame(copyComplement, 700, 500);
                af2.setTitle(complementTitle);
                String linkedTitle = MessageManager.getString("label.linked_view_title");
                SplitFrame splitFrame = new SplitFrame(al.isNucleotide() ? alignFrame : af2, al.isNucleotide() ? af2 : alignFrame);
                Desktop.addInternalFrame(splitFrame, linkedTitle, -1, -1);
                return;
            }
        }
        Desktop.addInternalFrame(alignFrame, alignFrame.getTitle(), 700, 500);
    }

    protected void addSortByMenuItems(AlignFrame alignFrame, List<AlignmentOrder> alorders) {
        if (alorders.size() == 1) {
            alignFrame.addSortByOrderMenuItem("hmmalign Ordering", alorders.get(0));
        } else {
            int i;
            ArrayList<String> names = new ArrayList<String>();
            int l = alorders.size();
            for (i = 0; i < l; ++i) {
                String orderName = " Region " + i;
                int j = i + 1;
                while (j < l) {
                    if (alorders.get(i).equals(alorders.get(j))) {
                        alorders.remove(j);
                        --l;
                        orderName = orderName + "," + j;
                        continue;
                    }
                    ++j;
                }
                if (i == 0 && j == 1) {
                    names.add("");
                    continue;
                }
                names.add(orderName);
            }
            l = alorders.size();
            for (i = 0; i < l; ++i) {
                alignFrame.addSortByOrderMenuItem(HMMALIGN + (String)names.get(i) + " Ordering", alorders.get(i));
            }
        }
    }
}

