/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.util.MessageManager;
import jalview.ws.params.ParamDatastoreI;
import jalview.ws.params.ParamManager;
import jalview.ws.params.WsParamSetI;
import jalview.xml.binding.jalview.ObjectFactory;
import jalview.xml.binding.jalview.WebServiceParameterSet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class WsParamSetManager
implements ParamManager {
    private static final String WS_PARAM_FILES = "WS_PARAM_FILES";
    Hashtable<String, ParamDatastoreI> paramparsers = new Hashtable();

    @Override
    public WsParamSetI[] getParameterSet(String name, String serviceUrl, boolean modifiable, boolean unmodifiable) {
        String files = Cache.getProperty(WS_PARAM_FILES);
        if (files == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(files, "|");
        String pfile = null;
        ArrayList<WsParamSetI> params = new ArrayList<WsParamSetI>();
        while (st.hasMoreTokens()) {
            pfile = st.nextToken();
            try {
                WsParamSetI[] pset;
                for (WsParamSetI p : pset = this.parseParamFile(pfile)) {
                    boolean add = false;
                    if (serviceUrl != null) {
                        for (String url : p.getApplicableUrls()) {
                            if (!url.equals(serviceUrl)) continue;
                            add = true;
                        }
                    } else {
                        add = true;
                    }
                    add &= modifiable == p.isModifiable() || unmodifiable == !p.isModifiable();
                    if (!(add &= name == null || p.getName().equals(name))) continue;
                    params.add(p);
                }
            }
            catch (IOException e) {
                Cache.log.info((Object)("Failed to parse parameter file " + pfile + " (Check that all " + WS_PARAM_FILES + " entries are valid!)"), (Throwable)e);
            }
        }
        return params.toArray(new WsParamSetI[0]);
    }

    private WsParamSetI[] parseParamFile(String filename) throws IOException {
        ArrayList<WsParamSetI> psets = new ArrayList<WsParamSetI>();
        InputStreamReader is = new InputStreamReader((InputStream)new FileInputStream(new File(filename)), "UTF-8");
        WebServiceParameterSet wspset = null;
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"jalview.xml.binding.jalview");
            Unmarshaller um = jc.createUnmarshaller();
            XMLStreamReader streamReader = XMLInputFactory.newInstance().createXMLStreamReader(is);
            JAXBElement jbe = um.unmarshal(streamReader, WebServiceParameterSet.class);
            wspset = (WebServiceParameterSet)jbe.getValue();
        }
        catch (Exception ex) {
            throw new IOException(ex);
        }
        if (wspset != null && wspset.getParameters().length() > 0) {
            List<String> urls = wspset.getServiceURL();
            String[] urlArray = urls.toArray(new String[urls.size()]);
            for (String url : urls) {
                WsParamSetI pset;
                ParamDatastoreI parser = this.paramparsers.get(url);
                if (parser == null || (pset = parser.parseServiceParameterFile(wspset.getName(), wspset.getDescription(), urlArray, wspset.getParameters())) == null) continue;
                pset.setSourceFile(filename);
                psets.add(pset);
                break;
            }
        }
        return psets.toArray(new WsParamSetI[0]);
    }

    @Override
    public void storeParameterSet(WsParamSetI parameterSet) {
        String filename = parameterSet.getSourceFile();
        File outfile = null;
        try {
            if (filename != null && !(outfile = new File(filename)).canWrite()) {
                Cache.log.warn((Object)("Can't write to " + filename + " - Prompting for new file to write to."));
                filename = null;
            }
        }
        catch (Exception e) {
            filename = null;
        }
        ParamDatastoreI parser = null;
        for (String urls : parameterSet.getApplicableUrls()) {
            if (parser != null) continue;
            parser = this.paramparsers.get(urls);
        }
        if (parser == null) {
            throw new Error(MessageManager.getString("error.implementation_error_cannot_find_marshaller_for_param_set"));
        }
        if (filename == null) {
            JalviewFileChooser chooser = new JalviewFileChooser("wsparams", "Web Service Parameter File");
            chooser.setFileView(new JalviewFileView());
            chooser.setDialogTitle(MessageManager.getString("label.choose_filename_for_param_file"));
            chooser.setToolTipText(MessageManager.getString("action.save"));
            int value = chooser.showSaveDialog(Desktop.instance);
            if (value == 0) {
                outfile = chooser.getSelectedFile();
                Cache.setProperty("LAST_DIRECTORY", outfile.getParent());
                filename = outfile.getAbsolutePath();
                if (!filename.endsWith(".wsparams")) {
                    filename = filename.concat(".wsparams");
                    outfile = new File(filename);
                }
            }
        }
        if (outfile != null) {
            String paramFiles = Cache.getDefault(WS_PARAM_FILES, filename);
            if (paramFiles.indexOf(filename) == -1) {
                if (paramFiles.length() > 0) {
                    paramFiles = paramFiles.concat("|");
                }
                paramFiles = paramFiles.concat(filename);
            }
            Cache.setProperty(WS_PARAM_FILES, paramFiles);
            WebServiceParameterSet paramxml = new WebServiceParameterSet();
            paramxml.setName(parameterSet.getName());
            paramxml.setDescription(parameterSet.getDescription());
            for (String url : parameterSet.getApplicableUrls()) {
                paramxml.getServiceURL().add(url);
            }
            paramxml.setVersion("1.0");
            try {
                paramxml.setParameters(parser.generateServiceParameterFile(parameterSet));
                PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outfile), "UTF-8"));
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{WebServiceParameterSet.class});
                Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
                jaxbMarshaller.marshal(new ObjectFactory().createWebServiceParameterSet(paramxml), (Writer)out);
                out.close();
                parameterSet.setSourceFile(filename);
            }
            catch (Exception e) {
                Cache.log.error((Object)("Couldn't write parameter file to " + outfile), (Throwable)e);
            }
        }
    }

    @Override
    public void deleteParameterSet(WsParamSetI parameterSet) {
        String filename = parameterSet.getSourceFile();
        if (filename == null || filename.trim().length() < 1) {
            return;
        }
        String paramFiles = Cache.getDefault(WS_PARAM_FILES, "");
        if (paramFiles.indexOf(filename) > -1) {
            String nparamFiles = new String();
            StringTokenizer st = new StringTokenizer(paramFiles, "|");
            while (st.hasMoreElements()) {
                String fl = st.nextToken();
                if (fl.equals(filename)) continue;
                nparamFiles = nparamFiles.concat("|").concat(fl);
            }
            Cache.setProperty(WS_PARAM_FILES, nparamFiles);
        }
        try {
            File pfile = new File(filename);
            if (pfile.exists() && pfile.canWrite() && JvOptionPane.showConfirmDialog(Desktop.instance, "Delete the preset's file, too ?", "Delete User Preset ?", 2) == 0) {
                pfile.delete();
            }
        }
        catch (Exception e) {
            Cache.log.error((Object)"Exception when trying to delete webservice user preset: ", (Throwable)e);
        }
    }

    @Override
    public void registerParser(String hosturl, ParamDatastoreI paramdataStore) {
        this.paramparsers.put(hosturl, paramdataStore);
    }
}

