/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.datamodel.VisibleContigsIterator;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.Desktop;
import jalview.gui.JvOptionPane;
import jalview.io.VamsasAppDatastore;
import jalview.structure.SelectionListener;
import jalview.structure.SelectionSource;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasListener;
import jalview.structure.VamsasSource;
import jalview.util.MessageManager;
import jalview.viewmodel.AlignmentViewport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.swing.JInternalFrame;
import uk.ac.vamsas.client.ClientHandle;
import uk.ac.vamsas.client.IClient;
import uk.ac.vamsas.client.IClientDocument;
import uk.ac.vamsas.client.IClientFactory;
import uk.ac.vamsas.client.InvalidSessionDocumentException;
import uk.ac.vamsas.client.UserHandle;
import uk.ac.vamsas.client.VorbaId;
import uk.ac.vamsas.client.picking.IMessageHandler;
import uk.ac.vamsas.client.picking.IPickManager;
import uk.ac.vamsas.client.picking.Message;
import uk.ac.vamsas.client.picking.MouseOverMessage;
import uk.ac.vamsas.client.picking.SelectionMessage;
import uk.ac.vamsas.client.simpleclient.SimpleClient;
import uk.ac.vamsas.client.simpleclient.SimpleClientConfig;
import uk.ac.vamsas.client.simpleclient.SimpleClientFactory;
import uk.ac.vamsas.objects.core.Entry;
import uk.ac.vamsas.objects.core.Input;
import uk.ac.vamsas.objects.core.Pos;
import uk.ac.vamsas.objects.core.RangeType;
import uk.ac.vamsas.objects.core.Seg;
import uk.ac.vamsas.objects.utils.Range;

public class VamsasApplication
implements SelectionSource,
VamsasSource {
    IClient vclient = null;
    ClientHandle app = null;
    UserHandle user = null;
    Desktop jdesktop = null;
    private boolean inInitialUpdate = true;
    private boolean promptUser = true;
    boolean firstUpdate = false;
    IdentityHashMap jv2vobj = null;
    Hashtable vobj2jv = null;
    Hashtable alRedoState = null;
    boolean errorsDuringUpdate = false;
    boolean errorsDuringAppUpdate = false;
    Hashtable _backup_vobj2jv;
    IdentityHashMap _backup_jv2vobj;
    private boolean joinedSession = false;
    private VamsasListener picker = null;
    private SelectionListener selecter;

    public VamsasApplication(Desktop jdesktop, File sessionPath, String sessionName) {
        this.jdesktop = jdesktop;
        this.initClientSession(null, sessionPath, sessionName);
    }

    private static IClientFactory getClientFactory() throws IOException {
        return new SimpleClientFactory();
    }

    public VamsasApplication(Desktop jdesktop) {
        this.jdesktop = jdesktop;
        this.initClientSession(null, null);
    }

    public VamsasApplication(Desktop jdesktop, String sessionUrl) {
        this.jdesktop = jdesktop;
        this.initClientSession(sessionUrl, null);
    }

    public static String[] getSessionList() throws Exception {
        return VamsasApplication.getClientFactory().getCurrentSessions();
    }

    private void initClientSession(String sess, File vamsasDocument) {
        this.initClientSession(sess, vamsasDocument, null);
    }

    private boolean initClientSession(String sess, File vamsasDocument, String newDocSessionName) {
        try {
            block8: {
                this.app = this.getJalviewHandle();
                IClientFactory clientfactory = VamsasApplication.getClientFactory();
                if (vamsasDocument != null) {
                    if (sess != null) {
                        throw new Error(MessageManager.getString("error.implementation_error_cannot_import_vamsas_doc"));
                    }
                    try {
                        if (newDocSessionName != null) {
                            this.vclient = clientfactory.openAsNewSessionIClient(this.app, vamsasDocument, newDocSessionName);
                            break block8;
                        }
                        this.vclient = clientfactory.openAsNewSessionIClient(this.app, vamsasDocument);
                    }
                    catch (InvalidSessionDocumentException e) {
                        JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("label.vamsas_doc_couldnt_be_opened_as_new_session"), MessageManager.getString("label.vamsas_document_import_failed"), 0);
                    }
                } else {
                    this.vclient = sess == null ? clientfactory.getNewSessionIClient(this.app) : clientfactory.getIClient(this.app, sess);
                }
            }
            this.setVclientConfig();
            this.user = this.vclient.getUserHandle();
        }
        catch (Exception e) {
            Cache.log.error((Object)"Couldn't instantiate vamsas client !", (Throwable)e);
            return false;
        }
        return true;
    }

    private void setVclientConfig() {
        if (this.vclient == null) {
            return;
        }
        try {
            if (this.vclient instanceof SimpleClient) {
                SimpleClientConfig cfg = ((SimpleClient)this.vclient).getSimpleClientConfig();
                cfg._validatemergedroots = false;
                cfg._validateupdatedroots = true;
            }
        }
        catch (Error e) {
            Cache.log.warn((Object)"Probable SERIOUS VAMSAS client incompatibility - carrying on regardless", (Throwable)e);
        }
        catch (Exception e) {
            Cache.log.warn((Object)"Probable VAMSAS client incompatibility - carrying on regardless", (Throwable)e);
        }
    }

    private ClientHandle getJalviewHandle() {
        return new ClientHandle("jalview.bin.Jalview", Cache.getProperty("VERSION"));
    }

    public boolean inSession() {
        return this.vclient != null;
    }

    public void initial_update() {
        if (!this.inSession()) {
            throw new Error(MessageManager.getString("error.implementation_error_vamsas_operation_not_init"));
        }
        this.addDocumentUpdateHandler();
        this.addStoreDocumentHandler();
        this.startSession();
        this.inInitialUpdate = true;
        Cache.log.debug((Object)"Jalview loading the Vamsas Session for the first time.");
        this.dealWithDocumentUpdate(false);
        this.inInitialUpdate = false;
        Cache.log.debug((Object)"... finished update for the first time.");
    }

    protected void updateJalviewGui() {
        JInternalFrame[] frames = this.jdesktop.getAllFrames();
        if (frames == null) {
            return;
        }
        try {
            for (int i = frames.length - 1; i > -1; --i) {
                if (!(frames[i] instanceof AlignFrame)) continue;
                AlignFrame af = (AlignFrame)frames[i];
                af.alignPanel.alignmentChanged();
            }
        }
        catch (Exception e) {
            Cache.log.warn((Object)"Exception whilst refreshing jalview windows after a vamsas document update.", (Throwable)e);
        }
    }

    public void push_update() {
        Thread udthread = new Thread(new Runnable(){

            @Override
            public void run() {
                Cache.log.info((Object)"Jalview updating to the Vamsas Session.");
                VamsasApplication.this.dealWithDocumentUpdate(true);
                Cache.log.info((Object)"Jalview finished updating to the Vamsas Session.");
            }
        });
        udthread.start();
    }

    public void end_session() {
        this.end_session(true);
    }

    public void end_session(boolean promptUser) {
        if (!this.inSession()) {
            throw new Error(MessageManager.getString("error.jalview_no_connected_vamsas_session"));
        }
        Cache.log.info((Object)"Jalview disconnecting from the Vamsas Session.");
        try {
            if (this.joinedSession) {
                boolean ourprompt = this.promptUser;
                this.promptUser = promptUser;
                this.vclient.finalizeClient();
                Cache.log.info((Object)"Jalview has left the session.");
                this.promptUser = ourprompt;
            } else {
                Cache.log.warn((Object)"JV Client leaving a session that's its not joined yet.");
            }
            this.joinedSession = false;
            this.vclient = null;
            this.app = null;
            this.user = null;
            this.jv2vobj = null;
            this.vobj2jv = null;
        }
        catch (Exception e) {
            Cache.log.error((Object)"Vamsas Session finalization threw exceptions!", (Throwable)e);
        }
    }

    public void updateJalview(IClientDocument cdoc) {
        Cache.log.debug((Object)"Jalview updating from sesion document ..");
        this.ensureJvVamsas();
        VamsasAppDatastore vds = new VamsasAppDatastore(cdoc, this.vobj2jv, this.jv2vobj, this.baseProvEntry(), this.alRedoState);
        try {
            vds.updateToJalview();
        }
        catch (Exception e) {
            Cache.log.error((Object)"Failed to update Jalview from vamsas document.", (Throwable)e);
        }
        try {
            if (this.firstUpdate) {
                vds.updateJalviewFromAppdata();
            }
        }
        catch (Exception e) {
            Cache.log.error((Object)"Exception when updating Jalview settings from Appdata.", (Throwable)e);
        }
        Cache.log.debug((Object)".. finished updating from sesion document.");
    }

    private void ensureJvVamsas() {
        if (this.jv2vobj == null) {
            this.jv2vobj = new IdentityHashMap();
            this.vobj2jv = new Hashtable();
            this.alRedoState = new Hashtable();
            this.firstUpdate = true;
        }
    }

    public int updateVamsasDocument(IClientDocument doc) {
        int storedviews = 0;
        this.ensureJvVamsas();
        this.errorsDuringUpdate = false;
        this.errorsDuringAppUpdate = false;
        this.backup_objectMapping();
        VamsasAppDatastore vds = new VamsasAppDatastore(doc, this.vobj2jv, this.jv2vobj, this.baseProvEntry(), this.alRedoState);
        JInternalFrame[] frames = Desktop.desktop.getAllFrames();
        if (frames == null) {
            return 0;
        }
        Hashtable<String, AlignFrame> skipList = new Hashtable<String, AlignFrame>();
        Hashtable<String, AlignFrame> viewset = new Hashtable<String, AlignFrame>();
        try {
            for (int i = frames.length - 1; i > -1; --i) {
                AlignFrame af;
                if (!(frames[i] instanceof AlignFrame) || viewset.containsKey((af = (AlignFrame)frames[i]).getViewport().getSequenceSetId())) continue;
                boolean stored = false;
                try {
                    stored = vds.storeVAMSAS(af.getViewport(), af.getTitle());
                }
                catch (Exception e) {
                    this.errorsDuringUpdate = true;
                    Cache.log.error((Object)("Exception synchronizing " + af.getTitle() + " " + (af.getViewport().getViewName() == null ? "" : " view " + af.getViewport().getViewName()) + " to document."), (Throwable)e);
                    stored = false;
                }
                if (!stored) {
                    skipList.put(af.getViewport().getSequenceSetId(), af);
                    continue;
                }
                ++storedviews;
                viewset.put(af.getViewport().getSequenceSetId(), af);
            }
            for (AlignFrame af : viewset.values()) {
                vds.storeSequenceMappings(af.getViewport(), af.getTitle());
            }
        }
        catch (Exception e) {
            Cache.log.error((Object)"Exception synchronizing Views to Document :", (Throwable)e);
            this.errorsDuringUpdate = true;
        }
        try {
            if (viewset.size() > 0) {
                vds.setSkipList(skipList);
                vds.updateJalviewClientAppdata();
            }
        }
        catch (Exception e) {
            Cache.log.error((Object)"Client Appdata Write exception", (Throwable)e);
            this.errorsDuringAppUpdate = true;
        }
        vds.clearSkipList();
        return storedviews;
    }

    private Entry baseProvEntry() {
        Entry pentry = new Entry();
        pentry.setUser(this.user.getFullName());
        pentry.setApp(this.app.getClientUrn());
        pentry.setDate(new Date());
        pentry.setAction("created");
        return pentry;
    }

    protected int dealWithDocumentUpdate(boolean fromJalview) {
        int storedviews = 0;
        Cache.log.debug((Object)"Updating jalview from changed vamsas document.");
        this.disableGui(true);
        try {
            long time = System.currentTimeMillis();
            IClientDocument cdoc = this.vclient.getClientDocument();
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Time taken to get ClientDocument = " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            if (fromJalview) {
                storedviews += this.updateVamsasDocument(cdoc);
                if (Cache.log.isDebugEnabled()) {
                    Cache.log.debug((Object)("Time taken to update Vamsas Document from jalview\t= " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
                cdoc.setVamsasRoots(cdoc.getVamsasRoots());
                if (Cache.log.isDebugEnabled()) {
                    Cache.log.debug((Object)("Time taken to set Document Roots\t\t= " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
            } else {
                this.updateJalview(cdoc);
                if (Cache.log.isDebugEnabled()) {
                    Cache.log.debug((Object)("Time taken to update Jalview from vamsas document Roots\t= " + (System.currentTimeMillis() - time)));
                    time = System.currentTimeMillis();
                }
            }
            this.vclient.updateDocument(cdoc);
            if (Cache.log.isDebugEnabled()) {
                Cache.log.debug((Object)("Time taken to update Session Document\t= " + (System.currentTimeMillis() - time)));
                time = System.currentTimeMillis();
            }
            cdoc = null;
        }
        catch (Exception ee) {
            System.err.println("Exception whilst updating :");
            ee.printStackTrace(System.err);
            this.recover_objectMappingBackup();
            storedviews = 0;
        }
        Cache.log.debug((Object)"Finished updating from document change.");
        this.disableGui(false);
        return storedviews;
    }

    private void addDocumentUpdateHandler() {
        final VamsasApplication client = this;
        this.vclient.addDocumentUpdateHandler(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cache.log.debug((Object)"Dealing with document update event.");
                client.dealWithDocumentUpdate(false);
                Cache.log.debug((Object)"finished dealing with event.");
            }
        });
        Cache.log.debug((Object)"Added Jalview handler for vamsas document updates.");
    }

    private void addStoreDocumentHandler() {
        final VamsasApplication client = this;
        this.vclient.addVorbaEventHandler("uk.ac.vamas.client.DocumentRequestToCloseEvent", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (client.promptUser) {
                    Cache.log.debug((Object)"Asking user if the vamsas session should be stored.");
                    int reply = JvOptionPane.showInternalConfirmDialog(Desktop.desktop, "The current VAMSAS session has unsaved data - do you want to save it ?", "VAMSAS Session Shutdown", 0, 3);
                    if (reply == 0) {
                        Cache.log.debug((Object)"Prompting for vamsas store filename.");
                        Desktop.instance.vamsasSave_actionPerformed(null);
                        Cache.log.debug((Object)"Finished attempt at storing document.");
                    }
                    Cache.log.debug((Object)"finished dealing with REQUESTTOCLOSE event.");
                } else {
                    Cache.log.debug((Object)"Ignoring store document request (promptUser==false)");
                }
            }
        });
        Cache.log.debug((Object)"Added Jalview handler for vamsas document updates.");
    }

    public void disableGui(boolean b) {
    }

    public void backup_objectMapping() {
        this._backup_vobj2jv = new Hashtable(this.vobj2jv);
        this._backup_jv2vobj = new IdentityHashMap(this.jv2vobj);
    }

    public void recover_objectMappingBackup() {
        if (this._backup_vobj2jv == null) {
            if (this.inInitialUpdate) {
                return;
            }
            throw new Error(MessageManager.getString("error.implementation_error_cannot_recover_vamsas_object_mappings"));
        }
        this.jv2vobj.clear();
        for (Map.Entry mp : this._backup_jv2vobj.entrySet()) {
            this.jv2vobj.put(mp.getKey(), mp.getValue());
        }
        for (Map.Entry mp : this._backup_vobj2jv.entrySet()) {
            this.vobj2jv.put(mp.getKey(), mp.getValue());
        }
    }

    private void startSession() {
        if (this.inSession()) {
            try {
                this.vclient.joinSession();
                this.joinedSession = true;
            }
            catch (Exception e) {
                Cache.log.error((Object)"Failed to join vamsas session.", (Throwable)e);
                this.vclient = null;
            }
            try {
                final IPickManager pm = this.vclient.getPickManager();
                final StructureSelectionManager ssm = StructureSelectionManager.getStructureSelectionManager(Desktop.instance);
                final VamsasApplication me = this;
                pm.registerMessageHandler(new IMessageHandler(){
                    String last = null;

                    public void handleMessage(Message message) {
                        if (VamsasApplication.this.vobj2jv == null) {
                            return;
                        }
                        if (message instanceof MouseOverMessage) {
                            MouseOverMessage mm = (MouseOverMessage)message;
                            String mstring = mm.getVorbaID() + " " + mm.getPosition();
                            if (this.last != null && mstring.equals(this.last)) {
                                return;
                            }
                            Object jvobj = VamsasApplication.this.vobj2jv.get(mm.getVorbaID());
                            if (jvobj != null && jvobj instanceof SequenceI) {
                                this.last = mstring;
                                ssm.mouseOverVamsasSequence((SequenceI)jvobj, mm.getPosition(), me);
                            }
                        }
                        if (message instanceof SelectionMessage) {
                            Object[] jvobjs;
                            SelectionMessage sm = (SelectionMessage)message;
                            sm.validate();
                            System.err.println("Received\n" + sm.getRawMessage());
                            Object[] objectArray = jvobjs = sm.getVorbaIDs() == null ? null : new Object[sm.getVorbaIDs().length];
                            if (jvobjs == null) {
                                ssm.sendSelection(null, null, null, me);
                                return;
                            }
                            Class<?> type = null;
                            boolean send = true;
                            for (int o = 0; o < jvobjs.length; ++o) {
                                jvobjs[o] = VamsasApplication.this.vobj2jv.get(sm.getVorbaIDs()[o]);
                                if (jvobjs[o] == null) continue;
                                if (type == null) {
                                    type = jvobjs[o].getClass();
                                }
                                if (type == jvobjs[o].getClass()) continue;
                                send = false;
                            }
                            SequenceGroup jselection = null;
                            ColumnSelection colsel = null;
                            if (type == Alignment.class && jvobjs.length == 1) {
                                send = true;
                            }
                            if (type == Sequence.class) {
                                Sequence seq;
                                boolean aligned = ((Sequence)jvobjs[0]).getDatasetSequence() != null;
                                int maxWidth = 0;
                                if (aligned) {
                                    jselection = new SequenceGroup();
                                    seq = (Sequence)jvobjs[0];
                                    jselection.addSequence(seq, false);
                                    maxWidth = seq.getLength();
                                }
                                for (int c = 1; aligned && jvobjs.length > 1 && c < jvobjs.length; ++c) {
                                    if (((Sequence)jvobjs[c]).getDatasetSequence() == null) {
                                        aligned = false;
                                        continue;
                                    }
                                    seq = (Sequence)jvobjs[c];
                                    jselection.addSequence(seq, false);
                                    if (maxWidth >= seq.getLength()) continue;
                                    maxWidth = seq.getLength();
                                }
                                if (!aligned) {
                                    jselection = null;
                                    if (jvobjs.length == 1) {
                                        // empty if block
                                    }
                                } else {
                                    jselection.setStartRes(0);
                                    jselection.setEndRes(maxWidth);
                                    if (sm.getRanges() != null) {
                                        int[] prange = Range.getBounds((RangeType)sm.getRanges());
                                        jselection.setStartRes(prange[0] - 1);
                                        jselection.setEndRes(prange[1] - 1);
                                        prange = Range.getIntervals((RangeType)sm.getRanges());
                                        colsel = new ColumnSelection();
                                        for (int p = 0; p < prange.length; p += 2) {
                                            int u;
                                            int d = prange[p] <= prange[p + 1] ? 1 : -1;
                                            int l = d < 0 ? 1 : 0;
                                            int n = u = d > 0 ? 1 : 0;
                                            if (jselection.getStartRes() > 0 && prange[p + l] == jselection.getStartRes()) {
                                                jselection.setStartRes(prange[p + l] - 1);
                                            }
                                            if (jselection.getEndRes() <= maxWidth && prange[p + u] == jselection.getEndRes() + 2) {
                                                jselection.setEndRes(prange[p + u] - 1);
                                            }
                                            int er = prange[p + 1];
                                            int de = er + d;
                                            for (int sr = prange[p]; sr != de; sr += d) {
                                                colsel.addElement(sr - 1);
                                            }
                                        }
                                    }
                                    send = true;
                                }
                            }
                            if (send) {
                                ssm.sendSelection(jselection, colsel, null, me);
                            }
                            for (int c = 0; c < jvobjs.length; ++c) {
                                jvobjs[c] = null;
                            }
                            jvobjs = null;
                            return;
                        }
                    }
                });
                this.picker = new VamsasListener(){
                    SequenceI last = null;
                    int i = -1;

                    @Override
                    public void mouseOverSequence(SequenceI seq, int index, VamsasSource source) {
                        VorbaId v;
                        if (VamsasApplication.this.jv2vobj == null) {
                            return;
                        }
                        if ((seq != this.last || this.i != index) && (v = (VorbaId)VamsasApplication.this.jv2vobj.get(seq)) != null) {
                            this.last = seq;
                            this.i = index;
                            MouseOverMessage message = new MouseOverMessage(v.getId(), index);
                            pm.sendMessage((Message)message);
                        }
                    }
                };
                this.selecter = new SelectionListener(){

                    @Override
                    public void selection(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
                        if (VamsasApplication.this.vobj2jv == null) {
                            Cache.log.warn((Object)"Selection listener still active for dead session.");
                            return;
                        }
                        if (source != me) {
                            AlignmentI visal = null;
                            if (source instanceof AlignViewport) {
                                visal = ((AlignmentViewport)((Object)source)).getAlignment();
                            }
                            Object sm = null;
                            if (!(seqsel != null && seqsel.getSize() != 0 || colsel != null && colsel.getSelected() != null && colsel.getSelected().size() != 0)) {
                                sm = source instanceof AlignViewport ? new SelectionMessage("jalview", new String[]{((AlignmentViewport)((Object)source)).getSequenceSetId()}, null, true) : new SelectionMessage("jalview", null, null, true);
                            } else {
                                String[] vobj = new String[seqsel.getSize()];
                                int o = 0;
                                for (SequenceI sequenceI : seqsel.getSequences(null)) {
                                    VorbaId v = (VorbaId)VamsasApplication.this.jv2vobj.get(sequenceI);
                                    if (v == null) continue;
                                    vobj[o++] = v.toString();
                                }
                                if (o < vobj.length) {
                                    String[] t = vobj;
                                    vobj = new String[o];
                                    System.arraycopy(t, 0, vobj, 0, o);
                                    t = null;
                                }
                                Input range = null;
                                if (seqsel != null && colsel != null) {
                                    range = new Input();
                                    if (colsel.getSelected() != null && colsel.getSelected().size() > 0 && visal != null && seqsel.getSize() == visal.getHeight()) {
                                        for (Integer ival : colsel.getSelected()) {
                                            Pos p = new Pos();
                                            p.setI(ival + 1);
                                            range.addPos(p);
                                        }
                                    } else {
                                        VisibleContigsIterator visibleContigsIterator = hidden.getVisContigsIterator(seqsel.getStartRes(), seqsel.getEndRes() + 1, false);
                                        while (visibleContigsIterator.hasNext()) {
                                            int[] region = (int[])visibleContigsIterator.next();
                                            Seg s = new Seg();
                                            s.setStart(region[0] + 1);
                                            s.setEnd(region[1] + 1);
                                            s.setInclusive(true);
                                            range.addSeg(s);
                                        }
                                    }
                                }
                                sm = vobj.length > 0 ? new SelectionMessage("jalview", vobj, (RangeType)range) : null;
                            }
                            if (sm != null) {
                                sm.validate();
                                Cache.log.debug((Object)("Selection Message\n" + sm.getRawMessage()));
                                pm.sendMessage((Message)sm);
                            }
                        }
                    }
                };
                ssm.addStructureViewerListener(this.picker);
                ssm.addSelectionListener(this.selecter);
            }
            catch (Exception e) {
                Cache.log.error((Object)"Failed to init Vamsas Picking", (Throwable)e);
            }
        }
    }

    public String getCurrentSession() {
        if (this.vclient != null) {
            return this.vclient.getSessionUrn();
        }
        return null;
    }
}

