/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.bin.Cache;
import jalview.datamodel.Alignment;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignmentPanel;
import jalview.gui.ColourMenuHelper;
import jalview.gui.CutAndPasteTransfer;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.OOMWarning;
import jalview.gui.PaintRefresher;
import jalview.gui.StructureViewer;
import jalview.gui.ViewSelectionMenu;
import jalview.io.DataSourceType;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.jbgui.GStructureViewer;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.structure.StructureMapping;
import jalview.structures.models.AAStructureBindingModel;
import jalview.util.MessageManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JColorChooser;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public abstract class StructureViewerBase
extends GStructureViewer
implements Runnable,
ViewSelectionMenu.ViewSetProvider {
    protected List<String> _aps = new ArrayList<String>();
    protected Vector<AlignmentPanel> _alignwith = new Vector();
    protected Vector<AlignmentPanel> _colourwith = new Vector();
    private String viewId = null;
    private AlignmentPanel ap;
    protected boolean alignAddedStructures = false;
    protected volatile boolean _started = false;
    protected volatile boolean addingStructures = false;
    protected Thread worker = null;
    protected boolean allChainsSelected = false;
    protected JMenu viewSelectionMenu;
    protected volatile boolean seqColoursApplied = false;

    @Override
    public boolean isAlignAddedStructures() {
        return this.alignAddedStructures;
    }

    @Override
    public void setAlignAddedStructures(boolean alignAdded) {
        this.alignAddedStructures = alignAdded;
    }

    public boolean isLinkedWith(AlignmentPanel ap2) {
        return this._aps.contains(ap2.av.getSequenceSetId());
    }

    public boolean isUsedforaligment(AlignmentPanel ap2) {
        return this._alignwith != null && this._alignwith.contains(ap2);
    }

    public boolean isUsedforcolourby(AlignmentPanel ap2) {
        return this._colourwith != null && this._colourwith.contains(ap2);
    }

    public boolean isColouredByViewer() {
        return !this.getBinding().isColourBySequence();
    }

    public String getViewId() {
        if (this.viewId == null) {
            this.viewId = System.currentTimeMillis() + "." + this.hashCode();
        }
        return this.viewId;
    }

    protected void setViewId(String viewId) {
        this.viewId = viewId;
    }

    public abstract String getStateInfo();

    protected void buildActionMenu() {
        if (this._alignwith == null) {
            this._alignwith = new Vector();
        }
        if (this._alignwith.size() == 0 && this.ap != null) {
            this._alignwith.add(this.ap);
        }
        for (Component c : this.viewerActionMenu.getMenuComponents()) {
            if (c == this.alignStructs) continue;
            this.viewerActionMenu.remove((JMenuItem)c);
        }
    }

    public AlignmentPanel getAlignmentPanel() {
        return this.ap;
    }

    protected void setAlignmentPanel(AlignmentPanel alp) {
        this.ap = alp;
    }

    @Override
    public AlignmentPanel[] getAllAlignmentPanels() {
        AlignmentPanel[] list = new AlignmentPanel[]{};
        for (String setid : this._aps) {
            AlignmentPanel[] panels = PaintRefresher.getAssociatedPanels(setid);
            if (panels == null) continue;
            AlignmentPanel[] t = new AlignmentPanel[list.length + panels.length];
            System.arraycopy(list, 0, t, 0, list.length);
            System.arraycopy(panels, 0, t, list.length, panels.length);
            list = t;
        }
        return list;
    }

    public void addAlignmentPanel(AlignmentPanel nap) {
        if (this.getAlignmentPanel() == null) {
            this.setAlignmentPanel(nap);
        }
        if (!this._aps.contains(nap.av.getSequenceSetId())) {
            this._aps.add(nap.av.getSequenceSetId());
        }
    }

    public void removeAlignmentPanel(AlignmentPanel nap) {
        block4: {
            try {
                this._alignwith.remove(nap);
                this._colourwith.remove(nap);
                if (this.getAlignmentPanel() != nap) break block4;
                this.setAlignmentPanel(null);
                for (AlignmentPanel aps : this.getAllAlignmentPanels()) {
                    if (aps == nap) continue;
                    this.setAlignmentPanel(aps);
                    break;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.getAlignmentPanel() != null) {
            this.buildActionMenu();
        }
    }

    public void useAlignmentPanelForSuperposition(AlignmentPanel nap) {
        this.addAlignmentPanel(nap);
        if (!this._alignwith.contains(nap)) {
            this._alignwith.add(nap);
        }
    }

    public void excludeAlignmentPanelForSuperposition(AlignmentPanel nap) {
        if (this._alignwith.contains(nap)) {
            this._alignwith.remove(nap);
        }
    }

    public void useAlignmentPanelForColourbyseq(AlignmentPanel nap, boolean enableColourBySeq) {
        this.useAlignmentPanelForColourbyseq(nap);
        this.getBinding().setColourBySequence(enableColourBySeq);
        this.seqColour.setSelected(enableColourBySeq);
        this.viewerColour.setSelected(!enableColourBySeq);
    }

    public void useAlignmentPanelForColourbyseq(AlignmentPanel nap) {
        this.addAlignmentPanel(nap);
        if (!this._colourwith.contains(nap)) {
            this._colourwith.add(nap);
        }
    }

    public void excludeAlignmentPanelForColourbyseq(AlignmentPanel nap) {
        if (this._colourwith.contains(nap)) {
            this._colourwith.remove(nap);
        }
    }

    public abstract StructureViewer.ViewerType getViewerType();

    protected abstract IProgressIndicator getIProgressIndicator();

    protected void addStructure(final PDBEntry pdbentry, final SequenceI[] seqs, final String[] chains, final IProgressIndicator alignFrame) {
        if (pdbentry.getFile() == null && this.worker != null && this.worker.isAlive()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    while (StructureViewerBase.this.worker != null && StructureViewerBase.this.worker.isAlive() && StructureViewerBase.this._started) {
                        try {
                            Thread.sleep(100 + (int)Math.random() * 100);
                        }
                        catch (Exception exception) {}
                    }
                    StructureViewerBase.this.addStructure(pdbentry, seqs, chains, alignFrame);
                }
            }).start();
            return;
        }
        this.getBinding().addSequenceAndChain(new PDBEntry[]{pdbentry}, new SequenceI[][]{seqs}, new String[][]{chains});
        this.addingStructures = true;
        this._started = false;
        this.worker = new Thread(this);
        this.worker.start();
    }

    protected boolean hasPdbId(String pdbId) {
        return this.getBinding().hasPdbId(pdbId);
    }

    protected List<StructureViewerBase> getViewersFor(AlignmentPanel alp) {
        return Desktop.instance.getStructureViewers(alp, this.getClass());
    }

    @Override
    public void addToExistingViewer(PDBEntry pdbentry, SequenceI[] seq, String[] chains, AlignmentViewPanel apanel, String pdbId) {
        if (this.hasPdbId(pdbId)) {
            return;
        }
        AlignmentPanel alignPanel = (AlignmentPanel)apanel;
        this.useAlignmentPanelForSuperposition(alignPanel);
        this.addStructure(pdbentry, seq, chains, alignPanel.alignFrame);
    }

    public void addSequenceMappingsToStructure(SequenceI[] seq, String[] chains, AlignmentViewPanel alpanel, String pdbFilename) {
        AlignmentPanel apanel = (AlignmentPanel)alpanel;
        apanel.getStructureSelectionManager().setMapping(seq, chains, pdbFilename, DataSourceType.FILE, this.getIProgressIndicator());
        if (apanel.getSeqPanel().seqCanvas.fr != null) {
            apanel.getSeqPanel().seqCanvas.fr.featuresAdded();
            apanel.paintAlignment(true, false);
        }
        block0: for (StructureViewerBase viewer : this.getViewersFor(null)) {
            AAStructureBindingModel bindingModel = viewer.getBinding();
            for (int pe = 0; pe < bindingModel.getPdbCount(); ++pe) {
                if (!bindingModel.getPdbEntry(pe).getFile().equals(pdbFilename)) continue;
                bindingModel.addSequence(pe, seq);
                viewer.addAlignmentPanel(apanel);
                viewer.useAlignmentPanelForColourbyseq(apanel);
                viewer.buildActionMenu();
                apanel.getStructureSelectionManager().sequenceColoursChanged(apanel);
                continue block0;
            }
        }
    }

    @Override
    public boolean addAlreadyLoadedFile(SequenceI[] seq, String[] chains, AlignmentViewPanel apanel, String pdbId) {
        String alreadyMapped = apanel.getStructureSelectionManager().alreadyMappedToFile(pdbId);
        if (alreadyMapped == null) {
            return false;
        }
        this.addSequenceMappingsToStructure(seq, chains, apanel, alreadyMapped);
        return true;
    }

    void setChainMenuItems(List<String> chainNames) {
        this.chainMenu.removeAll();
        if (chainNames == null || chainNames.isEmpty()) {
            return;
        }
        JMenuItem menuItem = new JMenuItem(MessageManager.getString("label.all"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                StructureViewerBase.this.allChainsSelected = true;
                for (int i = 0; i < StructureViewerBase.this.chainMenu.getItemCount(); ++i) {
                    if (!(StructureViewerBase.this.chainMenu.getItem(i) instanceof JCheckBoxMenuItem)) continue;
                    ((JCheckBoxMenuItem)StructureViewerBase.this.chainMenu.getItem(i)).setSelected(true);
                }
                StructureViewerBase.this.showSelectedChains();
                StructureViewerBase.this.allChainsSelected = false;
            }
        });
        this.chainMenu.add(menuItem);
        for (String chain : chainNames) {
            menuItem = new JCheckBoxMenuItem(chain, true);
            menuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    if (!StructureViewerBase.this.allChainsSelected) {
                        StructureViewerBase.this.showSelectedChains();
                    }
                }
            });
            this.chainMenu.add(menuItem);
        }
    }

    abstract void showSelectedChains();

    @Override
    public void changeColour_actionPerformed(String colourSchemeName) {
        AlignmentI al = this.getAlignmentPanel().av.getAlignment();
        ColourSchemeI cs = ColourSchemes.getInstance().getColourScheme(colourSchemeName, this.getAlignmentPanel().av, al, null);
        this.getBinding().setJalviewColourScheme(cs);
    }

    protected void buildColourMenu() {
        this.colourMenu.removeAll();
        AlignmentI al = this.getAlignmentPanel().av.getAlignment();
        this.colourMenu.add(this.seqColour);
        this.colourMenu.add(this.chainColour);
        this.colourMenu.add(this.chargeColour);
        this.chargeColour.setEnabled(!al.isNucleotide());
        ButtonGroup itemGroup = ColourMenuHelper.addMenuItems(this.colourMenu, this, al, true);
        this.viewerColour.setSelected(false);
        this.viewerColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.viewerColour_actionPerformed(actionEvent);
            }
        });
        this.colourMenu.add(this.viewerColour);
        JMenuItem backGround = new JMenuItem();
        backGround.setText(MessageManager.getString("action.background_colour"));
        backGround.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.background_actionPerformed(actionEvent);
            }
        });
        this.colourMenu.add(backGround);
        itemGroup.add(this.seqColour);
        itemGroup.add(this.chainColour);
        itemGroup.add(this.chargeColour);
        itemGroup.add(this.viewerColour);
    }

    protected void initMenus() {
        AAStructureBindingModel binding = this.getBinding();
        this.seqColour = new JRadioButtonMenuItem();
        this.seqColour.setText(MessageManager.getString("action.by_sequence"));
        this.seqColour.setName(ViewerColour.BySequence.name());
        this.seqColour.setSelected(binding.isColourBySequence());
        this.seqColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.seqColour_actionPerformed(actionEvent);
            }
        });
        this.chainColour = new JRadioButtonMenuItem();
        this.chainColour.setText(MessageManager.getString("action.by_chain"));
        this.chainColour.setName(ViewerColour.ByChain.name());
        this.chainColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.chainColour_actionPerformed(actionEvent);
            }
        });
        this.chargeColour = new JRadioButtonMenuItem();
        this.chargeColour.setText(MessageManager.getString("label.charge_cysteine"));
        this.chargeColour.setName(ViewerColour.ChargeCysteine.name());
        this.chargeColour.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StructureViewerBase.this.chargeColour_actionPerformed(actionEvent);
            }
        });
        this.viewerColour = new JRadioButtonMenuItem();
        this.viewerColour.setName(ViewerColour.ByViewer.name());
        this.viewerColour.setSelected(!binding.isColourBySequence());
        if (this._colourwith == null) {
            this._colourwith = new Vector();
        }
        if (this._alignwith == null) {
            this._alignwith = new Vector();
        }
        ViewSelectionMenu seqColourBy = new ViewSelectionMenu(MessageManager.getString("label.colour_by"), this, this._colourwith, new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (!StructureViewerBase.this.seqColour.isSelected()) {
                    StructureViewerBase.this.seqColour.doClick();
                } else {
                    StructureViewerBase.this.seqColour_actionPerformed(null);
                }
            }
        });
        this.viewMenu.add(seqColourBy);
        final ItemListener handler = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                StructureViewerBase.this.alignStructs.setEnabled(!StructureViewerBase.this._alignwith.isEmpty());
                StructureViewerBase.this.alignStructs.setToolTipText(MessageManager.formatMessage("label.align_structures_using_linked_alignment_views", StructureViewerBase.this._alignwith.size()));
            }
        };
        this.viewSelectionMenu = new ViewSelectionMenu(MessageManager.getString("label.superpose_with"), this, this._alignwith, handler);
        handler.itemStateChanged(null);
        this.viewerActionMenu.add((Component)this.viewSelectionMenu, 0);
        this.viewerActionMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                handler.itemStateChanged(null);
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        this.buildColourMenu();
    }

    @Override
    public void setJalviewColourScheme(ColourSchemeI cs) {
        this.getBinding().setJalviewColourScheme(cs);
    }

    @Override
    protected String alignStructs_actionPerformed(ActionEvent actionEvent) {
        return this.alignStructs_withAllAlignPanels();
    }

    protected String alignStructs_withAllAlignPanels() {
        if (this.getAlignmentPanel() == null) {
            return null;
        }
        if (this._alignwith.size() == 0) {
            this._alignwith.add(this.getAlignmentPanel());
        }
        String reply = null;
        try {
            AlignmentI[] als = new Alignment[this._alignwith.size()];
            HiddenColumns[] alc = new HiddenColumns[this._alignwith.size()];
            int[] alm = new int[this._alignwith.size()];
            int a = 0;
            for (AlignmentPanel alignPanel : this._alignwith) {
                als[a] = alignPanel.av.getAlignment();
                alm[a] = -1;
                alc[a++] = alignPanel.av.getAlignment().getHiddenColumns();
            }
            reply = this.getBinding().superposeStructures(als, alm, alc);
            if (reply != null) {
                String text = MessageManager.formatMessage("error.superposition_failed", reply);
                this.statusBar.setText(text);
            }
        }
        catch (Exception e) {
            StringBuffer sp = new StringBuffer();
            for (AlignmentPanel alignPanel : this._alignwith) {
                sp.append("'" + alignPanel.alignFrame.getTitle() + "' ");
            }
            Cache.log.info((Object)("Couldn't align structures with the " + sp.toString() + "associated alignment panels."), (Throwable)e);
        }
        return reply;
    }

    @Override
    public void background_actionPerformed(ActionEvent actionEvent) {
        Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_background_colour"), null);
        if (col != null) {
            this.getBinding().setBackgroundColour(col);
        }
    }

    @Override
    public void viewerColour_actionPerformed(ActionEvent actionEvent) {
        if (this.viewerColour.isSelected()) {
            this.getBinding().setColourBySequence(false);
        }
    }

    @Override
    public void chainColour_actionPerformed(ActionEvent actionEvent) {
        this.chainColour.setSelected(true);
        this.getBinding().colourByChain();
    }

    @Override
    public void chargeColour_actionPerformed(ActionEvent actionEvent) {
        this.chargeColour.setSelected(true);
        this.getBinding().colourByCharge();
    }

    @Override
    public void seqColour_actionPerformed(ActionEvent actionEvent) {
        AAStructureBindingModel binding = this.getBinding();
        binding.setColourBySequence(this.seqColour.isSelected());
        if (this._colourwith == null) {
            this._colourwith = new Vector();
        }
        if (binding.isColourBySequence()) {
            if (!binding.isLoadingFromArchive() && this._colourwith.size() == 0 && this.getAlignmentPanel() != null) {
                this._colourwith.add(this.getAlignmentPanel().alignFrame.alignPanel);
            }
            for (AlignmentPanel alignPanel : this._colourwith) {
                binding.colourBySequence(alignPanel);
            }
            this.seqColoursApplied = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pdbFile_actionPerformed(ActionEvent actionEvent) {
        JalviewFileChooser chooser = new JalviewFileChooser(Cache.getProperty("LAST_DIRECTORY"));
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.save_pdb_file"));
        chooser.setToolTipText(MessageManager.getString("action.save"));
        int value = chooser.showSaveDialog(this);
        if (value == 0) {
            BufferedReader in = null;
            try {
                String data;
                in = new BufferedReader(new FileReader(this.getBinding().getStructureFiles()[0]));
                File outFile = chooser.getSelectedFile();
                PrintWriter out = new PrintWriter(new FileOutputStream(outFile));
                while ((data = in.readLine()) != null) {
                    if (data.indexOf("<PRE>") > -1 || data.indexOf("</PRE>") > -1) continue;
                    out.println(data);
                }
                out.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    @Override
    public void viewMapping_actionPerformed(ActionEvent actionEvent) {
        CutAndPasteTransfer cap = new CutAndPasteTransfer();
        try {
            cap.appendText(this.getBinding().printMappings());
        }
        catch (OutOfMemoryError e) {
            new OOMWarning("composing sequence-structure alignments for display in text box.", e);
            cap.dispose();
            return;
        }
        Desktop.addInternalFrame(cap, MessageManager.getString("label.pdb_sequence_mapping"), 550, 600);
    }

    protected abstract String getViewerName();

    @Override
    public void updateTitleAndMenus() {
        AAStructureBindingModel binding = this.getBinding();
        if (binding.hasFileLoadingError()) {
            this.repaint();
            return;
        }
        this.setChainMenuItems(binding.getChainNames());
        this.setTitle(binding.getViewerTitle(this.getViewerName(), true));
        this.viewSelectionMenu.setEnabled(false);
        if (this.getBinding().getStructureFiles().length > 1 && this.getBinding().getSequence().length > 1) {
            this.viewSelectionMenu.setEnabled(true);
        }
        this.viewerActionMenu.setVisible(false);
        for (int i = 0; i < this.viewerActionMenu.getItemCount(); ++i) {
            if (!this.viewerActionMenu.getItem(i).isEnabled()) continue;
            this.viewerActionMenu.setVisible(true);
            break;
        }
        if (!binding.isLoadingFromArchive()) {
            this.seqColour_actionPerformed(null);
        }
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    @Override
    public boolean hasMapping() {
        if (this.worker != null && (this.addingStructures || this._started)) {
            return false;
        }
        if (this.getBinding() == null) {
            return this._aps == null || this._aps.size() == 0;
        }
        String[] pdbids = this.getBinding().getStructureFiles();
        if (pdbids == null) {
            return false;
        }
        int p = 0;
        for (String pdbid : pdbids) {
            StructureMapping[] sm = this.getBinding().getSsm().getMapping(pdbid);
            if (sm == null || sm.length <= 0 || sm[0] == null) continue;
            ++p;
        }
        if (p == 0 || p != pdbids.length) {
            return false;
        }
        return this.seqColoursApplied;
    }

    @Override
    public void raiseViewer() {
        this.toFront();
    }

    static enum ViewerColour {
        BySequence,
        ByChain,
        ChargeCysteine,
        ByViewer;

    }
}

