/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import com.stevesoft.pat.Regex;
import jalview.api.FeatureSettingsModelI;
import jalview.bin.Cache;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.DBRefEntry;
import jalview.datamodel.SequenceI;
import jalview.fts.core.GFTSPanel;
import jalview.fts.service.pdb.PDBFTSPanel;
import jalview.fts.service.uniprot.UniprotFTSPanel;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.IProgressIndicator;
import jalview.gui.JDatabaseTree;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.OOMWarning;
import jalview.io.FileFormatI;
import jalview.util.DBRefUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.seqfetcher.DbSourceProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;

public class SequenceFetcher
extends JPanel
implements Runnable {
    JLabel dbeg = new JLabel();
    JDatabaseTree database;
    JButton databaseButt;
    JLabel jLabel1 = new JLabel();
    JCheckBox replacePunctuation = new JCheckBox();
    JButton ok = new JButton();
    JButton clear = new JButton();
    JButton example = new JButton();
    JButton close = new JButton();
    JButton back = new JButton();
    JPanel jPanel1 = new JPanel();
    JTextArea textArea = new JTextArea();
    JScrollPane jScrollPane1 = new JScrollPane();
    JPanel jPanel2 = new JPanel();
    JPanel jPanel3 = new JPanel();
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    BorderLayout borderLayout3 = new BorderLayout();
    JInternalFrame frame;
    IProgressIndicator guiWindow;
    AlignFrame alignFrame;
    StringBuffer result;
    final String noDbSelected = "-- Select Database --";
    private static jalview.ws.SequenceFetcher sfetch = null;
    private static boolean _initingFetcher = false;
    private static Thread initingThread = null;
    private IProgressIndicator progressIndicator;
    private volatile boolean _isConstructing = true;
    private List<AlignFrame> newAlframes = null;
    GFTSPanel parentFTSframe = null;

    public JTextArea getTextArea() {
        return this.textArea;
    }

    public static jalview.ws.SequenceFetcher getSequenceFetcherSingleton(IProgressIndicator guiWindow) {
        if (_initingFetcher && initingThread != null && initingThread.isAlive()) {
            if (guiWindow != null) {
                guiWindow.setProgressBar(MessageManager.getString("status.waiting_sequence_database_fetchers_init"), Thread.currentThread().hashCode());
            }
            while (_initingFetcher && initingThread != null && initingThread.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (Exception exception) {}
            }
            if (guiWindow != null) {
                guiWindow.setProgressBar(MessageManager.getString("status.waiting_sequence_database_fetchers_init"), Thread.currentThread().hashCode());
            }
        }
        if (sfetch == null) {
            _initingFetcher = true;
            initingThread = Thread.currentThread();
            if (guiWindow != null) {
                guiWindow.setProgressBar(MessageManager.getString("status.init_sequence_database_fetchers"), Thread.currentThread().hashCode());
            }
            jalview.ws.SequenceFetcher sf = new jalview.ws.SequenceFetcher();
            if (guiWindow != null) {
                guiWindow.setProgressBar(null, Thread.currentThread().hashCode());
            }
            sfetch = sf;
            _initingFetcher = false;
            initingThread = null;
        }
        return sfetch;
    }

    public SequenceFetcher(IProgressIndicator guiIndic) {
        this(guiIndic, null, null);
    }

    public SequenceFetcher(IProgressIndicator guiIndic, final String selectedDb, final String queryString) {
        this.progressIndicator = guiIndic;
        final SequenceFetcher us = this;
        Thread sf = new Thread(new Runnable(){

            @Override
            public void run() {
                if (SequenceFetcher.getSequenceFetcherSingleton(SequenceFetcher.this.progressIndicator) != null) {
                    us.initGui(SequenceFetcher.this.progressIndicator, selectedDb, queryString);
                    us._isConstructing = false;
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("warn.couldnt_create_sequence_fetcher_client"), MessageManager.getString("label.couldnt_create_sequence_fetcher"), 0);
                        }
                    });
                }
            }
        });
        sf.start();
    }

    public static List<AlignFrame> fetchAndShow(String database, String query) {
        SequenceFetcher sf = new SequenceFetcher(Desktop.instance, database, query);
        while (sf._isConstructing) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception q) {
                return Collections.emptyList();
            }
        }
        sf.newAlframes = new ArrayList<AlignFrame>();
        sf.run();
        return sf.newAlframes;
    }

    protected boolean setInitialQuery(String selectedDb, String queryString) {
        if (selectedDb == null || selectedDb.trim().length() == 0) {
            return false;
        }
        try {
            List<DbSourceProxy> sp = sfetch.getSourceProxy(selectedDb);
            for (DbSourceProxy sourcep : sp) {
                if (sourcep.getTier() != 0) continue;
                this.database.selection = Arrays.asList(sourcep);
                break;
            }
            if (this.database.selection == null || this.database.selection.size() == 0) {
                System.err.println("Ignoring fetch parameter db='" + selectedDb + "'");
                return false;
            }
            this.textArea.setText(queryString);
        }
        catch (Exception q) {
            System.err.println("Ignoring fetch parameter db='" + selectedDb + "' and query='" + queryString + "'");
            return false;
        }
        return true;
    }

    private void initGui(IProgressIndicator guiWindow, String selectedDb, String queryString) {
        this.guiWindow = guiWindow;
        if (guiWindow instanceof AlignFrame) {
            this.alignFrame = (AlignFrame)guiWindow;
        }
        this.database = new JDatabaseTree(sfetch);
        try {
            this.jbInit();
            if (!this.setInitialQuery(selectedDb, queryString)) {
                this.database.waitForInput();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        if (Platform.isAMac()) {
            Desktop.addInternalFrame(this.frame, this.getFrameTitle(), false, 400, 240);
        } else {
            Desktop.addInternalFrame(this.frame, this.getFrameTitle(), false, 400, 180);
        }
    }

    private String getFrameTitle() {
        return this.alignFrame == null ? MessageManager.getString("label.new_sequence_fetcher") : MessageManager.getString("label.additional_sequence_fetcher");
    }

    public void embedWithFTSPanel(GFTSPanel toClose) {
        this.back.setVisible(true);
        this.parentFTSframe = toClose;
    }

    private void jbInit() throws Exception {
        this.setLayout(this.borderLayout2);
        this.database.setFont(JvSwingUtils.getLabelFont());
        this.dbeg.setFont(new Font("Verdana", 1, 11));
        this.jLabel1.setFont(new Font("Verdana", 2, 11));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText(MessageManager.getString("label.separate_multiple_accession_ids"));
        this.replacePunctuation.setHorizontalAlignment(0);
        this.replacePunctuation.setFont(new Font("Verdana", 2, 11));
        this.replacePunctuation.setText(MessageManager.getString("label.replace_commas_semicolons"));
        this.ok.setText(MessageManager.getString("action.ok"));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.ok_actionPerformed();
            }
        });
        this.clear.setText(MessageManager.getString("action.clear"));
        this.clear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.clear_actionPerformed();
            }
        });
        this.example.setText(MessageManager.getString("label.example"));
        this.example.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.example_actionPerformed();
            }
        });
        this.close.setText(MessageManager.getString("action.cancel"));
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.close_actionPerformed(e);
            }
        });
        this.back.setText(MessageManager.getString("action.back"));
        this.back.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SequenceFetcher.this.parentFTSframe.btn_back_ActionPerformed();
            }
        });
        this.back.setVisible(false);
        this.textArea.setFont(JvSwingUtils.getLabelFont());
        this.textArea.setLineWrap(true);
        this.textArea.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    SequenceFetcher.this.ok_actionPerformed();
                }
            }
        });
        this.jPanel3.setLayout(this.borderLayout1);
        this.borderLayout1.setVgap(5);
        this.jPanel1.add(this.back);
        this.jPanel1.add(this.example);
        this.jPanel1.add(this.clear);
        this.jPanel1.add(this.ok);
        this.jPanel1.add(this.close);
        this.jPanel2.setLayout(this.borderLayout3);
        this.databaseButt = new JButton(MessageManager.getString("action.select_ddbb"));
        this.databaseButt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SequenceFetcher.this.hidePanel();
                SequenceFetcher.this.database.showDialog();
            }
        });
        this.databaseButt.setFont(JvSwingUtils.getLabelFont());
        this.database.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String currentSelection = SequenceFetcher.this.database.getSelectedItem();
                if (currentSelection == null) {
                    SequenceFetcher.this.close_actionPerformed(null);
                }
                SequenceFetcher.this.showPanel();
                if ("pdb".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.pdbSourceAction();
                } else if ("uniprot".equalsIgnoreCase(currentSelection)) {
                    SequenceFetcher.this.uniprotSourceAction();
                } else {
                    SequenceFetcher.this.otherSourceAction();
                }
                SequenceFetcher.this.database.action = -1;
            }
        });
        this.dbeg.setText("");
        this.jPanel2.add((Component)this.databaseButt, "North");
        this.jPanel2.add((Component)this.dbeg, "Center");
        JPanel jPanel2a = new JPanel(new BorderLayout());
        jPanel2a.add((Component)this.jLabel1, "North");
        jPanel2a.add((Component)this.replacePunctuation, "South");
        this.jPanel2.add((Component)jPanel2a, "South");
        this.jPanel3.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.jPanel1, "South");
        this.add((Component)this.jPanel3, "Center");
        this.add((Component)this.jPanel2, "North");
        this.jScrollPane1.getViewport().add(this.textArea);
    }

    private void pdbSourceAction() {
        this.databaseButt.setText(this.database.getSelectedItem());
        new PDBFTSPanel(this);
        this.frame.dispose();
    }

    private void uniprotSourceAction() {
        this.databaseButt.setText(this.database.getSelectedItem());
        new UniprotFTSPanel(this);
        this.frame.dispose();
    }

    private void otherSourceAction() {
        try {
            this.databaseButt.setText(this.database.getSelectedItem() + (this.database.getSelectedSources().size() > 1 ? " (and " + this.database.getSelectedSources().size() + " others)" : ""));
            String eq = this.database.getExampleQueries();
            this.dbeg.setText(MessageManager.formatMessage("label.example_query_param", new String[]{eq}));
            boolean enablePunct = eq == null || eq.indexOf(",") <= -1;
            this.replacePunctuation.setEnabled(enablePunct);
        }
        catch (Exception ex) {
            this.dbeg.setText("");
            this.replacePunctuation.setEnabled(true);
        }
        this.jPanel2.repaint();
    }

    protected void example_actionPerformed() {
        Object db = null;
        try {
            this.textArea.setText(this.database.getExampleQueries());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.jPanel3.repaint();
    }

    protected void clear_actionPerformed() {
        this.textArea.setText("");
        this.jPanel3.repaint();
    }

    public void close_actionPerformed(ActionEvent e) {
        try {
            this.frame.setClosed(true);
            if (this.parentFTSframe != null) {
                this.parentFTSframe.btn_cancel_ActionPerformed();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void ok_actionPerformed() {
        this.databaseButt.setEnabled(false);
        this.example.setEnabled(false);
        this.textArea.setEnabled(false);
        this.ok.setEnabled(false);
        this.close.setEnabled(false);
        this.back.setEnabled(false);
        Thread worker = new Thread(this);
        worker.start();
    }

    private void resetDialog() {
        this.databaseButt.setEnabled(true);
        this.example.setEnabled(true);
        this.textArea.setEnabled(true);
        this.ok.setEnabled(true);
        this.close.setEnabled(true);
        this.back.setEnabled(this.parentFTSframe != null);
    }

    @Override
    public void run() {
        String error = "";
        if (!this.database.hasSelection()) {
            error = error + "Please select the source database\n";
        }
        Regex empty = this.replacePunctuation.isEnabled() && this.replacePunctuation.isSelected() ? new Regex("(\\s|[,; ])+", ";") : new Regex("(\\s|[; ])+", ";");
        this.textArea.setText(empty.replaceAll(this.textArea.getText()));
        if (!new Regex("[A-Za-z0-9_.]").search(this.textArea.getText())) {
            error = error + "Please enter a (semi-colon separated list of) database id(s)";
        }
        if (error.length() > 0) {
            this.showErrorMessage(error);
            this.resetDialog();
            return;
        }
        boolean addToLast = false;
        ArrayList<String> aresultq = new ArrayList<String>();
        ArrayList<String> presultTitle = new ArrayList<String>();
        ArrayList<AlignmentI> presult = new ArrayList<AlignmentI>();
        ArrayList<AlignmentI> aresult = new ArrayList<AlignmentI>();
        Iterator<DbSourceProxy> proxies = this.database.getSelectedSources().iterator();
        String[] qries = this.textArea.getText().split(";");
        List<String> nextFetch = Arrays.asList(qries);
        Iterator<String> en = Arrays.asList(new String[0]).iterator();
        int nqueries = qries.length;
        FeatureSettingsModelI preferredFeatureColours = null;
        while (proxies.hasNext() && (en.hasNext() || nextFetch.size() > 0)) {
            if (!en.hasNext() && nextFetch.size() > 0) {
                en = nextFetch.iterator();
                nqueries = nextFetch.size();
                qries = nextFetch.toArray(new String[nqueries]);
                nextFetch = new ArrayList<String>();
            }
            DbSourceProxy proxy = proxies.next();
            try {
                this.guiWindow.setProgressBar(MessageManager.formatMessage("status.fetching_sequence_queries_from", new String[]{Integer.valueOf(nqueries).toString(), proxy.getDbName()}), Thread.currentThread().hashCode());
                if (proxy.getMaximumQueryCount() == 1) {
                    while (en.hasNext()) {
                        String acc = en.next();
                        if (this.fetchSingleAccession(proxy, acc, aresultq, aresult)) continue;
                        nextFetch.add(acc);
                    }
                } else {
                    this.fetchMultipleAccessions(proxy, en, aresultq, aresult, nextFetch);
                }
            }
            catch (Exception e) {
                this.showErrorMessage("Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
                System.err.println("Retrieval failed for source ='" + this.database.getSelectedItem() + "' and query\n'" + this.textArea.getText() + "'\n");
                e.printStackTrace();
            }
            catch (OutOfMemoryError e) {
                this.showErrorMessage("Out of Memory when retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem() + "\nPlease see the Jalview FAQ for instructions for increasing the memory available to Jalview.\n");
                e.printStackTrace();
            }
            catch (Error e) {
                this.showErrorMessage("Serious Error retrieving " + this.textArea.getText() + " from " + this.database.getSelectedItem());
                e.printStackTrace();
            }
            if (aresult != null && aresult.size() > 0) {
                FeatureSettingsModelI proxyColourScheme = proxy.getFeatureColourScheme();
                if (proxyColourScheme != null) {
                    preferredFeatureColours = proxyColourScheme;
                }
                AlignmentI ar = null;
                if (proxy.isAlignmentSource()) {
                    addToLast = false;
                    while (aresult.size() > 0) {
                        presult.add((AlignmentI)aresult.remove(0));
                        presultTitle.add((String)aresultq.remove(0) + " " + this.getDefaultRetrievalTitle());
                    }
                } else {
                    String titl = null;
                    if (addToLast && presult.size() > 0) {
                        ar = (AlignmentI)presult.remove(presult.size() - 1);
                        titl = (String)presultTitle.remove(presultTitle.size() - 1);
                    }
                    while (aresult.size() > 0) {
                        if (ar == null) {
                            ar = (AlignmentI)aresult.remove(0);
                            continue;
                        }
                        ar.append((AlignmentI)aresult.remove(0));
                    }
                    addToLast = true;
                    presult.add(ar);
                    presultTitle.add(titl);
                }
            }
            this.guiWindow.setProgressBar(MessageManager.getString("status.finshed_querying"), Thread.currentThread().hashCode());
        }
        this.guiWindow.setProgressBar(presult.size() > 0 ? MessageManager.getString("status.parsing_results") : MessageManager.getString("status.processing"), Thread.currentThread().hashCode());
        while (presult.size() > 0) {
            this.parseResult((AlignmentI)presult.remove(0), (String)presultTitle.remove(0), null, preferredFeatureColours);
        }
        this.guiWindow.setProgressBar(null, Thread.currentThread().hashCode());
        if (nextFetch.size() > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Didn't retrieve the following " + (nextFetch.size() == 1 ? "query" : nextFetch.size() + " queries") + ": \n");
            int l = sb.length();
            int lr = 0;
            for (String s : nextFetch) {
                if (l != sb.length()) {
                    sb.append("; ");
                }
                if (lr - sb.length() > 40) {
                    sb.append("\n");
                }
                sb.append(s);
            }
            this.showErrorMessage(sb.toString());
        }
        this.resetDialog();
    }

    void fetchMultipleAccessions(DbSourceProxy proxy, Iterator<String> accessions, List<String> aresultq, List<AlignmentI> aresult, List<String> nextFetch) throws Exception {
        StringBuilder multiacc = new StringBuilder();
        ArrayList<String> tosend = new ArrayList<String>();
        while (accessions.hasNext()) {
            String nel = accessions.next();
            tosend.add(nel);
            multiacc.append(nel);
            if (!accessions.hasNext()) continue;
            multiacc.append(proxy.getAccessionSeparator());
        }
        try {
            String query = multiacc.toString();
            AlignmentI rslt = proxy.getSequenceRecords(query);
            if (rslt == null || rslt.getHeight() == 0) {
                nextFetch.addAll(tosend);
            } else {
                aresultq.add(query);
                aresult.add(rslt);
                if (tosend.size() > 1) {
                    this.checkResultForQueries(rslt, tosend, nextFetch, proxy);
                }
            }
        }
        catch (OutOfMemoryError oome) {
            new OOMWarning("fetching " + multiacc + " from " + this.database.getSelectedItem(), oome, this);
        }
    }

    boolean fetchSingleAccession(DbSourceProxy proxy, String accession, List<String> aresultq, List<AlignmentI> aresult) {
        boolean success = false;
        try {
            if (aresult != null) {
                try {
                    Thread.sleep(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            AlignmentI indres = null;
            try {
                indres = proxy.getSequenceRecords(accession);
            }
            catch (OutOfMemoryError oome) {
                new OOMWarning("fetching " + accession + " from " + proxy.getDbName(), oome, this);
            }
            if (indres != null) {
                aresultq.add(accession);
                aresult.add(indres);
                success = true;
            }
        }
        catch (Exception e) {
            Cache.log.info((Object)("Error retrieving " + accession + " from " + proxy.getDbName()), (Throwable)e);
        }
        return success;
    }

    void checkResultForQueries(AlignmentI rslt, List<String> queries, List<String> nextFetch, DbSourceProxy proxy) {
        SequenceI[] rs = rslt.getSequencesArray();
        for (String q : queries) {
            DBRefEntry dbr = new DBRefEntry();
            dbr.setSource(proxy.getDbSource());
            dbr.setVersion(null);
            String accId = proxy.getAccessionIdFromQuery(q);
            dbr.setAccessionId(accId);
            boolean rfound = false;
            for (int r = 0; r < rs.length; ++r) {
                List<DBRefEntry> found;
                if (rs[r] == null || (found = DBRefUtils.searchRefs(rs[r].getDBRefs(), accId)).isEmpty()) continue;
                rfound = true;
                break;
            }
            if (rfound) continue;
            nextFetch.add(q);
        }
    }

    public String getDefaultRetrievalTitle() {
        return "Retrieved from " + this.database.getSelectedItem();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AlignmentI parseResult(AlignmentI al, String title, FileFormatI currentFileFormat, FeatureSettingsModelI preferredFeatureColours) {
        if (al != null && al.getHeight() > 0) {
            if (title == null) {
                title = this.getDefaultRetrievalTitle();
            }
            if (this.alignFrame == null) {
                List<SequenceI> alsqs;
                AlignFrame af = new AlignFrame(al, 700, 500);
                if (currentFileFormat != null) {
                    af.currentFileFormat = currentFileFormat;
                }
                Object sfs = null;
                List<SequenceI> list = alsqs = al.getSequences();
                synchronized (alsqs) {
                    for (SequenceI sq : alsqs) {
                        if (!sq.getFeatures().hasFeatures()) continue;
                        af.setShowSeqFeatures(true);
                        break;
                    }
                    // ** MonitorExit[var8_8] (shouldn't be in output)
                    if (preferredFeatureColours != null) {
                        af.getViewport().applyFeaturesStyle(preferredFeatureColours);
                    }
                    if (Cache.getDefault("HIDE_INTRONS", true)) {
                        af.hideFeatureColumns("exon", false);
                    }
                    if (this.newAlframes != null) {
                        this.newAlframes.add(af);
                    }
                    Desktop.addInternalFrame(af, title, 700, 500);
                    af.setStatus(MessageManager.getString("label.successfully_pasted_alignment_file"));
                    try {
                        af.setMaximum(Cache.getDefault("SHOW_FULLSCREEN", false));
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.alignFrame.viewport.addAlignment(al, title);
            }
        }
        return al;
    }

    void showErrorMessage(final String error) {
        this.resetDialog();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JvOptionPane.showInternalMessageDialog(Desktop.desktop, error, MessageManager.getString("label.error_retrieving_data"), 2);
            }
        });
    }

    public IProgressIndicator getProgressIndicator() {
        return this.progressIndicator;
    }

    public void setProgressIndicator(IProgressIndicator progressIndicator) {
        this.progressIndicator = progressIndicator;
    }

    void showPanel() {
        this.frame.setVisible(true);
    }

    void hidePanel() {
        this.frame.setVisible(false);
    }

    public void setDatabaseChooserVisible(boolean b) {
        this.databaseButt.setVisible(b);
    }

    private class DatabaseSource
    extends DefaultMutableTreeNode {
        private DatabaseSource() {
        }
    }

    private class DatabaseAuthority
    extends DefaultMutableTreeNode {
        private DatabaseAuthority() {
        }
    }
}

