/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignViewportI;
import jalview.bin.Cache;
import jalview.commands.EditCommand;
import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.AlignmentI;
import jalview.datamodel.ColumnSelection;
import jalview.datamodel.HiddenColumns;
import jalview.datamodel.MappedFeatures;
import jalview.datamodel.SearchResultMatchI;
import jalview.datamodel.SearchResults;
import jalview.datamodel.SearchResultsI;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceFeature;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignFrame;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationPanel;
import jalview.gui.Desktop;
import jalview.gui.FeatureRenderer;
import jalview.gui.JvSwingUtils;
import jalview.gui.PaintRefresher;
import jalview.gui.PopupMenu;
import jalview.gui.SeqCanvas;
import jalview.gui.SliderPanel;
import jalview.gui.SplitFrame;
import jalview.io.SequenceAnnotationReport;
import jalview.renderer.ResidueShaderI;
import jalview.schemes.ResidueProperties;
import jalview.structure.SelectionListener;
import jalview.structure.SelectionSource;
import jalview.structure.SequenceListener;
import jalview.structure.StructureSelectionManager;
import jalview.structure.VamsasSource;
import jalview.util.Comparison;
import jalview.util.MappingUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.ViewportRanges;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class SeqPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
SequenceListener,
SelectionListener {
    private static final int MAX_TOOLTIP_LENGTH = 300;
    public SeqCanvas seqCanvas;
    public AlignmentPanel ap;
    private MousePos lastMousePosition;
    protected int editLastRes;
    protected int editStartSeq;
    protected AlignViewport av;
    ScrollThread scrollThread = null;
    boolean mouseDragging = false;
    boolean editingSeqs = false;
    boolean groupEditing = false;
    int oldSeq = -1;
    boolean changeEndSeq = false;
    boolean changeStartSeq = false;
    boolean changeEndRes = false;
    boolean changeStartRes = false;
    SequenceGroup stretchGroup = null;
    boolean remove = false;
    Point lastMousePress;
    boolean mouseWheelPressed = false;
    StringBuffer keyboardNo1;
    StringBuffer keyboardNo2;
    URL linkImageURL;
    private final SequenceAnnotationReport seqARep;
    StringBuilder tooltipText = new StringBuilder();
    String tmpString;
    EditCommand editCommand;
    StructureSelectionManager ssm;
    SearchResultsI lastSearchResults;
    int startWrapBlock = -1;
    int wrappedBlock = -1;
    String lastMessage;
    private Point lastp = null;
    String lastTooltip;
    private boolean updateOverviewAndStructs = false;

    public SeqPanel(AlignViewport viewport, AlignmentPanel alignPanel) {
        this.linkImageURL = this.getClass().getResource("/images/link.gif");
        this.seqARep = new SequenceAnnotationReport(this.linkImageURL.toString());
        ToolTipManager.sharedInstance().registerComponent(this);
        ToolTipManager.sharedInstance().setInitialDelay(0);
        ToolTipManager.sharedInstance().setDismissDelay(10000);
        this.av = viewport;
        this.setBackground(Color.white);
        this.seqCanvas = new SeqCanvas(alignPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.seqCanvas, "Center");
        this.ap = alignPanel;
        if (!viewport.isDataset()) {
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
            this.addMouseWheelListener(this);
            this.ssm = viewport.getStructureSelectionManager();
            this.ssm.addStructureViewerListener(this);
            this.ssm.addSelectionListener(this);
        }
    }

    MousePos findMousePosition(MouseEvent evt) {
        int col = this.findColumn(evt);
        int seqIndex = -1;
        int annIndex = -1;
        int y = evt.getY();
        int charHeight = this.av.getCharHeight();
        int alignmentHeight = this.av.getAlignment().getHeight();
        if (this.av.getWrapAlignment()) {
            this.seqCanvas.calculateWrappedGeometry(this.seqCanvas.getWidth(), this.seqCanvas.getHeight());
            int yOffsetPx = y % this.seqCanvas.wrappedRepeatHeightPx;
            int alignmentHeightPixels = this.seqCanvas.wrappedSpaceAboveAlignment + alignmentHeight * charHeight + 3;
            if (yOffsetPx >= alignmentHeightPixels) {
                AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
                int rowOffsetPx = yOffsetPx - alignmentHeightPixels;
                annIndex = AnnotationPanel.getRowIndex(rowOffsetPx, anns);
                seqIndex = alignmentHeight - 1;
            } else if ((yOffsetPx -= this.seqCanvas.wrappedSpaceAboveAlignment) >= 0) {
                seqIndex = Math.min(yOffsetPx / charHeight, alignmentHeight - 1);
            }
        } else {
            ViewportRanges ranges = this.av.getRanges();
            seqIndex = Math.min(y / charHeight + ranges.getStartSeq(), alignmentHeight - 1);
            seqIndex = Math.min(seqIndex, ranges.getEndSeq());
        }
        return new MousePos(col, seqIndex, annIndex);
    }

    int findColumn(MouseEvent evt) {
        int res = 0;
        int x = evt.getX();
        int startRes = this.av.getRanges().getStartRes();
        int charWidth = this.av.getCharWidth();
        if (this.av.getWrapAlignment()) {
            int hgap = this.av.getCharHeight();
            if (this.av.getScaleAboveWrapped()) {
                hgap += this.av.getCharHeight();
            }
            int cHeight = this.av.getAlignment().getHeight() * this.av.getCharHeight() + hgap + this.seqCanvas.getAnnotationHeight();
            int y = evt.getY();
            y = Math.max(0, y - hgap);
            if ((x -= this.seqCanvas.getLabelWidthWest()) < 0) {
                return -1;
            }
            int cwidth = this.seqCanvas.getWrappedCanvasWidth(this.getWidth());
            if (cwidth < 1) {
                return 0;
            }
            if (x >= cwidth * charWidth) {
                return -1;
            }
            this.wrappedBlock = y / cHeight;
            this.wrappedBlock += startRes / cwidth;
            int startOffset = startRes % cwidth;
            res = this.wrappedBlock * cwidth + startOffset + Math.min(cwidth - 1, x / charWidth);
        } else {
            x = Math.min(x, this.seqCanvas.getX() + this.seqCanvas.getWidth());
            res = x / charWidth + startRes;
            res = Math.min(res, this.av.getRanges().getEndRes());
        }
        if (this.av.hasHiddenColumns()) {
            res = this.av.getAlignment().getHiddenColumns().visibleToAbsoluteColumn(res);
        }
        return res;
    }

    void endEditing() {
        try {
            if (this.editCommand != null && this.editCommand.getSize() > 0) {
                this.ap.alignFrame.addHistoryItem(this.editCommand);
                this.av.firePropertyChange("alignment", null, this.av.getAlignment().getSequences());
            }
        }
        finally {
            this.editStartSeq = -1;
            this.editLastRes = -1;
            this.editingSeqs = false;
            this.groupEditing = false;
            this.keyboardNo1 = null;
            this.keyboardNo2 = null;
            this.editCommand = null;
        }
    }

    void setCursorRow() {
        this.seqCanvas.cursorY = this.getKeyboardNo1() - 1;
        this.scrollToVisible(true);
    }

    void setCursorColumn() {
        this.seqCanvas.cursorX = this.getKeyboardNo1() - 1;
        this.scrollToVisible(true);
    }

    void setCursorRowAndColumn() {
        if (this.keyboardNo2 == null) {
            this.keyboardNo2 = new StringBuffer();
        } else {
            this.seqCanvas.cursorX = this.getKeyboardNo1() - 1;
            this.seqCanvas.cursorY = this.getKeyboardNo2() - 1;
            this.scrollToVisible(true);
        }
    }

    void setCursorPosition() {
        SequenceI sequence = this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY);
        this.seqCanvas.cursorX = sequence.findIndex(this.getKeyboardNo1()) - 1;
        this.scrollToVisible(true);
    }

    void moveCursor(int dx, int dy) {
        this.seqCanvas.cursorX += dx;
        this.seqCanvas.cursorY += dy;
        HiddenColumns hidden = this.av.getAlignment().getHiddenColumns();
        if (this.av.hasHiddenColumns() && !hidden.isVisible(this.seqCanvas.cursorX)) {
            int original = this.seqCanvas.cursorX - dx;
            int maxWidth = this.av.getAlignment().getWidth();
            if (!hidden.isVisible(this.seqCanvas.cursorX)) {
                int visx = hidden.absoluteToVisibleColumn(this.seqCanvas.cursorX - dx);
                int[] region = hidden.getRegionWithEdgeAtRes(visx);
                if (region != null) {
                    if (dx == 1) {
                        this.seqCanvas.cursorX = region[1] + 1;
                    } else if (dx == -1) {
                        this.seqCanvas.cursorX = region[0] - 1;
                    }
                }
                int n = this.seqCanvas.cursorX = this.seqCanvas.cursorX < 0 ? 0 : this.seqCanvas.cursorX;
            }
            if (this.seqCanvas.cursorX >= maxWidth || !hidden.isVisible(this.seqCanvas.cursorX)) {
                this.seqCanvas.cursorX = original;
            }
        }
        this.scrollToVisible(false);
    }

    void scrollToVisible(boolean jump) {
        if (this.seqCanvas.cursorX < 0) {
            this.seqCanvas.cursorX = 0;
        } else if (this.seqCanvas.cursorX > this.av.getAlignment().getWidth() - 1) {
            this.seqCanvas.cursorX = this.av.getAlignment().getWidth() - 1;
        }
        if (this.seqCanvas.cursorY < 0) {
            this.seqCanvas.cursorY = 0;
        } else if (this.seqCanvas.cursorY > this.av.getAlignment().getHeight() - 1) {
            this.seqCanvas.cursorY = this.av.getAlignment().getHeight() - 1;
        }
        this.endEditing();
        boolean repaintNeeded = true;
        if (jump) {
            repaintNeeded = !this.av.getRanges().setViewportLocation(this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        } else if (this.av.getWrapAlignment()) {
            int x = this.av.getAlignment().getHiddenColumns().absoluteToVisibleColumn(this.seqCanvas.cursorX);
            this.av.getRanges().scrollToWrappedVisible(x);
        } else {
            this.av.getRanges().scrollToVisible(this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        }
        if (this.av.getAlignment().getHiddenColumns().isVisible(this.seqCanvas.cursorX)) {
            this.setStatusMessage(this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY), this.seqCanvas.cursorX, this.seqCanvas.cursorY);
        }
        if (repaintNeeded) {
            this.seqCanvas.repaint();
        }
    }

    void setSelectionAreaAtCursor(boolean topLeft) {
        SequenceGroup sg;
        SequenceI sequence = this.av.getAlignment().getSequenceAt(this.seqCanvas.cursorY);
        if (this.av.getSelectionGroup() != null) {
            int i;
            sg = this.av.getSelectionGroup();
            int min = this.av.getAlignment().getHeight();
            int max = 0;
            for (i = 0; i < sg.getSize(); ++i) {
                int index = this.av.getAlignment().findIndex(sg.getSequenceAt(i));
                if (index > max) {
                    max = index;
                }
                if (index >= min) continue;
                min = index;
            }
            ++max;
            if (topLeft) {
                sg.setStartRes(this.seqCanvas.cursorX);
                if (sg.getEndRes() < this.seqCanvas.cursorX) {
                    sg.setEndRes(this.seqCanvas.cursorX);
                }
                min = this.seqCanvas.cursorY;
            } else {
                sg.setEndRes(this.seqCanvas.cursorX);
                if (sg.getStartRes() > this.seqCanvas.cursorX) {
                    sg.setStartRes(this.seqCanvas.cursorX);
                }
                max = this.seqCanvas.cursorY + 1;
            }
            if (min > max) {
                this.av.setSelectionGroup(null);
            } else {
                sg.getSequences(null).clear();
                for (i = min; i < max; ++i) {
                    sg.addSequence(this.av.getAlignment().getSequenceAt(i), false);
                }
            }
        }
        if (this.av.getSelectionGroup() == null) {
            sg = new SequenceGroup();
            sg.setStartRes(this.seqCanvas.cursorX);
            sg.setEndRes(this.seqCanvas.cursorX);
            sg.addSequence(sequence, false);
            this.av.setSelectionGroup(sg);
        }
        this.ap.paintAlignment(false, false);
        this.av.sendSelection();
    }

    void insertGapAtCursor(boolean group) {
        this.groupEditing = group;
        this.editStartSeq = this.seqCanvas.cursorY;
        this.editLastRes = this.seqCanvas.cursorX;
        this.editSequence(true, false, this.seqCanvas.cursorX + this.getKeyboardNo1());
        this.endEditing();
    }

    void deleteGapAtCursor(boolean group) {
        this.groupEditing = group;
        this.editStartSeq = this.seqCanvas.cursorY;
        this.editLastRes = this.seqCanvas.cursorX + this.getKeyboardNo1();
        this.editSequence(false, false, this.seqCanvas.cursorX);
        this.endEditing();
    }

    void insertNucAtCursor(boolean group, String nuc) {
        this.groupEditing = group;
        this.editStartSeq = this.seqCanvas.cursorY;
        this.editLastRes = this.seqCanvas.cursorX;
        this.editSequence(false, true, this.seqCanvas.cursorX + this.getKeyboardNo1());
        this.endEditing();
    }

    void numberPressed(char value) {
        if (this.keyboardNo1 == null) {
            this.keyboardNo1 = new StringBuffer();
        }
        if (this.keyboardNo2 != null) {
            this.keyboardNo2.append(value);
        } else {
            this.keyboardNo1.append(value);
        }
    }

    int getKeyboardNo1() {
        try {
            if (this.keyboardNo1 != null) {
                int value = Integer.parseInt(this.keyboardNo1.toString());
                this.keyboardNo1 = null;
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keyboardNo1 = null;
        return 1;
    }

    int getKeyboardNo2() {
        try {
            if (this.keyboardNo2 != null) {
                int value = Integer.parseInt(this.keyboardNo2.toString());
                this.keyboardNo2 = null;
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.keyboardNo2 = null;
        return 1;
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
        MousePos pos = this.findMousePosition(evt);
        if (pos.isOverAnnotation() || pos.seqIndex == -1 || pos.column == -1) {
            return;
        }
        boolean didDrag = this.mouseDragging;
        this.mouseDragging = false;
        this.mouseWheelPressed = false;
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt, pos);
            evt.consume();
            return;
        }
        if (this.editingSeqs) {
            this.endEditing();
        } else {
            this.doMouseReleasedDefineMode(evt, didDrag);
        }
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.lastMousePress = evt.getPoint();
        MousePos pos = this.findMousePosition(evt);
        if (pos.isOverAnnotation() || pos.seqIndex == -1 || pos.column == -1) {
            return;
        }
        if (SwingUtilities.isMiddleMouseButton(evt)) {
            this.mouseWheelPressed = true;
            return;
        }
        boolean isControlDown = Platform.isControlDown(evt);
        if (evt.isShiftDown() || isControlDown) {
            this.editingSeqs = true;
            if (isControlDown) {
                this.groupEditing = true;
            }
        } else {
            this.doMousePressedDefineMode(evt, pos);
            return;
        }
        int seq = pos.seqIndex;
        int res = pos.column;
        if (seq < this.av.getAlignment().getHeight() && res < this.av.getAlignment().getSequenceAt(seq).getLength()) {
            this.editStartSeq = seq;
            this.editLastRes = res;
        } else {
            this.editStartSeq = -1;
            this.editLastRes = -1;
        }
    }

    @Override
    public void mouseOverSequence(SequenceI sequence, int index, int pos) {
        String tmp = sequence.hashCode() + " " + index + " " + pos;
        if (this.lastMessage == null || !this.lastMessage.equals(tmp)) {
            this.ssm.mouseOverSequence(sequence, index, pos, this.av);
        }
        this.lastMessage = tmp;
    }

    @Override
    public String highlightSequence(SearchResultsI results) {
        boolean noFastPaint;
        if (results == null || results.equals(this.lastSearchResults)) {
            return null;
        }
        this.lastSearchResults = results;
        boolean wasScrolled = false;
        if (this.av.isFollowHighlight()) {
            this.ap.setToScrollComplementPanel(false);
            wasScrolled = this.ap.scrollToPosition(results);
            if (wasScrolled) {
                this.seqCanvas.revalidate();
            }
            this.ap.setToScrollComplementPanel(true);
        }
        boolean bl = noFastPaint = wasScrolled && this.av.getWrapAlignment();
        if (this.seqCanvas.highlightSearchResults(results, noFastPaint)) {
            this.setStatusMessage(results);
        }
        return results.isEmpty() ? null : this.getHighlightInfo(results);
    }

    private String getHighlightInfo(SearchResultsI results) {
        AlignViewportI complement = this.ap.getAlignViewport().getCodingComplement();
        if (complement == null) {
            return null;
        }
        AlignFrame af = Desktop.getAlignFrameFor(complement);
        FeatureRenderer fr2 = af.getFeatureRenderer();
        int j = results.getSize();
        ArrayList<String> infos = new ArrayList<String>();
        for (int i = 0; i < j; ++i) {
            SequenceI seq;
            SequenceI ds;
            MappedFeatures mf;
            SearchResultMatchI match = results.getResults().get(i);
            int pos = match.getStart();
            if (pos != match.getEnd() || (mf = fr2.findComplementFeaturesAtResidue(ds = (seq = match.getSequence()).getDatasetSequence() == null ? seq : seq.getDatasetSequence(), pos)) == null) continue;
            for (SequenceFeature sf : mf.features) {
                String pv = mf.findProteinVariants(sf);
                if (pv.length() <= 0 || infos.contains(pv)) continue;
                infos.add(pv);
            }
        }
        if (infos.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (String info : infos) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(info);
        }
        return sb.toString();
    }

    @Override
    public VamsasSource getVamsasSource() {
        return this.ap == null ? null : this.ap.av;
    }

    @Override
    public void updateColours(SequenceI seq, int index) {
        System.out.println("update the seqPanel colours");
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        MousePos mousePos;
        if (this.editingSeqs) {
            this.mouseDragged(evt);
        }
        if ((mousePos = this.findMousePosition(evt)).equals(this.lastMousePosition)) {
            return;
        }
        this.lastMousePosition = mousePos;
        if (mousePos.isOverAnnotation()) {
            this.mouseMovedOverAnnotation(mousePos);
            return;
        }
        int seq = mousePos.seqIndex;
        int column = mousePos.column;
        if (column < 0 || seq < 0 || seq >= this.av.getAlignment().getHeight()) {
            this.lastMousePosition = null;
            this.setToolTipText(null);
            this.lastTooltip = null;
            this.ap.alignFrame.setStatus("");
            return;
        }
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (column >= sequence.getLength()) {
            return;
        }
        boolean isGapped = Comparison.isGap(sequence.getCharAt(column));
        int pos = this.setStatusMessage(sequence, column, seq);
        if (this.ssm != null && !isGapped) {
            this.mouseOverSequence(sequence, column, pos);
        }
        this.tooltipText.setLength(6);
        SequenceGroup[] groups = this.av.getAlignment().findAllGroups(sequence);
        if (groups != null) {
            for (int g = 0; g < groups.length; ++g) {
                if (groups[g].getStartRes() > column || groups[g].getEndRes() < column) continue;
                if (!groups[g].getName().startsWith("JTreeGroup") && !groups[g].getName().startsWith("JGroup")) {
                    this.tooltipText.append(groups[g].getName());
                }
                if (groups[g].getDescription() == null) continue;
                this.tooltipText.append(": " + groups[g].getDescription());
            }
        }
        if (this.av.isShowSequenceFeatures()) {
            AlignViewportI complement;
            AlignFrame af;
            FeatureRenderer fr2;
            MappedFeatures mf;
            List<SequenceFeature> features = this.ap.getFeatureRenderer().findFeaturesAtColumn(sequence, column + 1);
            this.seqARep.appendFeatures(this.tooltipText, pos, features, (FeatureRendererModel)this.ap.getSeqPanel().seqCanvas.fr);
            if (this.av.isShowComplementFeatures() && !Comparison.isGap(sequence.getCharAt(column)) && (mf = (fr2 = (af = Desktop.getAlignFrameFor(complement = this.ap.getAlignViewport().getCodingComplement())).getFeatureRenderer()).findComplementFeaturesAtResidue(sequence, pos)) != null) {
                this.seqARep.appendFeatures(this.tooltipText, pos, mf, (FeatureRendererModel)fr2);
            }
        }
        if (this.tooltipText.length() == 6) {
            this.setToolTipText(null);
            this.lastTooltip = null;
        } else {
            if (this.tooltipText.length() > 300) {
                this.tooltipText.setLength(300);
                this.tooltipText.append("...");
            }
            String textString = this.tooltipText.toString();
            if (this.lastTooltip == null || !this.lastTooltip.equals(textString)) {
                String formattedTooltipText = JvSwingUtils.wrapTooltip(true, textString);
                this.setToolTipText(formattedTooltipText);
                this.lastTooltip = textString;
            }
        }
    }

    protected void mouseMovedOverAnnotation(MousePos pos) {
        int column = pos.column;
        int rowIndex = pos.annotationIndex;
        if (column < 0 || !this.av.getWrapAlignment() || !this.av.isShowAnnotation() || rowIndex < 0) {
            return;
        }
        AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
        String tooltip = AnnotationPanel.buildToolTip(anns[rowIndex], column, anns);
        this.setToolTipText(tooltip);
        this.lastTooltip = tooltip;
        String msg = AnnotationPanel.getStatusMessage(this.av.getAlignment(), column, anns[rowIndex]);
        this.ap.alignFrame.setStatus(msg);
    }

    @Override
    public Point getToolTipLocation(MouseEvent event) {
        if (this.tooltipText == null || this.tooltipText.length() <= 6) {
            this.lastp = null;
            return null;
        }
        int x = event.getX();
        int w = this.getWidth();
        int wdth = w - x < 200 ? -(w / 2) : 5;
        Point p = this.lastp;
        if (!event.isShiftDown() || p == null) {
            this.lastp = p = new Point(event.getX() + wdth, event.getY() - 20);
        }
        return p;
    }

    int setStatusMessage(SequenceI sequence, int column, int seqIndex) {
        char sequenceChar = sequence.getCharAt(column);
        int pos = sequence.findPosition(column);
        this.setStatusMessage(sequence, seqIndex, sequenceChar, pos);
        return pos;
    }

    protected void setStatusMessage(SequenceI sequence, int seqIndex, char sequenceChar, int residuePos) {
        StringBuilder text = new StringBuilder(32);
        String seqno = seqIndex == -1 ? "" : " " + (seqIndex + 1);
        text.append("Sequence").append(seqno).append(" ID: ").append(sequence.getName());
        String residue = null;
        boolean isGapped = Comparison.isGap(sequenceChar);
        if (!isGapped) {
            boolean nucleotide = this.av.getAlignment().isNucleotide();
            String displayChar = String.valueOf(sequenceChar);
            residue = nucleotide ? ResidueProperties.nucleotideName.get(displayChar) : ("X".equalsIgnoreCase(displayChar) ? "X" : ("*".equals(displayChar) ? "STOP" : ResidueProperties.aa2Triplet.get(displayChar)));
            text.append(" ").append(nucleotide ? "Nucleotide" : "Residue").append(": ").append(residue == null ? displayChar : residue);
            text.append(" (").append(Integer.toString(residuePos)).append(")");
        }
        this.ap.alignFrame.setStatus(text.toString());
    }

    private void setStatusMessage(SearchResultsI results) {
        AlignmentI al = this.av.getAlignment();
        int sequenceIndex = al.findIndex(results);
        if (sequenceIndex == -1) {
            return;
        }
        SequenceI ds = al.getSequenceAt(sequenceIndex).getDatasetSequence();
        for (SearchResultMatchI m : results.getResults()) {
            SequenceI seq = m.getSequence();
            if (seq.getDatasetSequence() != null) {
                seq = seq.getDatasetSequence();
            }
            if (seq != ds) continue;
            int start = m.getStart();
            this.setStatusMessage(seq, sequenceIndex, seq.getCharAt(start - 1), start);
            return;
        }
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        MousePos pos = this.findMousePosition(evt);
        if (pos.isOverAnnotation() || pos.column == -1) {
            return;
        }
        if (this.mouseWheelPressed) {
            boolean inSplitFrame = this.ap.av.getCodingComplement() != null;
            boolean copyChanges = inSplitFrame && this.av.isProteinFontAsCdna();
            int oldWidth = this.av.getCharWidth();
            if (Math.abs((double)evt.getY() - this.lastMousePress.getY()) > Math.abs((double)evt.getX() - this.lastMousePress.getX())) {
                int fontSize = this.av.font.getSize();
                boolean fontChanged = false;
                if ((double)evt.getY() < this.lastMousePress.getY()) {
                    fontChanged = true;
                    --fontSize;
                } else if ((double)evt.getY() > this.lastMousePress.getY()) {
                    fontChanged = true;
                    ++fontSize;
                }
                if (fontSize < 1) {
                    fontSize = 1;
                }
                if (fontChanged) {
                    Font newFont = new Font(this.av.font.getName(), this.av.font.getStyle(), fontSize);
                    this.av.setFont(newFont, true);
                    this.av.setCharWidth(oldWidth);
                    this.ap.fontChanged();
                    if (copyChanges) {
                        this.ap.av.getCodingComplement().setFont(newFont, true);
                        SplitFrame splitFrame = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
                        splitFrame.adjustLayout();
                        splitFrame.repaint();
                    }
                }
            } else {
                int newWidth = 0;
                if ((double)evt.getX() < this.lastMousePress.getX() && this.av.getCharWidth() > 1) {
                    newWidth = this.av.getCharWidth() - 1;
                    this.av.setCharWidth(newWidth);
                } else if ((double)evt.getX() > this.lastMousePress.getX()) {
                    newWidth = this.av.getCharWidth() + 1;
                    this.av.setCharWidth(newWidth);
                }
                if (newWidth > 0) {
                    this.ap.paintAlignment(false, false);
                    if (copyChanges) {
                        this.av.getCodingComplement().setCharWidth(newWidth);
                        SplitFrame splitFrame = (SplitFrame)this.ap.alignFrame.getSplitViewContainer();
                        splitFrame.adjustLayout();
                        splitFrame.repaint();
                    }
                }
            }
            FontMetrics fm = this.getFontMetrics(this.av.getFont());
            this.av.validCharWidth = fm.charWidth('M') <= this.av.getCharWidth();
            this.lastMousePress = evt.getPoint();
            return;
        }
        if (!this.editingSeqs) {
            this.dragStretchGroup(evt);
            return;
        }
        int res = pos.column;
        if (res < 0) {
            res = 0;
        }
        if (this.editLastRes == -1 || this.editLastRes == res) {
            return;
        }
        if (res < this.av.getAlignment().getWidth() && res < this.editLastRes) {
            this.editSequence(false, false, res);
        } else {
            this.editSequence(true, false, res);
        }
        this.mouseDragging = true;
        if (this.scrollThread != null) {
            this.scrollThread.setMousePosition(evt.getPoint());
        }
    }

    synchronized void editSequence(boolean insertGap, boolean editSeq, int startres) {
        boolean inSelectionGroup;
        int fixedLeft = -1;
        int fixedRight = -1;
        boolean fixedColumns = false;
        SequenceGroup sg = this.av.getSelectionGroup();
        SequenceI seq = this.av.getAlignment().getSequenceAt(this.editStartSeq);
        if (!this.groupEditing && this.av.hasHiddenRows() && this.av.isHiddenRepSequence(seq)) {
            sg = this.av.getRepresentedSequences(seq);
            this.groupEditing = true;
        }
        StringBuilder message = new StringBuilder(64);
        String label = null;
        if (this.groupEditing) {
            message.append("Edit group:");
            label = MessageManager.getString("action.edit_group");
        } else {
            message.append("Edit sequence: " + seq.getName());
            label = seq.getName();
            if (label.length() > 10) {
                label = label.substring(0, 10);
            }
            label = MessageManager.formatMessage("label.edit_params", new String[]{label});
        }
        if (this.editCommand == null) {
            this.editCommand = new EditCommand(label);
        }
        if (insertGap) {
            message.append(" insert ");
        } else {
            message.append(" delete ");
        }
        message.append(Math.abs(startres - this.editLastRes) + " gaps.");
        this.ap.alignFrame.setStatus(message.toString());
        boolean bl = inSelectionGroup = sg != null && sg.getSequences(this.av.getHiddenRepSequences()).contains(seq);
        if (this.groupEditing || inSelectionGroup) {
            fixedColumns = true;
            if (sg == null) {
                if (!this.av.isHiddenRepSequence(seq)) {
                    this.endEditing();
                    return;
                }
                sg = this.av.getRepresentedSequences(seq);
            }
            fixedLeft = sg.getStartRes();
            fixedRight = sg.getEndRes();
            if (startres < fixedLeft && this.editLastRes >= fixedLeft || startres >= fixedLeft && this.editLastRes < fixedLeft || startres > fixedRight && this.editLastRes <= fixedRight || startres <= fixedRight && this.editLastRes > fixedRight) {
                this.endEditing();
                return;
            }
            if (fixedLeft > startres) {
                fixedRight = fixedLeft - 1;
                fixedLeft = 0;
            } else if (fixedRight < startres) {
                fixedLeft = fixedRight;
                fixedRight = -1;
            }
        }
        if (this.av.hasHiddenColumns()) {
            fixedColumns = true;
            int y1 = this.av.getAlignment().getHiddenColumns().getNextHiddenBoundary(true, startres);
            int y2 = this.av.getAlignment().getHiddenColumns().getNextHiddenBoundary(false, startres);
            if (insertGap && startres > y1 && this.editLastRes < y1 || !insertGap && startres < y2 && this.editLastRes > y2) {
                this.endEditing();
                return;
            }
            if (fixedLeft < y1 && (fixedRight > y2 || fixedRight == -1)) {
                if (startres >= y2) {
                    fixedLeft = y2;
                } else {
                    fixedRight = y2 - 1;
                }
            }
        }
        boolean success = this.doEditSequence(insertGap, editSeq, startres, fixedRight, fixedColumns, sg);
        String msg = SeqPanel.getEditStatusMessage(this.editCommand);
        this.ap.alignFrame.setStatus(msg == null ? " " : msg);
        if (!success) {
            this.endEditing();
        }
        this.editLastRes = startres;
        this.seqCanvas.repaint();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean doEditSequence(boolean insertGap, boolean editSeq, int startres, int fixedRight, boolean fixedColumns, SequenceGroup sg) {
        SequenceI seq = this.av.getAlignment().getSequenceAt(this.editStartSeq);
        SequenceI[] seqs = new SequenceI[]{seq};
        if (this.groupEditing) {
            int j;
            int g;
            List<SequenceI> vseqs = sg.getSequences(this.av.getHiddenRepSequences());
            int groupSize = vseqs.size();
            SequenceI[] groupSeqs = new SequenceI[groupSize];
            for (g = 0; g < groupSeqs.length; ++g) {
                groupSeqs[g] = vseqs.get(g);
            }
            if (insertGap) {
                if (sg.getStartRes() == 0 && sg.getEndRes() == fixedRight && sg.getEndRes() == this.av.getAlignment().getWidth() - 1) {
                    sg.setEndRes(this.av.getAlignment().getWidth() + startres - this.editLastRes);
                    fixedRight = sg.getEndRes();
                }
                boolean blank = false;
                while (fixedRight > this.editLastRes) {
                    blank = true;
                    block2: for (g = 0; g < groupSize; ++g) {
                        for (int j2 = 0; j2 < startres - this.editLastRes; ++j2) {
                            if (Comparison.isGap(groupSeqs[g].getCharAt(fixedRight - j2))) continue;
                            blank = false;
                            continue block2;
                        }
                    }
                    if (blank) break;
                    --fixedRight;
                }
                if (!blank) {
                    int hwidth;
                    if (sg.getSize() != this.av.getAlignment().getHeight()) return false;
                    if (this.av.hasHiddenColumns() && startres < this.av.getAlignment().getHiddenColumns().getNextHiddenBoundary(false, startres)) {
                        return false;
                    }
                    int alWidth = this.av.getAlignment().getWidth();
                    if (this.av.hasHiddenRows() && (hwidth = this.av.getAlignment().getHiddenSequences().getWidth()) > alWidth) {
                        alWidth = hwidth;
                    }
                    sg.setEndRes(sg.getEndRes() + startres - this.editLastRes);
                    fixedRight = alWidth + startres - this.editLastRes;
                }
            } else if (!insertGap) {
                for (g = 0; g < groupSize; ++g) {
                    for (j = startres; j < this.editLastRes; ++j) {
                        if (groupSeqs[g].getLength() <= j || Comparison.isGap(groupSeqs[g].getCharAt(j))) continue;
                        return false;
                    }
                }
            }
            if (insertGap) {
                if (fixedColumns && fixedRight != -1) {
                    for (j = this.editLastRes; j < startres; ++j) {
                        this.insertGap(j, groupSeqs, fixedRight);
                    }
                    return true;
                } else {
                    this.appendEdit(EditCommand.Action.INSERT_GAP, groupSeqs, startres, startres - this.editLastRes, false);
                }
                return true;
            } else if (fixedColumns && fixedRight != -1) {
                for (j = this.editLastRes; j > startres; --j) {
                    this.deleteChar(startres, groupSeqs, fixedRight);
                }
                return true;
            } else {
                this.appendEdit(EditCommand.Action.DELETE_GAP, groupSeqs, startres, this.editLastRes - startres, false);
            }
            return true;
        } else if (insertGap) {
            if (fixedColumns && fixedRight != -1) {
                for (int j = this.editLastRes; j < startres; ++j) {
                    if (this.insertGap(j, seqs, fixedRight)) continue;
                    return false;
                }
                return true;
            } else {
                this.appendEdit(EditCommand.Action.INSERT_GAP, seqs, this.editLastRes, startres - this.editLastRes, false);
            }
            return true;
        } else if (!editSeq) {
            if (fixedColumns && fixedRight != -1) {
                for (int j = this.editLastRes; j > startres; --j) {
                    if (!Comparison.isGap(seq.getCharAt(startres))) {
                        return false;
                    }
                    this.deleteChar(startres, seqs, fixedRight);
                }
                return true;
            } else {
                int max = 0;
                for (int m = startres; m < this.editLastRes && Comparison.isGap(seq.getCharAt(m)); ++m) {
                    ++max;
                }
                if (max <= 0) return true;
                this.appendEdit(EditCommand.Action.DELETE_GAP, seqs, startres, max, false);
            }
            return true;
        } else if (fixedColumns && fixedRight != -1) {
            for (int j = this.editLastRes; j < startres; ++j) {
                this.insertGap(j, seqs, fixedRight);
            }
            return true;
        } else {
            this.appendEdit(EditCommand.Action.INSERT_NUC, seqs, this.editLastRes, startres - this.editLastRes, false);
        }
        return true;
    }

    protected static String getEditStatusMessage(EditCommand editCommand) {
        if (editCommand == null) {
            return null;
        }
        int count = 0;
        for (EditCommand.Edit cmd : editCommand.getEdits()) {
            if (cmd.isSystemGenerated()) continue;
            count += cmd.getAction() == EditCommand.Action.INSERT_GAP ? cmd.getNumber() : -cmd.getNumber();
        }
        if (count == 0) {
            return null;
        }
        String msgKey = count > 1 ? "label.insert_gaps" : (count == 1 ? "label.insert_gap" : (count == -1 ? "label.delete_gap" : "label.delete_gaps"));
        count = Math.abs(count);
        return MessageManager.formatMessage(msgKey, String.valueOf(count));
    }

    boolean insertGap(int j, SequenceI[] seq, int fixedColumn) {
        int blankColumn = fixedColumn;
        for (int s = 0; s < seq.length; ++s) {
            for (blankColumn = fixedColumn; blankColumn > j && !Comparison.isGap(seq[s].getCharAt(blankColumn)); --blankColumn) {
            }
            if (blankColumn > j) continue;
            blankColumn = fixedColumn;
            this.endEditing();
            return false;
        }
        this.appendEdit(EditCommand.Action.DELETE_GAP, seq, blankColumn, 1, true);
        this.appendEdit(EditCommand.Action.INSERT_GAP, seq, j, 1, false);
        return true;
    }

    protected void appendEdit(EditCommand.Action action, SequenceI[] seq, int pos, int count, boolean systemGenerated) {
        EditCommand.Edit edit = new EditCommand.Edit(new EditCommand(), action, seq, pos, count, this.av.getAlignment().getGapCharacter());
        edit.setSystemGenerated(systemGenerated);
        this.editCommand.appendEdit(edit, this.av.getAlignment(), true, null);
    }

    void deleteChar(int j, SequenceI[] seqs, int fixedColumn) {
        this.appendEdit(EditCommand.Action.DELETE_GAP, seqs, j, 1, false);
        this.appendEdit(EditCommand.Action.INSERT_GAP, seqs, fixedColumn, 1, true);
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.oldSeq < 0) {
            this.oldSeq = 0;
        }
        this.stopScrolling();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lastMousePosition = null;
        this.ap.alignFrame.setStatus(" ");
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging && this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
        }
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        SequenceGroup sg = null;
        MousePos pos = this.findMousePosition(evt);
        if (pos.isOverAnnotation() || pos.seqIndex == -1 || pos.column == -1) {
            return;
        }
        if (evt.getClickCount() > 1) {
            sg = this.av.getSelectionGroup();
            if (sg != null && sg.getSize() == 1 && sg.getEndRes() - sg.getStartRes() < 2) {
                this.av.setSelectionGroup(null);
            }
            int column = pos.column;
            SequenceI sequence = this.av.getAlignment().getSequenceAt(pos.seqIndex);
            List<SequenceFeature> features = this.seqCanvas.getFeatureRenderer().findFeaturesAtColumn(sequence, column + 1);
            if (!features.isEmpty()) {
                SearchResults highlight = new SearchResults();
                highlight.addResult(sequence, features.get(0).getBegin(), features.get(0).getEnd());
                this.seqCanvas.highlightSearchResults(highlight, false);
                List<SequenceI> seqs = Collections.singletonList(sequence);
                this.seqCanvas.getFeatureRenderer().amendFeatures(seqs, features, false, this.ap);
                this.av.setSearchResults(null);
                this.seqCanvas.repaint();
            }
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        double wheelRotation = e.getPreciseWheelRotation();
        if (wheelRotation > 0.0) {
            if (e.isShiftDown()) {
                this.av.getRanges().scrollRight(true);
            } else {
                this.av.getRanges().scrollUp(false);
            }
        } else if (wheelRotation < 0.0) {
            if (e.isShiftDown()) {
                this.av.getRanges().scrollRight(false);
            } else {
                this.av.getRanges().scrollUp(true);
            }
        }
        this.mouseMoved(e);
        ToolTipManager.sharedInstance().mouseMoved(e);
    }

    protected void doMousePressedDefineMode(MouseEvent evt, MousePos pos) {
        int seq;
        if (pos.isOverAnnotation() || pos.seqIndex == -1 || pos.column == -1) {
            return;
        }
        int res = pos.column;
        this.oldSeq = seq = pos.seqIndex;
        this.updateOverviewAndStructs = false;
        this.startWrapBlock = this.wrappedBlock;
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (sequence == null || res > sequence.getLength()) {
            return;
        }
        this.stretchGroup = this.av.getSelectionGroup();
        if (this.stretchGroup == null || !this.stretchGroup.contains(sequence, res)) {
            this.stretchGroup = this.av.getAlignment().findGroup(sequence, res);
            if (this.stretchGroup != null) {
                this.av.setSelectionGroup(this.stretchGroup);
            }
        }
        if (evt.isPopupTrigger()) {
            this.showPopupMenu(evt, pos);
            return;
        }
        if (SwingUtilities.isRightMouseButton(evt) && !Platform.isAMac()) {
            return;
        }
        if (this.av.cursorMode) {
            this.seqCanvas.cursorX = res;
            this.seqCanvas.cursorY = seq;
            this.seqCanvas.repaint();
            return;
        }
        if (this.stretchGroup == null) {
            this.createStretchGroup(res, sequence);
        }
        if (this.stretchGroup != null) {
            this.stretchGroup.addPropertyChangeListener(this.seqCanvas);
        }
        this.seqCanvas.repaint();
    }

    private void createStretchGroup(int res, SequenceI sequence) {
        SequenceGroup sg = new SequenceGroup();
        sg.setStartRes(res);
        sg.setEndRes(res);
        sg.addSequence(sequence, false);
        this.av.setSelectionGroup(sg);
        this.stretchGroup = sg;
        if (this.av.getConservationSelected()) {
            SliderPanel.setConservationSlider(this.ap, this.av.getResidueShading(), this.ap.getViewName());
        }
        if (this.av.getAbovePIDThreshold()) {
            SliderPanel.setPIDSliderSource(this.ap, this.av.getResidueShading(), this.ap.getViewName());
        }
        if (this.stretchGroup != null && this.stretchGroup.getEndRes() == res) {
            this.changeEndRes = true;
        } else if (this.stretchGroup != null && this.stretchGroup.getStartRes() == res) {
            this.changeStartRes = true;
        }
        this.stretchGroup.getWidth();
    }

    void showPopupMenu(MouseEvent evt, MousePos pos) {
        int column = pos.column;
        int seq = pos.seqIndex;
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (sequence != null) {
            PopupMenu pop = new PopupMenu(this.ap, sequence, column);
            pop.show(this, evt.getX(), evt.getY());
        }
    }

    protected void doMouseReleasedDefineMode(MouseEvent evt, boolean afterDrag) {
        if (this.stretchGroup == null) {
            return;
        }
        this.stretchGroup.removePropertyChangeListener(this.seqCanvas);
        boolean vischange = this.stretchGroup.recalcConservation(true);
        this.updateOverviewAndStructs |= vischange && this.av.isSelectionDefinedGroup() && afterDrag;
        if (this.stretchGroup.cs != null) {
            if (afterDrag) {
                this.stretchGroup.cs.alignmentChanged(this.stretchGroup, this.av.getHiddenRepSequences());
            }
            ResidueShaderI groupColourScheme = this.stretchGroup.getGroupColourScheme();
            String name = this.stretchGroup.getName();
            if (this.stretchGroup.cs.conservationApplied()) {
                SliderPanel.setConservationSlider(this.ap, groupColourScheme, name);
            }
            if (this.stretchGroup.cs.getThreshold() > 0) {
                SliderPanel.setPIDSliderSource(this.ap, groupColourScheme, name);
            }
        }
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        this.ap.paintAlignment(this.updateOverviewAndStructs, this.updateOverviewAndStructs);
        this.updateOverviewAndStructs = false;
        this.changeEndRes = false;
        this.changeStartRes = false;
        this.stretchGroup = null;
        this.av.sendSelection();
    }

    protected void dragStretchGroup(MouseEvent evt) {
        if (this.stretchGroup == null) {
            return;
        }
        MousePos pos = this.findMousePosition(evt);
        if (pos.isOverAnnotation() || pos.column == -1 || pos.seqIndex == -1) {
            return;
        }
        int res = pos.column;
        int y = pos.seqIndex;
        if (this.wrappedBlock != this.startWrapBlock) {
            return;
        }
        res = Math.min(res, this.av.getAlignment().getWidth() - 1);
        if (this.stretchGroup.getEndRes() == res) {
            this.changeEndRes = true;
        } else if (this.stretchGroup.getStartRes() == res) {
            this.changeStartRes = true;
        }
        if (res < this.av.getRanges().getStartRes()) {
            res = this.av.getRanges().getStartRes();
        }
        if (this.changeEndRes) {
            if (res > this.stretchGroup.getStartRes() - 1) {
                this.stretchGroup.setEndRes(res);
                this.updateOverviewAndStructs |= this.av.isSelectionDefinedGroup();
            }
        } else if (this.changeStartRes && res < this.stretchGroup.getEndRes() + 1) {
            this.stretchGroup.setStartRes(res);
            this.updateOverviewAndStructs |= this.av.isSelectionDefinedGroup();
        }
        int dragDirection = 0;
        if (y > this.oldSeq) {
            dragDirection = 1;
        } else if (y < this.oldSeq) {
            dragDirection = -1;
        }
        while (y != this.oldSeq && this.oldSeq > -1 && y < this.av.getAlignment().getHeight()) {
            Sequence seq = (Sequence)this.av.getAlignment().getSequenceAt(this.oldSeq);
            this.oldSeq += dragDirection;
            if (this.oldSeq < 0) break;
            Sequence nextSeq = (Sequence)this.av.getAlignment().getSequenceAt(this.oldSeq);
            if (this.stretchGroup.getSequences(null).contains(nextSeq)) {
                this.stretchGroup.deleteSequence(seq, false);
                this.updateOverviewAndStructs |= this.av.isSelectionDefinedGroup();
                continue;
            }
            if (seq != null) {
                this.stretchGroup.addSequence(seq, false);
            }
            this.stretchGroup.addSequence(nextSeq, false);
            this.updateOverviewAndStructs |= this.av.isSelectionDefinedGroup();
        }
        if (this.oldSeq < 0) {
            this.oldSeq = -1;
        }
        this.mouseDragging = true;
        if (this.scrollThread != null) {
            this.scrollThread.setMousePosition(evt.getPoint());
        }
        StringBuilder status = new StringBuilder(64);
        List<SequenceI> seqs = this.stretchGroup.getSequences();
        String name = seqs.get(0).getName();
        if (name.length() > 20) {
            name = name.substring(0, 20);
        }
        status.append(name).append(" - ");
        name = seqs.get(seqs.size() - 1).getName();
        if (name.length() > 20) {
            name = name.substring(0, 20);
        }
        status.append(name).append(" ");
        int startRes = this.stretchGroup.getStartRes();
        status.append(" cols ").append(String.valueOf(startRes + 1)).append("-");
        int endRes = this.stretchGroup.getEndRes();
        status.append(String.valueOf(endRes + 1));
        status.append(" (").append(String.valueOf(seqs.size())).append(" x ").append(String.valueOf(endRes - startRes + 1)).append(")");
        this.ap.alignFrame.setStatus(status.toString());
    }

    void stopScrolling() {
        if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
            this.scrollThread = null;
        }
        this.mouseDragging = false;
    }

    void startScrolling(Point mousePos) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
        }
        this.mouseDragging = true;
        this.scrollThread.setMousePosition(mousePos);
    }

    @Override
    public void selection(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
        boolean iSentTheSelection;
        boolean bl = iSentTheSelection = this.av == source || source instanceof AlignViewport && ((AlignmentViewport)((Object)source)).getSequenceSetId().equals(this.av.getSequenceSetId());
        if (iSentTheSelection) {
            if (this.ap.getCalculationDialog() != null) {
                this.ap.getCalculationDialog().validateCalcTypes();
            }
            return;
        }
        if (!this.av.followSelection) {
            return;
        }
        if (this.av.isSelectionGroupChanged(false) || this.av.isColSelChanged(false)) {
            return;
        }
        if (this.selectionFromTranslation(seqsel, colsel, hidden, source)) {
            return;
        }
        boolean repaint = false;
        boolean copycolsel = false;
        SequenceGroup sgroup = null;
        if (seqsel != null && seqsel.getSize() > 0) {
            if (this.av.getAlignment() == null) {
                Cache.log.warn((Object)("alignviewport av SeqSetId=" + this.av.getSequenceSetId() + " ViewId=" + this.av.getViewId() + " 's alignment is NULL! returning immediately."));
                return;
            }
            sgroup = seqsel.intersect(this.av.getAlignment(), this.av.hasHiddenRows() ? this.av.getHiddenRepSequences() : null);
            if (sgroup != null && sgroup.getSize() > 0) {
                copycolsel = true;
            }
        }
        if (sgroup != null && sgroup.getSize() > 0) {
            this.av.setSelectionGroup(sgroup);
        } else {
            this.av.setSelectionGroup(null);
        }
        this.av.isSelectionGroupChanged(true);
        repaint = true;
        if (copycolsel) {
            if (colsel == null || colsel.isEmpty()) {
                if (this.av.getColumnSelection() != null) {
                    this.av.getColumnSelection().clear();
                    repaint = true;
                }
            } else if (this.av.getColumnSelection() == null) {
                this.av.setColumnSelection(new ColumnSelection(colsel));
            } else {
                this.av.getColumnSelection().setElementsFrom(colsel, this.av.getAlignment().getHiddenColumns());
            }
            this.av.isColSelChanged(true);
            repaint = true;
        }
        if (copycolsel && this.av.hasHiddenColumns() && this.av.getAlignment().getHiddenColumns() == null) {
            System.err.println("Bad things");
        }
        if (repaint) {
            PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        }
        if (this.ap.getCalculationDialog() != null) {
            this.ap.getCalculationDialog().validateCalcTypes();
        }
    }

    protected boolean selectionFromTranslation(SequenceGroup seqsel, ColumnSelection colsel, HiddenColumns hidden, SelectionSource source) {
        if (!(source instanceof AlignViewportI)) {
            return false;
        }
        AlignViewportI sourceAv = (AlignViewportI)((Object)source);
        if (sourceAv.getCodingComplement() != this.av && this.av.getCodingComplement() != sourceAv) {
            return false;
        }
        SequenceGroup sg = MappingUtils.mapSequenceGroup(seqsel, sourceAv, this.av);
        this.av.setSelectionGroup(sg);
        this.av.isSelectionGroupChanged(true);
        ColumnSelection cs = new ColumnSelection();
        HiddenColumns hs = new HiddenColumns();
        MappingUtils.mapColumnSelection(colsel, hidden, sourceAv, this.av, cs, hs);
        this.av.setColumnSelection(cs);
        boolean hiddenChanged = this.av.getAlignment().setHiddenColumns(hs);
        if (this.ap.getCalculationDialog() != null) {
            this.ap.getCalculationDialog().validateCalcTypes();
        }
        this.ap.paintAlignment(hiddenChanged, hiddenChanged);
        return true;
    }

    public SearchResultsI getLastSearchResults() {
        return this.lastSearchResults;
    }

    class ScrollThread
    extends Thread {
        private Point mousePos;
        private volatile boolean threadRunning = true;

        public ScrollThread() {
            this.setName("SeqPanel$ScrollThread");
            this.start();
        }

        public void setMousePosition(Point p) {
            this.mousePos = p;
        }

        public void stopScrolling() {
            this.threadRunning = false;
        }

        @Override
        public void run() {
            while (this.threadRunning && SeqPanel.this.mouseDragging) {
                if (this.mousePos != null) {
                    boolean scrolled = false;
                    ViewportRanges ranges = SeqPanel.this.av.getRanges();
                    if (this.mousePos.y < 0) {
                        scrolled = ranges.scrollUp(true);
                    } else if (this.mousePos.y >= SeqPanel.this.getHeight()) {
                        scrolled = ranges.scrollUp(false);
                    }
                    if (this.mousePos.x < 0) {
                        scrolled |= ranges.scrollRight(false);
                    } else if (this.mousePos.x >= SeqPanel.this.getWidth()) {
                        scrolled |= ranges.scrollRight(true);
                    }
                    if (!scrolled) {
                        this.threadRunning = false;
                        SeqPanel.this.ap.repaint();
                    }
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {}
            }
        }
    }

    static class MousePos {
        final int column;
        final int seqIndex;
        final int annotationIndex;

        MousePos(int col, int seq, int ann) {
            this.column = col;
            this.seqIndex = seq;
            this.annotationIndex = ann;
        }

        boolean isOverAnnotation() {
            return this.annotationIndex != -1;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof MousePos)) {
                return false;
            }
            MousePos o = (MousePos)obj;
            boolean b = this.column == o.column && this.seqIndex == o.seqIndex && this.annotationIndex == o.annotationIndex;
            return b;
        }

        public int hashCode() {
            return this.column + this.seqIndex + this.annotationIndex;
        }

        public String toString() {
            return String.format("c%d:s%d:a%d", this.column, this.seqIndex, this.annotationIndex);
        }
    }
}

