/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import ext.edu.ucsf.rbvi.strucviz2.StructureManager;
import jalview.analysis.AnnotationSorter;
import jalview.bin.Cache;
import jalview.gui.AlignFrame;
import jalview.gui.Desktop;
import jalview.gui.Help;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.StructureViewer;
import jalview.gui.WsPreferences;
import jalview.io.BackupFilesPresetEntry;
import jalview.io.FileFormatI;
import jalview.io.JalviewFileChooser;
import jalview.io.JalviewFileView;
import jalview.io.PIRFile;
import jalview.jbgui.GPreferences;
import jalview.jbgui.GSequenceLink;
import jalview.renderer.OverviewResColourFinder;
import jalview.schemes.ColourSchemeI;
import jalview.schemes.ColourSchemes;
import jalview.urls.UrlLinkTableModel;
import jalview.urls.api.UrlProviderI;
import jalview.urls.desktop.DesktopUrlProviderFactory;
import jalview.util.BrowserLauncher;
import jalview.util.FileUtils;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.ws.sifts.SiftsSettings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.help.HelpSetException;
import javax.swing.JColorChooser;
import javax.swing.JFileChooser;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;

public class Preferences
extends GPreferences {
    public static final String COMMA = ",";
    public static final String HMMSEARCH_SEQCOUNT = "HMMSEARCH_SEQCOUNT";
    public static final String HMMINFO_GLOBAL_BACKGROUND = "HMMINFO_GLOBAL_BACKGROUND";
    public static final String HMMALIGN_TRIM_TERMINI = "HMMALIGN_TRIM_TERMINI";
    public static final String ENABLE_SPLIT_FRAME = "ENABLE_SPLIT_FRAME";
    public static final String SCALE_PROTEIN_TO_CDNA = "SCALE_PROTEIN_TO_CDNA";
    public static final String DEFAULT_COLOUR = "DEFAULT_COLOUR";
    public static final String DEFAULT_COLOUR_PROT = "DEFAULT_COLOUR_PROT";
    public static final String DEFAULT_COLOUR_NUC = "DEFAULT_COLOUR_NUC";
    public static final String ADD_TEMPFACT_ANN = "ADD_TEMPFACT_ANN";
    public static final String ADD_SS_ANN = "ADD_SS_ANN";
    public static final String USE_RNAVIEW = "USE_RNAVIEW";
    public static final String STRUCT_FROM_PDB = "STRUCT_FROM_PDB";
    public static final String STRUCTURE_DISPLAY = "STRUCTURE_DISPLAY";
    public static final String CHIMERA_PATH = "CHIMERA_PATH";
    public static final String HMMER_PATH = "HMMER_PATH";
    public static final String CYGWIN_PATH = "CYGWIN_PATH";
    public static final String HMMSEARCH_DBS = "HMMSEARCH_DBS";
    public static final String SORT_ANNOTATIONS = "SORT_ANNOTATIONS";
    public static final String SHOW_AUTOCALC_ABOVE = "SHOW_AUTOCALC_ABOVE";
    public static final String SHOW_OCCUPANCY = "SHOW_OCCUPANCY";
    public static final String SHOW_OV_HIDDEN_AT_START = "SHOW_OV_HIDDEN_AT_START";
    public static final String USE_LEGACY_GAP = "USE_LEGACY_GAP";
    public static final String GAP_COLOUR = "GAP_COLOUR";
    public static final String HIDDEN_COLOUR = "HIDDEN_COLOUR";
    private static final int MIN_FONT_SIZE = 1;
    private static final int MAX_FONT_SIZE = 30;
    public static UrlProviderI sequenceUrlLinks;
    public static UrlLinkTableModel dataModel;
    public static List<String> groupURLLinks;
    JInternalFrame frame;
    private WsPreferences wsPrefs;
    private OptionsParam promptEachTimeOpt = new OptionsParam(MessageManager.getString("label.prompt_each_time"), "Prompt each time");
    private OptionsParam lineArtOpt = new OptionsParam(MessageManager.getString("label.lineart"), "Lineart");
    private OptionsParam textOpt = new OptionsParam(MessageManager.getString("action.text"), "Text");

    public Preferences() {
        int i;
        this.frame = new JInternalFrame();
        this.frame.setContentPane(this);
        this.wsPrefs = new WsPreferences();
        this.wsTab.add((Component)this.wsPrefs, "Center");
        int width = 500;
        int height = 450;
        new Platform();
        if (Platform.isAMac()) {
            width = 570;
            height = 480;
        }
        Desktop.addInternalFrame(this.frame, MessageManager.getString("label.preferences"), width, height);
        this.frame.setMinimumSize(new Dimension(width, height));
        this.hmmrTrimTermini.setSelected(Cache.getDefault(HMMALIGN_TRIM_TERMINI, false));
        if (Cache.getDefault(HMMINFO_GLOBAL_BACKGROUND, false)) {
            this.hmmerBackgroundUniprot.setSelected(true);
        } else {
            this.hmmerBackgroundAlignment.setSelected(true);
        }
        this.hmmerSequenceCount.setText(Cache.getProperty(HMMSEARCH_SEQCOUNT));
        this.hmmerPath.setText(Cache.getProperty(HMMER_PATH));
        this.hmmerPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.validateHmmerPath();
            }
        });
        this.hmmerPath.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                Preferences.this.validateHmmerPath();
            }
        });
        if (this.cygwinPath != null) {
            String path = Cache.getProperty(CYGWIN_PATH);
            if (path == null) {
                path = FileUtils.getPathTo("bash");
            }
            this.cygwinPath.setText(path);
            this.cygwinPath.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Preferences.this.validateCygwinPath();
                }
            });
            this.cygwinPath.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    Preferences.this.validateCygwinPath();
                }
            });
        }
        this.seqLimit.setSelected(Cache.getDefault("SHOW_JVSUFFIX", true));
        this.rightAlign.setSelected(Cache.getDefault("RIGHT_ALIGN_IDS", false));
        this.fullScreen.setSelected(Cache.getDefault("SHOW_FULLSCREEN", false));
        this.annotations.setSelected(Cache.getDefault("SHOW_ANNOTATIONS", true));
        this.conservation.setSelected(Cache.getDefault("SHOW_CONSERVATION", true));
        this.quality.setSelected(Cache.getDefault("SHOW_QUALITY", true));
        this.identity.setSelected(Cache.getDefault("SHOW_IDENTITY", true));
        this.openoverv.setSelected(Cache.getDefault("SHOW_OVERVIEW", false));
        this.showUnconserved.setSelected(Cache.getDefault("SHOW_UNCONSERVED", false));
        this.showOccupancy.setSelected(Cache.getDefault(SHOW_OCCUPANCY, false));
        this.showGroupConsensus.setSelected(Cache.getDefault("SHOW_GROUP_CONSENSUS", false));
        this.showGroupConservation.setSelected(Cache.getDefault("SHOW_GROUP_CONSERVATION", false));
        this.showConsensHistogram.setSelected(Cache.getDefault("SHOW_CONSENSUS_HISTOGRAM", true));
        this.showConsensLogo.setSelected(Cache.getDefault("SHOW_CONSENSUS_LOGO", false));
        this.showInformationHistogram.setSelected(Cache.getDefault("SHOW_INFORMATION_HISTOGRAM", true));
        this.showHMMLogo.setSelected(Cache.getDefault("SHOW_HMM_LOGO", false));
        this.showNpTooltip.setSelected(Cache.getDefault("SHOW_NPFEATS_TOOLTIP", true));
        this.showDbRefTooltip.setSelected(Cache.getDefault("SHOW_DBREFS_TOOLTIP", true));
        String[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (i = 0; i < fonts.length; ++i) {
            this.fontNameCB.addItem(fonts[i]);
        }
        for (i = 1; i <= 30; ++i) {
            this.fontSizeCB.addItem(i + "");
        }
        this.fontStyleCB.addItem("plain");
        this.fontStyleCB.addItem("bold");
        this.fontStyleCB.addItem("italic");
        this.fontNameCB.setSelectedItem(Cache.getDefault("FONT_NAME", "SansSerif"));
        this.fontSizeCB.setSelectedItem(Cache.getDefault("FONT_SIZE", "10"));
        this.fontStyleCB.setSelectedItem(Cache.getDefault("FONT_STYLE", "0"));
        this.smoothFont.setSelected(Cache.getDefault("ANTI_ALIAS", false));
        this.scaleProteinToCdna.setSelected(Cache.getDefault(SCALE_PROTEIN_TO_CDNA, false));
        this.idItalics.setSelected(Cache.getDefault("ID_ITALICS", true));
        this.wrap.setSelected(Cache.getDefault("WRAP_ALIGNMENT", false));
        this.gapSymbolCB.addItem("-");
        this.gapSymbolCB.addItem(".");
        this.gapSymbolCB.setSelectedItem(Cache.getDefault("GAP_SYMBOL", "-"));
        this.sortby.addItem("No sort");
        this.sortby.addItem("Id");
        this.sortby.addItem("Pairwise Identity");
        this.sortby.setSelectedItem(Cache.getDefault("SORT_ALIGNMENT", "No sort"));
        this.sortAnnBy.addItem(AnnotationSorter.SequenceAnnotationOrder.NONE.toString());
        this.sortAnnBy.addItem(AnnotationSorter.SequenceAnnotationOrder.SEQUENCE_AND_LABEL.toString());
        this.sortAnnBy.addItem(AnnotationSorter.SequenceAnnotationOrder.LABEL_AND_SEQUENCE.toString());
        AnnotationSorter.SequenceAnnotationOrder savedSort = AnnotationSorter.SequenceAnnotationOrder.valueOf(Cache.getDefault(SORT_ANNOTATIONS, AnnotationSorter.SequenceAnnotationOrder.NONE.name()));
        this.sortAnnBy.setSelectedItem(savedSort.toString());
        this.sortAutocalc.addItem("Autocalculated first");
        this.sortAutocalc.addItem("Autocalculated last");
        boolean showAbove = Cache.getDefault(SHOW_AUTOCALC_ABOVE, true);
        this.sortAutocalc.setSelectedItem(showAbove ? this.sortAutocalc.getItemAt(0) : this.sortAutocalc.getItemAt(1));
        this.startupCheckbox.setSelected(Cache.getDefault("SHOW_STARTUP_FILE", true));
        this.startupFileTextfield.setText(Cache.getDefault("STARTUP_FILE", Cache.getDefault("www.jalview.org", "http://www.jalview.org") + "/examples/exampleFile_2_3.jar"));
        this.protColour.addItem("None");
        this.nucColour.addItem("None");
        for (ColourSchemeI cs : ColourSchemes.getInstance().getColourSchemes()) {
            String name = cs.getSchemeName();
            this.protColour.addItem(name);
            this.nucColour.addItem(name);
        }
        String oldProp = Cache.getDefault(DEFAULT_COLOUR, "None");
        String newProp = Cache.getDefault(DEFAULT_COLOUR_PROT, null);
        this.protColour.setSelectedItem(newProp != null ? newProp : oldProp);
        newProp = Cache.getDefault(DEFAULT_COLOUR_NUC, null);
        this.nucColour.setSelectedItem(newProp != null ? newProp : oldProp);
        this.minColour.setBackground(Cache.getDefaultColour("ANNOTATIONCOLOUR_MIN", Color.orange));
        this.maxColour.setBackground(Cache.getDefaultColour("ANNOTATIONCOLOUR_MAX", Color.red));
        this.gapColour.setBackground(Cache.getDefaultColour(GAP_COLOUR, OverviewResColourFinder.OVERVIEW_DEFAULT_GAP));
        this.hiddenColour.setBackground(Cache.getDefaultColour(HIDDEN_COLOUR, OverviewResColourFinder.OVERVIEW_DEFAULT_HIDDEN));
        this.useLegacyGap.setSelected(Cache.getDefault(USE_LEGACY_GAP, false));
        this.gapLabel.setEnabled(!this.useLegacyGap.isSelected());
        this.gapColour.setEnabled(!this.useLegacyGap.isSelected());
        this.showHiddenAtStart.setSelected(Cache.getDefault(SHOW_OV_HIDDEN_AT_START, false));
        boolean structSelected = Cache.getDefault(STRUCT_FROM_PDB, false);
        this.structFromPdb.setSelected(structSelected);
        this.useRnaView.setSelected(Cache.getDefault(USE_RNAVIEW, false));
        this.useRnaView.setEnabled(structSelected);
        this.addSecondaryStructure.setSelected(Cache.getDefault(ADD_SS_ANN, false));
        this.addSecondaryStructure.setEnabled(structSelected);
        this.addTempFactor.setSelected(Cache.getDefault(ADD_TEMPFACT_ANN, false));
        this.addTempFactor.setEnabled(structSelected);
        this.structViewer.setSelectedItem(Cache.getDefault(STRUCTURE_DISPLAY, StructureViewer.ViewerType.JMOL.name()));
        this.chimeraPath.setText(Cache.getDefault(CHIMERA_PATH, ""));
        this.chimeraPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.validateChimeraPath();
            }
        });
        if (Cache.getDefault("MAP_WITH_SIFTS", false)) {
            this.siftsMapping.setSelected(true);
        } else {
            this.nwMapping.setSelected(true);
        }
        SiftsSettings.setMapWithSifts(Cache.getDefault("MAP_WITH_SIFTS", false));
        this.linkUrlTable.setModel(dataModel);
        final TableRowSorter<TableModel> sorter = new TableRowSorter<TableModel>(this.linkUrlTable.getModel());
        this.linkUrlTable.setRowSorter(sorter);
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        UrlLinkTableModel m = (UrlLinkTableModel)this.linkUrlTable.getModel();
        sortKeys.add(new RowSorter.SortKey(m.getPrimaryColumn(), SortOrder.DESCENDING));
        sortKeys.add(new RowSorter.SortKey(m.getSelectedColumn(), SortOrder.DESCENDING));
        sortKeys.add(new RowSorter.SortKey(m.getNameColumn(), SortOrder.ASCENDING));
        sorter.setSortKeys(sortKeys);
        sorter.sort();
        ActionListener onReset = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.filterTB.setText("");
                sorter.setRowFilter(RowFilter.regexFilter("", new int[0]));
            }
        };
        this.doReset.addActionListener(onReset);
        final RowFilter<TableModel, Object> customUrlFilter = new RowFilter<TableModel, Object>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Object> entry) {
                return ((UrlLinkTableModel)entry.getModel()).isUserEntry(entry);
            }
        };
        TableRowSorter<TableModel> customSorter = new TableRowSorter<TableModel>(this.linkUrlTable.getModel());
        customSorter.setRowFilter(customUrlFilter);
        ActionListener onCustomOnly = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Preferences.this.filterTB.setText("");
                sorter.setRowFilter(customUrlFilter);
            }
        };
        this.userOnly.addActionListener(onCustomOnly);
        this.filterTB.getDocument().addDocumentListener(new DocumentListener(){
            String caseInsensitiveFlag = "(?i)";

            @Override
            public void changedUpdate(DocumentEvent e) {
                sorter.setRowFilter(RowFilter.regexFilter(this.caseInsensitiveFlag + Preferences.this.filterTB.getText(), new int[0]));
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                sorter.setRowFilter(RowFilter.regexFilter(this.caseInsensitiveFlag + Preferences.this.filterTB.getText(), new int[0]));
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                sorter.setRowFilter(RowFilter.regexFilter(this.caseInsensitiveFlag + Preferences.this.filterTB.getText(), new int[0]));
            }
        });
        this.linkUrlTable.getSelectionModel().addListSelectionListener(new UrlListSelectionHandler());
        int onClickCol = ((UrlLinkTableModel)this.linkUrlTable.getModel()).getPrimaryColumn();
        String onClickName = this.linkUrlTable.getColumnName(onClickCol);
        this.linkUrlTable.getColumn(onClickName).setCellRenderer(new GPreferences.RadioButtonRenderer());
        this.linkUrlTable.getColumn(onClickName).setCellEditor(new GPreferences.RadioButtonEditor());
        for (int column = 0; column < this.linkUrlTable.getColumnCount(); ++column) {
            if (!this.linkUrlTable.getModel().getColumnClass(column).equals(Boolean.class)) continue;
            TableColumn tableColumn = this.linkUrlTable.getColumnModel().getColumn(column);
            int preferredWidth = tableColumn.getMinWidth();
            TableCellRenderer cellRenderer = this.linkUrlTable.getCellRenderer(0, column);
            Component c = this.linkUrlTable.prepareRenderer(cellRenderer, 0, column);
            int cwidth = c.getPreferredSize().width + this.linkUrlTable.getIntercellSpacing().width;
            preferredWidth = Math.max(preferredWidth, cwidth);
            tableColumn.setPreferredWidth(preferredWidth);
        }
        this.useProxy.setSelected(Cache.getDefault("USE_PROXY", false));
        this.useProxy_actionPerformed();
        this.proxyServerTB.setText(Cache.getDefault("PROXY_SERVER", ""));
        this.proxyPortTB.setText(Cache.getDefault("PROXY_PORT", ""));
        this.defaultBrowser.setText(Cache.getDefault("DEFAULT_BROWSER", ""));
        this.usagestats.setSelected(Cache.getDefault("USAGESTATS", false));
        this.questionnaire.setSelected(Cache.getProperty("NOQUESTIONNAIRES") == null);
        this.versioncheck.setSelected(Cache.getDefault("VERSION_CHECK", true));
        this.epsRendering.addItem(this.promptEachTimeOpt);
        this.epsRendering.addItem(this.lineArtOpt);
        this.epsRendering.addItem(this.textOpt);
        String defaultEPS = Cache.getDefault("EPS_RENDERING", "Prompt each time");
        if (defaultEPS.equalsIgnoreCase("Text")) {
            this.epsRendering.setSelectedItem(this.textOpt);
        } else if (defaultEPS.equalsIgnoreCase("Lineart")) {
            this.epsRendering.setSelectedItem(this.lineArtOpt);
        } else {
            this.epsRendering.setSelectedItem(this.promptEachTimeOpt);
        }
        this.autoIdWidth.setSelected(Cache.getDefault("FIGURE_AUTOIDWIDTH", false));
        this.userIdWidth.setEnabled(!this.autoIdWidth.isSelected());
        this.userIdWidthlabel.setEnabled(!this.autoIdWidth.isSelected());
        Integer wi = Cache.getIntegerProperty("FIGURE_FIXEDIDWIDTH");
        this.userIdWidth.setText(wi == null ? "" : wi.toString());
        this.blcjv.setSelected(Cache.getDefault("BLC_JVSUFFIX", true));
        this.clustaljv.setSelected(Cache.getDefault("CLUSTAL_JVSUFFIX", true));
        this.fastajv.setSelected(Cache.getDefault("FASTA_JVSUFFIX", true));
        this.msfjv.setSelected(Cache.getDefault("MSF_JVSUFFIX", true));
        this.pfamjv.setSelected(Cache.getDefault("PFAM_JVSUFFIX", true));
        this.pileupjv.setSelected(Cache.getDefault("PILEUP_JVSUFFIX", true));
        this.pirjv.setSelected(Cache.getDefault("PIR_JVSUFFIX", true));
        this.modellerOutput.setSelected(Cache.getDefault("PIR_MODELLER", false));
        this.embbedBioJSON.setSelected(Cache.getDefault("EXPORT_EMBBED_BIOJSON", true));
        this.autoCalculateConsCheck.setSelected(Cache.getDefault("AUTO_CALC_CONSENSUS", true));
        this.padGaps.setSelected(Cache.getDefault("PAD_GAPS", false));
        this.sortByTree.setSelected(Cache.getDefault("SORT_BY_TREE", false));
        this.annotations_actionPerformed(null);
        this.loadLastSavedBackupsOptions();
    }

    @Override
    public void ok_actionPerformed(ActionEvent e) {
        AlignFrame[] frames;
        if (!this.validateSettings()) {
            return;
        }
        Cache.applicationProperties.setProperty("SHOW_JVSUFFIX", Boolean.toString(this.seqLimit.isSelected()));
        Cache.applicationProperties.setProperty("RIGHT_ALIGN_IDS", Boolean.toString(this.rightAlign.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_FULLSCREEN", Boolean.toString(this.fullScreen.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_OVERVIEW", Boolean.toString(this.openoverv.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_ANNOTATIONS", Boolean.toString(this.annotations.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSERVATION", Boolean.toString(this.conservation.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_QUALITY", Boolean.toString(this.quality.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_IDENTITY", Boolean.toString(this.identity.isSelected()));
        Cache.applicationProperties.setProperty("GAP_SYMBOL", this.gapSymbolCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_NAME", this.fontNameCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_STYLE", this.fontStyleCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("FONT_SIZE", this.fontSizeCB.getSelectedItem().toString());
        Cache.applicationProperties.setProperty("ID_ITALICS", Boolean.toString(this.idItalics.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_UNCONSERVED", Boolean.toString(this.showUnconserved.isSelected()));
        Cache.applicationProperties.setProperty(SHOW_OCCUPANCY, Boolean.toString(this.showOccupancy.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_GROUP_CONSENSUS", Boolean.toString(this.showGroupConsensus.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_GROUP_CONSERVATION", Boolean.toString(this.showGroupConservation.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSENSUS_HISTOGRAM", Boolean.toString(this.showConsensHistogram.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_CONSENSUS_LOGO", Boolean.toString(this.showConsensLogo.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_INFORMATION_HISTOGRAM", Boolean.toString(this.showConsensHistogram.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_HMM_LOGO", Boolean.toString(this.showHMMLogo.isSelected()));
        Cache.applicationProperties.setProperty("ANTI_ALIAS", Boolean.toString(this.smoothFont.isSelected()));
        Cache.applicationProperties.setProperty(SCALE_PROTEIN_TO_CDNA, Boolean.toString(this.scaleProteinToCdna.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_NPFEATS_TOOLTIP", Boolean.toString(this.showNpTooltip.isSelected()));
        Cache.applicationProperties.setProperty("SHOW_DBREFS_TOOLTIP", Boolean.toString(this.showDbRefTooltip.isSelected()));
        Cache.applicationProperties.setProperty("WRAP_ALIGNMENT", Boolean.toString(this.wrap.isSelected()));
        Cache.applicationProperties.setProperty("STARTUP_FILE", this.startupFileTextfield.getText());
        Cache.applicationProperties.setProperty("SHOW_STARTUP_FILE", Boolean.toString(this.startupCheckbox.isSelected()));
        Cache.applicationProperties.setProperty("SORT_ALIGNMENT", this.sortby.getSelectedItem().toString());
        AnnotationSorter.SequenceAnnotationOrder annSortOrder = AnnotationSorter.SequenceAnnotationOrder.forDescription(this.sortAnnBy.getSelectedItem().toString());
        if (annSortOrder != null) {
            Cache.applicationProperties.setProperty(SORT_ANNOTATIONS, annSortOrder.name());
        }
        boolean showAutocalcFirst = this.sortAutocalc.getSelectedIndex() == 0;
        Cache.applicationProperties.setProperty(SHOW_AUTOCALC_ABOVE, Boolean.valueOf(showAutocalcFirst).toString());
        Cache.applicationProperties.setProperty(DEFAULT_COLOUR_PROT, this.protColour.getSelectedItem().toString());
        Cache.applicationProperties.setProperty(DEFAULT_COLOUR_NUC, this.nucColour.getSelectedItem().toString());
        Cache.setColourProperty("ANNOTATIONCOLOUR_MIN", this.minColour.getBackground());
        Cache.setColourProperty("ANNOTATIONCOLOUR_MAX", this.maxColour.getBackground());
        Cache.applicationProperties.setProperty(HMMALIGN_TRIM_TERMINI, Boolean.toString(this.hmmrTrimTermini.isSelected()));
        Cache.applicationProperties.setProperty(HMMINFO_GLOBAL_BACKGROUND, Boolean.toString(this.hmmerBackgroundUniprot.isSelected()));
        Cache.applicationProperties.setProperty(HMMSEARCH_SEQCOUNT, this.hmmerSequenceCount.getText());
        Cache.setOrRemove(HMMER_PATH, this.hmmerPath.getText());
        if (this.cygwinPath != null) {
            Cache.setOrRemove(CYGWIN_PATH, this.cygwinPath.getText());
        }
        if ((frames = Desktop.getAlignFrames()) != null && frames.length > 0) {
            for (AlignFrame f : frames) {
                f.updateHMMERStatus();
            }
        }
        this.hmmrTrimTermini.setSelected(Cache.getDefault(HMMALIGN_TRIM_TERMINI, false));
        if (Cache.getDefault(HMMINFO_GLOBAL_BACKGROUND, false)) {
            this.hmmerBackgroundUniprot.setSelected(true);
        } else {
            this.hmmerBackgroundAlignment.setSelected(true);
        }
        this.hmmerSequenceCount.setText(Cache.getProperty(HMMSEARCH_SEQCOUNT));
        this.hmmerPath.setText(Cache.getProperty(HMMER_PATH));
        Cache.setColourProperty(GAP_COLOUR, this.gapColour.getBackground());
        Cache.setColourProperty(HIDDEN_COLOUR, this.hiddenColour.getBackground());
        Cache.applicationProperties.setProperty(USE_LEGACY_GAP, Boolean.toString(this.useLegacyGap.isSelected()));
        Cache.applicationProperties.setProperty(SHOW_OV_HIDDEN_AT_START, Boolean.toString(this.showHiddenAtStart.isSelected()));
        Cache.applicationProperties.setProperty(ADD_TEMPFACT_ANN, Boolean.toString(this.addTempFactor.isSelected()));
        Cache.applicationProperties.setProperty(ADD_SS_ANN, Boolean.toString(this.addSecondaryStructure.isSelected()));
        Cache.applicationProperties.setProperty(USE_RNAVIEW, Boolean.toString(this.useRnaView.isSelected()));
        Cache.applicationProperties.setProperty(STRUCT_FROM_PDB, Boolean.toString(this.structFromPdb.isSelected()));
        Cache.applicationProperties.setProperty(STRUCTURE_DISPLAY, this.structViewer.getSelectedItem().toString());
        Cache.setOrRemove(CHIMERA_PATH, this.chimeraPath.getText());
        Cache.applicationProperties.setProperty("MAP_WITH_SIFTS", Boolean.toString(this.siftsMapping.isSelected()));
        SiftsSettings.setMapWithSifts(this.siftsMapping.isSelected());
        Cache.applicationProperties.setProperty("EPS_RENDERING", ((OptionsParam)this.epsRendering.getSelectedItem()).getCode());
        Cache.setOrRemove("DEFAULT_BROWSER", this.defaultBrowser.getText());
        BrowserLauncher.resetBrowser();
        String menuLinks = sequenceUrlLinks.writeUrlsAsString(true);
        if (menuLinks.isEmpty()) {
            Cache.applicationProperties.remove("SEQUENCE_LINKS");
        } else {
            Cache.applicationProperties.setProperty("SEQUENCE_LINKS", menuLinks.toString());
        }
        String nonMenuLinks = sequenceUrlLinks.writeUrlsAsString(false);
        if (nonMenuLinks.isEmpty()) {
            Cache.applicationProperties.remove("STORED_LINKS");
        } else {
            Cache.applicationProperties.setProperty("STORED_LINKS", nonMenuLinks.toString());
        }
        Cache.applicationProperties.setProperty("DEFAULT_URL", sequenceUrlLinks.getPrimaryUrlId());
        Cache.applicationProperties.setProperty("USE_PROXY", Boolean.toString(this.useProxy.isSelected()));
        Cache.setOrRemove("PROXY_SERVER", this.proxyServerTB.getText());
        Cache.setOrRemove("PROXY_PORT", this.proxyPortTB.getText());
        if (this.useProxy.isSelected()) {
            System.setProperty("http.proxyHost", this.proxyServerTB.getText());
            System.setProperty("http.proxyPort", this.proxyPortTB.getText());
        } else {
            System.setProperty("http.proxyHost", "");
            System.setProperty("http.proxyPort", "");
        }
        Cache.setProperty("VERSION_CHECK", Boolean.toString(this.versioncheck.isSelected()));
        if (Cache.getProperty("USAGESTATS") != null || this.usagestats.isSelected()) {
            Cache.setProperty("USAGESTATS", Boolean.toString(this.usagestats.isSelected()));
        }
        if (!this.questionnaire.isSelected()) {
            Cache.setProperty("NOQUESTIONNAIRES", "true");
        } else {
            Cache.removeProperty("NOQUESTIONNAIRES");
        }
        Cache.applicationProperties.setProperty("BLC_JVSUFFIX", Boolean.toString(this.blcjv.isSelected()));
        Cache.applicationProperties.setProperty("CLUSTAL_JVSUFFIX", Boolean.toString(this.clustaljv.isSelected()));
        Cache.applicationProperties.setProperty("FASTA_JVSUFFIX", Boolean.toString(this.fastajv.isSelected()));
        Cache.applicationProperties.setProperty("MSF_JVSUFFIX", Boolean.toString(this.msfjv.isSelected()));
        Cache.applicationProperties.setProperty("PFAM_JVSUFFIX", Boolean.toString(this.pfamjv.isSelected()));
        Cache.applicationProperties.setProperty("PILEUP_JVSUFFIX", Boolean.toString(this.pileupjv.isSelected()));
        Cache.applicationProperties.setProperty("PIR_JVSUFFIX", Boolean.toString(this.pirjv.isSelected()));
        Cache.applicationProperties.setProperty("PIR_MODELLER", Boolean.toString(this.modellerOutput.isSelected()));
        Cache.applicationProperties.setProperty("EXPORT_EMBBED_BIOJSON", Boolean.toString(this.embbedBioJSON.isSelected()));
        PIRFile.useModellerOutput = this.modellerOutput.isSelected();
        Cache.applicationProperties.setProperty("FIGURE_AUTOIDWIDTH", Boolean.toString(this.autoIdWidth.isSelected()));
        this.userIdWidth_actionPerformed();
        Cache.applicationProperties.setProperty("FIGURE_FIXEDIDWIDTH", this.userIdWidth.getText());
        Cache.applicationProperties.setProperty("AUTO_CALC_CONSENSUS", Boolean.toString(this.autoCalculateConsCheck.isSelected()));
        Cache.applicationProperties.setProperty("SORT_BY_TREE", Boolean.toString(this.sortByTree.isSelected()));
        Cache.applicationProperties.setProperty("PAD_GAPS", Boolean.toString(this.padGaps.isSelected()));
        this.wsPrefs.updateAndRefreshWsMenuConfig(false);
        Cache.applicationProperties.setProperty("BACKUPFILES_ENABLED", Boolean.toString(this.enableBackupFiles.isSelected()));
        int preset = this.getComboIntStringKey(this.backupfilesPresetsCombo);
        Cache.applicationProperties.setProperty("BACKUPFILES_PRESET", Integer.toString(preset));
        if (preset == 0) {
            BackupFilesPresetEntry customBFPE = this.getBackupfilesCurrentEntry();
            BackupFilesPresetEntry.backupfilesPresetEntriesValues.put(0, customBFPE);
            Cache.applicationProperties.setProperty("BACKUPFILES_CUSTOM", customBFPE.toString());
        }
        BackupFilesPresetEntry savedBFPE = BackupFilesPresetEntry.backupfilesPresetEntriesValues.get(preset);
        Cache.applicationProperties.setProperty("BACKUPFILES_SAVED", savedBFPE.toString());
        Cache.saveProperties();
        Desktop.instance.doConfigureStructurePrefs();
        try {
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean validateSettings() {
        if (!this.validateStructure()) {
            this.structureTab.requestFocusInWindow();
            return false;
        }
        return true;
    }

    @Override
    protected boolean validateStructure() {
        return this.validateChimeraPath();
    }

    @Override
    public void startupFileTextfield_mouseClicked() {
        String fileFormat = Cache.getProperty("DEFAULT_FILE_FORMAT");
        JalviewFileChooser chooser = JalviewFileChooser.forRead(Cache.getProperty("LAST_DIRECTORY"), fileFormat);
        chooser.setFileView(new JalviewFileView());
        chooser.setDialogTitle(MessageManager.getString("label.select_startup_file"));
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            FileFormatI format = chooser.getSelectedFormat();
            if (format != null) {
                Cache.applicationProperties.setProperty("DEFAULT_FILE_FORMAT", format.getName());
            }
            this.startupFileTextfield.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    public void cancel_actionPerformed(ActionEvent e) {
        try {
            this.wsPrefs.updateWsMenuConfig(true);
            this.wsPrefs.refreshWs_actionPerformed(e);
            this.frame.setClosed(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void annotations_actionPerformed(ActionEvent e) {
        this.conservation.setEnabled(this.annotations.isSelected());
        this.quality.setEnabled(this.annotations.isSelected());
        this.identity.setEnabled(this.annotations.isSelected());
        this.showOccupancy.setEnabled(this.annotations.isSelected());
        this.showGroupConsensus.setEnabled(this.annotations.isSelected());
        this.showGroupConservation.setEnabled(this.annotations.isSelected());
        this.showConsensHistogram.setEnabled(this.annotations.isSelected() && (this.identity.isSelected() || this.showGroupConsensus.isSelected()));
        this.showConsensLogo.setEnabled(this.annotations.isSelected() && (this.identity.isSelected() || this.showGroupConsensus.isSelected()));
        this.showInformationHistogram.setEnabled(this.annotations.isSelected());
        this.showHMMLogo.setEnabled(this.annotations.isSelected());
    }

    @Override
    public void newLink_actionPerformed(ActionEvent e) {
        GSequenceLink link = new GSequenceLink();
        boolean valid = false;
        while (!valid && JvOptionPane.showInternalConfirmDialog(Desktop.desktop, link, MessageManager.getString("label.new_sequence_url_link"), 2, -1, null) == 0) {
            if (!link.checkValid()) continue;
            if (((UrlLinkTableModel)this.linkUrlTable.getModel()).isUniqueName(link.getName())) {
                ((UrlLinkTableModel)this.linkUrlTable.getModel()).insertRow(link.getName(), link.getURL());
                valid = true;
                continue;
            }
            link.notifyDuplicate();
        }
    }

    @Override
    public void editLink_actionPerformed(ActionEvent e) {
        GSequenceLink link = new GSequenceLink();
        int index = this.linkUrlTable.getSelectedRow();
        if (index == -1) {
            Cache.log.debug((Object)"Edit with no row selected in linkUrlTable");
            return;
        }
        int nameCol = ((UrlLinkTableModel)this.linkUrlTable.getModel()).getNameColumn();
        int urlCol = ((UrlLinkTableModel)this.linkUrlTable.getModel()).getUrlColumn();
        String oldName = this.linkUrlTable.getValueAt(index, nameCol).toString();
        link.setName(oldName);
        link.setURL(this.linkUrlTable.getValueAt(index, urlCol).toString());
        boolean valid = false;
        while (!valid && JvOptionPane.showInternalConfirmDialog(Desktop.desktop, link, MessageManager.getString("label.edit_sequence_url_link"), 2, -1, null) == 0) {
            if (!link.checkValid()) continue;
            if (oldName.equals(link.getName()) || ((UrlLinkTableModel)this.linkUrlTable.getModel()).isUniqueName(link.getName())) {
                this.linkUrlTable.setValueAt(link.getName(), index, nameCol);
                this.linkUrlTable.setValueAt(link.getURL(), index, urlCol);
                valid = true;
                continue;
            }
            link.notifyDuplicate();
        }
    }

    @Override
    public void deleteLink_actionPerformed(ActionEvent e) {
        int index = this.linkUrlTable.getSelectedRow();
        int modelIndex = -1;
        if (index == -1) {
            Cache.log.debug((Object)"Delete with no row selected in linkUrlTable");
            return;
        }
        modelIndex = this.linkUrlTable.convertRowIndexToModel(index);
        ((UrlLinkTableModel)this.linkUrlTable.getModel()).removeRow(modelIndex);
    }

    @Override
    public void defaultBrowser_mouseClicked(MouseEvent e) {
        JFileChooser chooser = new JFileChooser(".");
        chooser.setDialogTitle(MessageManager.getString("label.select_default_browser"));
        int value = chooser.showOpenDialog(this);
        if (value == 0) {
            this.defaultBrowser.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    @Override
    protected void showunconserved_actionPerformed(ActionEvent e) {
        super.showunconserved_actionPerformed(e);
    }

    public static List<String> getGroupURLLinks() {
        return groupURLLinks;
    }

    @Override
    public void minColour_actionPerformed(JPanel panel) {
        Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_colour_minimum_value"), this.minColour.getBackground());
        if (col != null) {
            panel.setBackground(col);
        }
        panel.repaint();
    }

    @Override
    public void maxColour_actionPerformed(JPanel panel) {
        Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_colour_maximum_value"), this.maxColour.getBackground());
        if (col != null) {
            panel.setBackground(col);
        }
        panel.repaint();
    }

    @Override
    public void gapColour_actionPerformed(JPanel gap) {
        if (!this.useLegacyGap.isSelected()) {
            Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_gap_colour"), this.gapColour.getBackground());
            if (col != null) {
                gap.setBackground(col);
            }
            gap.repaint();
        }
    }

    @Override
    public void hiddenColour_actionPerformed(JPanel hidden) {
        Color col = JColorChooser.showDialog(this, MessageManager.getString("label.select_hidden_colour"), this.hiddenColour.getBackground());
        if (col != null) {
            hidden.setBackground(col);
        }
        hidden.repaint();
    }

    @Override
    protected void useLegacyGaps_actionPerformed(ActionEvent e) {
        boolean enabled = this.useLegacyGap.isSelected();
        if (enabled) {
            this.gapColour.setBackground(OverviewResColourFinder.OVERVIEW_DEFAULT_LEGACY_GAP);
        } else {
            this.gapColour.setBackground(OverviewResColourFinder.OVERVIEW_DEFAULT_GAP);
        }
        this.gapColour.setEnabled(!enabled);
        this.gapLabel.setEnabled(!enabled);
    }

    @Override
    protected void resetOvDefaults_actionPerformed(ActionEvent e) {
        this.useLegacyGap.setSelected(false);
        this.useLegacyGaps_actionPerformed(null);
        this.showHiddenAtStart.setSelected(false);
        this.hiddenColour.setBackground(OverviewResColourFinder.OVERVIEW_DEFAULT_HIDDEN);
    }

    @Override
    protected void userIdWidth_actionPerformed() {
        try {
            String val = this.userIdWidth.getText().trim();
            if (val.length() > 0) {
                Integer iw = Integer.parseInt(val);
                if (iw < 12) {
                    throw new NumberFormatException();
                }
                this.userIdWidth.setText(iw.toString());
            }
        }
        catch (NumberFormatException x) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("warn.user_defined_width_requirements"), MessageManager.getString("label.invalid_id_column_width"), 2);
            this.userIdWidth.setText("");
        }
    }

    @Override
    protected void autoIdWidth_actionPerformed() {
        this.userIdWidth.setEnabled(!this.autoIdWidth.isSelected());
        this.userIdWidthlabel.setEnabled(!this.autoIdWidth.isSelected());
    }

    private boolean validateChimeraPath() {
        File f;
        if (this.chimeraPath.getText().trim().length() > 0 && !(f = new File(this.chimeraPath.getText())).canExecute()) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("label.invalid_chimera_path"), MessageManager.getString("label.invalid_name"), 0);
            return false;
        }
        return true;
    }

    protected boolean validateExecutablePath(JTextField textField, String executable) {
        String folder = textField.getText().trim();
        if (FileUtils.getExecutable(executable, folder) != null) {
            return true;
        }
        if (folder.length() > 0) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.formatMessage("label.executable_not_found", executable), MessageManager.getString("label.invalid_folder"), 0);
        }
        return false;
    }

    public boolean canExecute(String path) {
        File file = new File(path);
        return file.canExecute() || (file = new File(path + ".exe")).canExecute();
    }

    @Override
    protected void structureViewer_actionPerformed(String selectedItem) {
        if (!selectedItem.equals(StructureViewer.ViewerType.CHIMERA.name())) {
            return;
        }
        boolean found = false;
        List<String> paths = StructureManager.getChimeraPaths();
        paths.add(0, this.chimeraPath.getText());
        for (String path : paths) {
            if (!new File(path.trim()).canExecute()) continue;
            found = true;
            break;
        }
        if (!found) {
            Object[] options = new String[]{"OK", "Help"};
            int showHelp = JvOptionPane.showInternalOptionDialog(Desktop.desktop, JvSwingUtils.wrapTooltip(true, MessageManager.getString("label.chimera_missing")), "", 0, 2, null, options, options[0]);
            if (showHelp == 1) {
                try {
                    Help.showHelpWindow(Help.HelpId.StructureViewer);
                }
                catch (HelpSetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    protected void validateHmmerPath() {
        this.validateExecutablePath(this.hmmerPath, "hmmbuild");
    }

    @Override
    protected void validateCygwinPath() {
        this.validateExecutablePath(this.cygwinPath, "run");
    }

    static {
        String inMenuString = Cache.getDefault("SEQUENCE_LINKS", "");
        String notInMenuString = Cache.getDefault("STORED_LINKS", "");
        String defaultUrl = Cache.getDefault("DEFAULT_URL", "EMBL-EBI Search");
        if (inMenuString.isEmpty() && notInMenuString.isEmpty()) {
            inMenuString = "EMBL-EBI Search|https://www.ebi.ac.uk/ebisearch/search.ebi?db=allebi&query=$SEQUENCE_ID$";
        }
        DesktopUrlProviderFactory factory = new DesktopUrlProviderFactory(defaultUrl, inMenuString, notInMenuString);
        sequenceUrlLinks = factory.createUrlProvider();
        dataModel = new UrlLinkTableModel(sequenceUrlLinks);
        groupURLLinks = new ArrayList<String>();
    }

    private class UrlListSelectionHandler
    implements ListSelectionListener {
        private UrlListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            int index = lsm.getMinSelectionIndex();
            if (index == -1) {
                Preferences.this.editLink.setEnabled(false);
                Preferences.this.deleteLink.setEnabled(false);
                return;
            }
            int modelIndex = Preferences.this.linkUrlTable.convertRowIndexToModel(index);
            if (((UrlLinkTableModel)Preferences.this.linkUrlTable.getModel()).isRowDeletable(modelIndex)) {
                Preferences.this.deleteLink.setEnabled(true);
            } else {
                Preferences.this.deleteLink.setEnabled(false);
            }
            if (((UrlLinkTableModel)Preferences.this.linkUrlTable.getModel()).isRowEditable(modelIndex)) {
                Preferences.this.editLink.setEnabled(true);
            } else {
                Preferences.this.editLink.setEnabled(false);
            }
        }
    }

    public class OptionsParam {
        private String name;
        private String code;

        public OptionsParam(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object that) {
            if (!(that instanceof OptionsParam)) {
                return false;
            }
            return this.code.equalsIgnoreCase(((OptionsParam)that).code);
        }

        public int hashCode() {
            return this.name.hashCode() + this.code.hashCode();
        }
    }
}

