/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.api.AlignmentViewPanel;
import jalview.api.structures.JalviewStructureDisplayI;
import jalview.datamodel.PDBEntry;
import jalview.datamodel.SequenceI;
import jalview.ext.rbvi.chimera.JalviewChimeraBinding;
import jalview.gui.AlignmentPanel;
import jalview.gui.ChimeraViewFrame;
import jalview.gui.SequenceRenderer;
import jalview.io.DataSourceType;
import jalview.structure.StructureSelectionManager;
import jalview.viewmodel.seqfeatures.FeatureRendererModel;
import javax.swing.SwingUtilities;

public class JalviewChimeraBindingModel
extends JalviewChimeraBinding {
    private ChimeraViewFrame cvf;

    public JalviewChimeraBindingModel(ChimeraViewFrame chimeraViewFrame, StructureSelectionManager ssm, PDBEntry[] pdbentry, SequenceI[][] sequenceIs, DataSourceType protocol) {
        super(ssm, pdbentry, sequenceIs, protocol);
        this.cvf = chimeraViewFrame;
    }

    @Override
    public FeatureRendererModel getFeatureRenderer(AlignmentViewPanel alignment) {
        AlignmentPanel ap;
        AlignmentPanel alignmentPanel = ap = alignment == null ? this.cvf.getAlignmentPanel() : (AlignmentPanel)alignment;
        if (ap.av.isShowSequenceFeatures()) {
            return ap.getSeqPanel().seqCanvas.fr;
        }
        return null;
    }

    @Override
    public jalview.api.SequenceRenderer getSequenceRenderer(AlignmentViewPanel alignment) {
        return new SequenceRenderer(((AlignmentPanel)alignment).av);
    }

    @Override
    public void refreshGUI() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JalviewChimeraBindingModel.this.cvf.updateTitleAndMenus();
                JalviewChimeraBindingModel.this.cvf.revalidate();
            }
        });
    }

    @Override
    public void updateColours(Object source) {
        AlignmentPanel ap = (AlignmentPanel)source;
        if (!this.cvf.isUsedforcolourby(ap)) {
            return;
        }
        if (!this.isLoadingFromArchive()) {
            this.colourBySequence(ap);
        }
    }

    @Override
    public void releaseReferences(Object svl) {
    }

    @Override
    protected void releaseUIResources() {
    }

    @Override
    public void refreshPdbEntries() {
    }

    @Override
    protected void sendAsynchronousCommand(final String command, final String progressMsg) {
        final long handle = progressMsg == null ? 0L : this.cvf.startProgressBar(progressMsg);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    JalviewChimeraBindingModel.this.sendChimeraCommand(command, false);
                }
                finally {
                    if (progressMsg != null) {
                        JalviewChimeraBindingModel.this.cvf.stopProgressBar(null, handle);
                    }
                }
            }
        });
    }

    @Override
    public JalviewStructureDisplayI getViewer() {
        return this.cvf;
    }
}

