/*
 * Decompiled with CFR 0.152.
 */
package jalview.gui;

import jalview.datamodel.AlignmentAnnotation;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.gui.AlignViewport;
import jalview.gui.AlignmentPanel;
import jalview.gui.AnnotationLabels;
import jalview.gui.Desktop;
import jalview.gui.IdCanvas;
import jalview.gui.JvOptionPane;
import jalview.gui.JvSwingUtils;
import jalview.gui.PaintRefresher;
import jalview.gui.PopupMenu;
import jalview.gui.Preferences;
import jalview.gui.SeqPanel;
import jalview.io.SequenceAnnotationReport;
import jalview.util.BrowserLauncher;
import jalview.util.MessageManager;
import jalview.util.Platform;
import jalview.viewmodel.AlignmentViewport;
import jalview.viewmodel.ViewportRanges;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;

public class IdPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    private IdCanvas idCanvas;
    protected AlignmentViewport av;
    protected AlignmentPanel alignPanel;
    ScrollThread scrollThread = null;
    String linkImageURL;
    int offy;
    int lastid = -1;
    boolean mouseDragging = false;
    private final SequenceAnnotationReport seqAnnotReport;

    public IdPanel(AlignViewport av, AlignmentPanel parent) {
        this.av = av;
        this.alignPanel = parent;
        this.setIdCanvas(new IdCanvas(av));
        this.linkImageURL = this.getClass().getResource("/images/link.gif").toString();
        this.seqAnnotReport = new SequenceAnnotationReport(this.linkImageURL);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getIdCanvas(), "Center");
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        SeqPanel sp = this.alignPanel.getSeqPanel();
        SeqPanel.MousePos pos = sp.findMousePosition(e);
        if (pos.isOverAnnotation()) {
            AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
            AlignmentAnnotation annotation = anns[pos.annotationIndex];
            this.setToolTipText(AnnotationLabels.getTooltip(annotation));
            this.alignPanel.alignFrame.setStatus(AnnotationLabels.getStatusMessage(annotation, anns));
        } else {
            int seq = Math.max(0, pos.seqIndex);
            if (seq < this.av.getAlignment().getHeight()) {
                SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
                StringBuilder tip = new StringBuilder(64);
                tip.append(sequence.getDisplayId(true)).append(" ");
                this.seqAnnotReport.createTooltipAnnotationReport(tip, sequence, this.av.isShowDBRefs(), this.av.isShowNPFeats(), sp.seqCanvas.fr);
                this.setToolTipText(JvSwingUtils.wrapTooltip(true, tip.toString()));
                StringBuilder text = new StringBuilder();
                text.append("Sequence ").append(String.valueOf(seq + 1)).append(" ID: ").append(sequence.getName());
                this.alignPanel.alignFrame.setStatus(text.toString());
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseDragging = true;
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        if (pos.isOverAnnotation()) {
            return;
        }
        int seq = Math.max(0, pos.seqIndex);
        if (seq < this.lastid) {
            this.selectSeqs(this.lastid - 1, seq);
        } else if (seq > this.lastid) {
            this.selectSeqs(this.lastid + 1, seq);
        }
        this.lastid = seq;
        this.alignPanel.paintAlignment(false, false);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        e.consume();
        double wheelRotation = e.getPreciseWheelRotation();
        if (wheelRotation > 0.0) {
            if (e.isShiftDown()) {
                this.av.getRanges().scrollRight(true);
            } else {
                this.av.getRanges().scrollUp(false);
            }
        } else if (wheelRotation < 0.0) {
            if (e.isShiftDown()) {
                this.av.getRanges().scrollRight(false);
            } else {
                this.av.getRanges().scrollUp(true);
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2 || SwingUtilities.isRightMouseButton(e)) {
            return;
        }
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        int seq = pos.seqIndex;
        if (pos.isOverAnnotation() || seq < 0) {
            return;
        }
        String id = this.av.getAlignment().getSequenceAt(seq).getName();
        String url = Preferences.sequenceUrlLinks.getPrimaryUrl(id);
        try {
            BrowserLauncher.openURL(url);
        }
        catch (Exception ex) {
            JvOptionPane.showInternalMessageDialog(Desktop.desktop, MessageManager.getString("label.web_browser_not_found_unix"), MessageManager.getString("label.web_browser_not_found"), 2);
            ex.printStackTrace();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging && e.getY() < 0 && this.av.getRanges().getStartSeq() > 0) {
            this.scrollThread = new ScrollThread(true);
        }
        if (this.mouseDragging && e.getY() >= this.getHeight() && this.av.getAlignment().getHeight() > this.av.getRanges().getEndSeq()) {
            this.scrollThread = new ScrollThread(false);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e, pos);
            return;
        }
        if (SwingUtilities.isRightMouseButton(e) && !Platform.isAMac()) {
            return;
        }
        if (this.av.getSelectionGroup() == null || !Platform.isControlDown(e) && !e.isShiftDown() && this.av.getSelectionGroup() != null) {
            this.av.setSelectionGroup(new SequenceGroup());
            this.av.getSelectionGroup().setStartRes(0);
            this.av.getSelectionGroup().setEndRes(this.av.getAlignment().getWidth() - 1);
        }
        if (e.isShiftDown() && this.lastid != -1) {
            this.selectSeqs(this.lastid, pos.seqIndex);
        } else {
            this.selectSeq(pos.seqIndex);
        }
        this.av.isSelectionGroupChanged(true);
        this.alignPanel.paintAlignment(false, false);
    }

    void showPopupMenu(MouseEvent e, SeqPanel.MousePos pos) {
        if (pos.isOverAnnotation()) {
            this.showAnnotationMenu(e, pos);
            return;
        }
        Sequence sq = (Sequence)this.av.getAlignment().getSequenceAt(pos.seqIndex);
        if (sq != null) {
            PopupMenu pop = new PopupMenu(this.alignPanel, (SequenceI)sq, Preferences.getGroupURLLinks());
            pop.show(this, e.getX(), e.getY());
        }
    }

    void showAnnotationMenu(MouseEvent e, SeqPanel.MousePos pos) {
        if (pos.annotationIndex == -1) {
            return;
        }
        AlignmentAnnotation[] anns = this.av.getAlignment().getAlignmentAnnotation();
        if (anns == null || pos.annotationIndex >= anns.length) {
            return;
        }
        AlignmentAnnotation ann = anns[pos.annotationIndex];
        if (!ann.label.contains("Consensus")) {
            return;
        }
        JPopupMenu pop = new JPopupMenu(MessageManager.getString("label.annotations"));
        AnnotationLabels.addConsensusMenuOptions(this.alignPanel, ann, pop);
        pop.show(this, e.getX(), e.getY());
    }

    void selectSeq(int seq) {
        this.lastid = seq;
        SequenceI pickedSeq = this.av.getAlignment().getSequenceAt(seq);
        this.av.getSelectionGroup().addOrRemove(pickedSeq, false);
    }

    void selectSeqs(int start, int end) {
        if (this.av.getSelectionGroup() == null) {
            return;
        }
        if (end >= this.av.getAlignment().getHeight()) {
            end = this.av.getAlignment().getHeight() - 1;
        }
        this.lastid = start;
        if (end < start) {
            int tmp = start;
            start = end;
            this.lastid = end = tmp;
        }
        for (int i = start; i <= end; ++i) {
            this.av.getSelectionGroup().addSequence(this.av.getAlignment().getSequenceAt(i), false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.stopScrolling();
        }
        SeqPanel.MousePos pos = this.alignPanel.getSeqPanel().findMousePosition(e);
        this.mouseDragging = false;
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
        this.av.sendSelection();
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e, pos);
        }
    }

    public void highlightSearchResults(List<SequenceI> list) {
        this.getIdCanvas().setHighlighted(list);
        if (list == null || list.isEmpty()) {
            return;
        }
        int index = this.av.getAlignment().findIndex(list.get(0));
        if (this.av.getRanges().getStartSeq() > index || this.av.getRanges().getEndSeq() < index) {
            this.av.getRanges().setStartSeq(index);
        }
    }

    public IdCanvas getIdCanvas() {
        return this.idCanvas;
    }

    public void setIdCanvas(IdCanvas idCanvas) {
        this.idCanvas = idCanvas;
    }

    class ScrollThread
    extends Thread {
        private boolean running = false;
        private boolean up;

        public ScrollThread(boolean up) {
            this.up = up;
            this.setName("IdPanel$ScrollThread$" + String.valueOf(up));
            this.start();
        }

        public void stopScrolling() {
            this.running = false;
        }

        @Override
        public void run() {
            this.running = true;
            while (this.running) {
                ViewportRanges ranges = IdPanel.this.av.getRanges();
                if (ranges.scrollUp(this.up)) {
                    int toSeq = this.up ? ranges.getStartSeq() : ranges.getEndSeq();
                    int fromSeq = toSeq < IdPanel.this.lastid ? IdPanel.this.lastid - 1 : IdPanel.this.lastid + 1;
                    IdPanel.this.selectSeqs(fromSeq, toSeq);
                    IdPanel.this.lastid = toSeq;
                } else {
                    this.running = false;
                }
                IdPanel.this.alignPanel.paintAlignment(false, false);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

